/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.InvEndEditor;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.InvEndEditor.EndWatcher;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class EnderChestListener
implements Listener {
    private CMI plugin;

    public EnderChestListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEnderChestClick(InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!this.plugin.getEnderChestManager().isWatching(player)) {
            return;
        }
        if (!PermissionsManager.CMIPerm.enderedit.hasPermission((CommandSender)player, true, new String[0])) {
            inventoryClickEvent.setCancelled(true);
            return;
        }
        EndWatcher endWatcher = this.plugin.getEnderChestManager().getWatcher(player);
        if (PermissionsManager.CMIPerm.command_ender_preventmodify.hasPermission((CommandSender)endWatcher.getTarget()) && !PermissionsManager.CMIPerm.command_ender_preventmodify_bypass.hasPermission((CommandSender)player)) {
            inventoryClickEvent.setCancelled(true);
            return;
        }
        this.plugin.getEnderChestManager().updateTargetEnderChest(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLoginEnder(PlayerLoginEvent playerLoginEvent) {
        Player player = playerLoginEvent.getPlayer();
        if (!this.plugin.getEnderChestManager().isBeingWatched(player)) {
            return;
        }
        EndWatcher endWatcher = this.plugin.getEnderChestManager().getSlave(player);
        if (endWatcher == null) {
            return;
        }
        CMIScheduler.runTaskLater(() -> {
            boolean bl = this.plugin.getEnderChestManager().openEnderChest(endWatcher.getMaster(), player);
        }, (long)1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuitEnder(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (!this.plugin.getEnderChestManager().isBeingWatched(player)) {
            return;
        }
        EndWatcher endWatcher = this.plugin.getEnderChestManager().getSlave(player);
        if (endWatcher == null) {
            return;
        }
        CMIScheduler.runTaskLater(() -> {
            boolean bl = this.plugin.getEnderChestManager().openEnderChest(endWatcher.getMaster(), this.plugin.getPlayerManager().getUser(player).getPlayer());
        }, (long)1L);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEnderChestDrag(InventoryDragEvent inventoryDragEvent) {
        Player player = (Player)inventoryDragEvent.getWhoClicked();
        if (!this.plugin.getEnderChestManager().isWatching(player)) {
            return;
        }
        if (!PermissionsManager.CMIPerm.enderedit.hasPermission((CommandSender)player, true, new String[0])) {
            inventoryDragEvent.setCancelled(true);
            return;
        }
        EndWatcher endWatcher = this.plugin.getEnderChestManager().getWatcher(player);
        if (PermissionsManager.CMIPerm.command_ender_preventmodify.hasPermission((CommandSender)endWatcher.getTarget()) && !PermissionsManager.CMIPerm.command_ender_preventmodify_bypass.hasPermission((CommandSender)player)) {
            inventoryDragEvent.setCancelled(true);
            return;
        }
        this.plugin.getEnderChestManager().updateTargetEnderChest(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNormalInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        Player player = (Player)inventoryCloseEvent.getPlayer();
        this.plugin.getEnderChestManager().removeWatcher(player);
    }
}

