/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Kits;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIPlayerInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class Kit {
    private List<ItemStack> item = new ArrayList<ItemStack>();
    private List<String> commands = new ArrayList<String>();
    private List<String> conditions = new ArrayList<String>();
    private List<String> Description = new ArrayList<String>();
    private HashMap<CMIPlayerInventory.CMIInventorySlot, ItemStack> extraItems = new HashMap();
    private ItemStack Icon = null;
    private ItemStack IconOff = null;
    private double cost = 0.0;
    private int expCost = 0;
    private Long delay = -1L;
    private String name = null;
    private String displayName = null;
    private String group = null;
    private String fileName = "Kits";
    private boolean enabled = true;
    private int weight = 0;
    private String cmdName = null;
    private Integer slot = null;
    private Integer page = null;
    private int maxUsages = -1;
    private boolean showDespiteUsage = false;
    private boolean showDespiteWeight = false;
    private boolean dropItems = true;

    public Kit(String string) {
        this.name = CMIChatColor.stripColor((String)string);
        this.reset();
    }

    public void reset() {
        this.item = new ArrayList<ItemStack>();
        int n = 0;
        while (n < 36) {
            this.item.add(null);
            ++n;
        }
        this.commands = new ArrayList<String>();
        this.conditions = new ArrayList<String>();
        this.Description = new ArrayList<String>();
        this.cost = 0.0;
        this.expCost = 0;
        this.delay = -1L;
        this.group = null;
    }

    public ItemStack getFirstNotNullItem() {
        for (ItemStack itemStack : this.item) {
            this.checkBook(itemStack);
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            return itemStack;
        }
        return null;
    }

    public List<ItemStack> getItems() {
        for (ItemStack itemStack : this.item) {
            this.checkBook(itemStack);
        }
        return this.item;
    }

    public List<ItemStack> getItems(Player player) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (ItemStack itemStack : this.item) {
            if (itemStack != null) {
                arrayList.add(itemStack.clone());
                continue;
            }
            arrayList.add(null);
        }
        for (ItemStack itemStack : arrayList) {
            ItemMeta itemMeta;
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR) || (itemMeta = itemStack.getItemMeta()) == null) continue;
            if (itemMeta.hasDisplayName()) {
                itemMeta.setDisplayName(CMI.getInstance().getKitsManager().processText(itemMeta.getDisplayName(), player, this));
            }
            if (itemMeta.hasLore()) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (String string : itemMeta.getLore()) {
                    arrayList2.add(CMI.getInstance().getKitsManager().processText(string, player, this));
                }
                itemMeta.setLore(arrayList2);
            }
            itemStack.setItemMeta(itemMeta);
        }
        for (ItemStack itemStack : arrayList) {
            this.checkBook(itemStack);
        }
        return arrayList;
    }

    private ItemStack checkBook(ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemMeta() == null || !(itemStack.getItemMeta() instanceof BookMeta)) {
            return itemStack;
        }
        return itemStack;
    }

    public void setItem(List<ItemStack> list2) {
        this.item.clear();
        for (ItemStack itemStack : list2) {
            this.checkBook(itemStack);
            this.item.add(itemStack == null ? null : itemStack.clone());
        }
    }

    public void setItem(int n, ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            this.item.set(n, null);
            return;
        }
        this.checkBook(itemStack);
        this.item.set(n, itemStack);
    }

    public void addItem(ItemStack itemStack) {
        this.checkBook(itemStack);
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            this.item.add(null);
            return;
        }
        this.item.add(itemStack);
    }

    public List<String> getCommands(Player player) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.commands) {
            arrayList.add(CMI.getInstance().getKitsManager().processText(string, player, this));
        }
        return arrayList;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> list2) {
        this.commands = list2;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double d) {
        this.cost = d;
    }

    public int getExpCost() {
        return this.expCost;
    }

    public void setExpCost(int n) {
        this.expCost = n;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    public List<String> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<String> list2) {
        this.conditions = list2;
    }

    public String getConfigName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = CMIChatColor.stripColor((String)string);
    }

    public List<String> getDescription(Player player) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.Description) {
            arrayList.add(CMI.getInstance().getKitsManager().processText(string, player, this));
        }
        return arrayList;
    }

    public List<String> getDescription() {
        return this.Description;
    }

    public void setDescription(List<String> list2) {
        this.Description = list2;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string.equalsIgnoreCase("na") || string.equalsIgnoreCase("none") ? null : string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public String getCommandName() {
        if (this.cmdName == null) {
            this.cmdName = this.getConfigName();
        }
        return this.cmdName;
    }

    public void setCommandName(String string) {
        this.cmdName = string;
    }

    public ItemStack getExtraItem(CMIPlayerInventory.CMIInventorySlot cMIInventorySlot) {
        return this.extraItems.get((Object)cMIInventorySlot);
    }

    public ItemStack getExtraItem(Player player, CMIPlayerInventory.CMIInventorySlot cMIInventorySlot) {
        ItemStack itemStack = this.getExtraItem(cMIInventorySlot);
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return null;
        }
        ItemMeta itemMeta = (itemStack = itemStack.clone()).getItemMeta();
        if (itemMeta != null) {
            if (itemMeta.hasDisplayName()) {
                itemMeta.setDisplayName(CMI.getInstance().getKitsManager().processText(itemMeta.getDisplayName(), player, this));
            }
            if (itemMeta.hasLore()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : itemMeta.getLore()) {
                    arrayList.add(CMI.getInstance().getKitsManager().processText(string, player, this));
                }
                itemMeta.setLore(arrayList);
            }
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public void setExtraItem(CMIPlayerInventory.CMIInventorySlot cMIInventorySlot, ItemStack itemStack) {
        if (itemStack != null) {
            this.extraItems.put(cMIInventorySlot, itemStack.clone());
        } else {
            this.extraItems.put(cMIInventorySlot, null);
        }
    }

    @Deprecated
    public ItemStack getHelmet() {
        return this.extraItems.get((Object)CMIPlayerInventory.CMIInventorySlot.Helmet);
    }

    @Deprecated
    public void setHelmet(ItemStack itemStack) {
        if (itemStack != null) {
            this.extraItems.put(CMIPlayerInventory.CMIInventorySlot.Helmet, itemStack.clone());
        }
    }

    @Deprecated
    public ItemStack getChest() {
        return this.extraItems.get((Object)CMIPlayerInventory.CMIInventorySlot.ChestPlate);
    }

    @Deprecated
    public void setChest(ItemStack itemStack) {
        if (itemStack != null) {
            this.extraItems.put(CMIPlayerInventory.CMIInventorySlot.ChestPlate, itemStack.clone());
        }
    }

    @Deprecated
    public ItemStack getLegs() {
        return this.extraItems.get((Object)CMIPlayerInventory.CMIInventorySlot.Pants);
    }

    @Deprecated
    public void setLegs(ItemStack itemStack) {
        if (itemStack != null) {
            this.extraItems.put(CMIPlayerInventory.CMIInventorySlot.Pants, itemStack.clone());
        }
    }

    @Deprecated
    public ItemStack getBoots() {
        return this.extraItems.get((Object)CMIPlayerInventory.CMIInventorySlot.Boots);
    }

    @Deprecated
    public void setBoots(ItemStack itemStack) {
        if (itemStack != null) {
            this.extraItems.put(CMIPlayerInventory.CMIInventorySlot.Boots, itemStack.clone());
        }
    }

    @Deprecated
    public ItemStack getOffHand() {
        return this.extraItems.get((Object)CMIPlayerInventory.CMIInventorySlot.OffHand);
    }

    @Deprecated
    public void setOffHand(ItemStack itemStack) {
        if (itemStack != null) {
            this.extraItems.put(CMIPlayerInventory.CMIInventorySlot.OffHand, itemStack.clone());
        }
    }

    public Integer getSlot() {
        return this.slot;
    }

    public void setSlot(Integer n) {
        if (n == null) {
            this.slot = n;
            return;
        }
        this.slot = n > 27 ? Integer.valueOf(27) : (n < 0 ? null : n);
    }

    public ItemStack getSafeIcon() {
        if (this.Icon != null) {
            return this.Icon.clone();
        }
        return this.item.isEmpty() ? CMIMaterial.WHITE_WOOL.newItemStack() : (this.getFirstNotNullItem() != null ? this.getFirstNotNullItem() : CMIMaterial.WHITE_WOOL.newItemStack());
    }

    public ItemStack getIcon() {
        if (this.Icon != null) {
            return this.Icon.clone();
        }
        return this.Icon;
    }

    public void setIcon(ItemStack itemStack) {
        this.Icon = itemStack;
    }

    public ItemStack getSafeIconOff() {
        if (this.IconOff != null) {
            return this.IconOff.clone();
        }
        return this.getSafeIcon();
    }

    public ItemStack getIconOff() {
        if (this.IconOff != null) {
            return this.IconOff.clone();
        }
        return this.getIcon();
    }

    public void setIconOff(ItemStack itemStack) {
        this.IconOff = itemStack;
    }

    public int getMaxUsages() {
        return this.maxUsages;
    }

    public void setMaxUsages(int n) {
        this.maxUsages = n;
    }

    public boolean isLimitedUse() {
        return this.maxUsages > 0;
    }

    public boolean isShowDespiteWeight() {
        return this.showDespiteWeight;
    }

    public void setShowDespiteWeight(boolean bl) {
        this.showDespiteWeight = bl;
    }

    public boolean isDropItems() {
        return this.dropItems;
    }

    public void setDropItems(boolean bl) {
        this.dropItems = bl;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.getCommandName() : this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public boolean isShowDespiteUsage() {
        return this.showDespiteUsage;
    }

    public void setShowDespiteUsage(boolean bl) {
        this.showDespiteUsage = bl;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer n) {
        if (n == null) {
            this.page = n;
            return;
        }
        this.page = n < 1 ? null : n;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }
}

