/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Search;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import com.Zrips.CMI.Modules.Scan.ScanResultLocations;
import com.Zrips.CMI.Modules.Search.SearchInfo;
import com.Zrips.CMI.utils.PlayerVaultManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public class Search {
    public HashMap<UUID, SearchInfo> SearchInfo = new HashMap();
    public int showInterval = 1000;
    private CMI plugin;

    public Search(CMI cMI) {
        this.plugin = cMI;
    }

    public HashMap<String, Integer> sortByComparator(Map<String, Integer> map) {
        LinkedList<Map.Entry<String, Integer>> linkedList = new LinkedList<Map.Entry<String, Integer>>(map.entrySet());
        Collections.sort(linkedList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> entry, Map.Entry<String, Integer> entry2) {
                return entry2.getValue().compareTo(entry.getValue());
            }
        });
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : linkedList) {
            linkedHashMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return linkedHashMap;
    }

    public HashMap<Integer, ArrayList<ScanResultLocations>> sortByKey(HashMap<Integer, ArrayList<ScanResultLocations>> hashMap) {
        LinkedList<Map.Entry<Integer, ArrayList<ScanResultLocations>>> linkedList = new LinkedList<Map.Entry<Integer, ArrayList<ScanResultLocations>>>(hashMap.entrySet());
        Collections.sort(linkedList, new Comparator<Map.Entry<Integer, ArrayList<ScanResultLocations>>>(){

            @Override
            public int compare(Map.Entry<Integer, ArrayList<ScanResultLocations>> entry, Map.Entry<Integer, ArrayList<ScanResultLocations>> entry2) {
                return entry2.getKey().compareTo(entry.getKey());
            }
        });
        LinkedHashMap<Integer, ArrayList<ScanResultLocations>> linkedHashMap = new LinkedHashMap<Integer, ArrayList<ScanResultLocations>>();
        for (Map.Entry entry : linkedList) {
            linkedHashMap.put((Integer)entry.getKey(), (ArrayList)entry.getValue());
        }
        return linkedHashMap;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isThisItemOk(SearchInfo searchInfo, ItemStack itemStack, Player player) {
        String string = player.getName();
        if (itemStack == null) {
            return false;
        }
        Inventory inventory = this.plugin.getNMS().getShulkerInv(itemStack);
        if (inventory != null) {
            int n = -1;
            ItemStack[] itemStackArray = inventory.getContents();
            int n2 = itemStackArray.length;
            int cMIItemStack = 0;
            while (cMIItemStack < n2) {
                ItemStack itemStack2 = itemStackArray[cMIItemStack];
                ++n;
                if (this.isThisItemOk(searchInfo, itemStack2, player)) {
                    searchInfo.add(SearchPlaceType.InventoryShulker, string, itemStack2.getAmount());
                }
                ++cMIItemStack;
            }
            if (searchInfo.exist(SearchPlaceType.InventoryShulker, string)) {
                int n3 = searchInfo.get(SearchPlaceType.InventoryShulker, string);
                if (n3 < searchInfo.getAmount()) {
                    searchInfo.remove(SearchPlaceType.InventoryShulker, string);
                }
                if (n3 >= searchInfo.getAmount() && searchInfo.isPurge()) {
                    int entry = -1;
                    ItemStack[] itemStackArray2 = inventory.getContents();
                    int n4 = itemStackArray2.length;
                    n2 = 0;
                    while (n2 < n4) {
                        void cMIMaterial;
                        ItemStack string2 = itemStackArray2[n2];
                        ++cMIMaterial;
                        if (this.isThisItemOk(searchInfo, string2, player) && !searchInfo.getSender().getName().equals(string)) {
                            inventory.setItem((int)cMIMaterial, null);
                        }
                        ++n2;
                    }
                }
            }
        }
        switch (searchInfo.getSearchType()) {
            case ENCHANT: {
                if (!itemStack.hasItemMeta() || !itemStack.getItemMeta().hasEnchants()) break;
                if (searchInfo.getEnchant() != null) {
                    Integer cMIMaterial = (Integer)itemStack.getItemMeta().getEnchants().get(searchInfo.getEnchant());
                    if (cMIMaterial == null) break;
                    if (searchInfo.getNumberState() > -1) {
                        if (cMIMaterial < searchInfo.getNumberState()) break;
                        return true;
                    }
                    return true;
                }
                for (Map.Entry entry : itemStack.getItemMeta().getEnchants().entrySet()) {
                    if ((Integer)entry.getValue() < searchInfo.getNumberState() || searchInfo.get(SearchPlaceType.Inventory, string) != null) continue;
                    return true;
                }
                break;
            }
            case FLY: {
                break;
            }
            case GM: {
                break;
            }
            case GOD: {
                break;
            }
            case ID: {
                CMIMaterial cMIMaterial = CMIMaterial.get((ItemStack)itemStack);
                int n = this.plugin.getUtilManager().getItemData(itemStack);
                if (CMIMaterial.isPlayerHead((Material)itemStack.getType())) {
                    for (CMIItemStack bookMeta : searchInfo.getItemInfo()) {
                        if (!bookMeta.getCMIType().isPlayerHead()) continue;
                        return true;
                    }
                } else {
                    for (CMIItemStack potionMeta : searchInfo.getItemInfo()) {
                        if (cMIMaterial != potionMeta.getCMIType() || n != potionMeta.getData() && potionMeta.getData() != -1) continue;
                        return true;
                    }
                }
                break;
            }
            case LORE: {
                if (!itemStack.hasItemMeta()) {
                    return false;
                }
                if (!itemStack.getItemMeta().hasLore()) {
                    return false;
                }
                for (String string2 : itemStack.getItemMeta().getLore()) {
                    if (string2 == null || !CMIChatColor.stripColor((String)string2).replace(" ", "").toLowerCase().contains(searchInfo.getItemLore())) continue;
                    return true;
                }
                break;
            }
            case MAXHP: {
                break;
            }
            case NAME: {
                if (itemStack.getType() != Material.WRITTEN_BOOK) {
                    if (!itemStack.hasItemMeta()) {
                        return false;
                    }
                    if (!itemStack.getItemMeta().hasDisplayName()) {
                        return false;
                    }
                    if (!CMIChatColor.stripColor((String)itemStack.getItemMeta().getDisplayName()).replace(" ", "").toLowerCase().contains(searchInfo.getItemName())) break;
                    return true;
                }
                BookMeta bookMeta = (BookMeta)itemStack.getItemMeta();
                String string3 = bookMeta.getTitle();
                if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
                    string3 = itemStack.getItemMeta().getDisplayName();
                }
                if (string3 == null || !CMIChatColor.stripColor((String)string3).replace(" ", "").toLowerCase().contains(searchInfo.getItemName())) break;
                return true;
            }
            case OVERSIZE: {
                if (itemStack.getAmount() >= 1 && itemStack.getAmount() <= itemStack.getMaxStackSize()) break;
                return true;
            }
            case POTION: {
                CMIMaterial cMIMaterial = CMIMaterial.get((ItemStack)itemStack);
                if (!cMIMaterial.isPotion()) {
                    return false;
                }
                PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
                if (potionMeta.getCustomEffects().size() == 0) {
                    return false;
                }
                for (PotionEffect potionEffect : potionMeta.getCustomEffects()) {
                    if (potionEffect.getAmplifier() < searchInfo.getNumberState()) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private void checkPlayer(SearchInfo searchInfo, Player player) {
        String string;
        searchInfo.addChecked();
        if (player == null) {
            return;
        }
        if (searchInfo.getTime() + (long)this.showInterval < System.currentTimeMillis()) {
            searchInfo.setTime();
            this.showTimer(searchInfo);
        }
        if ((string = player.getName()) == null) {
            return;
        }
        switch (searchInfo.getSearchType()) {
            case ID: 
            case NAME: 
            case LORE: 
            case ENCHANT: 
            case POTION: 
            case OVERSIZE: {
                int n;
                ItemStack[] itemStackArray;
                ItemStack itemStack;
                boolean bl = false;
                int n2 = -1;
                ItemStack[] itemStackArray2 = player.getEnderChest().getContents();
                int n3 = itemStackArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    itemStack = itemStackArray2[n4];
                    ++n2;
                    if (itemStack != null && this.isThisItemOk(searchInfo, itemStack, player)) {
                        searchInfo.add(SearchPlaceType.EnderChest, string, itemStack.getAmount());
                    }
                    ++n4;
                }
                n2 = -1;
                if (searchInfo.exist(SearchPlaceType.EnderChest, player.getName())) {
                    int n5 = searchInfo.get(SearchPlaceType.EnderChest, player.getName());
                    if (n5 < searchInfo.getAmount()) {
                        searchInfo.remove(SearchPlaceType.EnderChest, player.getName());
                    } else if (searchInfo.isPurge()) {
                        itemStackArray = player.getEnderChest().getContents();
                        int n6 = itemStackArray.length;
                        n3 = 0;
                        while (n3 < n6) {
                            ItemStack itemStack2 = itemStackArray[n3];
                            ++n2;
                            if (itemStack2 != null && this.isThisItemOk(searchInfo, itemStack2, player) && !searchInfo.getSender().getName().equals(player.getName())) {
                                player.getEnderChest().setItem(n2, null);
                                bl = true;
                            }
                            ++n3;
                        }
                    }
                }
                n2 = -1;
                itemStackArray2 = player.getInventory().getContents();
                n3 = itemStackArray2.length;
                int n7 = 0;
                while (n7 < n3) {
                    itemStack = itemStackArray2[n7];
                    ++n2;
                    if (this.isThisItemOk(searchInfo, itemStack, player)) {
                        searchInfo.add(SearchPlaceType.Inventory, string, itemStack.getAmount());
                    }
                    ++n7;
                }
                if (searchInfo.exist(SearchPlaceType.Inventory, player.getName())) {
                    int n8 = searchInfo.get(SearchPlaceType.Inventory, player.getName());
                    if (n8 < searchInfo.getAmount()) {
                        searchInfo.remove(SearchPlaceType.Inventory, player.getName());
                    }
                    if (n8 >= searchInfo.getAmount() && searchInfo.isPurge()) {
                        n2 = -1;
                        itemStackArray = player.getInventory().getContents();
                        int n9 = itemStackArray.length;
                        n3 = 0;
                        while (n3 < n9) {
                            ItemStack itemStack3 = itemStackArray[n3];
                            ++n2;
                            if (this.isThisItemOk(searchInfo, itemStack3, player) && !searchInfo.getSender().getName().equals(player.getName())) {
                                player.getInventory().setItem(n2, null);
                                bl = true;
                            }
                            ++n3;
                        }
                    }
                }
                n2 = -1;
                ItemStack[] itemStackArray3 = player.getInventory().getArmorContents();
                itemStackArray = itemStackArray3;
                int n10 = itemStackArray3.length;
                n3 = 0;
                while (n3 < n10) {
                    ItemStack itemStack4 = itemStackArray[n3];
                    ++n2;
                    if (this.isThisItemOk(searchInfo, itemStack4, player)) {
                        searchInfo.add(SearchPlaceType.Inventory, string, itemStack4.getAmount());
                    }
                    ++n3;
                }
                n2 = -1;
                if (searchInfo.exist(SearchPlaceType.Inventory, player.getName())) {
                    int n11 = searchInfo.get(SearchPlaceType.Inventory, player.getName());
                    if (n11 < searchInfo.getAmount()) {
                        searchInfo.remove(SearchPlaceType.Inventory, player.getName());
                    } else if (searchInfo.isPurge()) {
                        ItemStack[] itemStackArray4 = itemStackArray3;
                        int n12 = itemStackArray3.length;
                        n10 = 0;
                        while (n10 < n12) {
                            ItemStack itemStack5 = itemStackArray4[n10];
                            ++n2;
                            n = this.isThisItemOk(searchInfo, itemStack5, player) ? 1 : 0;
                            if (n != 0 && !searchInfo.getSender().getName().equals(player.getName())) {
                                player.getInventory().setItem(n2, null);
                                bl = true;
                            }
                            ++n10;
                        }
                    }
                }
                if (bl) {
                    this.plugin.save(player);
                }
                if (player.isOnline()) {
                    player.updateInventory();
                }
                if (CMIHookType.PlayerVaults.hasSubType()) {
                    int n13 = 0;
                    while (n13 < 100) {
                        Inventory inventory;
                        if (PlayerVaultManager.vaultExists(player.getUniqueId(), n13) && (inventory = PlayerVaultManager.loadOtherVault(player.getUniqueId(), n13, 54)) != null) {
                            ItemStack[] itemStackArray5;
                            ItemStack[] itemStackArray6 = itemStackArray5 = inventory.getContents();
                            n = itemStackArray5.length;
                            int n14 = 0;
                            while (n14 < n) {
                                ItemStack itemStack6 = itemStackArray6[n14];
                                ++n2;
                                if (itemStack6 != null && this.isThisItemOk(searchInfo, itemStack6, player)) {
                                    searchInfo.add(SearchPlaceType.PlayerVaults, String.valueOf(string) + "%%" + n13, itemStack6.getAmount());
                                }
                                ++n14;
                            }
                        }
                        ++n13;
                    }
                }
                return;
            }
            case FLY: {
                if (searchInfo.getBooleanState() == player.getAllowFlight()) {
                    searchInfo.add(SearchPlaceType.PlayerVaults, string);
                }
                return;
            }
            case GM: {
                GameMode gameMode = player.getGameMode();
                if (gameMode == null) {
                    return;
                }
                int n = gameMode.getValue();
                if (searchInfo.getNumberState() == n) {
                    searchInfo.add(SearchPlaceType.PlayerVaults, string);
                }
                return;
            }
            case GOD: {
                try {
                    if (searchInfo.getBooleanState() == player.isInvulnerable()) {
                        searchInfo.add(SearchPlaceType.PlayerVaults, string);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            case MAXHP: {
                double d = player.getMaxHealth();
                if (d < (double)searchInfo.getNumberState()) {
                    return;
                }
                searchInfo.add(SearchPlaceType.PlayerVaults, string);
                return;
            }
        }
    }

    public void search(SearchInfo searchInfo) {
        CMILC.info_Searching.sendMessage(searchInfo.getSender(), new Object[0]);
        CMIScheduler.runTaskAsynchronously(() -> {
            Player player2;
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                try {
                    this.checkPlayer(searchInfo, player2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            player2 = new ArrayList();
            OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
            int n = offlinePlayerArray.length;
            int n2 = 0;
            while (n2 < n) {
                OfflinePlayer offlinePlayer = offlinePlayerArray[n2];
                player2.add(offlinePlayer);
                ++n2;
            }
            searchInfo.setPlayers((List<OfflinePlayer>)player2);
            this.perform(searchInfo);
        });
    }

    private void perform(SearchInfo searchInfo) {
        searchInfo.setTask(CMIScheduler.scheduleSyncRepeatingTask(() -> {
            int n = -1;
            for (OfflinePlayer offlinePlayer : searchInfo.getPlayers()) {
                if (++n >= 10) break;
                CMIUser cMIUser = this.plugin.getPlayerManager().getUser(offlinePlayer, false);
                if (cMIUser == null || cMIUser.isOnline()) continue;
                Player player = cMIUser.getPlayer();
                try {
                    this.checkPlayer(searchInfo, player);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (!cMIUser.isOnline()) {
                    cMIUser.setPlayer(null);
                }
                CMI.getInstance().getNMS().unloadData(player);
                if (searchInfo.getTask() != null) continue;
                return;
            }
            try {
                searchInfo.setPlayers(searchInfo.getPlayers().subList(10, searchInfo.getPlayers().size()));
            }
            catch (Exception exception) {
                searchInfo.getPlayers().clear();
            }
            if (searchInfo.getPlayers().isEmpty() || searchInfo.getPlayers().size() <= 10) {
                if (searchInfo.getTask() != null) {
                    searchInfo.getTask().cancel();
                }
                int n2 = searchInfo.found();
                if (searchInfo.getPlayer() != null && !searchInfo.getPlayer().isOnline()) {
                    return;
                }
                CMIActionBar.send((CommandSender)searchInfo.getSender(), (String)CMILC.getIM("search", "totalfound", "[amount]", n2, "[files]", searchInfo.getTotalChecked()));
                CMIScheduler.runTask(() -> {
                    Bukkit.dispatchCommand((CommandSender)searchInfo.getSender(), (String)"cmi search list");
                    searchInfo.setTask(null);
                });
            }
        }, (long)0L, (long)2L));
    }

    public void showTimer(SearchInfo searchInfo) {
        Player player = searchInfo.getPlayer();
        if (player == null) {
            CMIMessages.consoleMessage((String)("&2(&e" + searchInfo.found() + "&2) " + searchInfo.getTotalChecked() + "/" + searchInfo.getTotalPlayersToCheck()));
            return;
        }
        String string = "";
        switch (searchInfo.getCurrent()) {
            case 1: {
                string = " &4-&2----";
                searchInfo.setCurrent(2);
                break;
            }
            case 2: {
                string = " &6-&4-&2---";
                searchInfo.setCurrent(3);
                break;
            }
            case 3: {
                string = " &6--&4-&2--";
                searchInfo.setCurrent(4);
                break;
            }
            case 4: {
                string = " &6---&4-&2-";
                searchInfo.setCurrent(5);
                break;
            }
            case 5: {
                string = " &6----&4-&2";
                searchInfo.setCurrent(1);
            }
        }
        CMIActionBar.send((Player)player, (String)(String.valueOf(CMILC.getIM("search", "started", new Object[0])) + string + " &2(&e" + searchInfo.found() + "&2) " + searchInfo.getTotalChecked() + "/" + searchInfo.getTotalPlayersToCheck()));
    }

    public static enum SearchPlaceType {
        Inventory("inv", "inv%", "cmi inv [player]"),
        InventoryShulker("invS", "invS%", "cmi inv [player]"),
        EnderChest("ender", "end%", "cmi ender [player]"),
        PlayerVaults("PlayerVault", "Pv%", "pv [player] [nr]"),
        Custom("", "Cs%", "");

        private String Place;
        private String pref;
        private String cmd;

        private SearchPlaceType(String string2, String string3, String string4) {
            this.Place = string2;
            this.pref = string3;
            this.cmd = string4;
        }

        public String getPlace() {
            return this.Place;
        }

        public String getPref() {
            return this.pref;
        }

        public String getCmd() {
            return this.cmd;
        }
    }
}

