/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Chat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Chat.CMIChatBubble;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class ChatBubbleListener
implements Listener {
    private CMI plugin;

    public ChatBubbleListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void AsyncPlayerChatEvent(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        this.plugin.getChatBubbleManager().showBubble(asyncPlayerChatEvent.getPlayer(), String.valueOf(CMIChatColor.translate((String)CMIChatColor.getLastColors((String)asyncPlayerChatEvent.getFormat()))) + asyncPlayerChatEvent.getMessage(), asyncPlayerChatEvent.getRecipients());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMoveExtendedRnage(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (player == null) {
            return;
        }
        CMIChatBubble cMIChatBubble = this.plugin.getChatBubbleManager().getBubble(player.getUniqueId());
        if (cMIChatBubble == null) {
            return;
        }
        if (!playerTeleportEvent.getFrom().getWorld().equals(playerTeleportEvent.getTo().getWorld())) {
            cMIChatBubble.delete();
            return;
        }
        this.plugin.getTeleportHandler().teleportEntity(cMIChatBubble.getDisplay().getDisplayEntity(), playerTeleportEvent.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN).thenApply(bl -> {
            if (!bl.booleanValue()) {
                if (!cMIChatBubble.getDisplay().getDisplayEntity().isDead()) {
                    CMIScheduler.runAtEntity((Entity)cMIChatBubble.getDisplay().getDisplayEntity(), cMIChatBubble::delete);
                }
                return null;
            }
            if (!player.isOnline()) {
                return null;
            }
            player.addPassenger(cMIChatBubble.getDisplay().getDisplayEntity());
            return null;
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (player == null) {
            return;
        }
        this.plugin.getChatBubbleManager().clearCache(player.getUniqueId());
    }
}

