/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.DynamicSigns;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIBlock;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Version.PaperMethods.PaperLib;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;

public class CMISign {
    private CuboidArea area;
    private List<String> lines = new ArrayList<String>();
    private Sign sign;
    private double updateIntervalSec = 5.0;
    private Long lastUpdate = 0L;
    private boolean personal = true;
    private int activationRange = 8;
    private int currentLine = 0;
    private CMILocation loc;

    public CMISign(CMILocation cMILocation) {
        this.loc = cMILocation;
    }

    public World getWorld() {
        return this.loc.getWorld();
    }

    public CMILocation getLoc() {
        return this.loc;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String getLine(int n) {
        return this.lines.size() - 1 < n || n < 0 ? "" : (this.lines.get(n) == null ? "" : this.lines.get(n));
    }

    public List<String> getLinesAsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.lines) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setLines(List<String> list2) {
        this.lines = list2;
    }

    public void setLines(String[] stringArray) {
        this.lines = Arrays.asList(stringArray);
    }

    public CuboidArea getBasicArea() {
        if (this.area != null) {
            return this.area;
        }
        return new CuboidArea(this.getLoc().clone().add((double)(-this.activationRange), (double)(-this.activationRange), (double)(-this.activationRange)), this.getLoc().clone().add((double)this.activationRange, (double)this.activationRange, (double)this.activationRange));
    }

    public CompletableFuture<CuboidArea> getArea() {
        if (this.area != null) {
            return CompletableFuture.completedFuture(this.area);
        }
        CompletableFuture completableFuture = PaperLib.getChunkAtAsync((Location)this.getLoc());
        return completableFuture.thenCompose(chunk -> {
            block5: {
                int n = this.getLoc().getBlockX() & 0xF;
                int n2 = this.getLoc().getBlockZ() & 0xF;
                Block block = chunk.getBlock(n, this.getLoc().getBlockY(), n2);
                if (block.getState() instanceof Sign) {
                    try {
                        CMIBlock cMIBlock = new CMIBlock(block);
                        BlockFace blockFace = cMIBlock.getFacing();
                        if (blockFace != null) {
                            this.area = new CuboidArea(this.getLoc().clone().add((double)(blockFace.getModX() == 0 ? -this.activationRange / 2 : 0), (double)(-this.activationRange / 2), (double)(blockFace.getModZ() == 0 ? -this.activationRange / 2 : 0)), this.getLoc().clone().add((double)(blockFace.getModX() == 0 ? this.activationRange / 2 : this.activationRange * blockFace.getModX()), (double)(this.activationRange / 2), (double)(blockFace.getModZ() == 0 ? this.activationRange / 2 : this.activationRange * blockFace.getModZ())));
                            break block5;
                        }
                        this.area = new CuboidArea(this.getLoc().clone().add((double)(-this.activationRange / 2), (double)(-this.activationRange / 2), (double)(-this.activationRange / 2)), this.getLoc().clone().add((double)(this.activationRange / 2), (double)(this.activationRange / 2), (double)(this.activationRange / 2)));
                    }
                    catch (Error | Exception throwable) {
                        this.area = new CuboidArea(this.getLoc().clone().add((double)(-this.activationRange), (double)(-this.activationRange), (double)(-this.activationRange)), this.getLoc().clone().add((double)this.activationRange, (double)this.activationRange, (double)this.activationRange));
                    }
                } else {
                    this.area = new CuboidArea(this.getLoc().clone().add((double)(-this.activationRange), (double)(-this.activationRange), (double)(-this.activationRange)), this.getLoc().clone().add((double)this.activationRange, (double)this.activationRange, (double)this.activationRange));
                }
            }
            return CompletableFuture.completedFuture(this.area);
        });
    }

    public void setArea(CuboidArea cuboidArea) {
        this.area = cuboidArea;
    }

    public Sign getSign() {
        if (this.sign == null) {
            Block block = this.loc.getBlock();
            if (!(block.getState() instanceof Sign)) {
                return this.sign;
            }
            this.sign = (Sign)block.getState();
        }
        return this.sign;
    }

    public void setSign(Sign sign) {
        this.sign = sign;
    }

    public boolean isTimeToUpdate() {
        return (double)this.lastUpdate.longValue() + this.updateIntervalSec * 1000.0 - 10.0 <= (double)System.currentTimeMillis();
    }

    public void setAsUpdated() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public void update() {
        this.update(null);
    }

    public void update(Player player) {
        if (this.getSign() == null) {
            return;
        }
        try {
            CMIScheduler.runTaskAsynchronously(() -> {
                String[] stringArray = new String[4];
                int n = this.currentLine;
                if (n >= this.lines.size()) {
                    n = this.lines.size() - 1;
                }
                if (n - 1 >= this.lines.size()) {
                    n = 0;
                }
                int n2 = 0;
                int n3 = 0;
                while (n3 < 4) {
                    String string = CMIChatColor.colorize((String)this.getLine(n));
                    if (string == null) {
                        string = "";
                    }
                    if (string.equals("_")) {
                        string = "";
                    }
                    string = CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(player, string);
                    stringArray[n3] = string = CMIChatColor.colorize((String)string);
                    if (++n >= this.lines.size()) {
                        n = 0;
                    }
                    if (++n2 >= this.lines.size()) break;
                    ++n3;
                }
                if (player == null) {
                    n3 = 0;
                    while (n3 < 4) {
                        this.getSign().setLine(n3, stringArray[n3]);
                        ++n3;
                    }
                    CMIScheduler.runTask(() -> {
                        if (this.getSign().getLocation().getChunk().isLoaded()) {
                            this.getSign().update();
                        }
                    });
                } else {
                    player.sendSignChange(this.getSign().getLocation(), stringArray);
                }
            });
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
    }

    public double getUpdateIntervalSec() {
        return this.updateIntervalSec;
    }

    public void setUpdateIntervalSec(double d) {
        this.updateIntervalSec = d;
        if (this.updateIntervalSec < 0.0) {
            this.updateIntervalSec = 0.0;
        }
    }

    public boolean isPersonal() {
        return this.personal;
    }

    public void setPersonal(boolean bl) {
        this.personal = bl;
    }

    public int getActivationRange() {
        return this.activationRange;
    }

    public void setActivationRange(int n) {
        this.activationRange = n;
        if (this.activationRange < 1) {
            this.activationRange = 1;
        }
    }

    public void updateCurrentLine() {
        if (this.lines.size() > 4) {
            ++this.currentLine;
        }
        if (this.currentLine >= this.lines.size()) {
            this.currentLine = 0;
        }
        if (this.lines.size() <= 4) {
            this.currentLine = 0;
        }
    }
}

