/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.PlayerCombat;

import com.Zrips.CMI.CMI;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.Enchants.CMIEnchantment;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Entities.MobHeadInfo;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.PersistentData.CMIBlockPersistentDataContainer;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class HeadContainerListener
implements Listener {
    private CMI plugin;
    static final Pattern pattern = Pattern.compile("([a-zA-Z0-9+/]{32,}+={0,2})");

    public HeadContainerListener(CMI cMI) {
        this.plugin = cMI;
    }

    private boolean processPersistentContainer(BlockBreakEvent blockBreakEvent) {
        String string;
        if (!(this.plugin.getPlayerCombatManager().isMaintainName() || this.plugin.getPlayerCombatManager().isMaintainLore() || this.plugin.getPlayerCombatManager().isMaintainEnchants())) {
            return false;
        }
        Block block = blockBreakEvent.getBlock();
        CMIBlockPersistentDataContainer cMIBlockPersistentDataContainer = new CMIBlockPersistentDataContainer(block);
        String string2 = this.plugin.getPlayerCombatManager().isMaintainName() ? cMIBlockPersistentDataContainer.getString("Skull.Name") : null;
        String string3 = this.plugin.getPlayerCombatManager().isMaintainLore() ? cMIBlockPersistentDataContainer.getString("Skull.Lore") : null;
        String string4 = string = this.plugin.getPlayerCombatManager().isMaintainEnchants() ? cMIBlockPersistentDataContainer.getString("Skull.Enchants") : null;
        if (string2 == null && string3 == null && string == null) {
            return false;
        }
        if (block.getDrops().isEmpty()) {
            return false;
        }
        ItemStack itemStack = ((ItemStack)block.getDrops().iterator().next()).clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (string2 != null) {
            itemMeta.setDisplayName(string2);
        }
        if (string3 != null) {
            itemMeta.setLore(CMIList.stringToList((String)string3, (String)"\n"));
        }
        itemStack.setItemMeta(itemMeta);
        if (string != null) {
            HashMap<Enchantment, Integer> hashMap = new HashMap<Enchantment, Integer>();
            String[] stringArray = string.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string5 = stringArray[n2];
                try {
                    String[] stringArray2 = string5.split(":");
                    Enchantment enchantment = CMIEnchantment.get((String)stringArray2[0]);
                    int n3 = Integer.parseInt(stringArray2[1]);
                    if (enchantment != null && n3 > 0) {
                        hashMap.put(enchantment, n3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            if (!hashMap.isEmpty()) {
                itemStack.addUnsafeEnchantments(hashMap);
            }
        }
        blockBreakEvent.setDropItems(false);
        blockBreakEvent.getBlock().getWorld().dropItemNaturally(blockBreakEvent.getBlock().getLocation(), itemStack);
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockBreakEvent(BlockBreakEvent blockBreakEvent) {
        String string;
        if (blockBreakEvent.isCancelled() || !blockBreakEvent.isDropItems()) {
            return;
        }
        Block block = blockBreakEvent.getBlock();
        if (!(block.getState() instanceof Skull)) {
            return;
        }
        try {
            if (this.processPersistentContainer(blockBreakEvent)) {
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        Object object = CMINBT.getNbt((Block)block);
        if (object == null) {
            return;
        }
        Matcher matcher = pattern.matcher(object.toString());
        if (!matcher.find()) {
            return;
        }
        CMINBT cMINBT = new CMINBT(block);
        if (cMINBT.hasNBT("PublicBukkitValues.slimefun:slimefun_block") && (string = cMINBT.getString("SkullOwner.Name")) != null && string.startsWith("CS-")) {
            return;
        }
        string = matcher.group(0);
        if (string == null) {
            return;
        }
        CMIEntityType[] cMIEntityTypeArray = CMIEntityType.values();
        int n = cMIEntityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIEntityType cMIEntityType = cMIEntityTypeArray[n2];
            MobHeadInfo mobHeadInfo = (MobHeadInfo)cMIEntityType.getHeadTexturesMap().get(string);
            if (mobHeadInfo != null) {
                ItemStack itemStack = cMIEntityType.getHead(string);
                if (itemStack == null) break;
                blockBreakEvent.setDropItems(false);
                blockBreakEvent.getBlock().getWorld().dropItemNaturally(blockBreakEvent.getBlock().getLocation(), itemStack);
                break;
            }
            ++n2;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlaceEvent(BlockPlaceEvent blockPlaceEvent) {
        String string;
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        Block block = blockPlaceEvent.getBlock();
        if (!(block.getState() instanceof Skull)) {
            return;
        }
        ItemStack itemStack = blockPlaceEvent.getItemInHand();
        ItemMeta itemMeta = itemStack.getItemMeta();
        CMIBlockPersistentDataContainer cMIBlockPersistentDataContainer = new CMIBlockPersistentDataContainer(block);
        if (itemMeta.hasDisplayName()) {
            cMIBlockPersistentDataContainer.set("Skull.Name", itemMeta.getDisplayName());
        }
        if (itemMeta.hasLore()) {
            cMIBlockPersistentDataContainer.set("Skull.Lore", CMIList.listToString((List)itemMeta.getLore(), (String)"\n"));
        }
        if (!itemMeta.getEnchants().isEmpty() && !(string = itemMeta.getEnchants().entrySet().stream().map(entry -> String.valueOf(CMIEnchantment.getName((Enchantment)((Enchantment)entry.getKey()))) + ":" + entry.getValue()).collect(Collectors.joining(";"))).isEmpty()) {
            cMIBlockPersistentDataContainer.set("Skull.Enchants", string);
        }
    }
}

