/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.CmdCost;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.CmdCost.CMICommandCost;
import com.Zrips.CMI.Modules.CmdCost.CMICommandCostUsage;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.CommandsHandler;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.RawMessages.RawMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CMICommandCostManager {
    private HashMap<String, CMICommandCost> costs = new HashMap();
    CMI plugin;
    private String fileName = "CommandCost.yml";

    public CMICommandCostManager(CMI cMI) {
        this.plugin = cMI;
    }

    public int getCommandCostCount() {
        return this.costs.size();
    }

    public void addCost(String string, double d) {
        this.costs.put(string.toLowerCase(), new CMICommandCost(string, d));
    }

    public CMICommandCost getCost(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        string = (string = string.toLowerCase()).startsWith(":") ? string.substring(1) : string;
        for (Map.Entry<String, CMICommandCost> entry : this.costs.entrySet()) {
            String string2;
            if (!string.startsWith(entry.getKey()) || !(string2 = string.substring(entry.getKey().length())).isEmpty() && !string2.startsWith(" ") && !entry.getKey().endsWith(" ")) continue;
            return entry.getValue();
        }
        return null;
    }

    public CMICommandCostUsage canUseCmd(CommandSender commandSender, String string) {
        if (!(commandSender instanceof Player)) {
            return CMICommandCostUsage.Can;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        string = string.startsWith(String.valueOf(CommandsHandler.getLabel()) + " :") ? String.valueOf(CommandsHandler.getLabel()) + " " + string.substring((String.valueOf(CommandsHandler.getLabel()) + " :").length()) : string;
        string = string.startsWith(String.valueOf(CommandsHandler.getLabel()) + ":" + CommandsHandler.getLabel()) ? String.valueOf(CommandsHandler.getLabel()) + string.substring(CommandsHandler.getLabel().length() * 2 + 1) : string;
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)commandSender);
        if (cMIUser == null) {
            return CMICommandCostUsage.Can;
        }
        CMICommandCost cMICommandCost = this.getCost(string);
        if (cMICommandCost == null) {
            return CMICommandCostUsage.Can;
        }
        if (PermissionsManager.CMIPerm.costbypass_$1.hasPermission(commandSender, cMICommandCost.getSubCommand().replace(" ", ""))) {
            return CMICommandCostUsage.CostBypass;
        }
        if (cMICommandCost.isRequiresConfirmation() && !cMICommandCost.isConfirmation(cMIUser.getUniqueId(), string)) {
            cMICommandCost.addConfirmation(cMIUser.getUniqueId(), string);
            return CMICommandCostUsage.ReqConfirm;
        }
        return cMIUser.hasMoney(cMICommandCost.getCost()) ? CMICommandCostUsage.Can : CMICommandCostUsage.NoMoney;
    }

    public boolean isContinueCommand(CommandSender commandSender, String string) {
        boolean bl;
        CMICommandCostUsage cMICommandCostUsage = this.plugin.getCommandCostManager().canUseCmd(commandSender, string);
        boolean bl2 = commandSender instanceof Player ? cMICommandCostUsage.equals((Object)CMICommandCostUsage.Can) || cMICommandCostUsage.equals((Object)CMICommandCostUsage.CostBypass) : (bl = true);
        if (!bl && commandSender instanceof Player) {
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)commandSender);
            CMICommandCost cMICommandCost = this.plugin.getCommandCostManager().getCost(string);
            if (cMICommandCostUsage.equals((Object)CMICommandCostUsage.NoMoney) || cMICommandCostUsage.equals((Object)CMICommandCostUsage.Cant)) {
                if (cMICommandCost != null && cMICommandCost.getCost() > 0.0 && !cMIUser.hasMoney(cMICommandCost.getCost())) {
                    CMIMessages.sendMessage((Object)commandSender, (LC)LC.econ_notEnoughMoney, (Object[])new Object[]{"[amount]", this.plugin.getEconomyManager().format(cMICommandCost.getCost())});
                    return false;
                }
            } else if (cMICommandCostUsage.equals((Object)CMICommandCostUsage.ReqConfirm)) {
                RawMessage rawMessage = new RawMessage();
                rawMessage.addText(CMILC.econ_commandCost.getLocale("[cost]", this.plugin.getEconomyManager().format(cMICommandCost.getCost())));
                rawMessage.addHover(LC.info_Click.getLocale(new Object[0]));
                rawMessage.addCommand(string);
                rawMessage.show(commandSender);
                return false;
            }
        }
        return true;
    }

    public boolean loadConfig(boolean bl) {
        this.plugin.safeRenameFile("commandCost.yml", "Settings" + File.separator + this.fileName);
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + this.fileName);
        }
        catch (Exception exception) {
            if (bl) {
                this.plugin.consoleMessage("&cSEVERE CONFIG FILE READ ERROR. Check your spelling! Changes will not be applied until you fix it or perform server restart which can result in config file reset");
                return false;
            }
            exception.printStackTrace();
        }
        if (configReader == null) {
            return false;
        }
        boolean bl2 = configReader.get("Enabled", Boolean.valueOf(false));
        configReader.addComment("Commands", new String[]{"Example: - 'cmi heal:100.5:true'", "While defining command avoid using alias and use full command name", "Cost can be any positive number", "After cost you can use true/false to define if you want to inform player when money is charged after using command or not", "Second true/false will define if we confirmation from players by typing command again or clicking on a message in chat before performing it and charging for it. This will include information about command cost. By default players will be asked for confirmation", "Attention! Don't use alias command name, use full base command, for example /heal is not valid, use /cmi heal otherwise you will be risking in allowing players to perform base command without a charge", "On another hand you can use custom alias commands in here", "", "Keep in mind: base CMI commands will double check if command was successfully performed before charging money, while custom alias will charge money despite commands success", "So in example of /cmi warp player will not be charged if he enters incorrect warp name, while having custom alias will charge money even if command fails to be performed"});
        List list2 = Arrays.asList("cmi heal:100.5:true:true", "cmi feed:100.5:true:true", "cmi home :30:true:true", "cmi warp :10:true:true");
        list2 = configReader.get("Commands", list2);
        this.costs.clear();
        if (bl2) {
            for (String string : list2) {
                CMICommandCost cMICommandCost = CMICommandCostManager.get(string);
                if (cMICommandCost == null) continue;
                this.costs.put(cMICommandCost.getCommand().toLowerCase(), cMICommandCost);
            }
        }
        configReader.save();
        return true;
    }

    private static CMICommandCost get(String string) {
        String[] stringArray = string.split(":");
        CMICommandCost cMICommandCost = null;
        try {
            cMICommandCost = new CMICommandCost(stringArray[0], Double.parseDouble(stringArray[1]));
        }
        catch (Exception exception) {
            CMI.getInstance().consoleMessage("&cWrong input for command cost: " + string);
            return null;
        }
        try {
            if (stringArray.length > 2) {
                cMICommandCost.setInformOnCharge(Boolean.parseBoolean(stringArray[2]));
            }
        }
        catch (Exception exception) {
            CMI.getInstance().consoleMessage("&cWrong input for command cost: " + string);
        }
        try {
            if (stringArray.length > 3) {
                cMICommandCost.setRequiresConfirmation(Boolean.parseBoolean(stringArray[3]));
            }
        }
        catch (Exception exception) {
            CMI.getInstance().consoleMessage("&cWrong input for command confirmation: " + string);
        }
        return cMICommandCost;
    }
}

