/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.GeoIP;

import com.Zrips.CMI.Modules.GeoIP.IPLocation;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.concurrent.ConcurrentHashMap;

public class LookupService {
    private RandomAccessFile file;
    private final File databaseFile;
    private static final Charset charset = Charset.forName("ISO-8859-1");
    private final CharsetDecoder charsetDecoder = charset.newDecoder();
    ConcurrentHashMap<String, IPLocation> cache = new ConcurrentHashMap();
    private byte databaseType = 1;
    private int[] databaseSegments;
    private int recordLength;
    private int dboptions;
    private byte[] dbbuffer;
    private byte[] index_cache;
    private long mtime;
    private static final int COUNTRY_BEGIN = 0xFFFF00;
    private static final int STATE_BEGIN_REV0 = 16700000;
    private static final int STATE_BEGIN_REV1 = 16000000;
    private static final int STRUCTURE_INFO_MAX_SIZE = 20;
    public static final int GEOIP_STANDARD = 0;
    public static final int GEOIP_MEMORY_CACHE = 1;
    public static final int GEOIP_CHECK_CACHE = 2;
    public static final int GEOIP_INDEX_CACHE = 4;
    public static final int GEOIP_UNKNOWN_SPEED = 0;
    public static final int GEOIP_DIALUP_SPEED = 1;
    public static final int GEOIP_CABLEDSL_SPEED = 2;
    public static final int GEOIP_CORPORATE_SPEED = 3;
    private static final int SEGMENT_RECORD_LENGTH = 3;
    private static final int STANDARD_RECORD_LENGTH = 3;
    private static final int ORG_RECORD_LENGTH = 4;
    private static final int MAX_RECORD_LENGTH = 4;
    private static final int FULL_RECORD_LENGTH = 60;
    private static final String[] countryCode = new String[]{"--", "AP", "EU", "AD", "AE", "AF", "AG", "AI", "AL", "AM", "CW", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "SX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TL", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "RS", "ZA", "ZM", "ME", "ZW", "A1", "A2", "O1", "AX", "GG", "IM", "JE", "BL", "MF", "BQ", "SS", "O1"};
    private static final String[] countryName = new String[]{"N/A", "Asia/Pacific Region", "Europe", "Andorra", "United Arab Emirates", "Afghanistan", "Antigua and Barbuda", "Anguilla", "Albania", "Armenia", "Curacao", "Angola", "Antarctica", "Argentina", "American Samoa", "Austria", "Australia", "Aruba", "Azerbaijan", "Bosnia and Herzegovina", "Barbados", "Bangladesh", "Belgium", "Burkina Faso", "Bulgaria", "Bahrain", "Burundi", "Benin", "Bermuda", "Brunei Darussalam", "Bolivia", "Brazil", "Bahamas", "Bhutan", "Bouvet Island", "Botswana", "Belarus", "Belize", "Canada", "Cocos (Keeling) Islands", "Congo, The Democratic Republic of the", "Central African Republic", "Congo", "Switzerland", "Cote D'Ivoire", "Cook Islands", "Chile", "Cameroon", "China", "Colombia", "Costa Rica", "Cuba", "Cape Verde", "Christmas Island", "Cyprus", "Czech Republic", "Germany", "Djibouti", "Denmark", "Dominica", "Dominican Republic", "Algeria", "Ecuador", "Estonia", "Egypt", "Western Sahara", "Eritrea", "Spain", "Ethiopia", "Finland", "Fiji", "Falkland Islands (Malvinas)", "Micronesia, Federated States of", "Faroe Islands", "France", "Sint Maarten (Dutch part)", "Gabon", "United Kingdom", "Grenada", "Georgia", "French Guiana", "Ghana", "Gibraltar", "Greenland", "Gambia", "Guinea", "Guadeloupe", "Equatorial Guinea", "Greece", "South Georgia and the South Sandwich Islands", "Guatemala", "Guam", "Guinea-Bissau", "Guyana", "Hong Kong", "Heard Island and McDonald Islands", "Honduras", "Croatia", "Haiti", "Hungary", "Indonesia", "Ireland", "Israel", "India", "British Indian Ocean Territory", "Iraq", "Iran, Islamic Republic of", "Iceland", "Italy", "Jamaica", "Jordan", "Japan", "Kenya", "Kyrgyzstan", "Cambodia", "Kiribati", "Comoros", "Saint Kitts and Nevis", "Korea, Democratic People's Republic of", "Korea, Republic of", "Kuwait", "Cayman Islands", "Kazakhstan", "Lao People's Democratic Republic", "Lebanon", "Saint Lucia", "Liechtenstein", "Sri Lanka", "Liberia", "Lesotho", "Lithuania", "Luxembourg", "Latvia", "Libya", "Morocco", "Monaco", "Moldova, Republic of", "Madagascar", "Marshall Islands", "Macedonia", "Mali", "Myanmar", "Mongolia", "Macau", "Northern Mariana Islands", "Martinique", "Mauritania", "Montserrat", "Malta", "Mauritius", "Maldives", "Malawi", "Mexico", "Malaysia", "Mozambique", "Namibia", "New Caledonia", "Niger", "Norfolk Island", "Nigeria", "Nicaragua", "Netherlands", "Norway", "Nepal", "Nauru", "Niue", "New Zealand", "Oman", "Panama", "Peru", "French Polynesia", "Papua New Guinea", "Philippines", "Pakistan", "Poland", "Saint Pierre and Miquelon", "Pitcairn Islands", "Puerto Rico", "Palestinian Territory", "Portugal", "Palau", "Paraguay", "Qatar", "Reunion", "Romania", "Russian Federation", "Rwanda", "Saudi Arabia", "Solomon Islands", "Seychelles", "Sudan", "Sweden", "Singapore", "Saint Helena", "Slovenia", "Svalbard and Jan Mayen", "Slovakia", "Sierra Leone", "San Marino", "Senegal", "Somalia", "Suriname", "Sao Tome and Principe", "El Salvador", "Syrian Arab Republic", "Swaziland", "Turks and Caicos Islands", "Chad", "French Southern Territories", "Togo", "Thailand", "Tajikistan", "Tokelau", "Turkmenistan", "Tunisia", "Tonga", "Timor-Leste", "Turkey", "Trinidad and Tobago", "Tuvalu", "Taiwan", "Tanzania, United Republic of", "Ukraine", "Uganda", "United States Minor Outlying Islands", "United States", "Uruguay", "Uzbekistan", "Holy See (Vatican City State)", "Saint Vincent and the Grenadines", "Venezuela", "Virgin Islands, British", "Virgin Islands, U.S.", "Vietnam", "Vanuatu", "Wallis and Futuna", "Samoa", "Yemen", "Mayotte", "Serbia", "South Africa", "Zambia", "Montenegro", "Zimbabwe", "Anonymous Proxy", "Satellite Provider", "Other", "Aland Islands", "Guernsey", "Isle of Man", "Jersey", "Saint Barthelemy", "Saint Martin", "Bonaire, Saint Eustatius and Saba", "South Sudan", "Other"};

    static {
        if (countryCode.length != countryName.length) {
            throw new AssertionError((Object)"countryCode.length!=countryName.length");
        }
    }

    public LookupService(File file, int n) {
        this.databaseFile = file;
        if (file.isFile()) {
            this.file = new RandomAccessFile(file, "r");
        }
        this.dboptions = n;
        this.init();
    }

    private synchronized void init() {
        if (this.file == null) {
            return;
        }
        if ((this.dboptions & 2) != 0) {
            this.mtime = this.databaseFile.lastModified();
        }
        this.file.seek(this.file.length() - 3L);
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[3];
        int n = 0;
        while (n < 20) {
            this.file.readFully(byArray);
            if (byArray[0] == -1 && byArray[1] == -1 && byArray[2] == -1) {
                this.databaseType = this.file.readByte();
                if (this.databaseType >= 106) {
                    this.databaseType = (byte)(this.databaseType - 105);
                }
                if (this.databaseType == 7) {
                    this.databaseSegments = new int[1];
                    this.databaseSegments[0] = 16700000;
                    this.recordLength = 3;
                    break;
                }
                if (this.databaseType == 3) {
                    this.databaseSegments = new int[1];
                    this.databaseSegments[0] = 16000000;
                    this.recordLength = 3;
                    break;
                }
                if (this.databaseType != 6 && this.databaseType != 2 && this.databaseType != 5 && this.databaseType != 23 && this.databaseType != 4 && this.databaseType != 22 && this.databaseType != 11 && this.databaseType != 24 && this.databaseType != 9 && this.databaseType != 21 && this.databaseType != 32 && this.databaseType != 33 && this.databaseType != 31 && this.databaseType != 30) break;
                this.databaseSegments = new int[1];
                this.databaseSegments[0] = 0;
                this.recordLength = this.databaseType == 6 || this.databaseType == 2 || this.databaseType == 21 || this.databaseType == 32 || this.databaseType == 33 || this.databaseType == 31 || this.databaseType == 30 || this.databaseType == 9 ? 3 : 4;
                this.file.readFully(byArray2);
                int n2 = 0;
                while (n2 < 3) {
                    this.databaseSegments[0] = this.databaseSegments[0] + (LookupService.unsignedByteToInt(byArray2[n2]) << n2 * 8);
                    ++n2;
                }
                break;
            }
            this.file.seek(this.file.getFilePointer() - 4L);
            ++n;
        }
        if (this.databaseType == 1 || this.databaseType == 12 || this.databaseType == 8 || this.databaseType == 10) {
            this.databaseSegments = new int[1];
            this.databaseSegments[0] = 0xFFFF00;
            this.recordLength = 3;
        }
        if ((this.dboptions & 1) == 1) {
            n = (int)this.file.length();
            this.dbbuffer = new byte[n];
            this.file.seek(0L);
            this.file.readFully(this.dbbuffer, 0, n);
            this.file.close();
        }
        if ((this.dboptions & 4) != 0) {
            n = this.databaseSegments[0] * this.recordLength * 2;
            this.index_cache = new byte[n];
            this.file.seek(0L);
            this.file.readFully(this.index_cache, 0, n);
        } else {
            this.index_cache = null;
        }
    }

    public synchronized void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
            this.file = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void _check_mtime() {
        try {
            long l;
            if ((this.dboptions & 2) != 0 && (l = this.databaseFile.lastModified()) != this.mtime) {
                this.close();
                this.file = new RandomAccessFile(this.databaseFile, "r");
                this.init();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public IPLocation getLocation(InetAddress inetAddress) {
        if (!this.databaseFile.isFile()) {
            return LookupService.getEmpty();
        }
        return this.getLocation(LookupService.bytesToLong(inetAddress.getAddress()));
    }

    public IPLocation getLocation(String string) {
        InetAddress inetAddress;
        if (string == null) {
            return LookupService.getEmpty();
        }
        IPLocation iPLocation = this.cache.get(string);
        if (iPLocation != null) {
            return iPLocation;
        }
        if (!this.databaseFile.isFile()) {
            this.cache.put(string, LookupService.getEmpty());
            return LookupService.getEmpty();
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.cache.put(string, LookupService.getEmpty());
            return LookupService.getEmpty();
        }
        IPLocation iPLocation2 = this.getLocation(inetAddress);
        this.cache.put(string, iPLocation2);
        return iPLocation2;
    }

    private synchronized IPLocation getLocation(long l) {
        if (!this.databaseFile.isFile()) {
            return LookupService.getEmpty();
        }
        try {
            int n = this.seekCountry(l);
            return this.readCityRecord(n);
        }
        catch (IOException iOException) {
            return LookupService.getEmpty();
        }
    }

    private static IPLocation getEmpty() {
        IPLocation iPLocation = new IPLocation();
        iPLocation.setCountryCode("--");
        iPLocation.setCountryName("N/A");
        return iPLocation;
    }

    private IPLocation readCityRecord(int n) {
        if (n == this.databaseSegments[0]) {
            return LookupService.getEmpty();
        }
        ByteBuffer byteBuffer = this.readRecordBuf(n, 60);
        IPLocation iPLocation = new IPLocation();
        try {
            int n2 = LookupService.unsignedByteToInt(byteBuffer.get());
            if (n2 == 0) {
                int n3 = n - 0xFFFF00;
                iPLocation.setCountryCode(countryCode[n3]);
                iPLocation.setCountryName(countryName[n3]);
            } else {
                iPLocation.setCountryCode(countryCode[n2]);
                iPLocation.setCountryName(countryName[n2]);
            }
            iPLocation.setRegion(this.readString(byteBuffer));
            iPLocation.setCity(this.readString(byteBuffer));
            iPLocation.setPostalCode(this.readString(byteBuffer));
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        return iPLocation;
    }

    private ByteBuffer readRecordBuf(int n, int n2) {
        ByteBuffer byteBuffer;
        int n3 = n + (2 * this.recordLength - 1) * this.databaseSegments[0];
        if ((this.dboptions & 1) == 1) {
            byteBuffer = ByteBuffer.wrap(this.dbbuffer, n3, Math.min(this.dbbuffer.length - n3, n2));
        } else {
            byte[] byArray = new byte[n2];
            this.file.seek(n3);
            this.file.read(byArray);
            byteBuffer = ByteBuffer.wrap(byArray);
        }
        return byteBuffer;
    }

    private String readString(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        while (byteBuffer.hasRemaining() && byteBuffer.get() != 0) {
        }
        int n3 = byteBuffer.position() - 1;
        String string = null;
        if (n3 > n) {
            byteBuffer.position(n);
            byteBuffer.limit(n3);
            string = this.charsetDecoder.decode(byteBuffer).toString();
            byteBuffer.limit(n2);
        }
        byteBuffer.position(n3 + 1);
        return string;
    }

    private synchronized int seekCountry(long l) {
        byte[] byArray = new byte[8];
        int[] nArray = new int[2];
        int n = 0;
        this._check_mtime();
        int n2 = 31;
        while (n2 >= 0) {
            this.readNode(byArray, nArray, n);
            if ((l & (long)(1 << n2)) > 0L) {
                if (nArray[1] >= this.databaseSegments[0]) {
                    return nArray[1];
                }
                n = nArray[1];
            } else {
                if (nArray[0] >= this.databaseSegments[0]) {
                    return nArray[0];
                }
                n = nArray[0];
            }
            --n2;
        }
        return 0;
    }

    private void readNode(byte[] byArray, int[] nArray, int n) {
        if ((this.dboptions & 1) == 1) {
            System.arraycopy(this.dbbuffer, 2 * this.recordLength * n, byArray, 0, 2 * this.recordLength);
        } else if ((this.dboptions & 4) != 0) {
            System.arraycopy(this.index_cache, 2 * this.recordLength * n, byArray, 0, 2 * this.recordLength);
        } else {
            try {
                this.file.seek(2 * this.recordLength * n);
                this.file.read(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int n2 = 0;
        while (n2 < 2) {
            nArray[n2] = 0;
            int n3 = 0;
            while (n3 < this.recordLength) {
                int n4 = byArray[n2 * this.recordLength + n3];
                if (n4 < 0) {
                    n4 += 256;
                }
                int n5 = n2;
                nArray[n5] = nArray[n5] + (n4 << n3 * 8);
                ++n3;
            }
            ++n2;
        }
    }

    private static long bytesToLong(byte[] byArray) {
        long l = 0L;
        int n = 0;
        while (n < 4) {
            long l2 = byArray[n];
            if (l2 < 0L) {
                l2 += 256L;
            }
            l += l2 << (3 - n) * 8;
            ++n;
        }
        return l;
    }

    private static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }
}

