/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.HpBar;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.utils.Util;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Entities.CMIEntity;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class HpBarListener
implements Listener {
    private CMI plugin;

    public HpBarListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void EntityDamageEntityEvent(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isBossBarHpBarEnabled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (this.plugin.getConfigManager().getHpBarBlackList().contains(entity.getType())) {
            return;
        }
        if (!(entity instanceof Damageable)) {
            return;
        }
        Player player = Util.getAttacker((EntityDamageEvent)entityDamageByEntityEvent);
        this.show(player, entity, entityDamageByEntityEvent.getFinalDamage());
    }

    private void show(Player player, Entity entity, double d) {
        if (player == null) {
            return;
        }
        if (player.getUniqueId().equals(entity.getUniqueId())) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (entity.getType().name().equals("ARMOR_STAND")) {
            return;
        }
        if (!PermissionsManager.CMIPerm.bossbar_hpbar.hasPermission((CommandSender)player, false, 60000L)) {
            return;
        }
        BossBarInfo bossBarInfo = new BossBarInfo(cMIUser.getPlayer(), "CMIHpBar");
        Damageable damageable = (Damageable)entity;
        bossBarInfo.setPercentage(damageable.getMaxHealth(), damageable.getHealth() - d);
        bossBarInfo.setStyle(BarStyle.SEGMENTED_10);
        double d2 = damageable.getHealth() - d;
        d2 = Math.floor(CMINumber.clamp((double)d2, (double)0.0, (double)d2) * 100.0) / 100.0;
        double d3 = d2 * 100.0 / damageable.getMaxHealth();
        if (d3 > 50.0) {
            bossBarInfo.setColor(BarColor.GREEN);
        } else if (d3 > 30.0) {
            bossBarInfo.setColor(BarColor.YELLOW);
        } else {
            bossBarInfo.setColor(BarColor.RED);
        }
        bossBarInfo.setKeepForTicks(Integer.valueOf(50));
        CMIEntity cMIEntity = new CMIEntity(entity);
        bossBarInfo.setTitleOfBar(CMILC.BossBar_hpBar.getLocale("[victim]", cMIEntity.getCustomName(), "[max]", (int)damageable.getMaxHealth(), "[current]", d2, "[damage]", (double)((int)(d * 100.0)) / 100.0));
        cMIUser.addBossBar(bossBarInfo);
    }
}

