/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.NickName;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Containers.CMIColorTypes;
import com.Zrips.CMI.Containers.CMITextCleaner;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.BungeeCord.BungeeCordManager;
import com.Zrips.CMI.Modules.BungeeCord.BungeeCordServer;
import com.Zrips.CMI.Modules.ChatFormat.ChatFormatManager;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Placeholders.Placeholder;
import com.Zrips.CMI.Modules.Vanish.VanishAction;
import com.Zrips.CMI.commands.list.vanish;
import java.util.Map;
import java.util.regex.Pattern;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerLoginEvent;

public class NickNameListener
implements Listener {
    private CMI plugin;

    public NickNameListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerLoginEvent(PlayerLoginEvent playerLoginEvent) {
        Player player = playerLoginEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.getNickName() == null) {
            return;
        }
        String string = this.plugin.getNickNameManager().getNickNameFormat();
        if (string.contains("{prefix}")) {
            string = string.replace("{prefix}", cMIUser.getPrefix());
        }
        if (string.contains("{suffix}")) {
            string = string.replace("{suffix}", cMIUser.getSuffix());
        }
        if (string.contains("{nickName}")) {
            string = string.replace("{nickName}", cMIUser.getNickName());
        }
        string = CMIChatColor.translate((String)string);
        player.setDisplayName(string);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void cleanPublicChatFromColors(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser != null) {
            cMIUser.updateDisplayName();
        }
        asyncPlayerChatEvent.setMessage(CMITextCleaner.cleanFromColorCodes(player, asyncPlayerChatEvent.getMessage(), CMIColorTypes.publicmessage, false));
    }

    public static String processGradientChat(Player player, String string) {
        CMIUser cMIUser = CMIUser.getUser(player);
        string = cMIUser != null && cMIUser.getChatMessageFormat() != null ? string.replace(Placeholder.CMIPlaceHolders.cmi_user_chatcolor.getFull(), cMIUser.getChatMessageFormat().toString()) : string.replace(Placeholder.CMIPlaceHolders.cmi_user_chatcolor.getFull(), "");
        if (CMIChatColor.stripColor((String)string).equals(string)) {
            String string2 = CMI.getInstance().getChatFormatManager().getGroupMessageFormat(player);
            string2 = cMIUser != null && cMIUser.getChatMessageFormat() != null ? string2.replace(Placeholder.CMIPlaceHolders.cmi_user_chatcolor.getFull(), cMIUser.getChatMessageFormat().toString()) : string2.replace(Placeholder.CMIPlaceHolders.cmi_user_chatcolor.getFull(), "");
            int n = (int)(Pattern.compile("\\{message\\}").splitAsStream(string2).count() - 1L);
            if (n > 1) {
                int n2;
                int n3 = string.length() / n;
                int n4 = 0;
                while (n4 < n - 1) {
                    String string3 = "";
                    n2 = n4 * n3;
                    while (n2 < n3 + n4 * n3) {
                        char c = string.charAt(n2);
                        string3 = String.valueOf(string3) + c;
                        ++n2;
                    }
                    string2 = string2.replaceFirst("\\{message\\}", string3);
                    ++n4;
                }
                String string4 = "";
                int n5 = n3 * (n - 1);
                while (n5 < string.length()) {
                    n2 = string.charAt(n5);
                    string4 = String.valueOf(string4) + (char)n2;
                    ++n5;
                }
                string2 = string2.replaceFirst("\\{message\\}", string4);
            }
            string = string2.replace("{message}", string);
        }
        return string;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void AsyncPlayerChatEventRawConverter(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        int n;
        if (asyncPlayerChatEvent.isCancelled() || asyncPlayerChatEvent.getRecipients().isEmpty()) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.plugin.getChatManager().isChatClickHoverMessages()) {
            int n2;
            if (this.plugin.getChatManager().isModifyChatFormat()) {
                asyncPlayerChatEvent.setMessage(NickNameListener.processGradientChat(player, asyncPlayerChatEvent.getMessage()));
            }
            if (this.plugin.getTagManager().isChatTagEnabled()) {
                asyncPlayerChatEvent.setMessage(this.plugin.getTagManager().tag(player, asyncPlayerChatEvent.getMessage(), asyncPlayerChatEvent.getFormat(), true));
            }
            if (this.plugin.getBungeeCordManager().isBungeeCord() && this.plugin.getChatFormatManager().isBungeePublicMessages() && ((n2 = this.plugin.getChatFormatManager().getChatGeneralRange(player.getWorld())) <= 0 || n2 > 0 && (BungeeCordManager.localRangedMessage == null || !BungeeCordManager.localRangedMessage.equals(player.getUniqueId()) || BungeeCordManager.localRangedMessageTime < System.currentTimeMillis()))) {
                CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
                for (Map.Entry<String, BungeeCordServer> entry : this.plugin.getBungeeCordManager().getServers().entrySet()) {
                    if (this.plugin.getBungeeCordManager().getThisServerName().equals(entry.getKey()) || !PermissionsManager.CMIPerm.bungee_publicmessages_$1.hasSetPermission((CommandSender)player, entry.getKey())) continue;
                    this.plugin.getBungeeCordManager().sendPublicMessage(entry.getKey(), asyncPlayerChatEvent.getPlayer().getName(), asyncPlayerChatEvent.getFormat().replace("%1$s", cMIUser.getDisplayName()).replace("%2$s", asyncPlayerChatEvent.getMessage()));
                }
            }
            return;
        }
        RawMessage rawMessage = new RawMessage();
        rawMessage.setDontBreakLine(true);
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isVanished() && cMIUser.getVanish().is(VanishAction.noMessages)) {
            CMILC.info(vanish.class, (CommandSender)player, "noMsg", new Object[0]);
            asyncPlayerChatEvent.setCancelled(true);
            return;
        }
        String string = CMILC.Chat_publicHover.getLocale(new Object[0]);
        string = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, string);
        rawMessage.addText(asyncPlayerChatEvent.getFormat().replace("%1$s", cMIUser.getDisplayName()).replace("%2$s", ""));
        rawMessage.addHover(string);
        ChatFormatManager.chatClickAction.pubmsg.updateClickAction(rawMessage, cMIUser);
        String string2 = asyncPlayerChatEvent.getMessage();
        string2 = CMITextCleaner.cleanFromColorCodes(player, asyncPlayerChatEvent.getMessage(), CMIColorTypes.publicmessage, false);
        string2 = this.plugin.getChatFormatManager().updateUrl(CMIChatColor.deColorize((String)string2));
        if (this.plugin.getChatManager().isModifyChatFormat()) {
            asyncPlayerChatEvent.setMessage(CMIChatColor.translate((String)NickNameListener.processGradientChat(player, string2)));
        } else {
            asyncPlayerChatEvent.setMessage(CMIChatColor.translate((String)string2));
        }
        if (this.plugin.getTagManager().isChatTagEnabled()) {
            string2 = this.plugin.getTagManager().tag(player, asyncPlayerChatEvent.getMessage(), asyncPlayerChatEvent.getFormat(), true);
        }
        this.plugin.getChatFormatManager().convertHoverOver(rawMessage, string2, player);
        string2 = this.plugin.getChatFormatManager().convertHoverItem(new StringBuilder(), string2, player, false).toString();
        for (Player player2 : asyncPlayerChatEvent.getRecipients()) {
            rawMessage.show(player2);
        }
        if (CMIModule.chatBubble.isEnabled()) {
            this.plugin.getChatBubbleManager().showBubble(asyncPlayerChatEvent.getPlayer(), String.valueOf(CMIChatColor.translate((String)CMIChatColor.getLastColors((String)asyncPlayerChatEvent.getFormat()))) + string2, asyncPlayerChatEvent.getRecipients());
        }
        if (this.plugin.getChatManager().isChatDynMapChat()) {
            this.plugin.getDynMapManager().sentMessage(player, string2);
        }
        asyncPlayerChatEvent.getRecipients().clear();
        asyncPlayerChatEvent.setFormat(CMIChatColor.stripHexColor((String)asyncPlayerChatEvent.getFormat()));
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_16_R1) && this.plugin.getChatManager().isModifyChatFormat()) {
            asyncPlayerChatEvent.setMessage(CMIChatColor.stripHexColor((String)string2));
        }
        if (Config.monochromeConsole) {
            asyncPlayerChatEvent.setFormat(CMIChatColor.stripColor((String)asyncPlayerChatEvent.getFormat()));
            asyncPlayerChatEvent.setMessage(CMIChatColor.stripColor((String)string2));
        }
        if (this.plugin.getBungeeCordManager().isBungeeCord() && this.plugin.getChatFormatManager().isBungeePublicMessages() && ((n = this.plugin.getChatFormatManager().getChatGeneralRange(player.getWorld())) <= 0 || n > 0 && (BungeeCordManager.localRangedMessage == null || !BungeeCordManager.localRangedMessage.equals(player.getUniqueId()) || BungeeCordManager.localRangedMessageTime < System.currentTimeMillis()))) {
            for (Map.Entry<String, BungeeCordServer> entry : this.plugin.getBungeeCordManager().getServers().entrySet()) {
                if (this.plugin.getBungeeCordManager().getThisServerName().equalsIgnoreCase(entry.getKey()) || !PermissionsManager.CMIPerm.bungee_publicmessages_$1.hasSetPermission((CommandSender)player, entry.getKey())) continue;
                this.plugin.getBungeeCordManager().sendPublicMessage(entry.getKey(), asyncPlayerChatEvent.getPlayer().getName(), rawMessage.getRaw());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void AsyncPlayerChatEventExtra(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        String string = asyncPlayerChatEvent.getFormat();
        Player player = asyncPlayerChatEvent.getPlayer();
        String string2 = asyncPlayerChatEvent.getMessage();
        if (!this.plugin.getChatManager().isChatClickHoverMessages()) {
            if (this.plugin.getChatManager().isColorsPublicMessages()) {
                string2 = CMITextCleaner.cleanFromColorCodes(player, asyncPlayerChatEvent.getMessage(), CMIColorTypes.publicmessage, false);
            }
            if (this.plugin.getTagManager().isChatTagEnabled()) {
                string2 = this.plugin.getTagManager().tag(player, string2, asyncPlayerChatEvent.getFormat(), true);
            }
            if (this.plugin.getChatManager().isModifyChatFormat()) {
                asyncPlayerChatEvent.setMessage(CMIChatColor.translate((String)string2));
            }
        }
        if (asyncPlayerChatEvent.getRecipients().isEmpty()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        string2 = string.contains("%2$s") ? string.replace("%2$s", string2) : string2;
        String string3 = string2 = string.contains("%1$s") ? string2.replace("%1$s", cMIUser.getDisplayName()) : string2;
        if (this.plugin.getBungeeCordManager().isBungeeCord() && this.plugin.getChatFormatManager().isBungeePublicMessages()) {
            for (Map.Entry<String, BungeeCordServer> entry : this.plugin.getBungeeCordManager().getServers().entrySet()) {
                if (this.plugin.getBungeeCordManager().getThisServerName().equalsIgnoreCase(entry.getKey()) || !PermissionsManager.CMIPerm.bungee_publicmessages_$1.hasSetPermission((CommandSender)player, entry.getKey())) continue;
                this.plugin.getBungeeCordManager().sendPublicMessage(entry.getKey(), asyncPlayerChatEvent.getPlayer().getName(), string2);
            }
        }
    }
}

