/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Selection;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import com.Zrips.CMI.Modules.Selection.SelectionSides;
import com.Zrips.CMI.Modules.Selection.Visualizer;
import com.Zrips.CMI.events.CMISelectionEvent;
import com.Zrips.CMI.events.CMISelectionVisualizationEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class SelectionManager {
    protected Map<UUID, CuboidArea> selections;
    protected CMI plugin;
    private HashMap<UUID, Visualizer> vMap = new HashMap();
    int visualizerSidesCap = 1000;
    int visualizerFrameCap = 1000;
    CMIEffectManager.CMIParticle selectedSpigotSides = CMIEffectManager.CMIParticle.DUST;
    CMIEffectManager.CMIParticle selectedSpigotFrame = CMIEffectManager.CMIParticle.HAPPY_VILLAGER;
    long visualizerShowFor = 60000L;
    long visualizerUpdateInterval = 10L;
    private static int Range = 16;

    public SelectionManager(CMI cMI) {
        this.plugin = cMI;
        this.selections = Collections.synchronizedMap(new HashMap());
    }

    public void hideSelection(Player player) {
        Visualizer visualizer = this.vMap.get(player.getUniqueId());
        if (visualizer == null) {
            return;
        }
        visualizer.cancelAll();
    }

    public void updateLocations(Player player, Location location, Location location2) {
        this.updateLocations(player, location, location2, false);
    }

    public void updateLocations(Player player, Location location, Location location2, boolean bl) {
        if (location != null && location2 != null) {
            this.selections.put(player.getUniqueId(), new CuboidArea(location, location2));
            this.afterSelectionUpdate(player, bl);
        }
    }

    public void placeLoc1(Player player, Location location) {
        this.placeLoc1(player, location, false);
    }

    public void placeLoc1(Player player, Location location, boolean bl) {
        if (location == null) {
            return;
        }
        CuboidArea cuboidArea = this.getSelectionCuboid(player);
        if (cuboidArea == null || cuboidArea.getWorld() != null && !cuboidArea.getWorld().equals(location.getWorld())) {
            cuboidArea = new CuboidArea(location.getWorld());
            this.setSelectionCuboid(player, cuboidArea);
        }
        cuboidArea.setLowLocation(location);
        if (bl) {
            this.afterSelectionUpdate(player);
        }
    }

    public void placeLoc2(Player player, Location location) {
        this.placeLoc2(player, location, false);
    }

    public void placeLoc2(Player player, Location location, boolean bl) {
        if (location == null) {
            return;
        }
        CuboidArea cuboidArea = this.getSelectionCuboid(player);
        if (cuboidArea == null || cuboidArea.getWorld() != null && !cuboidArea.getWorld().equals(location.getWorld())) {
            cuboidArea = new CuboidArea(location.getWorld());
            this.setSelectionCuboid(player, cuboidArea);
        }
        cuboidArea.setHighLocation(location);
        if (bl) {
            this.afterSelectionUpdate(player);
        }
    }

    public void afterSelectionUpdate(Player player) {
        this.afterSelectionUpdate(player, false);
    }

    public void afterSelectionUpdate(Player player, boolean bl) {
        if (this.hasPlacedBoth(player)) {
            Visualizer visualizer = this.vMap.get(player.getUniqueId());
            if (visualizer == null) {
                visualizer = new Visualizer(player);
            }
            visualizer.setStart(System.currentTimeMillis());
            visualizer.cancelAll();
            if (bl) {
                visualizer.setLoc(null);
            }
            visualizer.setAreas(this.getSelectionCuboid(player));
            this.showBounds(player, visualizer);
        }
    }

    @Deprecated
    public Location getPlayerLoc1(Player player) {
        return this.getPlayerLoc1(player.getUniqueId());
    }

    @Deprecated
    public Location getPlayerLoc1(String string) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(string);
        if (cMIUser == null) {
            return null;
        }
        return this.getPlayerLoc1(cMIUser.getUniqueId());
    }

    @Deprecated
    public Location getPlayerLoc1(UUID uUID) {
        CuboidArea cuboidArea = this.selections.get(uUID);
        if (cuboidArea == null) {
            return null;
        }
        return cuboidArea.getLowLoc();
    }

    @Deprecated
    public Location getPlayerLoc2(Player player) {
        return this.getPlayerLoc2(player.getUniqueId());
    }

    @Deprecated
    public Location getPlayerLoc2(String string) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(string);
        if (cMIUser == null) {
            return null;
        }
        return this.getPlayerLoc2(cMIUser.getUniqueId());
    }

    @Deprecated
    public Location getPlayerLoc2(UUID uUID) {
        CuboidArea cuboidArea = this.selections.get(uUID);
        if (cuboidArea == null) {
            return null;
        }
        return cuboidArea.getHighLoc();
    }

    public CuboidArea getSelectionCuboid(Player player) {
        if (player == null) {
            return null;
        }
        return this.getSelectionCuboid(player.getUniqueId());
    }

    public void setSelectionCuboid(Player player, CuboidArea cuboidArea) {
        this.selections.put(player.getUniqueId(), cuboidArea);
        CMISelectionEvent cMISelectionEvent = new CMISelectionEvent(player, this.plugin.getSelectionManager().getSelectionCuboid(player));
        Bukkit.getPluginManager().callEvent((Event)cMISelectionEvent);
    }

    @Deprecated
    public CuboidArea getSelectionCuboid(String string) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(string);
        if (cMIUser == null) {
            return null;
        }
        return this.getSelectionCuboid(cMIUser.getUniqueId());
    }

    public CuboidArea getSelectionCuboid(UUID uUID) {
        if (uUID == null) {
            return null;
        }
        return this.selections.get(uUID);
    }

    public boolean hasPlacedBoth(Player player) {
        return this.hasPlacedBoth(player.getUniqueId());
    }

    @Deprecated
    public boolean hasPlacedBoth(String string) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(string);
        if (cMIUser == null) {
            return false;
        }
        return this.hasPlacedBoth(cMIUser.getUniqueId());
    }

    public boolean hasPlacedBoth(UUID uUID) {
        CuboidArea cuboidArea = this.selections.get(uUID);
        if (cuboidArea == null) {
            return false;
        }
        return cuboidArea.valid();
    }

    @Deprecated
    public void showSelectionInfo(Player player) {
        this.showSelection(player);
    }

    public void showSelection(Player player) {
        if (this.hasPlacedBoth(player.getUniqueId())) {
            Visualizer visualizer = new Visualizer(player);
            visualizer.setAreas(this.getSelectionCuboid(player));
            this.showBounds(player, visualizer);
        }
    }

    public void showBounds(Player player, Visualizer visualizer) {
        Visualizer visualizer2 = this.vMap.get(player.getUniqueId());
        if (visualizer2 != null) {
            visualizer2.cancelAll();
        }
        CMISelectionVisualizationEvent cMISelectionVisualizationEvent = new CMISelectionVisualizationEvent(player, visualizer);
        Bukkit.getPluginManager().callEvent((Event)cMISelectionVisualizationEvent);
        if (cMISelectionVisualizationEvent.isCancelled()) {
            return;
        }
        this.vMap.put(player.getUniqueId(), visualizer);
        CMIScheduler.runTaskAsynchronously(() -> {
            if (!visualizer.getAreas().isEmpty()) {
                this.makeBorders(player);
            }
        });
    }

    public List<Location> getLocations(Location location, Location location2, Vector vector, boolean bl) {
        double d = 1.0;
        double d2 = 1.0;
        if (vector.getX() == 0.0) {
            vector.setX(d + d * 0.1);
        }
        if (vector.getY() == 0.0) {
            vector.setY(d2 + d2 * 0.1);
        }
        if (vector.getZ() == 0.0) {
            vector.setZ(d + d * 0.1);
        }
        double d3 = d;
        double d4 = d2;
        if (bl) {
            d3 = 0.0;
            d4 = 0.0;
        }
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (location.getWorld() != location2.getWorld()) {
            return arrayList;
        }
        double d5 = d3;
        while (d5 < vector.getX()) {
            Location location3 = location.clone();
            if (vector.getX() > d + d * 0.1) {
                location3.add(d5, 0.0, 0.0);
            }
            double d6 = d4;
            while (d6 < vector.getY()) {
                Location location4 = location3.clone();
                if (vector.getY() > d2 + d2 * 0.1) {
                    location4.add(0.0, d6, 0.0);
                }
                double d7 = d3;
                while (d7 < vector.getZ()) {
                    double d8;
                    Location location5 = location4.clone();
                    if (vector.getZ() > d + d * 0.1) {
                        location5.add(0.0, 0.0, d7);
                    }
                    if ((d8 = location2.distance(location5)) < (double)Range) {
                        arrayList.add(location5.clone());
                    }
                    d7 += d;
                }
                d6 += d2;
            }
            d5 += d;
        }
        return arrayList;
    }

    private List<Location> getLocationsWallsByData(Location location, Vector vector, Location location2, SelectionSides selectionSides) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (selectionSides.ShowNorthSide()) {
            arrayList.addAll(this.getLocations(location2.clone(), location.clone(), new Vector(vector.getX(), vector.getY(), 0.0), false));
        }
        if (selectionSides.ShowSouthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, 0.0, vector.getZ()), location.clone(), new Vector(vector.getX(), vector.getY(), 0.0), false));
        }
        if (selectionSides.ShowWestSide()) {
            arrayList.addAll(this.getLocations(location2.clone(), location.clone(), new Vector(0.0, vector.getY(), vector.getZ()), false));
        }
        if (selectionSides.ShowEastSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(vector.getX(), 0.0, 0.0), location.clone(), new Vector(0.0, vector.getY(), vector.getZ()), false));
        }
        if (selectionSides.ShowTopSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, vector.getY(), 0.0), location.clone(), new Vector(vector.getX(), 0.0, vector.getZ()), false));
        }
        if (selectionSides.ShowBottomSide()) {
            arrayList.addAll(this.getLocations(location2.clone(), location.clone(), new Vector(vector.getX(), 0.0, vector.getZ()), false));
        }
        return arrayList;
    }

    private List<Location> getLocationsCornersByData(Location location, Vector vector, Location location2, SelectionSides selectionSides) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (selectionSides.ShowBottomSide() && selectionSides.ShowNorthSide()) {
            arrayList.addAll(this.getLocations(location2.clone(), location.clone(), new Vector(vector.getX(), 0.0, 0.0), true));
        }
        if (selectionSides.ShowTopSide() && selectionSides.ShowNorthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, vector.getY(), 0.0), location.clone(), new Vector(vector.getX(), 0.0, 0.0), true));
        }
        if (selectionSides.ShowBottomSide() && selectionSides.ShowSouthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, 0.0, vector.getZ()), location.clone(), new Vector(vector.getX(), 0.0, 0.0), true));
        }
        if (selectionSides.ShowTopSide() && selectionSides.ShowSouthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, vector.getY(), vector.getZ()), location.clone(), new Vector(vector.getX(), 0.0, 0.0), true));
        }
        if (selectionSides.ShowWestSide() && selectionSides.ShowNorthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, 0.0, 0.0), location.clone(), new Vector(0.0, vector.getY(), 0.0), true));
        }
        if (selectionSides.ShowEastSide() && selectionSides.ShowNorthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(vector.getX(), 0.0, 0.0), location.clone(), new Vector(0.0, vector.getY(), 0.0), true));
        }
        if (selectionSides.ShowSouthSide() && selectionSides.ShowWestSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, 0.0, vector.getZ()), location.clone(), new Vector(0.0, vector.getY(), 0.0), true));
        }
        if (selectionSides.ShowSouthSide() && selectionSides.ShowEastSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(vector.getX(), 0.0, vector.getZ()), location.clone(), new Vector(0.0, vector.getY() + 1.0, 0.0), true));
        }
        if (selectionSides.ShowWestSide() && selectionSides.ShowBottomSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, 0.0, 0.0), location.clone(), new Vector(0.0, 0.0, vector.getZ()), true));
        }
        if (selectionSides.ShowEastSide() && selectionSides.ShowBottomSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(vector.getX(), 0.0, 0.0), location.clone(), new Vector(0.0, 0.0, vector.getZ()), true));
        }
        if (selectionSides.ShowWestSide() && selectionSides.ShowTopSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, vector.getY(), 0.0), location.clone(), new Vector(0.0, 0.0, vector.getZ()), true));
        }
        if (selectionSides.ShowEastSide() && selectionSides.ShowTopSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(vector.getX(), vector.getY(), 0.0), location.clone(), new Vector(0.0, 0.0, vector.getZ()), true));
        }
        return arrayList;
    }

    public boolean makeBorders(Player player) {
        Visualizer visualizer = this.vMap.get(player.getUniqueId());
        if (visualizer == null) {
            return false;
        }
        List<CuboidArea> list2 = null;
        list2 = visualizer.getAreas();
        Location location = player.getLocation();
        ArrayList<Location> arrayList = new ArrayList<Location>();
        ArrayList<Location> arrayList2 = new ArrayList<Location>();
        boolean bl = visualizer.isSameLoc();
        if (!bl) {
            for (CuboidArea cuboidArea : list2) {
                if (cuboidArea == null) continue;
                CuboidArea cuboidArea2 = cuboidArea.clone();
                cuboidArea2.getHighPoint().add(new Vector(1, 1, 1));
                SelectionSides selectionSides = new SelectionSides();
                double d = location.getBlockX() - Range;
                double d2 = location.getBlockZ() - Range;
                double d3 = location.getBlockY() - Range;
                double d4 = location.getBlockX() + Range;
                double d5 = location.getBlockZ() + Range;
                double d6 = location.getBlockY() + Range;
                if ((double)cuboidArea2.getLowPoint().getBlockX() < d) {
                    cuboidArea2.getLowPoint().setX(d);
                    selectionSides.setWestSide(false);
                }
                if ((double)cuboidArea2.getHighPoint().getBlockX() > d4) {
                    cuboidArea2.getHighPoint().setX(d4);
                    selectionSides.setEastSide(false);
                }
                if ((double)cuboidArea2.getLowPoint().getBlockZ() < d2) {
                    cuboidArea2.getLowPoint().setZ(d2);
                    selectionSides.setNorthSide(false);
                }
                if ((double)cuboidArea2.getHighPoint().getBlockZ() > d5) {
                    cuboidArea2.getHighPoint().setZ(d5);
                    selectionSides.setSouthSide(false);
                }
                if ((double)cuboidArea2.getLowPoint().getBlockY() < d3) {
                    cuboidArea2.getLowPoint().setY(d3);
                    selectionSides.setBottomSide(false);
                }
                if ((double)cuboidArea2.getHighPoint().getBlockY() > d6) {
                    cuboidArea2.getHighPoint().setY(d6);
                    selectionSides.setTopSide(false);
                }
                double d7 = cuboidArea2.getXSize() - 1;
                double d8 = cuboidArea2.getYSize() - 1;
                double d9 = cuboidArea2.getZSize() - 1;
                arrayList.addAll(this.getLocationsWallsByData(location, new Vector(d7, d8, d9), cuboidArea2.getLowLoc(), selectionSides));
                arrayList2.addAll(this.getLocationsCornersByData(location, new Vector(d7, d8, d9), cuboidArea2.getLowLoc(), selectionSides));
            }
            visualizer.setLoc(player.getLocation());
        } else {
            arrayList.addAll(visualizer.getLocations());
            arrayList2.addAll(visualizer.getLocations2());
        }
        if (visualizer.getTask() != null) {
            visualizer.getTask().cancel();
        }
        CMIScheduler.runTaskAsynchronously(() -> {
            CMIEffectManager.CMIParticle cMIParticle = CMIEffectManager.CMIParticle.getCMIParticle((String)this.selectedSpigotSides.name());
            CMIEffect cMIEffect = new CMIEffect(cMIParticle);
            cMIEffect.setAmount(1);
            cMIEffect.setOffset(new Vector(0, 0, 0));
            cMIEffect.setSpeed(0.0f);
            int n = arrayList.size();
            int n2 = arrayList2.size();
            int n3 = 1;
            int n4 = 1;
            if (n > this.visualizerSidesCap && !bl) {
                n3 = n / this.visualizerSidesCap + 1;
            }
            if (n2 > this.visualizerFrameCap && !bl) {
                n4 = n2 / this.visualizerFrameCap + 1;
            }
            ArrayList<Location> arrayList = new ArrayList<Location>();
            ArrayList<Location> arrayList2 = new ArrayList<Location>();
            try {
                Location location;
                int n5 = 0;
                while (n5 < arrayList.size()) {
                    location = (Location)arrayList.get(n5);
                    this.plugin.getNMS().playEffect(player, location, this.selectedSpigotSides, 0.0f, 0.0f, 0.0f, 0.0f, 1);
                    if (!bl) {
                        arrayList.add(location);
                    }
                    n5 += n3;
                }
                n5 = 0;
                while (n5 < arrayList2.size()) {
                    location = (Location)arrayList2.get(n5);
                    this.plugin.getNMS().playEffect(player, location, this.selectedSpigotFrame, 0.0f, 0.0f, 0.0f, 0.0f, 1);
                    if (!bl) {
                        arrayList2.add(location);
                    }
                    n5 += n4;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            if (!bl) {
                visualizer.setLocations(arrayList);
                visualizer.setLocations2(arrayList2);
            }
        });
        if (visualizer.isOnce()) {
            return true;
        }
        if (visualizer.getStart() + this.visualizerShowFor < System.currentTimeMillis()) {
            return false;
        }
        visualizer.setTask(CMIScheduler.runTaskLater(() -> {
            if (player.isOnline()) {
                this.makeBorders(player);
            }
        }, (long)(this.visualizerUpdateInterval * 1L)));
        return true;
    }

    public void clearSelection(Player player) {
        this.selections.remove(player.getUniqueId());
    }

    public boolean worldEdit(Player player) {
        LC.info_NoInformation.sendMessage((Object)player, new Object[0]);
        return false;
    }

    public boolean worldEditUpdate(Player player) {
        LC.info_NoInformation.sendMessage((Object)player, new Object[0]);
        return false;
    }
}

