/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.SpawnerCharge;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.util.List;
import java.util.Random;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerActionsListener
implements Listener {
    private CMI plugin;

    public SpawnerActionsListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreakExplodeTnT(EntityExplodeEvent entityExplodeEvent) {
        if (entityExplodeEvent.isCancelled()) {
            return;
        }
        if (!(entityExplodeEvent.getEntity() instanceof TNTPrimed)) {
            return;
        }
        if (!this.plugin.getSpawnerChargesManager().isSpawnerDropFromTnt()) {
            return;
        }
        if (this.plugin.getSpawnerChargesManager().isSpawnersSupportDisabled()) {
            return;
        }
        int n = this.plugin.getSpawnerChargesManager().getSpawnerDropChanceTnt();
        this.dropSpawner(n, entityExplodeEvent.blockList());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteractEvent(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.isCancelled()) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null || !CMIMaterial.get((Block)block).equals((Object)CMIMaterial.SPAWNER)) {
            return;
        }
        if (this.plugin.getSpawnerChargesManager().isSpawnersSupportDisabled()) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        try {
            if (Version.isCurrentHigher((Version)Version.v1_8_R3) && playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!player.isSneaking()) {
            ItemStack itemStack;
            if (this.plugin.getSpawnerChargesManager().isSpawnersBreakEnabled() && CMIMaterial.isPickaxe((Material)(itemStack = CMI.getInstance().getPlayerManager().getUser(player).getItemInHand()).getType())) {
                CMILC.info_ClickSpawner.sendMessage(player, "[percent]", this.plugin.getSpawnerChargesManager().getSpawnerDropChance(player, block));
            }
            return;
        }
        if (!PermissionsManager.CMIPerm.command_spawner_shiftclick.hasPermission((CommandSender)player, true, false, new String[0])) {
            return;
        }
        this.plugin.getSpawnerChargesManager().openSpawnerPickerUI(player, 1);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreakExplodeCreeper(EntityExplodeEvent entityExplodeEvent) {
        if (entityExplodeEvent.isCancelled()) {
            return;
        }
        if (!(entityExplodeEvent.getEntity() instanceof Creeper)) {
            return;
        }
        if (!this.plugin.getSpawnerChargesManager().isSpawnerDropFromCreeper()) {
            return;
        }
        if (this.plugin.getSpawnerChargesManager().isSpawnersSupportDisabled()) {
            return;
        }
        int n = this.plugin.getSpawnerChargesManager().getSpawnerDropChanceCreeper();
        this.dropSpawner(n, entityExplodeEvent.blockList());
    }

    private void dropSpawner(int n, List<Block> list2) {
        Random random = new Random(System.nanoTime());
        for (Block block : list2) {
            int n2;
            if (!CMIMaterial.SPAWNER.equals(block.getType()) || (n2 = random.nextInt(100)) > n) continue;
            ItemStack itemStack = CMIMaterial.SPAWNER.newItemStack();
            BlockState blockState = block.getState();
            CreatureSpawner creatureSpawner = (CreatureSpawner)blockState;
            itemStack = this.plugin.getUtilManager().setEntityType(itemStack, creatureSpawner.getSpawnedType());
            block.setType(Material.AIR);
            block.getWorld().dropItemNaturally(block.getLocation(), itemStack);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        ItemMeta itemMeta;
        if (!this.plugin.getSpawnerChargesManager().isSpawnersPlaceEnabled()) {
            return;
        }
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        if (!CMIMaterial.SPAWNER.equals(blockPlaceEvent.getBlock().getType())) {
            return;
        }
        if (this.plugin.getSpawnerChargesManager().isSpawnersSupportDisabled()) {
            return;
        }
        Player player = blockPlaceEvent.getPlayer();
        ItemStack itemStack = blockPlaceEvent.getItemInHand();
        if (itemStack == null) {
            return;
        }
        BlockState blockState = blockPlaceEvent.getBlock().getState();
        CreatureSpawner creatureSpawner = (CreatureSpawner)blockState;
        boolean bl = false;
        EntityType entityType = null;
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_19_R2) && Version.isCurrentEqualOrLower((Version)Version.v1_20_R3)) {
            itemMeta = new CMINBT(itemStack);
            boolean bl2 = bl = !itemMeta.hasNBT("BlockEntityTag");
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) {
            BlockStateMeta blockStateMeta;
            itemMeta = itemStack.getItemMeta();
            if (itemMeta instanceof BlockStateMeta && (blockStateMeta = (BlockStateMeta)itemMeta).getBlockState() instanceof CreatureSpawner) {
                CreatureSpawner creatureSpawner2 = (CreatureSpawner)blockStateMeta.getBlockState();
                entityType = creatureSpawner2.getSpawnedType();
            }
        } else {
            entityType = new CMIItemStack(itemStack).getEntityType();
        }
        if (entityType == null && !bl) {
            return;
        }
        if (this.plugin.getSpawnerChargesManager().isSpawnersPlaceRequiresPermission()) {
            if (!this.plugin.getSpawnerChargesManager().isSpawnersPlaceRequiresExactPermission()) {
                if (!PermissionsManager.CMIPerm.placespawner.hasPermission((CommandSender)player, true, new String[0])) {
                    blockPlaceEvent.setCancelled(true);
                    return;
                }
            } else if (entityType != null && !PermissionsManager.CMIPerm.placespawner_$1.hasPermission((CommandSender)player, entityType.name().toLowerCase())) {
                blockPlaceEvent.setCancelled(true);
                return;
            }
        }
        if (bl) {
            return;
        }
        creatureSpawner.setSpawnedType(entityType);
        creatureSpawner.update();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSpawnerInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.isCancelled()) {
            return;
        }
        if (playerInteractEvent.getClickedBlock() == null) {
            return;
        }
        if (!CMIMaterial.SPAWNER.equals(playerInteractEvent.getClickedBlock().getType())) {
            return;
        }
        if (this.plugin.getSpawnerChargesManager().isSpawnersSupportDisabled()) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        ItemStack itemStack = playerInteractEvent.getItem();
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        if (!CMIMaterial.isMonsterEgg((Material)itemStack.getType())) {
            return;
        }
        if (!this.plugin.getSpawnerChargesManager().isSpawnersEggInteractRequiresPermission()) {
            return;
        }
        EntityType entityType = new CMIItemStack(itemStack).getEntityType();
        if (entityType == null) {
            return;
        }
        if (!PermissionsManager.CMIPerm.egginteract_$1.hasPermission((CommandSender)player, true, entityType.name().toLowerCase())) {
            playerInteractEvent.setCancelled(true);
            return;
        }
    }
}

