/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.SpawnerCharge;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerChargeListener
implements Listener {
    private CMI plugin;
    Random rand = new Random();
    static HashMap<UUID, Block> breaking = new HashMap();

    public SpawnerChargeListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void BlockBreakEventExpDrop(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        if (!CMIMaterial.SPAWNER.equals(blockBreakEvent.getBlock().getType())) {
            return;
        }
        if (this.plugin.getSpawnerChargesManager().isSpawnersSupportDisabled()) {
            return;
        }
        if (!this.plugin.getSpawnerChargesManager().isSpawnersXpDrop()) {
            blockBreakEvent.setExpToDrop(0);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void BlockBreakEventFull(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        if (!CMIMaterial.SPAWNER.equals(blockBreakEvent.getBlock().getType())) {
            return;
        }
        if (this.plugin.getSpawnerChargesManager().isSpawnersSupportDisabled()) {
            return;
        }
        breaking.remove(blockBreakEvent.getPlayer().getUniqueId());
        Player player = blockBreakEvent.getPlayer();
        if (this.plugin.getSpawnerChargesManager().isChargesUse()) {
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
            if (cMIUser == null) {
                return;
            }
            boolean bl = cMIUser.getPCharge().have();
            if (!PermissionsManager.CMIPerm.spawners_charge_bypass.hasPermission((CommandSender)player)) {
                if (!bl) {
                    player.sendMessage(this.plugin.getLM().getMessage("command.charges.info.cantBreak", new Object[0]));
                    if (!this.plugin.getSpawnerChargesManager().isChargesBreakWithoutCharge()) {
                        blockBreakEvent.setCancelled(true);
                        return;
                    }
                } else if (!cMIUser.getPCharge().takeCharge()) {
                    player.sendMessage(this.plugin.getLM().getMessage("command.charges.info.allUsed", "[time]", cMIUser.getPCharge().getLeftTime()));
                    if (!this.plugin.getSpawnerChargesManager().isChargesBreakWithoutCharge()) {
                        blockBreakEvent.setCancelled(true);
                        return;
                    }
                    return;
                }
            }
        }
        if (!this.plugin.getSpawnerChargesManager().isSpawnersBreakEnabled()) {
            return;
        }
        int n = this.plugin.getSpawnerChargesManager().getSpawnerDropChance(player, blockBreakEvent.getBlock());
        if (n <= 0 || this.rand.nextInt(100) > n) {
            if (n >= 0) {
                CMILC.info_FailedSpawnerMine.sendMessage(player, "[percent]", n);
            }
            blockBreakEvent.setExpToDrop(0);
            return;
        }
        breaking.put(player.getUniqueId(), blockBreakEvent.getBlock());
        blockBreakEvent.setExpToDrop(0);
    }

    public static void clearCache(UUID uUID) {
        breaking.remove(uUID);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void blockBreakEventFull(BlockBreakEvent blockBreakEvent) {
        if (this.plugin.getSpawnerChargesManager().isSpawnersSupportDisabled()) {
            return;
        }
        if (breaking.isEmpty()) {
            return;
        }
        Block block = breaking.remove(blockBreakEvent.getPlayer().getUniqueId());
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        if (block == null) {
            return;
        }
        if (!blockBreakEvent.getBlock().equals(block)) {
            return;
        }
        ItemStack itemStack = CMIMaterial.SPAWNER.newItemStack();
        BlockState blockState = blockBreakEvent.getBlock().getState();
        if (!(blockState instanceof CreatureSpawner)) {
            return;
        }
        CreatureSpawner creatureSpawner = (CreatureSpawner)blockState;
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) {
            BlockStateMeta blockStateMeta;
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta instanceof BlockStateMeta && (blockStateMeta = (BlockStateMeta)itemMeta).getBlockState() instanceof CreatureSpawner) {
                CreatureSpawner creatureSpawner2 = (CreatureSpawner)blockStateMeta.getBlockState();
                creatureSpawner2.setSpawnedType(creatureSpawner.getSpawnedType());
                blockStateMeta.setBlockState((BlockState)creatureSpawner2);
                itemStack.setItemMeta((ItemMeta)blockStateMeta);
            }
            blockBreakEvent.getBlock().getWorld().dropItemNaturally(blockBreakEvent.getBlock().getLocation(), itemStack);
            return;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_19_R2)) {
            CMINBT cMINBT = new CMINBT(block);
            if (cMINBT.hasNBT("SpawnData.entity.id")) {
                itemStack = this.plugin.getUtilManager().setEntityType(itemStack, creatureSpawner.getSpawnedType());
            }
        } else {
            itemStack = this.plugin.getUtilManager().setEntityType(itemStack, creatureSpawner.getSpawnedType());
        }
        blockBreakEvent.getBlock().getWorld().dropItemNaturally(blockBreakEvent.getBlock().getLocation(), itemStack);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void BlockPlaceEvent(BlockPlaceEvent blockPlaceEvent) {
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        if (!CMIMaterial.SPAWNER.equals(blockPlaceEvent.getBlock().getType())) {
            return;
        }
        if (!this.plugin.getSpawnerChargesManager().isChargesUse()) {
            return;
        }
        if (this.plugin.getSpawnerChargesManager().isSpawnersSupportDisabled()) {
            return;
        }
        Player player = blockPlaceEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.getPCharge().have() && cMIUser.getPCharge().lowerCd()) {
            CMIActionBar.send((Player)player, (String)this.plugin.getLM().getMessage("command.charges.info.minusCd", "[sec]", cMIUser.getPCharge().getBonus()));
        }
    }
}

