/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.utils;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Containers.CMICollision;
import com.Zrips.CMI.Containers.CMIHitBox;
import com.Zrips.CMI.Containers.CMIRay;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.itemInfo;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Teleportations.TeleportManager;
import com.google.common.base.Charsets;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIBlock;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Items.CMIPotionEffect;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class Util {
    public boolean Debug = true;
    private HashMap<String, replyResponder> replyMapBySender = new HashMap();
    private HashMap<String, replyResponder> replyMapByReceiver = new HashMap();
    private HashMap<UUID, String> worldCache = new HashMap();
    static Random random = new Random(System.nanoTime());
    private CMI plugin;
    Integer range = null;

    public Util(CMI cMI) {
        this.plugin = cMI;
        for (World world2 : Bukkit.getWorlds()) {
            this.worldCache.put(world2.getUID(), world2.getName());
        }
    }

    public static Player getAttacker(EntityDamageEvent entityDamageEvent) {
        Projectile projectile;
        if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
            return null;
        }
        EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
        Player player = null;
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player) {
            player = (Player)entity;
        } else if (entity instanceof Projectile && (projectile = (Projectile)entity).getShooter() instanceof Player) {
            player = (Player)projectile.getShooter();
        }
        return player;
    }

    public static Entity getDamager(EntityDamageEvent entityDamageEvent) {
        Projectile projectile;
        if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
            return null;
        }
        EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Projectile && (projectile = (Projectile)entity).getShooter() instanceof Player) {
            entity = (Player)projectile.getShooter();
        }
        return entity;
    }

    public static SignSide getSignSide(Block block, Location location) {
        float f = (float)Math.toDegrees(Math.atan2(location.getX() - (double)block.getX() - 0.5, location.getZ() - (double)block.getZ() - 0.5));
        f = f < 0.0f ? f + 360.0f : f;
        BlockFace blockFace = new CMIBlock(block).getFacing();
        double d = Math.toDegrees(Math.atan2(blockFace.getModX(), blockFace.getModZ()));
        double d2 = Math.abs(d - (double)f) % 360.0;
        return (d2 > 180.0 ? 360.0 - d2 : d2) < 90.0 ? SignSide.FRONT : SignSide.BACK;
    }

    public String serializePotionEffect(PotionEffect potionEffect) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(potionEffect.getType().getName());
        stringBuilder.append(":");
        stringBuilder.append(potionEffect.getDuration() / 20);
        if (potionEffect.getAmplifier() > 0) {
            stringBuilder.append(":");
            stringBuilder.append(potionEffect.getAmplifier() + 1);
        }
        if (potionEffect.hasParticles()) {
            stringBuilder.append(":v");
        }
        return stringBuilder.toString();
    }

    public PotionEffect deserializePotionEffect(String string) {
        return this.deserializePotionEffect(string, null);
    }

    public PotionEffect deserializePotionEffect(String string, Integer n) {
        if (string == null) {
            return null;
        }
        string = string.replace(" ", "_");
        String[] stringArray = string.split(":");
        PotionEffectType potionEffectType = null;
        int n2 = n == null ? 0 : n;
        int n3 = 0;
        boolean bl = false;
        String[] stringArray2 = stringArray;
        int n4 = stringArray.length;
        int n5 = 0;
        while (n5 < n4) {
            block15: {
                String string2 = stringArray2[n5];
                if (potionEffectType == null) {
                    potionEffectType = CMIPotionEffect.get((String)string2);
                } else if (string2.equalsIgnoreCase("v")) {
                    bl = true;
                } else {
                    if (n2 == 0) {
                        try {
                            n2 = Integer.parseInt(string2);
                            break block15;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (n2 != 0 && n3 == 0) {
                        try {
                            n3 = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++n5;
        }
        if (potionEffectType == null) {
            return null;
        }
        if (n2 == 0) {
            n2 = 15;
        }
        n2 *= 20;
        if (--n3 < 0) {
            n3 = 0;
        }
        return new PotionEffect(potionEffectType, n2, n3, true, bl);
    }

    public boolean isNPC(Player player) {
        return player.hasMetadata("NPC");
    }

    public UUID generateUUID(String string) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + string).getBytes(Charsets.UTF_8));
    }

    public int getPlayerTrackingRange() {
        return this.getPlayerTrackingRange(null);
    }

    public boolean lookingAt(Player player, Vector vector, double d, double d2) {
        float f;
        int n;
        float f2;
        int n2;
        Location location = player.getEyeLocation().clone();
        location.setDirection(vector.subtract(location.toVector()));
        float f3 = location.getYaw() - 180.0f;
        if (f3 < 0.0f) {
            f3 += 360.0f;
        }
        if (Math.abs(n2 = (int)(f3 - (f2 = (float)((int)player.getLocation().getYaw() + 180)))) > 180) {
            n2 = (int)(360.0f + (f3 - f2));
        }
        if ((n2 %= 360) > 180) {
            n2 = 360 - n2;
        }
        if ((double)Math.abs(n2) > d) {
            return false;
        }
        float f4 = location.getPitch() - 90.0f;
        if (f4 < 0.0f) {
            f4 += 180.0f;
        }
        if (Math.abs(n = (int)(f4 - (f = (float)((int)player.getLocation().getPitch() + 90)))) > 180) {
            n = (int)(360.0f + (f4 - f));
        }
        return (double)Math.abs(n) <= d2;
    }

    public int getPlayerTrackingRange(World world2) {
        if (this.range == null) {
            this.range = 64;
            try {
                Object object = null;
                if (world2 != null) {
                    object = Bukkit.spigot().getConfig().get("world-settings." + world2.getName() + ".entity-tracking-range.players");
                }
                if (object == null) {
                    object = Bukkit.spigot().getConfig().get("world-settings.default.entity-tracking-range.players");
                }
                if (object != null) {
                    this.range = (int)((Integer)object);
                }
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return this.range;
    }

    @Deprecated
    public void addMessageReplayTo(String string, String string2) {
        this.addMessageReplyTo(string, string2);
    }

    public void addMessageReplyTo(String string, String string2) {
        this.replyMapBySender.put(string2, new replyResponder(string, System.currentTimeMillis()));
        this.replyMapByReceiver.remove(string2);
        this.replyMapByReceiver.put(string, new replyResponder(string2, System.currentTimeMillis()));
        if (this.plugin.getBungeeCordManager().isBungeeCord()) {
            this.plugin.getBungeeCordManager().talksWith(string2, string);
        }
    }

    public void addMessageReplyToBySender(String string, String string2) {
        this.replyMapBySender.put(string2, new replyResponder(string, System.currentTimeMillis()));
    }

    @Deprecated
    public void removeMessageReplayTo(String string) {
        this.removeMessageReplyTo(string);
    }

    public void removeMessageReplyTo(String string) {
        replyResponder replyResponder2;
        replyResponder replyResponder3 = this.replyMapByReceiver.remove(string);
        if (replyResponder3 != null && (replyResponder2 = this.replyMapBySender.get(replyResponder3.getName())) != null && replyResponder2.getName().equalsIgnoreCase(string)) {
            this.replyMapBySender.remove(replyResponder3.getName());
        }
    }

    public double getDistance(Location location, Location location2) {
        if (location == null || location2 == null || location.getWorld() != location2.getWorld()) {
            return 2.147483647E9;
        }
        try {
            return location.distance(location2);
        }
        catch (Throwable throwable) {
            return 2.147483647E9;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMaxWorldHeight(World world2) {
        if (world2 == null) {
            return 256;
        }
        Integer n = this.plugin.getConfigManager().getFlyAboveRoofLimitationsMap().get(world2.getName());
        if (n != null && n > 0) {
            return n;
        }
        if (world2.getEnvironment() == null) {
            return 256;
        }
        try {
            switch (world2.getEnvironment()) {
                case NETHER: {
                    return 128;
                }
                case NORMAL: 
                case THE_END: {
                    if (!Version.isCurrentEqualOrHigher((Version)Version.v1_17_R1)) return 256;
                    return world2.getMaxHeight();
                }
            }
            return 256;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return 256;
    }

    public Vector getVector(Location location, Location location2) {
        double d = location.getX() - location2.getX();
        double d2 = location.getY() - location2.getY();
        double d3 = location.getZ() - location2.getZ();
        double d4 = Math.atan2(d3, d);
        double d5 = Math.atan2(Math.sqrt(d3 * d3 + d * d), d2) + Math.PI;
        double d6 = Math.sin(d5) * Math.cos(d4);
        double d7 = Math.sin(d5) * Math.sin(d4);
        double d8 = Math.cos(d5);
        return new Vector(d6, d8, d7);
    }

    public double getYaw(Location location, Location location2) {
        double d = location.getX() - location2.getX();
        double d2 = location.getZ() - location2.getZ();
        return Math.toDegrees(Math.atan2(d2, d));
    }

    public double getPitch(Location location, Location location2) {
        double d = location.getX() - location2.getX();
        double d2 = location.getY() - location2.getY();
        double d3 = location.getZ() - location2.getZ();
        return Math.toDegrees(Math.atan2(Math.sqrt(d3 * d3 + d * d), d2) + Math.PI);
    }

    @Deprecated
    public String getMessageReplayTo(String string) {
        return this.getMessageReplyTo(string);
    }

    public String getMessageReplyTo(String string) {
        if (this.plugin.getChatManager().isChatReplyToLastMessenger()) {
            replyResponder replyResponder2 = this.replyMapByReceiver.get(string);
            if (replyResponder2 == null) {
                replyResponder2 = this.replyMapBySender.get(string);
            }
            return replyResponder2 == null ? null : replyResponder2.getName();
        }
        replyResponder replyResponder3 = this.replyMapBySender.get(string);
        if ((replyResponder3 == null || replyResponder3.getTime() + (long)this.plugin.getChatManager().getLastMessengerTimeOut() * 1000L < System.currentTimeMillis()) && (replyResponder3 = this.replyMapByReceiver.get(string)) == null) {
            replyResponder3 = this.replyMapBySender.get(string);
        }
        return replyResponder3 == null ? null : replyResponder3.getName();
    }

    public String createTextProbgressBar(int n, float f, float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        if (f2 > f) {
            f2 = f;
        }
        f2 = f2 * (float)n / f;
        f = n;
        String string = LC.info_ProgressBarFill.getLocale(new Object[0]);
        String string2 = LC.info_ProgressBarEmpty.getLocale(new Object[0]);
        String string3 = "";
        int n2 = 0;
        while ((float)n2 < f2) {
            string3 = string3.isEmpty() ? String.valueOf(string3) + string : String.valueOf(string3) + CMIChatColor.stripColor((String)string);
            ++n2;
        }
        String string4 = "";
        float f3 = f2;
        while (f3 < f) {
            string4 = string4.isEmpty() ? String.valueOf(string4) + string2 : String.valueOf(string4) + CMIChatColor.stripColor((String)string2);
            f3 += 1.0f;
        }
        string3 = String.valueOf(string3) + string4;
        return string3;
    }

    public Block getHighestBlockAt(Location location, boolean bl) {
        int n = location.getWorld().getMaxHeight();
        while (n > CMIWorld.getMinHeight((World)location.getWorld())) {
            Block block = location.getWorld().getBlockAt(location.getBlockX(), n, location.getBlockZ());
            if (!(block == null || block.getType().equals((Object)Material.AIR) || bl && !block.getType().isSolid())) {
                return block;
            }
            --n;
        }
        return null;
    }

    public TreeMap<Double, Entity> getClosestEntities(Location location, int n, double d, EntityType entityType) {
        HashSet<Entity> hashSet = new HashSet<Entity>();
        int n2 = -1;
        while (n2 < 2) {
            int n3 = -1;
            while (n3 < 2) {
                hashSet.addAll(Arrays.asList(location.getWorld().getChunkAt(location.getChunk().getX() + n2, location.getChunk().getZ() + n3).getEntities()));
                ++n3;
            }
            ++n2;
        }
        double d2 = n * 2;
        TreeMap<Double, Entity> treeMap = new TreeMap<Double, Entity>();
        Entity entity = this.getClosestEntity(location, n, entityType);
        if (entity == null) {
            return treeMap;
        }
        for (Entity entity2 : hashSet) {
            double d3;
            double d4;
            if (entityType != null && !entity2.getType().equals((Object)entityType) || entity2.getCustomName() != null && entity2.getCustomName().equalsIgnoreCase("CMIArmorStandForSit") || d2 < (d4 = location.distance(entity2.getLocation())) || d < (d3 = entity.getLocation().distance(entity2.getLocation()))) continue;
            treeMap.put(d4, entity2);
        }
        return treeMap;
    }

    public Entity getClosestEntity(Location location, int n, EntityType entityType) {
        HashSet<Entity> hashSet = new HashSet<Entity>();
        int n2 = -1;
        while (n2 < 2) {
            int n3 = -1;
            while (n3 < 2) {
                hashSet.addAll(Arrays.asList(location.getWorld().getChunkAt(location.getChunk().getX() + n2, location.getChunk().getZ() + n3).getEntities()));
                ++n3;
            }
            ++n2;
        }
        double d = n * 2;
        Entity entity = null;
        for (Entity entity2 : hashSet) {
            double d2;
            if (entityType != null && !entity2.getType().equals((Object)entityType) || entity2.getCustomName() != null && entity2.getCustomName().equalsIgnoreCase("CMIArmorStandForSit") || d < (d2 = location.distance(entity2.getLocation()))) continue;
            d = d2;
            entity = entity2;
        }
        return entity;
    }

    public Entity getTargetEntity(Player player) {
        return this.getTargetEntity(player, 0.95, false, true);
    }

    public Entity getTargetEntity(Player player, double d) {
        return this.getTargetEntity(player, d, false, true);
    }

    public Entity getTargetEntity(Player player, boolean bl, boolean bl2) {
        return this.getTargetEntity(player, 0.95, bl, bl2);
    }

    public Entity getTargetEntity(Player player, double d, boolean bl, boolean bl2) {
        int n = 30;
        List list2 = player.getNearbyEntities((double)n, (double)n, (double)n).stream().filter(arg_0 -> ((Player)player).hasLineOfSight(arg_0)).collect(Collectors.toList());
        CMIRay cMIRay = new CMIRay(player);
        double d2 = -1.0;
        Entity entity = null;
        for (Entity entity2 : list2) {
            double d3;
            Object object;
            if (!(bl && bl2 || !(entity2 instanceof Player))) {
                object = (Player)entity2;
                if (!bl && object.getGameMode().name().equalsIgnoreCase("SPECTATOR") || !bl2 && !player.canSee(object)) continue;
            }
            if ((d3 = new CMICollision((CMIHitBox)(object = new CMIHitBox(entity2))).collidesNearest(cMIRay, 0.0, n)) == -1.0 || !(d3 < d2) && d2 != -1.0) continue;
            d2 = d3;
            entity = entity2;
        }
        return entity;
    }

    public Block getTargetBlock(Player player, int n, boolean bl) {
        return this.getTargetBlock(player, null, n, bl);
    }

    public Block getTargetBlock(Player player, int n) {
        return this.getTargetBlock(player, null, n, false);
    }

    public Block getTargetBlock(Player player, Material material, int n) {
        return this.getTargetBlock(player, material, n, false);
    }

    public Block getTargetBlock(Player player, Material material, int n, boolean bl) {
        ArrayList<Block> arrayList = this.getLastTwoTargetBlock(player, material, n, bl);
        return arrayList.isEmpty() ? null : arrayList.get(arrayList.size() - 1);
    }

    public ArrayList<Block> getLastTwoTargetBlock(Player player, int n) {
        return this.getLastTwoTargetBlock(player, null, n, false);
    }

    public ArrayList<Block> getLastTwoTargetBlock(Player player, Material material, int n, boolean bl) {
        if (n > 240) {
            n = 240;
        }
        if (n < 1) {
            n = 1;
        }
        Block block = this.plugin.getNMS().getBlockLookingAt(player, n, bl);
        BlockIterator blockIterator = new BlockIterator((LivingEntity)player, n);
        LinkedHashSet<Block> linkedHashSet = new LinkedHashSet<Block>();
        if (block == null) {
            return new ArrayList<Block>(linkedHashSet);
        }
        Block block2 = null;
        while (blockIterator.hasNext()) {
            Block block3 = (Block)blockIterator.next();
            if (block2 == null && !block3.equals(block)) {
                block2 = block3;
            }
            if (!block3.equals(block)) continue;
            linkedHashSet.add(block2);
            break;
        }
        linkedHashSet.add(block);
        return new ArrayList<Block>(linkedHashSet);
    }

    public itemInfo getItemInfo(String string) {
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(string);
        if (cMIItemStack != null) {
            return new itemInfo(cMIItemStack.getType());
        }
        return new itemInfo(CMIMaterial.get((String)string));
    }

    public int getItemData(ItemStack itemStack) {
        if (itemStack.getType().toString().contains("_EGG")) {
            return CMILib.getInstance().getReflectionManager().getEggId(itemStack);
        }
        if (itemStack.getType().equals((Object)CMIMaterial.SPAWNER.getMaterial())) {
            return new CMIItemStack(itemStack).getEntityType().getTypeId();
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return 0;
        }
        return itemStack.getData().getData();
    }

    public String translateDamageCause(String string) {
        if (CMILib.getInstance().getLM().containsKey("info.DamageCause." + string.toLowerCase())) {
            string = CMILib.getInstance().getLM().getMessage("info.DamageCause." + string.toLowerCase(), new Object[0]);
        }
        return string;
    }

    public int getOnlinePlayerCount() {
        return this.getOnlinePlayerCount(null);
    }

    public int getOnlinePlayerCount(World world2) {
        int n = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (world2 != null && !player.getWorld().equals(world2)) continue;
            ++n;
        }
        return n;
    }

    public String getOnlinePlayersAsString() {
        return this.getOnlinePlayersAsString(null);
    }

    public String getOnlinePlayersAsString(String string) {
        String string2 = "";
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (string != null && player.getName().equalsIgnoreCase(string)) continue;
            if (!string2.isEmpty()) {
                string2 = String.valueOf(string2) + ",";
            }
            string2 = String.valueOf(string2) + player.getName();
        }
        return string2;
    }

    @Deprecated
    public List<Player> getPlayersFromRange(Location location, int n, boolean bl) {
        return this.getPlayersFromRange(location, n);
    }

    public List<Player> getPlayersFromRange(Location location, int n) {
        return this.getPlayersFromRange(null, location, n);
    }

    public List<Player> getPlayersFromRange(Player player, Location location, int n) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            Location location2 = player2.getLocation();
            if (n < 0) {
                arrayList.add(player2);
                continue;
            }
            if (location2.getWorld() != location.getWorld() || location2.getBlockX() > location.getBlockX() + n || location2.getBlockX() < location.getBlockX() - n || location2.getBlockY() > location.getBlockY() + n || location2.getBlockY() < location.getBlockY() - n || location2.getBlockZ() > location.getBlockZ() + n || location2.getBlockZ() < location.getBlockZ() - n || player != null && !player2.canSee(player)) continue;
            arrayList.add(player2);
        }
        return arrayList;
    }

    public List<Player> getPlayersFromRangeForCounter(Location location, int n, boolean bl) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location location2 = player.getLocation();
            if (location2.getWorld() != location.getWorld() || location2.getBlockX() > location.getBlockX() + n || location2.getBlockX() < location.getBlockX() - n || location2.getBlockY() > location.getBlockY() + n || location2.getBlockY() < location.getBlockY() - n || location2.getBlockZ() > location.getBlockZ() + n || location2.getBlockZ() < location.getBlockZ() - n) continue;
            if (!bl) {
                CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
                if (!cMIUser.isJoinedCounter() && cMIUser.hasPermission(PermissionsManager.CMIPerm.command_counter_autojoin)) {
                    cMIUser.setJoinedCounter(true);
                }
                if (!cMIUser.isJoinedCounter()) continue;
            }
            arrayList.add(player);
        }
        return arrayList;
    }

    public World getWorld(String string) {
        World world2 = Bukkit.getWorld((String)string);
        if (world2 != null) {
            return world2;
        }
        string = string.replace("_", "").replace(".", "").replace("-", "").replace(" ", "");
        for (World world3 : Bukkit.getWorlds()) {
            String string2 = world3.getName().replace("_", "").replace(".", "").replace("-", "").replace(" ", "");
            if (!string2.equalsIgnoreCase(string)) continue;
            return world3;
        }
        return null;
    }

    public List<String> getWorldList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (World world2 : Bukkit.getWorlds()) {
            if (world2 == null || world2.getName() == null) continue;
            arrayList.add(world2.getName());
        }
        return arrayList;
    }

    public void resendBlockInfo(Player player, Block block) {
        CMIScheduler.runTaskLater(() -> player.sendBlockChange(block.getLocation(), block.getType(), (byte)0), (long)10L);
    }

    public boolean isFullInv(ItemStack[] itemStackArray, List<ItemStack> list2) {
        int n = 36;
        ItemStack[] itemStackArray2 = itemStackArray;
        int n2 = itemStackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ItemStack itemStack = itemStackArray2[n3];
            if (itemStack != null) {
                --n;
            }
            ++n3;
        }
        return n < list2.size();
    }

    public List<ItemStack> ConvertInvToList(Inventory inventory) {
        ItemStack[] itemStackArray = inventory.getContents();
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        ItemStack[] itemStackArray2 = itemStackArray;
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemStack = itemStackArray2[n2];
            if (itemStack != null) {
                arrayList.add(itemStack);
            }
            ++n2;
        }
        return arrayList;
    }

    public boolean canRepair(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Material material = Material.getMaterial((String)itemStack.getType().name());
        if (material.isBlock() || material.getMaxDurability() < 1) {
            return false;
        }
        if (itemStack.getDurability() == 0) {
            return false;
        }
        CMINBT cMINBT = new CMINBT(itemStack);
        Integer n = cMINBT.getInt("CustomModelData");
        if (n != null && this.plugin.getRepairManager().getBlockedCustomDataID().contains(n)) {
            return false;
        }
        Byte by = cMINBT.getByte("Unbreakable");
        return by == null || by != 1;
    }

    public boolean needRepair(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Material material = Material.getMaterial((String)itemStack.getType().name());
        if (material.isBlock() || material.getMaxDurability() < 1) {
            return false;
        }
        return itemStack.getDurability() != 0;
    }

    public ItemStack repairItem(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Material material = Material.getMaterial((String)itemStack.getType().name());
        if (material.isBlock() || material.getMaxDurability() < 1) {
            return null;
        }
        if (itemStack.getDurability() == 0) {
            return null;
        }
        itemStack.setDurability((short)0);
        return itemStack;
    }

    public boolean hasSilkTouch(ItemStack itemStack, int n) {
        if (itemStack == null) {
            return false;
        }
        for (Map.Entry entry : itemStack.getEnchantments().entrySet()) {
            if (!((Enchantment)entry.getKey()).getName().equalsIgnoreCase("SILK_TOUCH") || (Integer)entry.getValue() < n) continue;
            return true;
        }
        return false;
    }

    public ItemStack setEntityType(ItemStack itemStack, EntityType entityType) {
        try {
            BlockStateMeta blockStateMeta = (BlockStateMeta)itemStack.getItemMeta();
            CreatureSpawner creatureSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
            creatureSpawner.setSpawnedType(entityType);
            if (!Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                creatureSpawner.setCreatureTypeByName(entityType.name());
            }
            blockStateMeta.setBlockState((BlockState)creatureSpawner);
            String string = CMILib.getInstance().getLM().getMessage("info.EntityType." + entityType.toString().toLowerCase(), new Object[0]);
            String string2 = String.valueOf(entityType.name().toLowerCase().replace("_", " ").substring(0, 1).toUpperCase()) + entityType.name().toLowerCase().replace("_", " ").substring(1);
            String string3 = string = this.plugin.getLM().isString("info.EntityType." + entityType.toString().toLowerCase()) ? string : string2;
            if (!blockStateMeta.hasDisplayName()) {
                blockStateMeta.setDisplayName(LC.info_Spawner.getLocale(new Object[]{"[type]", string}));
            }
            itemStack.setItemMeta((ItemMeta)blockStateMeta);
        }
        catch (Throwable throwable) {
            itemStack.setDurability(entityType.getTypeId());
        }
        return itemStack;
    }

    public boolean haveBlackListedItems(Player player, TeleportManager.TpAction tpAction) {
        HashMap<Material, Integer> hashMap;
        if (this.plugin.getTeleportManager().getBlockedItems().isEmpty()) {
            return false;
        }
        if (PermissionsManager.CMIPerm.teleport_bypassblacklist.hasPermission((CommandSender)player)) {
            return false;
        }
        if (this.plugin.getTeleportManager().isBlackListedItemsEnabledFor(tpAction).booleanValue() && !(hashMap = this.plugin.getUtilManager().getBlackListedItems(player)).isEmpty()) {
            this.showBlackListedItemList(player, hashMap);
            return true;
        }
        return false;
    }

    private void showBlackListedItemList(Player player, HashMap<Material, Integer> hashMap) {
        RawMessage rawMessage = new RawMessage();
        Material material = null;
        int n = 1;
        String string = "";
        for (Map.Entry<Material, Integer> object2 : hashMap.entrySet()) {
            if (material == null) {
                material = object2.getKey();
                n = object2.getValue();
            }
            if (!string.isEmpty()) {
                string = String.valueOf(string) + " \n";
            }
            string = String.valueOf(string) + CMILC.info_BlackList.getLocale("[material]", object2.getKey().name().toLowerCase(), "[amount]", object2.getValue(), "[max]", this.plugin.getTeleportManager().getBlockedItems().get(object2.getKey()));
        }
        if (material == null) {
            return;
        }
        Integer n2 = this.plugin.getTeleportManager().getBlockedItems().get(material);
        if (n2 == null) {
            return;
        }
        rawMessage.addText(CMILC.info_CantTeleport.getLocale("[item]", material.name().toLowerCase(), "[amount]", n, "[max]", n2)).addHover(string);
        rawMessage.show(player);
    }

    public HashMap<Material, Integer> getBlackListedItems(Player player) {
        HashMap<Material, Integer> hashMap = new HashMap<Material, Integer>();
        if (this.plugin.getTeleportManager().getBlockedItems().isEmpty()) {
            return hashMap;
        }
        PlayerInventory playerInventory = player.getInventory();
        HashMap<Material, Integer> hashMap2 = new HashMap<Material, Integer>();
        hashMap2 = this.getAllItemsFromInv((Inventory)playerInventory, hashMap2);
        for (Map.Entry<Material, Integer> entry : hashMap2.entrySet()) {
            Integer n = this.plugin.getTeleportManager().getBlockedItems().get(entry.getKey());
            if (n == null || entry.getValue() <= n) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    private HashMap<Material, Integer> getAllItemsFromInv(Inventory inventory, HashMap<Material, Integer> hashMap) {
        ItemStack[] itemStackArray = inventory.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemStack = itemStackArray[n2];
            if (itemStack != null && itemStack.getType() != Material.AIR) {
                Integer n3;
                Inventory inventory2 = this.plugin.getNMS().getShulkerInv(itemStack);
                if (inventory2 != null) {
                    hashMap = this.getAllItemsFromInv(inventory2, hashMap);
                }
                if ((n3 = hashMap.get(itemStack.getType())) == null) {
                    n3 = 0;
                }
                hashMap.put(itemStack.getType(), n3 + itemStack.getAmount());
            }
            ++n2;
        }
        return hashMap;
    }

    public String convertLocToStringShort(Location location) {
        String string = "";
        if (location != null && location.getWorld() != null) {
            string = String.valueOf(string) + location.getWorld().getName();
            string = String.valueOf(string) + ";" + location.getBlockX();
            string = String.valueOf(string) + ";" + location.getBlockY();
            string = String.valueOf(string) + ";" + location.getBlockZ();
        }
        return string;
    }

    public boolean validName(String string) {
        return this.validName("[^a-zA-Z0-9\\-\\_]", string);
    }

    public boolean validName(String string, String string2) {
        String string3;
        block5: {
            if (string2.contains(":") || string2.contains(".") || string2.contains("|")) {
                return false;
            }
            try {
                string3 = string2.replaceAll(string, "");
                if (!string3.isEmpty()) break block5;
                return false;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                String string4 = string2.replaceAll("[^a-zA-Z0-9\\-\\_]", "");
                if (string4.isEmpty()) {
                    return false;
                }
                return string2.equals(string4);
            }
        }
        return string2.equals(string3);
    }

    public String getWorldName(UUID uUID) {
        World world2 = Bukkit.getWorld((UUID)uUID);
        if (world2 != null) {
            return world2.getName();
        }
        return this.worldCache.get(uUID);
    }

    public CMIChatColor getTpsColor(Double d) {
        if (d < 17.0) {
            return CMIChatColor.DARK_RED;
        }
        if (d < 18.3) {
            return CMIChatColor.RED;
        }
        if (d < 18.8) {
            return CMIChatColor.GOLD;
        }
        if (d < 19.2) {
            return CMIChatColor.YELLOW;
        }
        if (d < 19.7) {
            return CMIChatColor.GREEN;
        }
        return CMIChatColor.DARK_GREEN;
    }

    public static File getFile(Player player) {
        return Util.getFile(player.getUniqueId());
    }

    public static File getFile(UUID uUID) {
        return new File(((World)Bukkit.getWorlds().get(0)).getWorldFolder(), "playerdata" + File.separator + uUID + ".dat");
    }

    public Player getRandomOnlinePlayer() {
        return this.getRandomOnlinePlayer(null);
    }

    public Player getRandomOnlinePlayer(Set<Player> set) {
        Player player2;
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            if (set != null && set.contains(player2)) continue;
            arrayList.add(player2);
        }
        Collections.shuffle(arrayList, random);
        player2 = null;
        if (!arrayList.isEmpty()) {
            player2 = (Player)arrayList.get(0);
        }
        return player2;
    }

    public boolean blockedItemFromRenaming(CommandSender commandSender, ItemStack itemStack, String string) {
        if (!(commandSender instanceof Player)) {
            return false;
        }
        HashMap<CMIItemStack, String> hashMap = this.plugin.getConfigManager().getItemRenamingPreventMap();
        if (hashMap.isEmpty()) {
            return false;
        }
        if (PermissionsManager.CMIPerm.anvil_itemrename_bypass.hasPermission(commandSender)) {
            return false;
        }
        if (Config.ItemRenamingGlobalDisable) {
            return true;
        }
        for (Map.Entry<CMIItemStack, String> entry : hashMap.entrySet()) {
            if (!entry.getKey().getType().equals((Object)itemStack.getType())) continue;
            if (entry.getValue().isEmpty()) {
                return true;
            }
            Pattern pattern = Pattern.compile(entry.getValue());
            Matcher matcher = pattern.matcher(CMIChatColor.stripColor((String)string));
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public String getLineSplitter(String string) {
        string = LC.info_SpliterMiddle.getLocale(new Object[]{"[value]", string});
        int n = 320;
        String string2 = LC.info_singleSpliter.getLocale(new Object[0]);
        String string3 = CMIChatColor.getLastColors((String)string2);
        string2 = CMIChatColor.stripColor((String)string2);
        StringBuilder stringBuilder = new StringBuilder();
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, true);
        Font font = new Font("Tahoma", 0, 12);
        int n2 = (int)font.getStringBounds(CMIChatColor.stripColor((String)string), fontRenderContext).getWidth();
        int n3 = (n - n2) / 12;
        stringBuilder.append(string3);
        int n4 = 0;
        while (n4 < n3) {
            stringBuilder.append(string2);
            ++n4;
        }
        stringBuilder.append(string);
        n4 = 0;
        while (n4 < n3) {
            stringBuilder.append(string2);
            ++n4;
        }
        return stringBuilder.toString();
    }

    public static enum SignSide {
        FRONT,
        BACK;

    }

    public class replyResponder {
        private String name;
        private Long time;

        public replyResponder(String string, Long l) {
            this.name = string;
            this.time = l;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public Long getTime() {
            return this.time;
        }

        public void setTime(Long l) {
            this.time = l;
        }
    }
}

