/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.BossBar;

import com.Zrips.CMI.CMI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.BossBar.CMIBossBarHideEvent;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CommandType;
import net.Zrips.CMILib.Version.Version;
import net.Zrips.CMILib.commands.CMICommand;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class BossBarManager {
    CMILib plugin;
    HashMap<String, BossBarInfo> globalBars = new HashMap();
    ConcurrentHashMap<UUID, ConcurrentHashMap<String, BossBarInfo>> barMap = new ConcurrentHashMap();

    public BossBarManager(CMILib plugin) {
        this.plugin = plugin;
    }

    public void addGlobalBar(BossBarInfo binfo) {
        if (binfo.isGlobal()) {
            BossBarInfo old = this.globalBars.get(binfo.getNameOfBar().replaceAll("[^a-zA-Z0-9]", ""));
            if (old != null) {
                old.cancelAutoScheduler();
                old.cancelHideScheduler();
            }
            this.globalBars.put(binfo.getNameOfBar().replaceAll("[^a-zA-Z0-9]", ""), binfo);
        }
        this.Show(binfo);
    }

    public void removeGlobalBossbar(BossBarInfo bar) {
        this.removeGlobalBossbar(bar.getNameOfBar());
    }

    public void removeGlobalBossbar(String barName) {
        BossBarInfo ret = this.globalBars.remove(barName.replaceAll("[^a-zA-Z0-9]", ""));
        if (ret != null) {
            ret.cancelAutoScheduler();
            ret.cancelHideScheduler();
        }
    }

    public void updateGlobalBars(Player player) {
        for (Map.Entry<String, BossBarInfo> iter : new HashMap<String, BossBarInfo>(this.globalBars).entrySet()) {
            BossBarInfo binfo = iter.getValue();
            if (!binfo.stillRunning()) {
                this.globalBars.remove(iter.getKey());
                continue;
            }
            BossBarInfo clone = binfo.clone(player);
            clone.setBar(null);
            this.getBossBarInfo(player).remove(clone.getNameOfBar().toLowerCase());
            this.addBossBar(player, clone);
        }
    }

    public synchronized void updateBossBars(Player player) {
        if (Version.isCurrentLower(Version.v1_9_R1)) {
            return;
        }
        if (player == null) {
            return;
        }
        HashMap<String, BossBarInfo> temp = new HashMap<String, BossBarInfo>(this.getBossBarInfo(player));
        for (Map.Entry<String, BossBarInfo> one : temp.entrySet()) {
            this.Show(one.getValue());
        }
    }

    public synchronized void Show(final BossBarInfo barInfo) {
        if (Version.isCurrentLower(Version.v1_9_R1)) {
            return;
        }
        barInfo.cancelAutoScheduler();
        barInfo.cancelHideScheduler();
        barInfo.setAutoId(Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Player player = barInfo.getPlayer();
                if (!(barInfo.isGlobal() || player != null && player.isOnline())) {
                    barInfo.setMakeVisible(true);
                }
                if (barInfo.isGlobal() && player != null && !player.isOnline()) {
                    barInfo.remove();
                    return;
                }
                barInfo.updateCycle();
                BossBar bar = barInfo.getBar();
                String name = player == null ? barInfo.getTitleOfBar() : barInfo.getTitleOfBar(player);
                boolean isNew = true;
                if (bar == null) {
                    BarColor color = barInfo.getColor();
                    if (color == null) {
                        if (player == null) {
                            color = BarColor.GREEN;
                        } else {
                            ConcurrentHashMap<String, BossBarInfo> info = BossBarManager.this.getBossBarInfo(player);
                            int size = 1;
                            if (info != null) {
                                size = info.size();
                            }
                            switch (size) {
                                case 1: {
                                    color = BarColor.GREEN;
                                    break;
                                }
                                case 2: {
                                    color = BarColor.RED;
                                    break;
                                }
                                case 3: {
                                    color = BarColor.WHITE;
                                    break;
                                }
                                case 4: {
                                    color = BarColor.YELLOW;
                                    break;
                                }
                                case 5: {
                                    color = BarColor.PINK;
                                    break;
                                }
                                case 6: {
                                    color = BarColor.PURPLE;
                                    break;
                                }
                                default: {
                                    color = BarColor.BLUE;
                                }
                            }
                        }
                    }
                    bar = Bukkit.createBossBar((String)name, (BarColor)color, (BarStyle)(barInfo.getStyle() != null ? barInfo.getStyle() : BarStyle.SEGMENTED_10), (BarFlag[])new BarFlag[0]);
                    barInfo.setBar(bar);
                } else {
                    bar.setTitle(name);
                    if (barInfo.getStyle() != null) {
                        bar.setStyle(barInfo.getStyle());
                    }
                    if (barInfo.getColor() != null) {
                        bar.setColor(barInfo.getColor());
                    }
                    bar.setVisible(true);
                    isNew = false;
                }
                Double percentage = barInfo.getPercentage();
                if (percentage == null) {
                    percentage = 1.0;
                }
                if (barInfo.getAdjustPerc() != null) {
                    Double curP = barInfo.getPercentage();
                    if (curP != null && curP + barInfo.getAdjustPerc() <= 0.0 && barInfo.getAdjustPerc() < 0.0 || curP != null && curP + barInfo.getAdjustPerc() >= 1.0 && barInfo.getAdjustPerc() > 0.0) {
                        if (barInfo.getCommands() != null && barInfo.getHideId() == null) {
                            try {
                                curP = barInfo.getAdjustPerc() < 0.0 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                                barInfo.setPercentage(curP);
                                bar.setProgress(curP.doubleValue());
                                bar.setTitle(name);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            Bukkit.getScheduler().runTask((Plugin)BossBarManager.this.plugin, () -> {
                                if (CMILib.getInstance().isCmiPresent()) {
                                    if (player != null) {
                                        CMI.getInstance().getSpecializedCommandManager().processCmds(barInfo.getCommands(player), player);
                                    } else {
                                        CMI.getInstance().getSpecializedCommandManager().processCmds(barInfo.getCommands(null), (CommandSender)Bukkit.getConsoleSender());
                                    }
                                } else if (player != null) {
                                    CMICommand.performCommand(player, barInfo.getCommands(player), CommandType.bossbar);
                                } else {
                                    CMICommand.performCommand((CommandSender)Bukkit.getConsoleSender(), barInfo.getCommands(null), CommandType.bossbar);
                                }
                            });
                        }
                        if (barInfo.getHideId() == null) {
                            barInfo.setHideId(Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)BossBarManager.this.plugin, new Runnable(){

                                @Override
                                public void run() {
                                    CMIBossBarHideEvent ev = new CMIBossBarHideEvent(barInfo);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)ev);
                                    if (!ev.isCancelled()) {
                                        barInfo.getBar().setVisible(false);
                                        barInfo.cancelAutoScheduler();
                                        BossBarManager.this.removeGlobalBossbar(barInfo);
                                        barInfo.remove();
                                        barInfo.setHideId(null);
                                    }
                                }
                            }, (long)barInfo.getKeepFor().intValue()));
                        }
                    }
                    if (curP == null) {
                        curP = barInfo.getAdjustPerc() > 0.0 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                    }
                    curP = curP + barInfo.getAdjustPerc();
                    barInfo.setPercentage(curP);
                } else {
                    barInfo.setPercentage(percentage);
                }
                try {
                    bar.setProgress(barInfo.getPercentage().doubleValue());
                    bar.setTitle(name);
                    if (player != null && player.isOnline()) {
                        BossBarManager.this.getBossBarInfo(player).put(barInfo.getNameOfBar().toLowerCase(), barInfo);
                        if (isNew || barInfo.isMakeVisible() && BossBarManager.this.getBossBar(player, barInfo.getNameOfBar()) == null) {
                            bar.addPlayer(player);
                            bar.setVisible(true);
                            barInfo.setMakeVisible(false);
                        } else if (barInfo.isMakeVisible() && BossBarManager.this.getBossBar(player, barInfo.getNameOfBar()) != null) {
                            bar.removePlayer(player);
                            BossBarManager.this.removeGlobalBossbar(barInfo);
                            barInfo.remove();
                        }
                    }
                }
                catch (NoSuchMethodError e) {
                    e.printStackTrace();
                }
                if (!barInfo.stillRunning() && barInfo.getHideId() == null) {
                    barInfo.setHideId(Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)BossBarManager.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            CMIBossBarHideEvent ev = new CMIBossBarHideEvent(barInfo);
                            Bukkit.getServer().getPluginManager().callEvent((Event)ev);
                            if (!ev.isCancelled()) {
                                barInfo.getBar().setVisible(false);
                                BossBarManager.this.removeGlobalBossbar(barInfo);
                                barInfo.remove();
                                barInfo.setHideId(null);
                            }
                        }
                    }, (long)barInfo.getKeepFor().intValue()));
                }
            }
        }, 0L, (long)barInfo.getAuto().intValue()));
    }

    public void removeBossBar(Player player, String name) {
        BossBarInfo old = this.getBossBar(player, name);
        if (old == null) {
            return;
        }
        this.removeBossBar(player, old);
    }

    public void removeBossBar(Player player, BossBarInfo bossBar) {
        if (bossBar == null) {
            return;
        }
        if (bossBar.getBar() != null) {
            bossBar.getBar().setVisible(false);
        }
        bossBar.cancelAutoScheduler();
        bossBar.cancelHideScheduler();
        this.getBossBarInfo(player).remove(bossBar.getNameOfBar().toLowerCase());
    }

    public void addBossBar(Player player, BossBarInfo barInfo) {
        if (player == null || barInfo == null) {
            return;
        }
        if (barInfo.getPlayer() == null) {
            barInfo.setPlayer(player);
        }
        if (!this.getBossBarInfo(player).containsKey(barInfo.getNameOfBar().toLowerCase())) {
            this.getBossBarInfo(player).put(barInfo.getNameOfBar().toLowerCase(), barInfo);
            this.Show(barInfo);
        } else {
            BossBarInfo old = this.getBossBar(player, barInfo.getNameOfBar().toLowerCase());
            if (old != null) {
                old.cancelAutoScheduler();
                old.cancelHideScheduler();
                if (barInfo.getColor() != null) {
                    old.setColor(barInfo.getColor());
                }
                if (barInfo.getKeepFor() != null) {
                    old.setKeepForTicks(barInfo.getKeepFor());
                }
                if (barInfo.getPercentage() != null) {
                    old.setPercentage(barInfo.getPercentage());
                }
                if (barInfo.getPlayer() != null) {
                    old.setPlayer(barInfo.getPlayer());
                }
                if (barInfo.getAdjustPerc() != null) {
                    old.setAdjustPerc(barInfo.getAdjustPerc());
                }
                if (barInfo.getStyle() != null) {
                    old.setStyle(barInfo.getStyle());
                }
                if (!barInfo.getTitleOfBar().isEmpty()) {
                    old.setTitleOfBar(barInfo.getTitleOfBarClean());
                }
                if (barInfo.getBar() != null) {
                    old.setBar(barInfo.getBar());
                }
                if (barInfo.getHideId() != null) {
                    old.setHideId(barInfo.getHideId());
                }
                if (barInfo.getAuto() != null) {
                    old.setAuto(barInfo.getAuto());
                }
                if (barInfo.getCommands() != null) {
                    old.setCmds(barInfo.getCommands());
                }
            }
            this.Show(old);
        }
    }

    public synchronized BossBarInfo getBossBar(Player player, String name) {
        ConcurrentHashMap<String, BossBarInfo> info = this.getBossBarInfo(player);
        if (info == null) {
            return null;
        }
        return info.get(name.toLowerCase());
    }

    public synchronized ConcurrentHashMap<String, BossBarInfo> getBossBarInfo(Player player) {
        if (player == null) {
            return null;
        }
        ConcurrentHashMap<String, BossBarInfo> got = this.barMap.get(player.getUniqueId());
        if (got == null) {
            got = new ConcurrentHashMap();
            this.barMap.put(player.getUniqueId(), got);
        }
        return got;
    }

    public synchronized void hideBossBars(Player player) {
        if (player.isOnline()) {
            ConcurrentHashMap<String, BossBarInfo> info = this.getBossBarInfo(player);
            if (info == null) {
                return;
            }
            for (Map.Entry<String, BossBarInfo> one : info.entrySet()) {
                try {
                    one.getValue().getBar().setVisible(false);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }

    public void clearBossMaps(Player player) {
        ConcurrentHashMap<String, BossBarInfo> info = this.getBossBarInfo(player);
        if (info == null) {
            return;
        }
        for (Map.Entry<String, BossBarInfo> one : info.entrySet()) {
            one.getValue().cancelHideScheduler();
        }
        info.clear();
    }
}

