/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Container;

import java.util.Arrays;
import java.util.LinkedHashMap;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Messages.CMIMessages;
import org.bukkit.block.Biome;

public class CMIBiome {
    private static LinkedHashMap<Biome, CMIBiome> biomeNames = new LinkedHashMap();
    private Biome biome;
    private String name = null;

    public static void initialize() {
        Arrays.stream(Biome.values()).map(Enum::toString).sorted().filter(name -> name != null).forEach(name -> {
            try {
                Biome biome = null;
                for (Biome bio : Biome.values()) {
                    if (!bio.toString().equalsIgnoreCase((String)name)) continue;
                    biome = bio;
                    break;
                }
                if (biome == null) {
                    return;
                }
                biomeNames.put(biome, new CMIBiome(biome, CMILib.getInstance().getConfigManager().getLocaleConfig().get("info.Biomes." + biome.toString(), CMIText.firstToUpperCase(biome.toString()))));
            }
            catch (Exception e) {
                CMIMessages.consoleMessage("&4Failed to recognize biome by (" + name + ") name. Skipping.");
            }
        });
    }

    public CMIBiome(Biome biome) {
        this.biome = biome;
        CMIBiome n = biomeNames.get(biome);
        if (n != null) {
            this.name = n.getBiomeName();
        }
    }

    public CMIBiome(Biome biome, String name) {
        this.biome = biome;
        this.name = name;
    }

    public CMIBiome getBiome(Biome biome) {
        return biomeNames.get(biome);
    }

    public Biome getBiome() {
        return this.biome;
    }

    public String getBiomeName() {
        if (this.name == null) {
            this.name = CMIText.firstToUpperCase(this.biome.toString());
        }
        return this.name;
    }
}

