/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Container;

import java.util.HashMap;
import net.Zrips.CMILib.Container.BlockStateType;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Attachable;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.material.Banner;
import org.bukkit.material.Bed;
import org.bukkit.material.Comparator;
import org.bukkit.material.Diode;
import org.bukkit.material.Dispenser;
import org.bukkit.material.Door;
import org.bukkit.material.Gate;
import org.bukkit.material.Hopper;
import org.bukkit.material.Lever;
import org.bukkit.material.Observer;
import org.bukkit.material.PistonBaseMaterial;
import org.bukkit.material.PistonExtensionMaterial;
import org.bukkit.material.Sign;
import org.bukkit.material.Skull;
import org.bukkit.material.Stairs;
import org.bukkit.material.TripwireHook;

public class CMIBlock {
    private Block block;
    private Integer data = null;
    private Object blockd = null;

    public CMIBlock(Block block) {
        this.block = block;
    }

    @Deprecated
    public blockDirection getDirection() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            return blockDirection.none;
        }
        return blockDirection.getByDir(this.block.getData()) == null ? blockDirection.none : blockDirection.getByDir(this.block.getData());
    }

    public boolean isWaterlogged() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1) && this.block.getBlockData() instanceof Waterlogged) {
            Waterlogged wl = (Waterlogged)this.block.getBlockData();
            return wl.isWaterlogged();
        }
        CMIMaterial mat = CMIMaterial.get(this.block);
        switch (mat) {
            case WATER: 
            case LEGACY_STATIONARY_WATER: 
            case BUBBLE_COLUMN: 
            case KELP_PLANT: 
            case KELP: 
            case SEAGRASS: 
            case TALL_SEAGRASS: {
                return true;
            }
        }
        return false;
    }

    public Bisect getBisect() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockData blockData = this.block.getBlockData();
            if (!(blockData instanceof Bisected)) {
                return null;
            }
            Bisected half = (Bisected)blockData;
            switch (half.getHalf().toString()) {
                case "TOP": {
                    return Bisect.TOP;
                }
                case "BOTTOM": {
                    return Bisect.BOTTOM;
                }
            }
        }
        return null;
    }

    public boolean isAttached() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockData blockData = this.block.getBlockData();
            if (!(blockData instanceof Attachable)) {
                return false;
            }
            Attachable half = (Attachable)blockData;
            return half.isAttached();
        }
        return false;
    }

    public Axis getAxis() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockData blockData = this.block.getBlockData();
            if (!(blockData instanceof Orientable)) {
                return null;
            }
            Orientable half = (Orientable)blockData;
            return half.getAxis();
        }
        return null;
    }

    public BedPart getBedPart() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockData blockData = this.block.getBlockData();
            if (!(blockData instanceof org.bukkit.block.data.type.Bed)) {
                return null;
            }
            org.bukkit.block.data.type.Bed half = (org.bukkit.block.data.type.Bed)blockData;
            switch (half.getPart().toString()) {
                case "FOOT": {
                    return BedPart.FOOT;
                }
                case "HEAD": {
                    return BedPart.HEAD;
                }
            }
        }
        return null;
    }

    public StairShape getStairShape() {
        CMIMaterial cm;
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1) && (cm = CMIMaterial.get(this.block)).isStairs()) {
            BlockData blockData = this.block.getBlockData();
            org.bukkit.block.data.type.Stairs stair = (org.bukkit.block.data.type.Stairs)blockData;
            Stairs.Shape shape = stair.getShape();
            return StairShape.getByName(shape.toString());
        }
        return null;
    }

    public BlockFace getFacing() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockData blockData = this.block.getBlockData();
            if (blockData instanceof Directional) {
                Directional directional = this.blockd == null ? (Directional)blockData.clone() : (Directional)this.blockd;
                return directional.getFacing();
            }
            if (blockData instanceof Rotatable) {
                Rotatable directional = this.blockd == null ? (Rotatable)blockData.clone() : (Rotatable)this.blockd;
                return directional.getRotation();
            }
        }
        try {
            CMIMaterial cm = CMIMaterial.get(this.block);
            switch (cm) {
                case COMPARATOR: {
                    Comparator Comparator2 = (Comparator)this.block.getState().getData();
                    return Comparator2.getFacing();
                }
                case REPEATER: {
                    Diode diode = (Diode)this.block.getState().getData();
                    return diode.getFacing();
                }
                case DISPENSER: {
                    Dispenser Dispenser2 = (Dispenser)this.block.getState().getData();
                    return Dispenser2.getFacing();
                }
                case HOPPER: {
                    if (Version.isCurrentEqualOrHigher(Version.v1_9_R1)) {
                        Hopper Hopper2 = (Hopper)this.block.getState().getData();
                        return Hopper2.getFacing();
                    }
                    return BlockFace.DOWN;
                }
                case LEVER: {
                    Lever Lever2 = (Lever)this.block.getState().getData();
                    return Lever2.getFacing();
                }
                case TRIPWIRE_HOOK: {
                    TripwireHook TripwireHook2 = (TripwireHook)this.block.getState().getData();
                    return TripwireHook2.getFacing();
                }
            }
            if (cm.isSign()) {
                Sign sign = (Sign)this.block.getState().getData();
                return sign.getFacing();
            }
            if (cm.isSkull()) {
                Skull Skull2 = (Skull)this.block.getState().getData();
                return Skull2.getFacing();
            }
            if (cm.isBed()) {
                Bed mat = (Bed)this.block.getState().getData();
                return mat.getFacing();
            }
            if (cm.isDoor()) {
                Door mat = (Door)this.block.getState().getData();
                return mat.getFacing();
            }
            if (cm.isGate()) {
                Gate mat = (Gate)this.block.getState().getData();
                return mat.getFacing();
            }
            String stringname = this.block.getType().name();
            if (stringname.contains("_STAIRS")) {
                Stairs mat = (Stairs)this.block.getState().getData();
                return mat.getFacing();
            }
            if (stringname.contains("BANNER")) {
                Banner Banner2 = (Banner)this.block.getState().getData();
                return Banner2.getFacing();
            }
            if (stringname.contains("OBSERVER")) {
                Observer Banner2 = (Observer)this.block.getState().getData();
                return Banner2.getFacing();
            }
            if (stringname.contains("PISTON_BASE")) {
                PistonBaseMaterial Banner2 = (PistonBaseMaterial)this.block.getState().getData();
                return Banner2.getFacing();
            }
            if (stringname.contains("PISTON_EXTENSION")) {
                PistonExtensionMaterial Banner2 = (PistonExtensionMaterial)this.block.getState().getData();
                return Banner2.getFacing();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public CMIBlock flip(FlipDirection direction, boolean angle) {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            Directional directional;
            CMIMaterial cmat = CMIMaterial.get(this.block);
            BlockData blockData = this.block.getBlockData().clone();
            switch (direction) {
                case UP_DOWN: {
                    Bisected half;
                    if (!(blockData instanceof Bisected)) break;
                    Bisected bisected = half = this.blockd == null || !(this.blockd instanceof Bisected) ? (Bisected)blockData.clone() : (Bisected)this.blockd;
                    if (half == null) break;
                    switch (half.getHalf().toString()) {
                        case "TOP": {
                            half.setHalf(Bisected.Half.BOTTOM);
                            break;
                        }
                        case "BOTTOM": {
                            half.setHalf(Bisected.Half.TOP);
                        }
                    }
                    if (this.blockd != null) break;
                    this.blockd = half;
                }
            }
            if (blockData instanceof Directional) {
                Directional directional2 = directional = this.blockd == null ? (Directional)blockData.clone() : (Directional)this.blockd;
                if (directional != null) {
                    BlockFace face = directional.getFacing();
                    block12 : switch (direction) {
                        case NORTH_SOUTH: {
                            if (angle) {
                                switch (face.toString()) {
                                    case "NORTH": {
                                        directional.setFacing(BlockFace.EAST);
                                        break;
                                    }
                                    case "SOUTH": {
                                        directional.setFacing(BlockFace.WEST);
                                        break;
                                    }
                                    case "WEST": {
                                        directional.setFacing(BlockFace.SOUTH);
                                        break;
                                    }
                                    case "EAST": {
                                        directional.setFacing(BlockFace.NORTH);
                                    }
                                }
                                break;
                            }
                            switch (face.toString()) {
                                case "NORTH": {
                                    directional.setFacing(BlockFace.SOUTH);
                                    break;
                                }
                                case "SOUTH": {
                                    directional.setFacing(BlockFace.NORTH);
                                }
                            }
                            break;
                        }
                        case WEST_EAST: {
                            if (angle) {
                                switch (face.toString()) {
                                    case "WEST": {
                                        directional.setFacing(BlockFace.NORTH);
                                        break;
                                    }
                                    case "EAST": {
                                        directional.setFacing(BlockFace.SOUTH);
                                        break;
                                    }
                                    case "NORTH": {
                                        directional.setFacing(BlockFace.WEST);
                                        break;
                                    }
                                    case "SOUTH": {
                                        directional.setFacing(BlockFace.EAST);
                                    }
                                }
                                break;
                            }
                            switch (face.toString()) {
                                case "WEST": {
                                    directional.setFacing(BlockFace.EAST);
                                    break;
                                }
                                case "EAST": {
                                    directional.setFacing(BlockFace.WEST);
                                }
                            }
                            break;
                        }
                        case UP_DOWN: {
                            switch (face.toString()) {
                                case "UP": {
                                    directional.setFacing(BlockFace.DOWN);
                                    break block12;
                                }
                                case "DOWN": {
                                    directional.setFacing(BlockFace.UP);
                                }
                            }
                        }
                    }
                    if (this.blockd == null) {
                        this.blockd = directional;
                    }
                }
            }
            if (cmat.isStairs()) {
                org.bukkit.block.data.type.Stairs stair = (org.bukkit.block.data.type.Stairs)this.blockd;
                Stairs.Shape shape = stair.getShape();
                BlockFace face = stair.getFacing();
                block65 : switch (direction) {
                    case NORTH_SOUTH: 
                    case WEST_EAST: {
                        switch (shape.toString()) {
                            case "INNER_LEFT": {
                                stair.setShape(Stairs.Shape.INNER_RIGHT);
                                break block65;
                            }
                            case "INNER_RIGHT": {
                                stair.setShape(Stairs.Shape.INNER_LEFT);
                                break block65;
                            }
                            case "OUTER_LEFT": {
                                stair.setShape(Stairs.Shape.OUTER_RIGHT);
                                break block65;
                            }
                            case "OUTER_RIGHT": {
                                stair.setShape(Stairs.Shape.OUTER_LEFT);
                            }
                        }
                    }
                }
            }
            if (blockData instanceof Rotatable) {
                directional = this.blockd == null ? (Rotatable)blockData.clone() : (Rotatable)this.blockd;
                switch (directional.getRotation()) {
                    case NORTH: {
                        directional.setRotation(BlockFace.SOUTH);
                        break;
                    }
                    case NORTH_NORTH_EAST: {
                        directional.setRotation(BlockFace.SOUTH_SOUTH_WEST);
                        break;
                    }
                    case NORTH_EAST: {
                        directional.setRotation(BlockFace.SOUTH_WEST);
                        break;
                    }
                    case EAST_NORTH_EAST: {
                        directional.setRotation(BlockFace.WEST_SOUTH_WEST);
                        break;
                    }
                    case EAST: {
                        directional.setRotation(BlockFace.WEST);
                        break;
                    }
                    case EAST_SOUTH_EAST: {
                        directional.setRotation(BlockFace.WEST_NORTH_WEST);
                        break;
                    }
                    case SOUTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_WEST);
                        break;
                    }
                    case SOUTH_SOUTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_NORTH_WEST);
                        break;
                    }
                    case SOUTH: {
                        directional.setRotation(BlockFace.NORTH);
                        break;
                    }
                    case SOUTH_SOUTH_WEST: {
                        directional.setRotation(BlockFace.NORTH_NORTH_EAST);
                        break;
                    }
                    case SOUTH_WEST: {
                        directional.setRotation(BlockFace.NORTH_EAST);
                        break;
                    }
                    case WEST_SOUTH_WEST: {
                        directional.setRotation(BlockFace.EAST_NORTH_EAST);
                        break;
                    }
                    case WEST: {
                        directional.setRotation(BlockFace.EAST);
                        break;
                    }
                    case WEST_NORTH_WEST: {
                        directional.setRotation(BlockFace.EAST_SOUTH_EAST);
                        break;
                    }
                    case NORTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_EAST);
                        break;
                    }
                    case NORTH_NORTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_SOUTH_EAST);
                    }
                }
                if (this.blockd == null) {
                    this.blockd = directional;
                }
            }
            if (!(cmat.isWall() || cmat.isGlassPane() || cmat.isFence() || cmat.equals((Object)CMIMaterial.IRON_BARS) || this.blockd != null)) {
                this.blockd = blockData.clone();
            }
            return this;
        }
        int flipX = 0;
        int flipY = 0;
        int flipZ = 0;
        Material type = this.block.getType();
        this.data = this.data == null ? this.block.getData() : this.data.intValue();
        CMIMaterial cmat = CMIMaterial.get(this.block);
        try {
            switch (direction) {
                case NORTH_SOUTH: {
                    flipZ = 1;
                    break;
                }
                case WEST_EAST: {
                    flipX = 1;
                    break;
                }
                case UP_DOWN: {
                    flipY = 1;
                }
            }
            if (cmat.isButton()) {
                switch (this.data & 0xFFFFFFF7) {
                    case 1: {
                        this.data = this.data + flipX;
                        break;
                    }
                    case 2: {
                        this.data = this.data - flipX;
                        break;
                    }
                    case 3: {
                        this.data = this.data + flipZ;
                        break;
                    }
                    case 4: {
                        this.data = this.data - flipZ;
                        break;
                    }
                    case 0: 
                    case 5: {
                        this.data = this.data ^ flipY * 5;
                    }
                }
            } else if (cmat.isSlab()) {
                this.data = this.data ^ flipY << 3;
            } else if (cmat.isDoor()) {
                if ((this.data & 8) == 0) {
                    switch (this.data & 3) {
                        case 0: {
                            this.data = this.data + flipX + flipZ * 3;
                            break;
                        }
                        case 1: {
                            this.data = this.data - flipX + flipZ;
                            break;
                        }
                        case 2: {
                            this.data = this.data + flipX - flipZ;
                            break;
                        }
                        case 3: {
                            this.data = this.data - flipX - flipZ * 3;
                        }
                    }
                }
            } else if (cmat.isTrapDoor()) {
                switch (this.data & 3) {
                    case 0: 
                    case 1: {
                        this.data = this.data ^ flipZ;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.data = this.data ^ flipX;
                    }
                }
            } else if (cmat.isBed()) {
                switch (this.data & 3) {
                    case 0: 
                    case 2: {
                        this.data = this.data ^ flipZ << 1;
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.data = this.data ^ flipX << 1;
                    }
                }
            } else if (cmat.isSign()) {
                switch (direction) {
                    case NORTH_SOUTH: {
                        this.data = 16 - this.data & 0xF;
                        break;
                    }
                    case WEST_EAST: {
                        this.data = 8 - this.data & 0xF;
                        break;
                    }
                }
            }
            block128 : switch (CMIMaterial.get(this.block)) {
                case TORCH: 
                case REDSTONE_TORCH: {
                    if (this.data < 1 || this.data > 4) break;
                    switch (this.data) {
                        case 1: {
                            this.data = this.data + flipX;
                            break;
                        }
                        case 2: {
                            this.data = this.data - flipX;
                            break;
                        }
                        case 3: {
                            this.data = this.data + flipZ;
                            break;
                        }
                        case 4: {
                            this.data = this.data - flipZ;
                        }
                    }
                    break;
                }
                case LEVER: {
                    switch (this.data & 0xFFFFFFF7) {
                        case 1: {
                            this.data = this.data + flipX;
                            break;
                        }
                        case 2: {
                            this.data = this.data - flipX;
                            break;
                        }
                        case 3: {
                            this.data = this.data + flipZ;
                            break;
                        }
                        case 4: {
                            this.data = this.data - flipZ;
                            break;
                        }
                        case 5: 
                        case 7: {
                            this.data = this.data ^ flipY << 1;
                            break;
                        }
                        case 0: 
                        case 6: {
                            this.data = this.data ^ flipY * 6;
                        }
                    }
                    break;
                }
                case RAIL: {
                    switch (this.data) {
                        case 6: {
                            this.data = this.data + flipX + flipZ * 3;
                            break;
                        }
                        case 7: {
                            this.data = this.data - flipX + flipZ;
                            break;
                        }
                        case 8: {
                            this.data = this.data + flipX - flipZ;
                            break;
                        }
                        case 9: {
                            this.data = this.data - flipX - flipZ * 3;
                        }
                    }
                }
                case POWERED_RAIL: 
                case DETECTOR_RAIL: 
                case ACTIVATOR_RAIL: {
                    switch (this.data & 7) {
                        case 0: 
                        case 1: {
                            this.data = this.data;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.data = this.data ^ flipX;
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.data = this.data ^ flipZ;
                        }
                    }
                    break;
                }
                case HOPPER: 
                case LADDER: 
                case WALL_SIGN: 
                case CHEST: 
                case FURNACE: 
                case LEGACY_BURNING_FURNACE: 
                case ENDER_CHEST: 
                case TRAPPED_CHEST: {
                    int extra = this.data & 8;
                    int withoutFlags = this.data & 0xFFFFFFF7;
                    switch (withoutFlags) {
                        case 2: 
                        case 3: {
                            this.data = this.data ^ flipZ | extra;
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.data = this.data ^ flipX | extra;
                        }
                    }
                    break;
                }
                case DISPENSER: 
                case DROPPER: {
                    int dispPower = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 2: 
                        case 3: {
                            this.data = this.data ^ flipZ | dispPower;
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.data = this.data ^ flipX | dispPower;
                            break;
                        }
                        case 0: 
                        case 1: {
                            this.data = this.data ^ flipY | dispPower;
                        }
                    }
                    break;
                }
                case PUMPKIN: 
                case JACK_O_LANTERN: {
                    if (this.data > 3) break;
                }
                case COMPARATOR: 
                case REPEATER: 
                case TRIPWIRE_HOOK: 
                case LEGACY_DIODE_BLOCK_OFF: 
                case LEGACY_DIODE_BLOCK_ON: 
                case LEGACY_REDSTONE_COMPARATOR_OFF: 
                case LEGACY_REDSTONE_COMPARATOR_ON: 
                case COCOA: {
                    switch (this.data & 3) {
                        case 0: 
                        case 2: {
                            this.data = this.data ^ flipZ << 1;
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.data = this.data ^ flipX << 1;
                        }
                    }
                    break;
                }
                case PISTON_HEAD: 
                case STICKY_PISTON: 
                case MOVING_PISTON: {
                    switch (this.data & 0xFFFFFFF7) {
                        case 0: 
                        case 1: {
                            this.data = this.data ^ flipY;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.data = this.data ^ flipZ;
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.data = this.data ^ flipX;
                        }
                    }
                    break;
                }
                case RED_MUSHROOM: 
                case BROWN_MUSHROOM: {
                    switch (this.data) {
                        case 1: 
                        case 4: 
                        case 7: {
                            this.data = this.data + flipX * 2;
                            break;
                        }
                        case 3: 
                        case 6: 
                        case 9: {
                            this.data = this.data - flipX * 2;
                        }
                    }
                    switch (this.data) {
                        case 1: 
                        case 2: 
                        case 3: {
                            this.data = this.data + flipZ * 6;
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 9: {
                            this.data = this.data - flipZ * 6;
                        }
                    }
                    break;
                }
                case VINE: {
                    int bit1 = 0;
                    int bit2 = 0;
                    switch (direction) {
                        case NORTH_SOUTH: {
                            bit1 = 2;
                            bit2 = 8;
                            break;
                        }
                        case WEST_EAST: {
                            bit1 = 1;
                            bit2 = 4;
                            break;
                        }
                        default: {
                            this.data = this.data;
                        }
                    }
                    int newData = this.data & ~(bit1 | bit2);
                    if ((this.data & bit1) != 0) {
                        newData |= bit2;
                    }
                    if ((this.data & bit2) != 0) {
                        newData |= bit1;
                    }
                    this.data = newData;
                    break;
                }
                case LEGACY_SKULL: {
                    switch (this.data) {
                        case 2: 
                        case 3: {
                            this.data = this.data ^ flipZ;
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.data = this.data ^ flipX;
                        }
                    }
                    break;
                }
                case ANVIL: {
                    switch (this.data & 3) {
                        case 0: 
                        case 2: {
                            this.data = this.data ^ flipZ << 1;
                            break block128;
                        }
                        case 1: 
                        case 3: {
                            this.data = this.data ^ flipX << 1;
                        }
                    }
                }
            }
            if (cmat.isFence()) {
                switch (this.data & 3) {
                    case 0: 
                    case 2: {
                        this.data = this.data ^ flipZ << 1;
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.data = this.data ^ flipX << 1;
                    }
                }
            } else if (cmat.isStairs()) {
                this.data = this.data ^ flipY << 2;
                switch (this.data) {
                    case 0: 
                    case 1: 
                    case 4: 
                    case 5: {
                        this.data = this.data ^ flipX;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: {
                        this.data = this.data ^ flipZ;
                    }
                }
            }
            if (type.name().contains("TERRACOTTA")) {
                switch (this.data & 3) {
                    case 0: 
                    case 2: {
                        this.data = this.data ^ flipZ << 1;
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.data = this.data ^ flipX << 1;
                    }
                }
            }
        }
        catch (Exception e) {
            this.data = this.data;
        }
        return this;
    }

    public CMIBlock rotate90Reverse() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockFace face;
            Directional directional;
            CMIMaterial cmat = CMIMaterial.get(this.block);
            BlockData blockData = this.block.getBlockData();
            if (blockData instanceof Directional) {
                directional = this.blockd == null ? (Directional)blockData.clone() : (Directional)this.blockd;
                face = directional.getFacing();
                switch (directional.getFacing()) {
                    case NORTH: {
                        directional.setFacing(BlockFace.WEST);
                        break;
                    }
                    case EAST: {
                        directional.setFacing(BlockFace.NORTH);
                        break;
                    }
                    case SOUTH: {
                        directional.setFacing(BlockFace.EAST);
                        break;
                    }
                    case WEST: {
                        directional.setFacing(BlockFace.SOUTH);
                    }
                }
                if (this.blockd == null) {
                    this.blockd = directional.clone();
                }
            }
            if (blockData instanceof Rotatable) {
                directional = this.blockd == null ? (Rotatable)blockData.clone() : (Rotatable)this.blockd;
                face = directional.getRotation();
                switch (face) {
                    case NORTH: {
                        directional.setRotation(BlockFace.WEST);
                        break;
                    }
                    case NORTH_NORTH_EAST: {
                        directional.setRotation(BlockFace.WEST_NORTH_WEST);
                        break;
                    }
                    case NORTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_WEST);
                        break;
                    }
                    case EAST_NORTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_NORTH_WEST);
                        break;
                    }
                    case EAST: {
                        directional.setRotation(BlockFace.NORTH);
                        break;
                    }
                    case EAST_SOUTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_NORTH_EAST);
                        break;
                    }
                    case SOUTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_EAST);
                        break;
                    }
                    case SOUTH_SOUTH_EAST: {
                        directional.setRotation(BlockFace.EAST_NORTH_EAST);
                        break;
                    }
                    case SOUTH: {
                        directional.setRotation(BlockFace.EAST);
                        break;
                    }
                    case SOUTH_SOUTH_WEST: {
                        directional.setRotation(BlockFace.EAST_SOUTH_EAST);
                        break;
                    }
                    case SOUTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_EAST);
                        break;
                    }
                    case WEST_SOUTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_SOUTH_EAST);
                        break;
                    }
                    case WEST: {
                        directional.setRotation(BlockFace.SOUTH);
                        break;
                    }
                    case WEST_NORTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_SOUTH_WEST);
                        break;
                    }
                    case NORTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_WEST);
                        break;
                    }
                    case NORTH_NORTH_WEST: {
                        directional.setRotation(BlockFace.WEST_SOUTH_WEST);
                    }
                }
                if (this.blockd == null) {
                    this.blockd = directional;
                }
                return this;
            }
            if (this.blockd == null) {
                this.blockd = blockData.clone();
            }
            return this;
        }
        Material type = this.block.getType();
        this.data = this.data == null ? this.block.getData() : this.data.intValue();
        CMIMaterial cmat = CMIMaterial.get(this.block);
        try {
            int withoutFlags;
            int extra;
            block25 : switch (cmat) {
                case TORCH: 
                case LEGACY_REDSTONE_TORCH_OFF: 
                case LEGACY_REDSTONE_TORCH_ON: {
                    switch (this.data) {
                        case 1: {
                            this.data = 3;
                            break;
                        }
                        case 2: {
                            this.data = 4;
                            break;
                        }
                        case 3: {
                            this.data = 2;
                            break;
                        }
                        case 4: {
                            this.data = 1;
                        }
                    }
                }
                case RAIL: {
                    switch (this.data) {
                        case 6: {
                            this.data = 7;
                            break;
                        }
                        case 7: {
                            this.data = 8;
                            break;
                        }
                        case 8: {
                            this.data = 9;
                            break;
                        }
                        case 9: {
                            this.data = 6;
                        }
                    }
                }
                case POWERED_RAIL: 
                case DETECTOR_RAIL: 
                case ACTIVATOR_RAIL: {
                    switch (this.data & 7) {
                        case 0: {
                            this.data = 1 | this.data & 0xFFFFFFF8;
                            break;
                        }
                        case 1: {
                            this.data = 0 | this.data & 0xFFFFFFF8;
                            break;
                        }
                        case 2: {
                            this.data = 5 | this.data & 0xFFFFFFF8;
                            break;
                        }
                        case 3: {
                            this.data = 4 | this.data & 0xFFFFFFF8;
                            break;
                        }
                        case 4: {
                            this.data = 2 | this.data & 0xFFFFFFF8;
                            break;
                        }
                        case 5: {
                            this.data = 3 | this.data & 0xFFFFFFF8;
                        }
                    }
                    break;
                }
                case STONE_BUTTON: 
                case OAK_BUTTON: {
                    int thrown = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 1: {
                            this.data = 3 | thrown;
                            break;
                        }
                        case 2: {
                            this.data = 4 | thrown;
                            break;
                        }
                        case 3: {
                            this.data = 2 | thrown;
                            break;
                        }
                        case 4: {
                            this.data = 1 | thrown;
                        }
                    }
                    break;
                }
                case LEVER: {
                    int thrown = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 1: {
                            this.data = 3 | thrown;
                            break;
                        }
                        case 2: {
                            this.data = 4 | thrown;
                            break;
                        }
                        case 3: {
                            this.data = 2 | thrown;
                            break;
                        }
                        case 4: {
                            this.data = 1 | thrown;
                            break;
                        }
                        case 5: {
                            this.data = 6 | thrown;
                            break;
                        }
                        case 6: {
                            this.data = 5 | thrown;
                            break;
                        }
                        case 7: {
                            this.data = 0 | thrown;
                            break;
                        }
                        case 0: {
                            this.data = 7 | thrown;
                        }
                    }
                    break;
                }
                case OAK_DOOR: 
                case IRON_DOOR: {
                    if ((this.data & 8) != 0) break;
                }
                case TRIPWIRE_HOOK: 
                case COCOA: {
                    extra = this.data & 0xFFFFFFFC;
                    withoutFlags = this.data & 3;
                    switch (withoutFlags) {
                        case 0: {
                            this.data = 1 | extra;
                            break;
                        }
                        case 1: {
                            this.data = 2 | extra;
                            break;
                        }
                        case 2: {
                            this.data = 3 | extra;
                            break;
                        }
                        case 3: {
                            this.data = 0 | extra;
                        }
                    }
                    break;
                }
                case LEGACY_SIGN_POST: {
                    this.data = (this.data + 4) % 16;
                    break;
                }
                case HOPPER: 
                case LADDER: 
                case WALL_SIGN: 
                case CHEST: 
                case FURNACE: 
                case LEGACY_BURNING_FURNACE: 
                case ENDER_CHEST: 
                case TRAPPED_CHEST: {
                    extra = this.data & 8;
                    withoutFlags = this.data & 0xFFFFFFF7;
                    switch (withoutFlags) {
                        case 2: {
                            this.data = 5 | extra;
                            break;
                        }
                        case 3: {
                            this.data = 4 | extra;
                            break;
                        }
                        case 4: {
                            this.data = 2 | extra;
                            break;
                        }
                        case 5: {
                            this.data = 3 | extra;
                        }
                    }
                    break;
                }
                case DISPENSER: 
                case DROPPER: {
                    int dispPower = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 2: {
                            this.data = 5 | dispPower;
                            break;
                        }
                        case 3: {
                            this.data = 4 | dispPower;
                            break;
                        }
                        case 4: {
                            this.data = 2 | dispPower;
                            break;
                        }
                        case 5: {
                            this.data = 3 | dispPower;
                        }
                    }
                    break;
                }
                case PUMPKIN: 
                case JACK_O_LANTERN: {
                    switch (this.data) {
                        case 0: {
                            this.data = 1;
                            break;
                        }
                        case 1: {
                            this.data = 2;
                            break;
                        }
                        case 2: {
                            this.data = 3;
                            break;
                        }
                        case 3: {
                            this.data = 0;
                        }
                    }
                    break;
                }
                case HAY_BLOCK: 
                case OAK_LOG: 
                case BIRCH_LOG: 
                case SPRUCE_LOG: 
                case JUNGLE_LOG: {
                    if (this.data < 4 || this.data > 11) break;
                    this.data = this.data ^ 0xC;
                    break;
                }
                case LEGACY_DIODE_BLOCK_OFF: 
                case LEGACY_DIODE_BLOCK_ON: 
                case LEGACY_REDSTONE_COMPARATOR_OFF: 
                case LEGACY_REDSTONE_COMPARATOR_ON: {
                    int dir2 = this.data & 3;
                    int delay = this.data - dir2;
                    switch (dir2) {
                        case 0: {
                            this.data = 1 | delay;
                            break;
                        }
                        case 1: {
                            this.data = 2 | delay;
                            break;
                        }
                        case 2: {
                            this.data = 3 | delay;
                            break;
                        }
                        case 3: {
                            this.data = 0 | delay;
                        }
                    }
                    break;
                }
                case OAK_TRAPDOOR: 
                case IRON_TRAPDOOR: {
                    int withoutOrientation = this.data & 0xFFFFFFFC;
                    int orientation = this.data & 3;
                    switch (orientation) {
                        case 0: {
                            this.data = 3 | withoutOrientation;
                            break;
                        }
                        case 1: {
                            this.data = 2 | withoutOrientation;
                            break;
                        }
                        case 2: {
                            this.data = 0 | withoutOrientation;
                            break;
                        }
                        case 3: {
                            this.data = 1 | withoutOrientation;
                        }
                    }
                    break;
                }
                case PISTON_HEAD: 
                case STICKY_PISTON: 
                case MOVING_PISTON: {
                    int rest = this.data & 0xFFFFFFF8;
                    switch (this.data & 7) {
                        case 2: {
                            this.data = 5 | rest;
                            break;
                        }
                        case 3: {
                            this.data = 4 | rest;
                            break;
                        }
                        case 4: {
                            this.data = 2 | rest;
                            break;
                        }
                        case 5: {
                            this.data = 3 | rest;
                        }
                    }
                    break;
                }
                case RED_MUSHROOM: 
                case BROWN_MUSHROOM: {
                    if (this.data >= 10) {
                        this.data = this.data;
                        break;
                    }
                    this.data = this.data * 3 % 10;
                    break;
                }
                case VINE: {
                    this.data = (this.data << 1 | this.data >> 3) & 0xF;
                    break;
                }
                case ANVIL: {
                    int damage = this.data & 0xFFFFFFFC;
                    switch (this.data & 3) {
                        case 0: {
                            this.data = 3 | damage;
                            break;
                        }
                        case 2: {
                            this.data = 1 | damage;
                            break;
                        }
                        case 1: {
                            this.data = 0 | damage;
                            break;
                        }
                        case 3: {
                            this.data = 2 | damage;
                        }
                    }
                    break;
                }
                case LEGACY_SKULL: {
                    switch (this.data) {
                        case 2: {
                            this.data = 5;
                            break block25;
                        }
                        case 3: {
                            this.data = 4;
                            break block25;
                        }
                        case 4: {
                            this.data = 2;
                            break block25;
                        }
                        case 5: {
                            this.data = 3;
                        }
                    }
                }
            }
            if (cmat.isBed()) {
                this.data = this.data & 0xFFFFFFFC | this.data + 1 & 3;
            } else if (cmat.isGate()) {
                this.data = this.data + 1 & 3 | this.data & 0xFFFFFFFC;
            } else if (cmat.isStairs()) {
                switch (this.data) {
                    case 0: {
                        this.data = 2;
                        break;
                    }
                    case 1: {
                        this.data = 3;
                        break;
                    }
                    case 2: {
                        this.data = 1;
                        break;
                    }
                    case 3: {
                        this.data = 0;
                        break;
                    }
                    case 4: {
                        this.data = 6;
                        break;
                    }
                    case 5: {
                        this.data = 7;
                        break;
                    }
                    case 6: {
                        this.data = 5;
                        break;
                    }
                    case 7: {
                        this.data = 4;
                    }
                }
            }
            if (type.name().contains("TERRACOTTA")) {
                extra = this.data & 0xFFFFFFFC;
                withoutFlags = this.data & 3;
                switch (withoutFlags) {
                    case 0: {
                        this.data = 1 | extra;
                        break;
                    }
                    case 1: {
                        this.data = 2 | extra;
                        break;
                    }
                    case 2: {
                        this.data = 3 | extra;
                        break;
                    }
                    case 3: {
                        this.data = 0 | extra;
                    }
                }
            }
        }
        catch (Exception e) {
            this.data = this.data;
        }
        return this;
    }

    public CMIBlock rotate90() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            CMIMaterial cmat = CMIMaterial.get(this.block);
            BlockData blockData = this.block.getBlockData().clone();
            if (blockData instanceof Directional) {
                Directional directional = this.blockd == null ? (Directional)((Directional)blockData).clone() : (Directional)this.blockd;
                BlockFace face = directional.getFacing();
                switch (face) {
                    case NORTH: {
                        directional.setFacing(BlockFace.EAST);
                        break;
                    }
                    case EAST: {
                        directional.setFacing(BlockFace.SOUTH);
                        break;
                    }
                    case SOUTH: {
                        directional.setFacing(BlockFace.WEST);
                        break;
                    }
                    case WEST: {
                        directional.setFacing(BlockFace.NORTH);
                    }
                }
                if (this.blockd == null) {
                    this.blockd = directional.clone();
                }
                return this;
            }
            if (blockData instanceof Rotatable) {
                Rotatable directional = this.blockd == null ? (Rotatable)blockData.clone() : (Rotatable)this.blockd;
                BlockFace face = directional.getRotation();
                switch (face) {
                    case NORTH: {
                        directional.setRotation(BlockFace.EAST);
                        break;
                    }
                    case NORTH_NORTH_EAST: {
                        directional.setRotation(BlockFace.EAST_SOUTH_EAST);
                        break;
                    }
                    case NORTH_EAST: {
                        directional.setRotation(BlockFace.SOUTH_EAST);
                        break;
                    }
                    case EAST_NORTH_EAST: {
                        directional.setRotation(BlockFace.SOUTH_SOUTH_EAST);
                        break;
                    }
                    case EAST: {
                        directional.setRotation(BlockFace.SOUTH);
                        break;
                    }
                    case EAST_SOUTH_EAST: {
                        directional.setRotation(BlockFace.SOUTH_SOUTH_WEST);
                        break;
                    }
                    case SOUTH_EAST: {
                        directional.setRotation(BlockFace.SOUTH_WEST);
                        break;
                    }
                    case SOUTH_SOUTH_EAST: {
                        directional.setRotation(BlockFace.WEST_SOUTH_WEST);
                        break;
                    }
                    case SOUTH: {
                        directional.setRotation(BlockFace.WEST);
                        break;
                    }
                    case SOUTH_SOUTH_WEST: {
                        directional.setRotation(BlockFace.WEST_NORTH_WEST);
                        break;
                    }
                    case SOUTH_WEST: {
                        directional.setRotation(BlockFace.NORTH_WEST);
                        break;
                    }
                    case WEST_SOUTH_WEST: {
                        directional.setRotation(BlockFace.NORTH_NORTH_WEST);
                        break;
                    }
                    case WEST: {
                        directional.setRotation(BlockFace.NORTH);
                        break;
                    }
                    case WEST_NORTH_WEST: {
                        directional.setRotation(BlockFace.NORTH_NORTH_EAST);
                        break;
                    }
                    case NORTH_WEST: {
                        directional.setRotation(BlockFace.NORTH_EAST);
                        break;
                    }
                    case NORTH_NORTH_WEST: {
                        directional.setRotation(BlockFace.EAST_NORTH_EAST);
                    }
                }
                if (this.blockd == null) {
                    this.blockd = directional;
                }
            } else {
                if (this.blockd == null) {
                    this.blockd = blockData.clone();
                }
                return this;
            }
        }
        Material type = this.block.getType();
        this.data = this.data == null ? this.block.getData() : this.data.intValue();
        CMIMaterial cmat = CMIMaterial.get(this.block);
        try {
            block25 : switch (cmat) {
                case TORCH: 
                case LEGACY_REDSTONE_TORCH_OFF: 
                case LEGACY_REDSTONE_TORCH_ON: {
                    switch (this.data) {
                        case 3: {
                            this.data = 1;
                            break;
                        }
                        case 4: {
                            this.data = 2;
                            break;
                        }
                        case 2: {
                            this.data = 3;
                            break;
                        }
                        case 1: {
                            this.data = 4;
                        }
                    }
                    break;
                }
                case RAIL: {
                    switch (this.data) {
                        case 7: {
                            this.data = 6;
                            break;
                        }
                        case 8: {
                            this.data = 7;
                            break;
                        }
                        case 9: {
                            this.data = 8;
                            break;
                        }
                        case 6: {
                            this.data = 9;
                        }
                    }
                }
                case POWERED_RAIL: 
                case DETECTOR_RAIL: 
                case ACTIVATOR_RAIL: {
                    int power = this.data & 0xFFFFFFF8;
                    switch (this.data & 7) {
                        case 1: {
                            this.data = 0 | power;
                            break;
                        }
                        case 0: {
                            this.data = 1 | power;
                            break;
                        }
                        case 5: {
                            this.data = 2 | power;
                            break;
                        }
                        case 4: {
                            this.data = 3 | power;
                            break;
                        }
                        case 2: {
                            this.data = 4 | power;
                            break;
                        }
                        case 3: {
                            this.data = 5 | power;
                        }
                    }
                    break;
                }
                case STONE_BUTTON: 
                case OAK_BUTTON: {
                    int thrown = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 3: {
                            this.data = 1 | thrown;
                            break;
                        }
                        case 4: {
                            this.data = 2 | thrown;
                            break;
                        }
                        case 2: {
                            this.data = 3 | thrown;
                            break;
                        }
                        case 1: {
                            this.data = 4 | thrown;
                        }
                    }
                    break;
                }
                case LEVER: {
                    int thrown = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 3: {
                            this.data = 1 | thrown;
                            break;
                        }
                        case 4: {
                            this.data = 2 | thrown;
                            break;
                        }
                        case 2: {
                            this.data = 3 | thrown;
                            break;
                        }
                        case 1: {
                            this.data = 4 | thrown;
                            break;
                        }
                        case 6: {
                            this.data = 5 | thrown;
                            break;
                        }
                        case 5: {
                            this.data = 6 | thrown;
                            break;
                        }
                        case 0: {
                            this.data = 7 | thrown;
                            break;
                        }
                        case 7: {
                            this.data = 0 | thrown;
                        }
                    }
                    break;
                }
                case OAK_DOOR: 
                case IRON_DOOR: {
                    if ((this.data & 8) != 0) break;
                }
                case TRIPWIRE_HOOK: 
                case COCOA: {
                    int extra = this.data & 0xFFFFFFFC;
                    int withoutFlags = this.data & 3;
                    switch (withoutFlags) {
                        case 1: {
                            this.data = 0 | extra;
                            break;
                        }
                        case 2: {
                            this.data = 1 | extra;
                            break;
                        }
                        case 3: {
                            this.data = 2 | extra;
                            break;
                        }
                        case 0: {
                            this.data = 3 | extra;
                        }
                    }
                    break;
                }
                case SIGN: {
                    this.data = (this.data + 12) % 16;
                    break;
                }
                case HOPPER: 
                case LADDER: 
                case WALL_SIGN: 
                case CHEST: 
                case FURNACE: 
                case LEGACY_BURNING_FURNACE: 
                case ENDER_CHEST: 
                case TRAPPED_CHEST: {
                    int extra = this.data & 8;
                    int withoutFlags = this.data & 0xFFFFFFF7;
                    switch (withoutFlags) {
                        case 5: {
                            this.data = 2 | extra;
                            break;
                        }
                        case 4: {
                            this.data = 3 | extra;
                            break;
                        }
                        case 2: {
                            this.data = 4 | extra;
                            break;
                        }
                        case 3: {
                            this.data = 5 | extra;
                        }
                    }
                    break;
                }
                case DISPENSER: 
                case DROPPER: {
                    int dispPower = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 5: {
                            this.data = 2 | dispPower;
                            break;
                        }
                        case 4: {
                            this.data = 3 | dispPower;
                            break;
                        }
                        case 2: {
                            this.data = 4 | dispPower;
                            break;
                        }
                        case 3: {
                            this.data = 5 | dispPower;
                        }
                    }
                    break;
                }
                case PUMPKIN: 
                case JACK_O_LANTERN: {
                    switch (this.data) {
                        case 1: {
                            this.data = 0;
                            break;
                        }
                        case 2: {
                            this.data = 1;
                            break;
                        }
                        case 3: {
                            this.data = 2;
                            break;
                        }
                        case 0: {
                            this.data = 3;
                        }
                    }
                    break;
                }
                case HAY_BLOCK: 
                case OAK_LOG: 
                case BIRCH_LOG: 
                case SPRUCE_LOG: 
                case JUNGLE_LOG: {
                    if (this.data < 4 || this.data > 11) break;
                    this.data = this.data ^ 0xC;
                    break;
                }
                case LEGACY_DIODE_BLOCK_OFF: 
                case LEGACY_DIODE_BLOCK_ON: 
                case LEGACY_REDSTONE_COMPARATOR_OFF: 
                case LEGACY_REDSTONE_COMPARATOR_ON: {
                    int dir2 = this.data & 3;
                    int delay = this.data - dir2;
                    switch (dir2) {
                        case 1: {
                            this.data = 0 | delay;
                            break;
                        }
                        case 2: {
                            this.data = 1 | delay;
                            break;
                        }
                        case 3: {
                            this.data = 2 | delay;
                            break;
                        }
                        case 0: {
                            this.data = 3 | delay;
                        }
                    }
                    break;
                }
                case OAK_TRAPDOOR: 
                case IRON_TRAPDOOR: {
                    int withoutOrientation = this.data & 0xFFFFFFFC;
                    int orientation = this.data & 3;
                    switch (orientation) {
                        case 3: {
                            this.data = 0 | withoutOrientation;
                            break;
                        }
                        case 2: {
                            this.data = 1 | withoutOrientation;
                            break;
                        }
                        case 0: {
                            this.data = 2 | withoutOrientation;
                            break;
                        }
                        case 1: {
                            this.data = 3 | withoutOrientation;
                        }
                    }
                }
                case PISTON_HEAD: 
                case STICKY_PISTON: 
                case MOVING_PISTON: {
                    int rest = this.data & 0xFFFFFFF8;
                    switch (this.data & 7) {
                        case 5: {
                            this.data = 2 | rest;
                            break;
                        }
                        case 4: {
                            this.data = 3 | rest;
                            break;
                        }
                        case 2: {
                            this.data = 4 | rest;
                            break;
                        }
                        case 3: {
                            this.data = 5 | rest;
                        }
                    }
                    break;
                }
                case RED_MUSHROOM: 
                case BROWN_MUSHROOM: {
                    if (this.data >= 10) {
                        this.data = this.data;
                        break;
                    }
                    this.data = this.data * 7 % 10;
                }
                case VINE: {
                    this.data = (this.data >> 1 | this.data << 3) & 0xF;
                    break;
                }
                case ANVIL: {
                    int damage = this.data & 0xFFFFFFFC;
                    switch (this.data & 3) {
                        case 0: {
                            this.data = 1 | damage;
                            break;
                        }
                        case 2: {
                            this.data = 3 | damage;
                            break;
                        }
                        case 1: {
                            this.data = 2 | damage;
                            break;
                        }
                        case 3: {
                            this.data = 0 | damage;
                        }
                    }
                    break;
                }
                case LEGACY_SKULL: {
                    switch (this.data) {
                        case 2: {
                            this.data = 4;
                            break block25;
                        }
                        case 3: {
                            this.data = 5;
                            break block25;
                        }
                        case 4: {
                            this.data = 3;
                            break block25;
                        }
                        case 5: {
                            this.data = 2;
                        }
                    }
                }
            }
            if (cmat.isBed()) {
                this.data = this.data & 0xFFFFFFFC | this.data - 1 & 3;
            } else if (cmat.isGate()) {
                this.data = this.data + 3 & 3 | this.data & 0xFFFFFFFC;
            } else if (cmat.isStairs()) {
                switch (this.data) {
                    case 2: {
                        this.data = 0;
                        break;
                    }
                    case 3: {
                        this.data = 1;
                        break;
                    }
                    case 1: {
                        this.data = 2;
                        break;
                    }
                    case 0: {
                        this.data = 3;
                        break;
                    }
                    case 6: {
                        this.data = 4;
                        break;
                    }
                    case 7: {
                        this.data = 5;
                        break;
                    }
                    case 5: {
                        this.data = 6;
                        break;
                    }
                    case 4: {
                        this.data = 7;
                    }
                }
            }
            if (type.name().contains("TERRACOTTA")) {
                int extra = this.data & 0xFFFFFFFC;
                int withoutFlags = this.data & 3;
                switch (withoutFlags) {
                    case 1: {
                        this.data = 0 | extra;
                        break;
                    }
                    case 2: {
                        this.data = 1 | extra;
                        break;
                    }
                    case 3: {
                        this.data = 2 | extra;
                        break;
                    }
                    case 0: {
                        this.data = 3 | extra;
                    }
                }
            }
        }
        catch (Exception e) {
            this.data = this.data;
        }
        return this;
    }

    public Object getData() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            return this.blockd == null ? this.block.getBlockData().clone() : this.blockd;
        }
        if (this.data == null) {
            return this.block.getData();
        }
        return this.data.byteValue();
    }

    public CMIBlock setData(Object data) {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            if (data != null) {
                BlockData blockData = (BlockData)data;
                this.blockd = blockData.clone();
            } else {
                this.blockd = data;
            }
        } else {
            try {
                this.data = (int)((Integer)data);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return this;
    }

    public boolean hasInventory() {
        return this.block.getState() instanceof InventoryHolder;
    }

    public Inventory getInventory() {
        if (this.block.getState() instanceof InventoryHolder) {
            try {
                this.block.getChunk().load(false);
                this.block.getChunk().setForceLoaded(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            InventoryHolder holder = (InventoryHolder)this.block.getState();
            return holder.getInventory();
        }
        return null;
    }

    public Block getSecondaryBedBlock() {
        if (this.block == null || !CMIMaterial.isBed(this.block.getType())) {
            return null;
        }
        BlockFace facing = this.getFacing();
        BedPart part = this.getBedPart();
        if (facing == null || part == null) {
            return null;
        }
        Location loc = this.block.getLocation().clone();
        switch (facing) {
            case WEST: {
                switch (part) {
                    case FOOT: {
                        return loc.add(-1.0, 0.0, 0.0).getBlock();
                    }
                    case HEAD: {
                        return loc.add(1.0, 0.0, 0.0).getBlock();
                    }
                }
                break;
            }
            case EAST: {
                switch (part) {
                    case FOOT: {
                        return loc.add(1.0, 0.0, 0.0).getBlock();
                    }
                    case HEAD: {
                        return loc.add(-1.0, 0.0, 0.0).getBlock();
                    }
                }
                break;
            }
            case NORTH: {
                switch (part) {
                    case FOOT: {
                        return loc.add(0.0, 0.0, -1.0).getBlock();
                    }
                    case HEAD: {
                        return loc.add(0.0, 0.0, 1.0).getBlock();
                    }
                }
                break;
            }
            case SOUTH: {
                switch (part) {
                    case FOOT: {
                        return loc.add(0.0, 0.0, 1.0).getBlock();
                    }
                    case HEAD: {
                        return loc.add(0.0, 0.0, -1.0).getBlock();
                    }
                }
            }
        }
        return null;
    }

    public Block getBedFootBlock() {
        if (this.block == null || !CMIMaterial.isBed(this.block.getType())) {
            return null;
        }
        Block sec = this.getSecondaryBedBlock();
        Location loc = this.block.getLocation();
        if (this.getBedPart() != null) {
            CMIBlock cbs;
            if (this.getBedPart() == BedPart.FOOT) {
                return this.block;
            }
            if (sec != null && (cbs = new CMIBlock(sec)).getBedPart() != null && cbs.getBedPart() == BedPart.FOOT) {
                return sec;
            }
        }
        return null;
    }

    public Block getBlock() {
        return this.block;
    }

    public static HashMap<BlockStateType, String> getBlockStates(Block block) {
        HashMap<BlockStateType, String> map = new HashMap<BlockStateType, String>();
        if (!Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            return map;
        }
        try {
            String blockData = block.getBlockData().getAsString();
            if (blockData.contains("[")) {
                String part = blockData.split("\\[", 2)[1];
                part = part.substring(0, part.length() - 1);
                for (String one : part.split(",")) {
                    String[] sp = one.split("=", 2);
                    BlockStateType type = BlockStateType.getByName(sp[0]);
                    if (type == null) continue;
                    map.put(type, sp[1]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return map;
    }

    public static enum blockDirection {
        none(-1),
        upWest(0),
        upEast(1),
        upNorth(2),
        upSouth(3),
        downWest(4),
        downEast(5),
        downNorth(6),
        downSouth(7);

        private int dir;

        private blockDirection(int dir2) {
            this.dir = dir2;
        }

        public int getDir() {
            return this.dir;
        }

        public static blockDirection getByDir(int dir2) {
            for (blockDirection one : blockDirection.values()) {
                if (one.getDir() != dir2) continue;
                return one;
            }
            return null;
        }
    }

    public static enum Bisect {
        TOP,
        BOTTOM;

    }

    public static enum BedPart {
        HEAD,
        FOOT;

    }

    public static enum StairShape {
        INNER_LEFT,
        INNER_RIGHT,
        OUTER_LEFT,
        OUTER_RIGHT,
        STRAIGHT;


        public static StairShape getByName(String name) {
            for (StairShape one : StairShape.values()) {
                if (!one.toString().equalsIgnoreCase(name)) continue;
                return one;
            }
            return null;
        }
    }

    public static enum FlipDirection {
        NORTH_SOUTH,
        WEST_EAST,
        UP_DOWN;

    }
}

