/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.FileHandler;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Location;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigReader
extends YamlConfiguration {
    private HashMap<String, String> comments = new HashMap();
    private HashMap<String, Object> contents = new HashMap();
    YamlConfiguration config;
    private String p = null;
    private File file = null;
    private boolean recordContents = false;
    private Plugin plugin;
    String[] waitingComment = null;

    public ConfigReader(Plugin plugin, String fileName) throws Exception {
        this(new File(plugin.getDataFolder(), fileName));
        this.plugin = plugin;
    }

    public ConfigReader(File file) throws Exception {
        this.file = file;
        this.config = this.getyml(file);
    }

    public void load() {
        block6: {
            try {
                if (!this.file.isFile()) break block6;
                try {
                    this.options().parseComments(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.load(this.file);
                try {
                    this.options().parseComments(true);
                }
                catch (Throwable throwable) {}
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public void save(String file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.save(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        Files.createParentDirs((File)file);
        String data = this.insertComments(this.saveToString());
        try (PrintWriter writer = new PrintWriter(file, "UTF-8");){
            writer.write(data);
        }
    }

    private String insertComments(String yaml) {
        if (!this.comments.isEmpty()) {
            String[] yamlContents = yaml.split("[" + System.getProperty("line.separator") + "]");
            StringBuilder newContents = new StringBuilder();
            StringBuilder currentPath = new StringBuilder();
            boolean commentedPath = false;
            boolean node = false;
            int depth = 0;
            boolean firstLine = true;
            for (String line : yamlContents) {
                int whiteSpace;
                int index;
                if (firstLine) {
                    firstLine = false;
                    if (line.startsWith("#")) continue;
                }
                boolean keyOk = true;
                if (line.contains(": ")) {
                    index = 0;
                    index = line.indexOf(": ");
                    if (index < 0) {
                        index = line.length() - 1;
                    }
                    whiteSpace = 0;
                    for (int n = 0; n < line.length() && line.charAt(n) == ' '; ++n) {
                        ++whiteSpace;
                    }
                    String key = line.substring(whiteSpace, index);
                    if (key.contains(" ")) {
                        keyOk = false;
                    } else if (key.contains("&")) {
                        keyOk = false;
                    } else if (key.contains(".")) {
                        keyOk = false;
                    } else if (key.contains("'")) {
                        keyOk = false;
                    } else if (key.contains("\"")) {
                        keyOk = false;
                    }
                }
                if (line.contains(": ") && keyOk || line.length() > 1 && line.charAt(line.length() - 1) == ':') {
                    commentedPath = false;
                    node = true;
                    index = 0;
                    index = line.indexOf(": ");
                    if (index < 0) {
                        index = line.length() - 1;
                    }
                    if (currentPath.toString().isEmpty()) {
                        currentPath = new StringBuilder(line.substring(0, index));
                    } else {
                        whiteSpace = 0;
                        for (int n = 0; n < line.length() && line.charAt(n) == ' '; ++n) {
                            ++whiteSpace;
                        }
                        if (whiteSpace / 2 > depth) {
                            currentPath.append(".").append(line.substring(whiteSpace, index));
                            ++depth;
                        } else if (whiteSpace / 2 < depth) {
                            int newDepth = whiteSpace / 2;
                            for (int i = 0; i < depth - newDepth; ++i) {
                                currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "");
                            }
                            int lastIndex = currentPath.lastIndexOf(".");
                            if (lastIndex < 0) {
                                currentPath = new StringBuilder();
                            } else {
                                currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "").append(".");
                            }
                            currentPath.append(line.substring(whiteSpace, index));
                            depth = newDepth;
                        } else {
                            int lastIndex = currentPath.lastIndexOf(".");
                            if (lastIndex < 0) {
                                currentPath = new StringBuilder();
                            } else {
                                currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "").append(".");
                            }
                            currentPath.append(line.substring(whiteSpace, index));
                        }
                    }
                } else {
                    node = false;
                }
                StringBuilder newLine = new StringBuilder(line);
                if (node) {
                    String comment = null;
                    if (!commentedPath) {
                        comment = this.comments.get(currentPath.toString());
                    }
                    if (comment != null && !comment.isEmpty()) {
                        newLine.insert(0, System.getProperty("line.separator")).insert(0, comment);
                        comment = null;
                        commentedPath = true;
                    }
                }
                newLine.append(System.getProperty("line.separator"));
                newContents.append(newLine.toString());
            }
            return newContents.toString();
        }
        return yaml;
    }

    public void addHeaderComments(List<String> comments) {
        if (Version.isCurrentEqualOrHigher(Version.v1_18_R1)) {
            try {
                this.getC().options().setHeader(comments);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.getC().options().header(ConfigReader.formStringBuilder(comments).toString());
    }

    public void appendComment(String path, String ... commentLines) {
        this.addComment(path, true, commentLines);
    }

    public void addComment(String path, String ... commentLines) {
        this.addComment(path, false, commentLines);
    }

    public void addComment(String path, boolean append, String ... commentLines) {
        if (this.p != null) {
            path = this.p + path;
        }
        StringBuilder commentstring = new StringBuilder();
        if (append && this.comments.containsKey(path)) {
            commentstring.append(this.comments.get(path));
        }
        String leadingSpaces = "";
        for (int n = 0; n < path.length(); ++n) {
            if (path.charAt(n) != '.') continue;
            leadingSpaces = leadingSpaces + "  ";
        }
        for (String line : commentLines) {
            if (!line.isEmpty()) {
                line = leadingSpaces + "# " + line;
            }
            if (commentstring.length() > 0) {
                commentstring.append(System.getProperty("line.separator"));
            }
            commentstring.append(line);
        }
        this.comments.put(path, commentstring.toString());
    }

    public YamlConfiguration getyml(File file) throws Exception {
        YamlConfiguration config = new YamlConfiguration();
        FileInputStream fileinputstream = null;
        try {
            fileinputstream = new FileInputStream(file);
            InputStreamReader str = new InputStreamReader((InputStream)fileinputstream, Charset.forName("UTF-8"));
            config.load((Reader)str);
            str.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            this.saveToBackup();
            throw e;
        }
        finally {
            if (fileinputstream != null) {
                try {
                    fileinputstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return config;
    }

    public void saveToBackup() {
        this.saveToBackup(true);
    }

    public void saveToBackup(boolean inform) {
        File dataFolder = this.plugin == null ? CMILib.getInstance().getDataFolder() : this.plugin.getDataFolder();
        File cc = new File(dataFolder, "FileBackups");
        if (!cc.isDirectory()) {
            cc.mkdir();
        }
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss ");
        String newFileName = dateFormat.format(date) + this.file.getName();
        if (inform) {
            CMIMessages.consoleMessage("&cFailed to load " + this.file.getName() + "! Backup have been saved into " + dataFolder.getPath() + File.separator + "FileBackups" + File.separator + newFileName);
        }
        File f = new File(dataFolder, "FileBackups" + File.separator + newFileName);
        try {
            Files.copy((File)this.file, (File)f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void newLn(StringBuilder header) {
        header.append(System.lineSeparator());
    }

    private static StringBuilder formStringBuilder(List<String> list) {
        StringBuilder header = new StringBuilder();
        for (String one : list) {
            header.append(one);
            ConfigReader.newLn(header);
        }
        return header;
    }

    public void header(List<String> list) {
        if (Version.isCurrentEqualOrHigher(Version.v1_18_R1)) {
            try {
                this.options().setHeader(list);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.options().header(ConfigReader.formStringBuilder(list).toString());
    }

    private void checkWaitingComment(String path) {
        if (this.waitingComment == null) {
            return;
        }
        this.addComment(path, this.waitingComment);
        this.waitingComment = null;
    }

    public YamlConfiguration getC() {
        return this.config;
    }

    public void copyDefaults(boolean value) {
        this.getC().options().copyDefaults(value);
    }

    public Boolean get(String path, Boolean boo) {
        path = this.process(path, boo);
        return this.config.getBoolean(path);
    }

    public String process(String path, Object value) {
        if (this.p != null) {
            path = this.p + path;
        }
        this.checkWaitingComment(path);
        this.config.addDefault(path, value);
        this.copySetting(path);
        return path;
    }

    public Object get(String path, Location boo) {
        path = this.process(path, boo);
        return this.config.get(path);
    }

    public int get(String path, int boo) {
        path = this.process(path, boo);
        return this.config.getInt(path);
    }

    public int get(String path, Integer boo) {
        path = this.process(path, boo);
        return this.config.getInt(path);
    }

    public List<Integer> getIntList(String path, List<Integer> list) {
        path = this.process(path, list);
        return this.config.getIntegerList(path);
    }

    private static String convertUnicode(String st) {
        try {
            if (!st.contains("\\u")) {
                return st;
            }
            StringBuilder sb = new StringBuilder(st.length());
            block7: for (int i = 0; i < st.length(); ++i) {
                int ch = st.charAt(i);
                if (ch == 92) {
                    char nextChar;
                    char c = nextChar = i == st.length() - 1 ? (char)'\\' : (char)st.charAt(i + 1);
                    if (nextChar >= '0' && nextChar <= '7') {
                        String code = "" + nextChar;
                        if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                            code = code + st.charAt(i + 1);
                            if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                                code = code + st.charAt(i + 1);
                                ++i;
                            }
                        }
                        sb.append((char)Integer.parseInt(code, 8));
                        continue;
                    }
                    switch (nextChar) {
                        case 'u': {
                            if (i >= st.length() - 5) {
                                ch = 117;
                                break;
                            }
                            try {
                                int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5), 16);
                                sb.append(Character.toChars(code));
                            }
                            catch (NumberFormatException e) {
                                sb.append("\\");
                                continue block7;
                            }
                            i += 5;
                            continue block7;
                        }
                        default: {
                            sb.append("\\");
                            continue block7;
                        }
                    }
                    ++i;
                }
                sb.append((char)ch);
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return st;
        }
    }

    public List<String> get(String path, List<String> list) {
        path = this.process(path, list);
        if (this.recordContents) {
            this.contents.put(path, this.config.isList(path) ? this.config.getStringList(path) : list);
        }
        List ls = this.config.getStringList(path);
        for (int p = 0; p < ls.size(); ++p) {
            String st = ConfigReader.convertUnicode((String)ls.get(p));
            ls.set(p, st);
        }
        return ls;
    }

    public String get(String path, String boo) {
        path = this.process(path, boo);
        if (this.recordContents) {
            this.contents.put(path, this.config.isString(path) ? this.config.getString(path) : boo);
        }
        return ConfigReader.convertUnicode(this.config.getString(path));
    }

    public Double get(String path, Double boo) {
        path = this.process(path, boo);
        return this.config.getDouble(path);
    }

    private synchronized void copySetting(String path) {
        this.set(path, this.config.get(path));
    }

    public void resetP() {
        this.p = null;
    }

    @Deprecated
    public void setP(String cmd) {
        this.p = "command." + cmd + ".info.";
    }

    public void setFullPath(String path) {
        this.p = path;
    }

    public String getPath() {
        return this.p;
    }

    public void setRecordContents(boolean recordContents) {
        this.recordContents = recordContents;
    }

    public HashMap<String, Object> getContents() {
        return this.contents;
    }

    public File getFile() {
        return this.file;
    }

    public void copyDefaults() {
        this.getC().options().copyDefaults(true);
    }

    public void forceSet(String path, Object obj) {
        this.config.set(path, obj);
        this.copySetting(path);
    }

    public String getObject(String path, Object boo) {
        if (path == null) {
            return ConfigReader.convertUnicode(this.config.getString(path));
        }
        path = this.process(path, boo);
        if (this.recordContents) {
            this.contents.put(path, this.config.isString(path) ? this.config.getString(path) : boo);
        }
        return ConfigReader.convertUnicode(this.config.getString(path));
    }
}

