/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Locale;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Locale.Snd;
import net.Zrips.CMILib.Locale.YmlMaker;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Language {
    public FileConfiguration enlocale;
    public FileConfiguration Customlocale;
    private CMILib plugin;
    private String lang;

    public Language(CMILib plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void reload() {
        try {
            this.Customlocale = new YmlMaker(this.plugin, "Translations" + File.separator + "Locale_" + this.lang + ".yml").getConfig();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private FileConfiguration getEN() {
        if (this.enlocale == null) {
            try {
                this.enlocale = new YmlMaker(this.plugin, "Translations" + File.separator + "Locale_EN.yml").getConfig();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.enlocale;
    }

    public String getMessage(String key, Object ... variables) {
        String missing = "Missing locale for " + key + " ";
        String msg = "";
        msg = this.Customlocale.isString(key) ? this.Customlocale.getString(key) : (this.Customlocale.isList(key) ? CMIList.listToString(this.Customlocale.getStringList(key)) : (this.getEN().isString(key) ? this.getEN().getString(key) : missing));
        Snd snd = null;
        Location customLoc = null;
        ArrayList<Object> remove = new ArrayList<Object>();
        for (Object one : variables) {
            if (one instanceof Snd && snd == null) {
                snd = (Snd)one;
                remove.add(one);
                continue;
            }
            if (CMILib.getInstance().isCmiPresent() && one instanceof com.Zrips.CMI.Containers.Snd) {
                com.Zrips.CMI.Containers.Snd cmisnd = (com.Zrips.CMI.Containers.Snd)one;
                msg = this.updateCmiSnd(cmisnd, msg);
                remove.add(one);
                continue;
            }
            if (one instanceof Location && customLoc == null) {
                customLoc = (Location)one;
                remove.add(one);
                continue;
            }
            if (!(one instanceof Player) || snd != null) continue;
            snd = new Snd().setTarget((Player)one).setTarget((Player)one);
        }
        if (customLoc != null) {
            msg = this.replacePlayer(customLoc, msg);
        }
        if (snd != null) {
            msg = this.updateSnd(snd, msg);
        }
        if (variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                if (remove.contains(variables[i])) continue;
                if (variables.length >= i + 2) {
                    Object var = variables[i + 1];
                    if (var instanceof Boolean) {
                        Object object = var = (Boolean)var != false ? LC.info_variables_True.getLocale(new Object[0]) : LC.info_variables_False.getLocale(new Object[0]);
                    }
                    if (var instanceof LC) {
                        var = ((LC)((Object)var)).getText();
                    }
                    msg = Language.outReplace(msg, variables[i], var);
                }
                ++i;
            }
        }
        msg = msg.replace("!prefix!", this.getM(LC.info_prefix));
        msg = this.filterNewLine(msg);
        return CMIChatColor.translate(msg);
    }

    public String filterNewLine(String msg) {
        Pattern patern = Pattern.compile("([ ]?[\\/][n][$|\\s])|([ ]?\\\\n)");
        Matcher match = patern.matcher(msg);
        while (match.find()) {
            if (match.group(1) != null && !match.group(1).isEmpty()) {
                msg = msg.replace(match.group(1), "\n");
            }
            if (match.group(2) == null || match.group(2).isEmpty()) continue;
            msg = msg.replace(match.group(2), "\n");
        }
        return msg;
    }

    private String getM(LC lc) {
        String key = lc.getPt();
        String missing = "Missing locale for &7" + key + " ";
        String msg = "";
        msg = this.Customlocale.isString(key) ? this.Customlocale.getString(key) : (this.Customlocale.isList(key) ? CMIList.listToString(this.Customlocale.getStringList(key)) : (this.getEN().isString(key) ? this.getEN().getString(key) : missing));
        return msg;
    }

    public List<String> updateSnd(Snd snd, List<String> msg) {
        int l = msg.size();
        for (int i = 0; i < l; ++i) {
            msg.set(i, this.updateSnd(snd, msg.get(i)));
        }
        return msg;
    }

    public String updateSnd(Snd snd, String msg) {
        String name;
        if (msg == null) {
            return null;
        }
        if (!msg.contains("[")) {
            msg = this.filterNewLine(msg);
            return msg;
        }
        if (snd.getConsoleSender() != null) {
            name = snd.getConsoleSender().getName();
            if (name.equalsIgnoreCase("Console") || name.equalsIgnoreCase(CMILib.getFakeUserName())) {
                name = this.getM(LC.info_Console);
            }
            msg = Language.replace(msg, "senderName", name);
            msg = Language.replace(msg, "senderDisplayName", name);
            msg = Language.replace(msg, "senderPrefix", "");
            msg = Language.replace(msg, "senderSuffix", "");
        }
        if (snd.getPlayerSender() != null) {
            msg = this.replacePlayer("sender", snd.getPlayerSender(), snd.getPlayerTarget(), msg);
            if (snd.getPlayerSender().getLocation() != null) {
                msg = this.replacePlayer(snd.getPlayerSender().getLocation(), msg);
            }
        }
        if (snd.getConsoleTarget() != null) {
            name = snd.getConsoleTarget().getName();
            if (name.equalsIgnoreCase("Console") || name.equalsIgnoreCase(CMILib.getFakeUserName())) {
                name = this.getM(LC.info_Console);
            }
            msg = Language.replace(msg, "targetName", name);
            msg = Language.replace(msg, "targetDisplayName", name);
        }
        if (snd.getPlayerTarget() != null) {
            msg = this.replacePlayer("", snd.getPlayerTarget(), snd.getPlayerSender(), msg);
            msg = this.replacePlayer("player", snd.getPlayerTarget(), snd.getPlayerSender(), msg);
            if (snd.getPlayerTarget().getLocation() != null) {
                msg = this.replacePlayer(snd.getPlayerTarget().getLocation(), msg);
            }
            msg = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(snd.getPlayerTarget(), msg);
        }
        if (snd.getConsoleSource() != null) {
            name = snd.getConsoleSource().getName();
            if (name.equalsIgnoreCase("Console") || name.equalsIgnoreCase(CMILib.getFakeUserName())) {
                name = this.getM(LC.info_Console);
            }
            msg = Language.replace(msg, "sourceName", name);
            msg = Language.replace(msg, "sourceDisplayName", name);
        }
        if (snd.getSenderName() != null) {
            name = snd.getSenderName();
            if (name.equalsIgnoreCase("Console") || name.equalsIgnoreCase(CMILib.getFakeUserName())) {
                name = this.getM(LC.info_Console);
            }
            msg = Language.replace(msg, "senderName", name);
            msg = Language.replace(msg, "senderDisplayName", name);
        }
        if (snd.getTargetName() != null) {
            name = snd.getTargetName();
            if (name.equalsIgnoreCase("Console") || name.equalsIgnoreCase(CMILib.getFakeUserName())) {
                name = this.getM(LC.info_Console);
            }
            msg = Language.replace(msg, "Name", name);
            msg = Language.replace(msg, "DisplayName", name);
            msg = Language.replace(msg, "playerName", name);
            msg = Language.replace(msg, "playerDisplayName", name);
        }
        if (snd.getPlayerSource() != null) {
            msg = this.replacePlayer("source", snd.getPlayerSource(), snd.getPlayerTarget(), msg);
            if (snd.getPlayerSource().getLocation() != null) {
                msg = this.replacePlayer(snd.getPlayerSource().getLocation(), msg);
            }
        }
        msg = this.filterNewLine(msg);
        return msg;
    }

    public String updateCmiSnd(com.Zrips.CMI.Containers.Snd snd, String msg) {
        String name;
        if (msg == null) {
            return null;
        }
        if (!msg.contains("[")) {
            msg = this.filterNewLine(msg);
            return msg;
        }
        msg = Language.replace(msg, "serverName", CMI.getInstance().getBungeeCordManager().isBungeeCord() ? CMI.getInstance().getBungeeCordManager().getThisServerName() : this.plugin.getReflectionManager().getServerName());
        if (snd.getConsoleSender() != null) {
            name = snd.getConsoleSender().getName();
            if (name.equalsIgnoreCase("Console") || name.equalsIgnoreCase(CMI.getInstance().getPlayerManager().getFakeUserName())) {
                name = this.getM(LC.info_Console);
            }
            msg = Language.replace(msg, "senderName", name);
            msg = Language.replace(msg, "senderDisplayName", name);
            msg = Language.replace(msg, "senderPrefix", "");
            msg = Language.replace(msg, "senderSuffix", "");
        }
        if (snd.getPlayerSender() != null) {
            msg = this.replacePlayer("sender", snd.getPlayerSender(), snd.getPlayerTarget(), msg);
            if (snd.getPlayerSender().getLocation() != null) {
                msg = this.replacePlayer(snd.getPlayerSender().getLocation(), msg);
            }
        }
        if (snd.getSenderUser() != null) {
            msg = this.replaceCmiUser("sender", snd.getSenderUser(), msg);
        }
        if (snd.getConsoleTarget() != null) {
            name = snd.getConsoleTarget().getName();
            if (name.equalsIgnoreCase("Console") || name.equalsIgnoreCase(CMI.getInstance().getPlayerManager().getFakeUserName())) {
                name = this.getM(LC.info_Console);
            }
            msg = Language.replace(msg, "targetName", name);
            msg = Language.replace(msg, "targetDisplayName", name);
        }
        if (snd.getPlayerTarget() != null) {
            msg = this.replacePlayer("", snd.getPlayerTarget(), snd.getPlayerSender(), msg);
            msg = this.replacePlayer("player", snd.getPlayerTarget(), snd.getPlayerSender(), msg);
            if (snd.getPlayerTarget().isOnline() && snd.getPlayerTarget().getLocation() != null) {
                msg = this.replacePlayer(snd.getPlayerTarget().getLocation(), msg);
            }
        }
        if (snd.getTargetUser() != null) {
            msg = this.replaceCmiUser("", snd.getTargetUser(), msg);
        }
        if (snd.getConsoleSource() != null) {
            name = snd.getConsoleSource().getName();
            if (name.equalsIgnoreCase("Console") || name.equalsIgnoreCase(CMI.getInstance().getPlayerManager().getFakeUserName())) {
                name = this.getM(LC.info_Console);
            }
            msg = Language.replace(msg, "sourceName", name);
            msg = Language.replace(msg, "sourceDisplayName", name);
        }
        if (snd.getSenderName() != null) {
            name = snd.getSenderName();
            if (name.equalsIgnoreCase("Console") || name.equalsIgnoreCase(CMI.getInstance().getPlayerManager().getFakeUserName())) {
                name = this.getM(LC.info_Console);
            }
            msg = Language.replace(msg, "senderName", name);
            msg = Language.replace(msg, "senderDisplayName", name);
        }
        if (snd.getTargetName() != null) {
            name = snd.getTargetName();
            if (name.equalsIgnoreCase("Console") || name.equalsIgnoreCase(CMI.getInstance().getPlayerManager().getFakeUserName())) {
                name = this.getM(LC.info_Console);
            }
            msg = Language.replace(msg, "Name", name);
            msg = Language.replace(msg, "DisplayName", name);
            msg = Language.replace(msg, "playerName", name);
            msg = Language.replace(msg, "playerDisplayName", name);
        }
        if (snd.getPlayerSource() != null) {
            msg = this.replacePlayer("source", snd.getPlayerSource(), snd.getPlayerTarget(), msg);
            if (snd.getPlayerSource().getLocation() != null) {
                msg = this.replacePlayer(snd.getPlayerSource().getLocation(), msg);
            }
        }
        if (snd.getSourceUser() != null) {
            msg = this.replaceCmiUser("source", snd.getSourceUser(), msg);
        }
        msg = this.cleanVariables("", msg);
        msg = this.cleanVariables("target", msg);
        msg = this.cleanVariables("source", msg);
        msg = this.filterNewLine(msg);
        return msg;
    }

    private String cleanVariables(String type, String msg) {
        msg = Language.replace(msg, "serverName", "");
        msg = Language.replace(msg, type + "offon", "");
        msg = Language.replace(msg, type + "Prefix", "");
        msg = Language.replace(msg, type + "Suffix", "");
        return msg;
    }

    public String replaceCmiUser(String type, CMIUser user, String msg) {
        if ((msg = Language.replace(msg, "serverName", CMI.getInstance().getBungeeCordManager().isBungeeCord() ? CMI.getInstance().getBungeeCordManager().getThisServerName() : this.plugin.getReflectionManager().getServerName())) == null || user == null) {
            return msg;
        }
        if (user.isOnline()) {
            msg = this.replacePlayer(type, user.getPlayer(), null, msg);
        }
        msg = Language.replace(msg, type + "offon", this.getOffOn(user.isOnline()));
        msg = Language.replace(msg, type + "Name", user.getName(false));
        msg = Language.replace(msg, type + "Nick", user.getNickName());
        msg = Language.replace(msg, type + "NickName", user.getNickName());
        msg = Language.replace(msg, type + "DisplayName", user.getDisplayName(true));
        msg = Language.replace(msg, type + "Prefix", CMIChatColor.translate(user.getPrefix()));
        msg = Language.replace(msg, type + "Suffix", CMIChatColor.translate(user.getSuffix()));
        if (type.isEmpty()) {
            msg = Language.replace(msg, "playerName", user.getName(false));
            msg = Language.replace(msg, "playerNick", user.getNickName());
            msg = Language.replace(msg, "playerNickName", user.getNickName());
            msg = Language.replace(msg, "playerDisplayName", user.getDisplayName(true));
            msg = Language.replace(msg, "Prefix", CMIChatColor.translate(user.getPrefix()));
            msg = Language.replace(msg, "Suffix", CMIChatColor.translate(user.getSuffix()));
        }
        if (user.getLogOutLocation() != null) {
            msg = this.replacePlayer(type, user.getLogOutLocation(), msg);
        }
        return msg;
    }

    public String replacePlayer(String type, Player player, Player whoGets, String msg) {
        if (msg == null || player == null) {
            return msg;
        }
        msg = Language.replace(msg, type + "Name", player.getName());
        msg = Language.replace(msg, type + "DisplayName", player.getDisplayName());
        msg = Language.replace(msg, type + "offon", this.getOffOn(player, whoGets));
        msg = Language.replace(msg, type + "Hp", (int)player.getHealth());
        msg = Language.replace(msg, type + "MaxHp", (int)player.getMaxHealth());
        msg = Language.replace(msg, type + "Hunger", player.getFoodLevel());
        if (player.getGameMode() != null) {
            msg = Language.replace(msg, type + "GameMode", this.getMessage("info.variables." + player.getGameMode().name().toLowerCase(), new Object[0]));
        }
        if (player.isOnline() && player.getLocation() != null) {
            msg = this.replacePlayer(type, player.getLocation(), msg);
        }
        return msg;
    }

    public String replacePlayer(String type, Location loc, String msg) {
        if (msg == null || loc == null) {
            return msg;
        }
        msg = Language.replace(msg, type + "X", loc.getBlockX());
        msg = Language.replace(msg, type + "Y", loc.getBlockY());
        msg = Language.replace(msg, type + "Z", loc.getBlockZ());
        msg = Language.replace(msg, type + "Yaw", (int)loc.getYaw());
        msg = Language.replace(msg, type + "Pitch", (int)loc.getPitch());
        if (loc.getWorld() != null) {
            msg = Language.replace(msg, type + "WorldName", loc.getWorld().getName());
            msg = Language.replace(msg, type + "World", loc.getWorld().getName());
        }
        return msg;
    }

    public String replacePlayer(Location loc, String msg) {
        if (msg == null || loc == null) {
            return msg;
        }
        msg = Language.replace(msg, "x", loc.getBlockX());
        msg = Language.replace(msg, "y", loc.getBlockY());
        msg = Language.replace(msg, "z", loc.getBlockZ());
        msg = Language.replace(msg, "yaw", (int)loc.getYaw());
        msg = Language.replace(msg, "pitch", (int)loc.getPitch());
        if (loc.getWorld() != null) {
            msg = Language.replace(msg, "worldName", loc.getWorld().getName());
            msg = Language.replace(msg, "world", loc.getWorld().getName());
        }
        return msg;
    }

    private static String outReplace(String msg, Object what, Object with) {
        if (what == null) {
            return msg;
        }
        if (with == null) {
            with = "";
        }
        return msg.replace(String.valueOf(what), String.valueOf(with));
    }

    private static String replace(String msg, Object what, Object with) {
        if (what == null) {
            return msg;
        }
        if (with == null) {
            with = "";
        }
        return msg.replaceAll(String.valueOf("(?i)(\\[" + what + "\\])"), Matcher.quoteReplacement(String.valueOf(with)));
    }

    public String getDefaultMessage(String key) {
        String missing = "Missing locale for " + key + " ";
        String msg = "";
        msg = this.getEN().isString(key) ? this.getEN().getString(key) : missing;
        StringBuilder s = new StringBuilder();
        if (msg.contains("/n")) {
            int i = 0;
            for (String one : msg.split("/n")) {
                s.append(one);
                if (++i >= msg.split("/n").length) continue;
                s.append("\n  ");
            }
            msg = s.toString();
        }
        return CMIChatColor.translate(msg);
    }

    public List<String> getMessageList(String key, Object ... variables) {
        int i;
        List ls;
        String missing = "Missing locale for " + key + " ";
        if (this.Customlocale.isList(key)) {
            ls = this.Customlocale.getStringList(key);
        } else {
            List list = ls = !this.getEN().getStringList(key).isEmpty() ? this.getEN().getStringList(key) : Arrays.asList(missing);
        }
        if (variables != null && variables.length > 0) {
            for (i = 0; i < ls.size(); ++i) {
                String msg = (String)ls.get(i);
                for (int y = 0; y < variables.length; y += 2) {
                    msg = msg.replace(String.valueOf(variables[y]), String.valueOf(variables[y + 1]));
                }
                msg = this.filterNewLine(msg);
                ls.set(i, CMIChatColor.translate(msg));
            }
        }
        i = 0;
        for (String one : ls) {
            ls.set(i, CMIChatColor.translate(one.replace("!prefix!", this.getM(LC.info_prefix))));
            ++i;
        }
        return ls;
    }

    public boolean isList(String key) {
        if (this.Customlocale != null && this.Customlocale.contains(key)) {
            return this.Customlocale.isList(key);
        }
        if (this.getEN().contains(key)) {
            return this.getEN().isList(key);
        }
        return false;
    }

    public boolean containsKey(String key) {
        if (this.Customlocale != null && this.Customlocale.contains(key)) {
            return true;
        }
        return this.getEN().contains(key);
    }

    public boolean isString(String key) {
        return this.getEN().isString(key);
    }

    public Set<String> getKeys(String path) {
        if (!this.lang.equalsIgnoreCase("EN") && this.Customlocale != null && this.Customlocale.isConfigurationSection(path)) {
            return this.Customlocale.getConfigurationSection(path).getKeys(false);
        }
        if (this.getEN() != null && this.getEN().isConfigurationSection(path)) {
            return this.getEN().getConfigurationSection(path).getKeys(false);
        }
        return new HashSet<String>();
    }

    public String getOffOn(Player player, Player whoGets) {
        return this.getOffOn(whoGets == null ? player.isOnline() : whoGets.canSee(player) && player.isOnline());
    }

    public String getOffOn(Player player) {
        return this.getOffOn(player.isOnline());
    }

    public String getOffOn(boolean state) {
        return state ? LC.info_variables_Online.getLocale(new Object[0]) : LC.info_variables_Offline.getLocale(new Object[0]);
    }
}

