/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.commands;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.CMILibConfig;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIArray;
import net.Zrips.CMILib.Container.CMICommandSender;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Locale.Snd;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Permissions.CMILPerm;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.commands.CAnnotation;
import net.Zrips.CMILib.commands.CMICommand;
import net.Zrips.CMILib.commands.Cmd;
import net.Zrips.CMILib.commands.Void;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;

public class CommandsHandler
implements CommandExecutor {
    public static final String label = "cmil";
    private static String packagePath = "";
    private static Map<String, CMICommand> commands = new TreeMap<String, CMICommand>();
    public static boolean enabledDebug = true;
    private boolean testServer = false;
    protected CMILib plugin;

    public CommandsHandler(CMILib plugin) {
        this.plugin = plugin;
        packagePath = this.getClass().getPackage().getName() + ".list";
        if (plugin.getReflectionManager().getServerName().equals("LT_Craft") && ((World)Bukkit.getWorlds().get(0)).getSeed() == 1782374759L) {
            this.testServer = true;
        }
    }

    public Boolean performCMICommand(CommandSender sender, Class<?> command, String ... args) {
        CMICommand cmd = CommandsHandler.getCommands().get(command.getSimpleName().toLowerCase());
        if (cmd == null) {
            return false;
        }
        return this.performCMICommand(sender, cmd, args);
    }

    public Boolean performCMICommand(CommandSender sender, CMICommand cmd, String[] args) {
        if (cmd == null) {
            return false;
        }
        return cmd.getCmdClass().perform(this.plugin, new CMICommandSender(sender), args);
    }

    public Boolean performCMICommand(CommandSender sender, Class<?> command, String args) {
        CMICommand cmd = CommandsHandler.getCommands().get(command.getSimpleName().toLowerCase());
        if (cmd == null) {
            return false;
        }
        return this.performCMICommand(sender, cmd, args);
    }

    public Boolean performCMICommand(CommandSender sender, CMICommand cmd, String args) {
        if (cmd == null) {
            return false;
        }
        String[] ar = args.split(" ");
        return cmd.getCmdClass().perform(this.plugin, new CMICommandSender(sender), ar);
    }

    public boolean onCommand(CommandSender sender, Command command, String l, String[] args) {
        String ar;
        Object cm;
        String suffix;
        if (args.length > 0 && args[0].equalsIgnoreCase("rmc")) {
            return false;
        }
        CMICommandSender cmiSender = new CMICommandSender(sender);
        if (cmiSender.isCommandBlock()) {
            try {
                for (int i = 0; i < args.length; ++i) {
                    String one = args[i];
                    List ent = Bukkit.selectEntities((CommandSender)sender, (String)one.toLowerCase());
                    if (ent.isEmpty() || !one.equalsIgnoreCase("@p") && !one.equalsIgnoreCase("@r")) continue;
                    args[i] = ((Entity)ent.get(0)).getName();
                }
            }
            catch (Throwable i) {
                // empty catch block
            }
        }
        if (!CMILPerm.command.hasPermission(cmiSender, false, 5000L)) {
            if (cmiSender.isPlayer()) {
                boolean showPerm = CMILibConfig.permisionOnError || CMILPerm.permisiononerror.hasPermission(sender, false, (Long)5000L);
                RawMessage rm = new RawMessage();
                rm.addText(CMIMessages.getMsg(LC.info_NoPermission, new Object[0])).addHover(showPerm ? "&2" + CMILPerm.command.getPermission() : null);
                rm.show(sender);
            }
            ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
            Snd snd = new Snd().setSender(console).setTarget(sender);
            CMIMessages.sendMessage((Object)console, CMIMessages.getMsg(LC.info_NoPlayerPermission, snd, "[permission]", CMILPerm.command.getPermission()), false);
            return false;
        }
        if (args.length == 0) {
            return this.help(cmiSender, 1);
        }
        if ((args.length == 1 || args.length == 2) && (args[0].equalsIgnoreCase("?") || args[0].equalsIgnoreCase("help"))) {
            if (!CMILibConfig.showMainHelpPage) {
                CMIMessages.sendMessage((Object)cmiSender, LC.info_NoCommand, new Object[0]);
                return false;
            }
            int page = 1;
            if (args.length == 2) {
                try {
                    page = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    CMIMessages.sendMessage((Object)cmiSender, CMIMessages.getMsg(LC.info_UseInteger, new Object[0]), false);
                    return true;
                }
            }
            if (page < 1) {
                page = 1;
            }
            return this.help(cmiSender, page);
        }
        String cmd = args[0].toLowerCase();
        Cmd cmdClass = this.getCmdClass(cmd);
        if (cmdClass == null && (cmdClass = this.getBestCmdmatch(cmd)) != null && !(suffix = CMIArray.toString(args, 1)).isEmpty()) {
            suffix = " " + suffix;
        }
        if (cmdClass == null) {
            CMIMessages.sendMessage((Object)cmiSender, LC.info_NoCommand, new Object[0]);
            return false;
        }
        cmd = cmdClass.getClass().getSimpleName();
        if (!cmd.equalsIgnoreCase(args[0])) {
            RawMessage rm = new RawMessage();
            StringBuilder s = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                if (!s.toString().isEmpty()) {
                    s.append(" ");
                }
                s.append(args[i]);
            }
            rm.addText(CMIMessages.getMsg(LC.info_cantFindCommand, "[%1]", args[0], "[%2]", cmd)).addHover(CMIMessages.getMsg(LC.info_Click, new Object[0])).addCommand(CommandsHandler.getLabel() + " " + cmd + " " + s);
            rm.show(sender);
            if (CMILibConfig.isSimilarCommandPrevention) {
                return false;
            }
        }
        if (!CommandsHandler.hasCommandPermission(cmiSender, cmd, 50L)) {
            if (cmiSender.isPlayer()) {
                Class<? extends Cmd> redirectClass;
                CMICommand cm2 = CommandsHandler.getCommands().get(cmdClass.getClass().getSimpleName());
                if (cm2 != null && !cm2.getAnottation().redirectClass().equals(Void.class) && CommandsHandler.hasCommandPermission(cmiSender, (redirectClass = cm2.getAnottation().redirectClass()).getSimpleName(), 50L)) {
                    cmiSender.performCommand(CommandsHandler.getLabel() + " " + redirectClass.getSimpleName() + " " + CMIArray.toString(CMIArray.removeFirst(args)));
                    return true;
                }
                boolean showPerm = CMILibConfig.permisionOnError || CMILPerm.permisiononerror.hasPermission(sender, false, (Long)5000L);
                RawMessage rm = new RawMessage();
                rm.addText(CMIMessages.getMsg(LC.info_NoPermission, new Object[0])).addHover(showPerm ? "&2cmil.command." + cmd : null);
                rm.show(sender);
                ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
                Snd snd = new Snd().setSender(console).setTarget(sender);
                CMIMessages.sendMessage((Object)console, CMIMessages.getMsg(LC.info_NoPlayerPermission, snd, "[permission]", "cmil.command." + cmd), false);
            } else {
                CMIMessages.sendMessage((Object)sender, CMIMessages.getMsg(LC.info_NoPermission, new Object[0]), false);
            }
            return false;
        }
        String[] myArgs = CMIArray.removeFirst(args);
        if (myArgs.length > 0 && myArgs[myArgs.length - 1].equals("?") && ((cm = CommandsHandler.getCommands().get(cmdClass.getClass().getSimpleName())) == null || !((CMICommand)cm).getAnottation().ignoreHelpPage())) {
            this.sendUsage(cmiSender, cmd);
            return false;
        }
        for (Method met : cmdClass.getClass().getMethods()) {
            int good;
            int size;
            boolean more;
            ArrayList<Integer> list;
            if (!met.isAnnotationPresent(CAnnotation.class)) continue;
            CAnnotation cs = met.getAnnotation(CAnnotation.class);
            if (cmiSender.isPlayer()) {
                int[] regVar = cs.regVar();
                list = new ArrayList<Integer>();
                more = true;
                int[] nArray = regVar;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int one = nArray[i];
                    if (one < 0) {
                        more = false;
                    }
                    list.add(one);
                }
                size = myArgs.length;
                good = 1;
                if (list.contains(666)) {
                    CMIMessages.sendMessage((Object)sender, LC.info_FromConsole, false);
                    return false;
                }
                if (list.contains(-size)) {
                    good = 0;
                }
                if (list.contains(size)) {
                    good = 1;
                }
                if (list.contains(-100) && size == 0) {
                    good = 0;
                }
                if (more && !list.contains(size)) {
                    good = 0;
                }
                if (good != 0) continue;
                this.sendUsage(cmiSender, cmdClass.getClass().getSimpleName(), false);
                return false;
            }
            int[] consoleVar = cs.consoleVar();
            list = new ArrayList();
            more = true;
            for (int one : consoleVar) {
                if (one < 0) {
                    more = false;
                }
                list.add(one);
            }
            size = myArgs.length;
            good = 1;
            if (list.contains(666)) {
                CMIMessages.sendMessage((Object)sender, LC.info_Ingame, false);
                return false;
            }
            if (list.contains(-size)) {
                good = 0;
            }
            if (list.contains(size)) {
                good = 1;
            }
            if (list.contains(-100) && size == 0) {
                good = 0;
            }
            if (more && !list.contains(size)) {
                good = 0;
            }
            if (good != 0) continue;
            this.sendUsage(cmiSender, cmdClass.getClass().getSimpleName(), false);
            return false;
        }
        if (myArgs.length > 0) {
            myArgs[myArgs.length - 1] = myArgs[myArgs.length - 1].replace("<>-<>", "");
        }
        ar = (ar = CMIArray.toString(myArgs, " ")).isEmpty() ? "" : " " + ar;
        Boolean back = cmdClass.perform(this.plugin, cmiSender, myArgs);
        if (back != null && !back.booleanValue()) {
            this.sendUsage(cmiSender, cmd, false);
        }
        return back != null && back != false;
    }

    public static boolean hasCommandPermission(CMICommandSender sender, String cmd, Long delay) {
        if (!sender.isPlayer()) {
            return true;
        }
        if (CMILPerm.command_$1.hasPermission(sender, false, true, delay, "*")) {
            return true;
        }
        return CMILPerm.command_$1.hasPermission(sender, false, true, delay, cmd);
    }

    private String getUsage(String cmd) {
        String baseCmd = "cmil " + cmd;
        String cmdString = this.plugin.getLM().getMessage("command.help.output.cmdFormat", "[command]", baseCmd);
        String key = "command." + cmd + ".help.args";
        cmdString = this.plugin.getLM().containsKey(key) && !this.plugin.getLM().getMessage(key, new Object[0]).isEmpty() ? cmdString.replace("[arguments]", " " + this.plugin.getLM().getMessage(key, new Object[0])) : cmdString.replace("[arguments]", "");
        return cmdString;
    }

    public void sendUsage(CMICommandSender sender, String cmd) {
        this.sendUsage(sender, cmd, true);
    }

    public void sendUsage(CMICommandSender sender, String cmd, boolean explanation) {
        String message = CMIChatColor.YELLOW + this.plugin.getLM().getMessage("command.help.output.usage", new Object[0]);
        message = message.replace("%usage%", this.getUsage(cmd));
        CMIMessages.sendMessage((Object)sender, message, false);
        CMIMessages.sendMessage((Object)sender, this.plugin.getLM().getMessage("command.help.output.helpPageDescription", "[description]", this.plugin.getLM().getMessage("command." + cmd + ".help.info", new Object[0])), false);
        if (explanation && this.plugin.getLM().containsKey("command." + cmd + ".help.explanation")) {
            if (this.plugin.getLM().isString("command." + cmd + ".help.explanation")) {
                CMIMessages.sendMessage((Object)sender, this.plugin.getLM().getMessage("command.help.output.explanation", "[explanation]", this.plugin.getLM().getMessage("command." + cmd + ".help.explanation", new Object[0])), false);
            } else {
                for (String one : this.plugin.getLM().getMessageList("command." + cmd + ".help.explanation", new Object[0])) {
                    CMIMessages.sendMessage((Object)sender, this.plugin.getLM().getMessage("command.help.output.explanation", "[explanation]", one), false);
                }
            }
        }
    }

    protected boolean help(CMICommandSender sender, int page) {
        Map<String, Integer> commands = CommandsHandler.getCommands(sender);
        if (commands.size() == 0) {
            CMIMessages.sendMessage((Object)sender, LC.info_NoPermission.getLocale(new Object[0]), false);
            return true;
        }
        if (!CMILibConfig.CommandSorting) {
            commands = CommandsHandler.sort(commands);
        }
        PageInfo pi = new PageInfo(7, commands.size(), page);
        CMIMessages.sendMessage((Object)sender, this.plugin.getLM().getMessage("command.help.output.title", new Object[0]), false);
        int i = -1;
        for (Map.Entry<String, Integer> one : commands.entrySet()) {
            if (++i > pi.getEnd()) break;
            if (!pi.isInRange(i)) continue;
            String message = this.plugin.getLM().getMessage("command.help.output.cmdInfoFormat", new Object[0]);
            message = message.replace("[command]", this.getUsage(one.getKey()));
            message = message.replace("[description]", this.plugin.getLM().getMessage("command." + one.getKey() + ".help.info", new Object[0]));
            CMIMessages.sendMessage((Object)sender, message, false);
        }
        pi.ShowPagination(sender, "/cmil ?");
        return true;
    }

    public static List<String> getClassesFromPackage(String pckgname) throws ClassNotFoundException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (URL jarURL : ((URLClassLoader)CMILib.class.getClassLoader()).getURLs()) {
                try {
                    result.addAll(CommandsHandler.getClassesInSamePackageFromJar(pckgname, jarURL.toURI().getPath()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Null pointer exception)");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getClassesInSamePackageFromJar(String packageName, String jarPath) {
        JarFile jarFile = null;
        ArrayList<String> listOfCommands = new ArrayList<String>();
        try {
            jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String entryName = entry.getName();
                packageName = packageName.replace(".", "/");
                if (entryName == null || !entryName.endsWith(".class") || !entryName.startsWith(packageName)) continue;
                String name = entryName.replace(packageName, "").replace(".class", "").replace("/", "");
                if (name.contains("$")) {
                    name = name.split("\\$")[0];
                }
                listOfCommands.add(name);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return listOfCommands;
    }

    public static Map<String, Integer> getCommands(CMICommandSender sender) {
        TreeMap<String, Integer> temp = new TreeMap<String, Integer>();
        for (Map.Entry<String, CMICommand> cmd : commands.entrySet()) {
            if (cmd.getValue().getAnottation().hidden() || cmd.getValue().getAnottation().test() || cmd.getValue().getEnabled() != null && !cmd.getValue().getEnabled().booleanValue()) continue;
            if (cmd.getValue().getEnabled() == null) {
                cmd.getValue().setEnabled(true);
            }
            if (sender != null && !CommandsHandler.hasCommandPermission(sender, cmd.getKey(), 5000L)) continue;
            temp.put(cmd.getKey(), cmd.getValue().getAnottation().priority());
        }
        return temp;
    }

    public void fillCommands() {
        List<Object> lm = new ArrayList();
        HashMap classes = new HashMap();
        try {
            lm = CommandsHandler.getClassesFromPackage(packagePath);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        for (String string : lm) {
            Class<?> newclass = CommandsHandler.getClass(string);
            if (newclass == null) continue;
            classes.put(string, newclass);
        }
        block5: for (Map.Entry entry : classes.entrySet()) {
            for (Method met : ((Class)entry.getValue()).getMethods()) {
                if (!met.isAnnotationPresent(CAnnotation.class)) continue;
                String cmd = (String)entry.getKey();
                try {
                    if (!Cmd.class.isAssignableFrom((Class)entry.getValue())) continue block5;
                    Cmd cmdClass = (Cmd)((Class)entry.getValue()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    CMICommand cmiCommand = new CMICommand(cmdClass, cmd, met.getAnnotation(CAnnotation.class));
                    if (cmiCommand.getAnottation().test() && !this.testServer) continue;
                    commands.put(cmd.toLowerCase(), cmiCommand);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    Bukkit.getConsoleSender().sendMessage("!!! " + cmd);
                    e.printStackTrace();
                }
                continue block5;
            }
        }
    }

    private static Class<?> getClass(String cmd) {
        Class<?> nmsClass = null;
        if (cmd.toLowerCase().contains("notfinished")) {
            return null;
        }
        try {
            nmsClass = Class.forName(packagePath + "." + cmd.toLowerCase());
        }
        catch (Exception e) {
            CMIMessages.consoleMessage("&cFailed to load " + cmd.toLowerCase() + " command!");
            e.printStackTrace();
        }
        return nmsClass;
    }

    private Cmd getCmdClass(String cmdName) {
        CMICommand cmd = commands.get(cmdName.toLowerCase());
        Cmd cmdClass = null;
        if (cmd != null) {
            if (cmd.getAnottation().test() && !this.testServer) {
                return null;
            }
            if (cmd.getEnabled() != null && !cmd.getEnabled().booleanValue()) {
                CMIMessages.consoleMessage("&5Someone tried to use command for disabled module (" + cmd.getName() + ")");
                return null;
            }
            if (cmd.getEnabled() == null) {
                cmd.setEnabled(true);
            }
            cmdClass = cmd.getCmdClass();
        }
        return cmdClass;
    }

    private Cmd getBestCmdmatch(String cmdName) {
        if (CMILibConfig.SimilarCommandChecker > 0) {
            double matchPercentage;
            Object bestMatch = null;
            int value = cmdName.length() * 2;
            for (Map.Entry<String, CMICommand> one : commands.entrySet()) {
                int d = CommandsHandler.distance(one.getKey(), cmdName);
                if (d > value) continue;
                value = d;
                bestMatch = one.getValue().getCmdClass();
                if (value != 1) continue;
                break;
            }
            if (bestMatch != null && (double)CMILibConfig.SimilarCommandChecker <= (matchPercentage = 100.0 - (double)value * 100.0 / (double)bestMatch.getClass().getSimpleName().length())) {
                return bestMatch;
            }
        }
        return null;
    }

    public static int distance(String a, String b) {
        a = a.toLowerCase();
        b = b.toLowerCase();
        int[] costs = new int[b.length() + 1];
        for (int j = 0; j < costs.length; ++j) {
            costs[j] = j;
        }
        for (int i = 1; i <= a.length(); ++i) {
            costs[0] = i;
            int nw = i - 1;
            for (int j = 1; j <= b.length(); ++j) {
                int cj = Math.min(1 + Math.min(costs[j], costs[j - 1]), a.charAt(i - 1) == b.charAt(j - 1) ? nw : nw + 1);
                nw = costs[j];
                costs[j] = cj;
            }
        }
        return costs[b.length()];
    }

    private static Map<String, Integer> sort(Map<String, Integer> unsortMap) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }

    public static Map<String, CMICommand> getCommands() {
        return commands;
    }

    public static String getLabel() {
        return label;
    }

    public boolean isTestServer() {
        return this.testServer;
    }

    public static String getCommandPrefix(String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        if (command.startsWith(CommandsHandler.getLabel() + " ")) {
            command = command.substring(CommandsHandler.getLabel().length() + 1);
        }
        return CommandsHandler.getLabel() + " " + command;
    }
}

