/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.guis;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.gui.Gui;
import me.mylogo.chestlock.guis.LockFriendsGui;
import me.mylogo.chestlock.guis.LockGui;
import me.mylogo.chestlock.items.NBTItem;
import me.mylogo.chestlock.lock.LockedChest;
import me.mylogo.chestlock.user.LockUserInfo;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ChoosePlayerGui
extends Gui {
    private final Player player;
    private final LockedChest lockedChest;
    private List<LockUserInfo> userInfos;
    private int page;

    public ChoosePlayerGui(Lock lock, Player player, LockedChest lockedChest) {
        super(lock);
        this.player = player;
        this.lockedChest = lockedChest;
        this.userInfos = Bukkit.getOnlinePlayers().stream().filter(arg_0 -> ((Player)player).canSee(arg_0)).map(OfflinePlayer::getUniqueId).map(lock.getUserManager()::getInfo).collect(Collectors.toList());
        this.addConsumer("go_back", () -> this.goToGui(new LockFriendsGui(lock, player, lockedChest), player));
        this.addConsumer("back", () -> {
            --this.page;
            this.fillPlayers();
        });
        this.addConsumer("next", () -> {
            ++this.page;
            this.fillPlayers();
        });
        this.fillPlayers();
        this.insert(this.inv.getSize() - 9, "go_back", lock.getLockConfig().getBackItem());
    }

    private void fillPlayers() {
        List list = this.userInfos.stream().skip(this.page * 9 * 4).limit(36L).collect(Collectors.toList());
        for (int i = 0; i < 36; ++i) {
            if (i < list.size()) {
                this.inv.setItem(i, ((LockUserInfo)list.get(i)).getSkull());
                continue;
            }
            this.inv.setItem(i, null);
        }
        if (this.page > 0) {
            this.insert(38, "back", this.plugin.getLockConfig().getPreviousPageItem());
        } else {
            this.inv.setItem(38, LockGui.BLANK);
        }
        if (this.userInfos.size() > this.page * 9 * 4) {
            this.insert(42, "next", this.plugin.getLockConfig().getNextPageItem());
        } else {
            this.inv.setItem(42, LockGui.BLANK);
        }
    }

    @Override
    protected void initInventory() {
        this.inv = Bukkit.createInventory(null, (int)45, (String)this.plugin.getLockConfig().getChoosePlayerGuiTitle());
        this.fill(36, 45, LockGui.BLANK);
    }

    @Override
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        int n = inventoryClickEvent.getRawSlot();
        if (n < 36) {
            inventoryClickEvent.setCancelled(true);
            ItemStack itemStack = inventoryClickEvent.getCurrentItem();
            if (itemStack == null || itemStack.getType() == Material.AIR) {
                return;
            }
            NBTItem nBTItem = new NBTItem(itemStack);
            if (nBTItem.hasKey("_uuid")) {
                UUID uUID = UUID.fromString(nBTItem.getString("_uuid"));
                LockUserInfo lockUserInfo2 = this.userInfos.stream().filter(lockUserInfo -> lockUserInfo.getUniqueId().equals(uUID)).findFirst().orElse(null);
                if (lockUserInfo2 != null) {
                    if (this.lockedChest.isTrusted(lockUserInfo2)) {
                        this.player.sendMessage(this.plugin.getLockConfig().getFriendAlreadyAdded());
                        return;
                    }
                    if (this.lockedChest.isOwner(lockUserInfo2.getUniqueId())) {
                        this.player.sendMessage(this.plugin.getLockConfig().getCannotAddYourself());
                        return;
                    }
                    this.lockedChest.addTrusted(lockUserInfo2);
                    this.backToFriends();
                }
            }
        } else {
            this.handleRegularClick(inventoryClickEvent);
        }
    }

    private void backToFriends() {
        this.goToGui(new LockFriendsGui(this.plugin, this.player, this.lockedChest), this.player);
    }
}

