/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.guis;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.gui.Gui;
import me.mylogo.chestlock.guis.ChoosePlayerGui;
import me.mylogo.chestlock.guis.LockGui;
import me.mylogo.chestlock.items.ItemBuilder;
import me.mylogo.chestlock.items.NBTItem;
import me.mylogo.chestlock.lock.LockedChest;
import me.mylogo.chestlock.user.LockUserInfo;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class LockFriendsGui
extends Gui {
    private final Player player;
    private final LockedChest lockedChest;
    private int page;

    public LockFriendsGui(Lock lock, Player player, LockedChest lockedChest) {
        super(lock);
        this.player = player;
        this.lockedChest = lockedChest;
        this.addConsumer("next", () -> {
            ++this.page;
            this.fillFriends();
        });
        this.addConsumer("back", () -> {
            --this.page;
            this.fillFriends();
        });
        this.addConsumer("go_back", () -> this.goToGui(new LockGui(lock, player, lockedChest), player));
        this.addConsumer("add", () -> this.goToGui(new ChoosePlayerGui(lock, player, lockedChest), player));
        this.addConsumer("friend", (InventoryClickEvent inventoryClickEvent, NBTItem nBTItem) -> {
            String string = nBTItem.getString("uuid");
            try {
                UUID uUID = UUID.fromString(string);
                lockedChest.getTrusted().removeIf(lockUserInfo -> lockUserInfo.getUniqueId().equals(uUID));
                this.fillFriends();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
        this.addConsumer("copy", () -> {
            LockUserInfo lockUserInfo = lock.getUserManager().getInfo(player);
            lockUserInfo.setCopiedList(new ArrayList<LockUserInfo>(lockedChest.getTrusted()));
            player.sendMessage(lock.getLockConfig().getFriendsCopied());
        });
        this.addConsumer("paste", () -> {
            LockUserInfo lockUserInfo = lock.getUserManager().getInfo(player);
            List<LockUserInfo> list = lockUserInfo.getCopiedList();
            if (list != null) {
                lockedChest.setTrusted(new ArrayList<LockUserInfo>(list));
                this.fillFriends();
                player.sendMessage(lock.getLockConfig().getFriendsPasted());
            } else {
                player.sendMessage(lock.getLockConfig().getNoFriendsCopied());
            }
        });
        this.fillFriends();
        this.insert(18, "go_back", lock.getLockConfig().getBackItem());
    }

    private void fillFriends() {
        List list = this.lockedChest.getTrusted().stream().skip(this.page * 5).limit(5L).collect(Collectors.toList());
        for (int i = 0; i < 5; ++i) {
            if (i < list.size()) {
                LockUserInfo lockUserInfo = (LockUserInfo)list.get(i);
                ItemBuilder itemBuilder = new ItemBuilder(lockUserInfo.getSkull());
                itemBuilder.setName(this.plugin.getLockConfig().getFriendSkullName().replace("%player%", lockUserInfo.getName()));
                itemBuilder.setLore(this.plugin.getLockConfig().getFriendsSkullLore());
                NBTItem nBTItem = new NBTItem(itemBuilder.build());
                nBTItem.setString("uuid", lockUserInfo.getUniqueId().toString());
                this.insert(11 + i, "friend", nBTItem.build());
                continue;
            }
            this.inv.setItem(11 + i, null);
        }
        if (this.page > 0) {
            this.insert(10, "back", this.plugin.getLockConfig().getPreviousPageItem());
        } else {
            this.inv.setItem(10, LockGui.BLANK);
        }
        if (this.lockedChest.getTrusted().size() > this.page * 5) {
            this.insert(16, "next", this.plugin.getLockConfig().getNextPageItem());
        } else {
            this.inv.setItem(16, LockGui.BLANK);
        }
    }

    @Override
    protected void initInventory() {
        this.inv = Bukkit.createInventory(null, (int)27, (String)this.plugin.getLockConfig().getFriendsGuiTitle());
        this.fill(0, 10, LockGui.BLANK);
        this.fill(17, 27, LockGui.BLANK);
        this.insert(21, "copy", this.plugin.getLockConfig().getCopyFriendsItem());
        this.insert(22, "add", this.plugin.getLockConfig().getAddFriendItem());
        this.insert(23, "paste", this.plugin.getLockConfig().getPasteFriendsItem());
    }
}

