/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.listeners;

import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.api.events.OpenRequestLockGuiEvent;
import me.mylogo.chestlock.guis.LockGui;
import me.mylogo.chestlock.guis.YesNoGui;
import me.mylogo.chestlock.lock.BlockPos;
import me.mylogo.chestlock.lock.LockedChest;
import me.mylogo.chestlock.user.LockUserInfo;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class PlayerListener
implements Listener {
    private Lock plugin;
    private BlockPos[] SURROUNDING = new BlockPos[]{new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(0, 0, 1)};

    public PlayerListener(Lock lock) {
        this.plugin = lock;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        LockUserInfo lockUserInfo = this.plugin.getUserManager().getInfo(player);
        lockUserInfo.setName(player.getName());
        lockUserInfo.setDisplayName(player.getDisplayName());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Block block = playerInteractEvent.getClickedBlock();
            Player player = playerInteractEvent.getPlayer();
            if (!player.isSneaking()) {
                return;
            }
            if (this.plugin.getLockConfig().isLockable(block.getType())) {
                LockedChest lockedChest = this.plugin.getLockManager().getLockedChest(block);
                if (lockedChest == null && playerInteractEvent.useInteractedBlock() != Event.Result.DENY && player.isSneaking()) {
                    if (this.hasNoBlockInHand(player)) {
                        playerInteractEvent.setCancelled(true);
                        OpenRequestLockGuiEvent openRequestLockGuiEvent = new OpenRequestLockGuiEvent(playerInteractEvent, block);
                        Bukkit.getPluginManager().callEvent((Event)openRequestLockGuiEvent);
                        if (!openRequestLockGuiEvent.isCancelled()) {
                            this.requestLock(player, block);
                        }
                    }
                } else if (lockedChest != null) {
                    LockUserInfo lockUserInfo = this.plugin.getUserManager().getInfo(player);
                    if (lockedChest.isOwner(player.getUniqueId()) || lockUserInfo.isBypassing()) {
                        if (player.isSneaking() && this.hasNoBlockInHand(player)) {
                            playerInteractEvent.setUseInteractedBlock(Event.Result.DENY);
                            new LockGui(this.plugin, player, lockedChest).openFor(player);
                        }
                    } else if (!lockedChest.canUse(lockUserInfo) && this.hasNoBlockInHand(player)) {
                        if (!lockUserInfo.isBypassing()) {
                            playerInteractEvent.setUseInteractedBlock(Event.Result.DENY);
                            player.sendMessage(this.plugin.getLockConfig().getContainerIsLocked(lockedChest.getOwner().getName()));
                        } else {
                            player.sendMessage(this.plugin.getCommands().prefixedMessage("\u00a7e\u00a7lYou have bypassed a protected chest by \u00a7b\u00a7l" + lockedChest.getOwner().getName()));
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent inventoryOpenEvent) {
        DoubleChest doubleChest;
        Inventory inventory = inventoryOpenEvent.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (inventoryHolder instanceof DoubleChest) {
            doubleChest = (DoubleChest)inventoryHolder;
            inventoryHolder = doubleChest.getLeftSide();
        }
        if (inventoryHolder instanceof BlockState) {
            doubleChest = (BlockState)inventoryHolder;
            LockedChest lockedChest = this.plugin.getLockManager().getLockedChest(doubleChest.getBlock());
            if (lockedChest == null) {
                return;
            }
            LockUserInfo lockUserInfo = this.plugin.getUserManager().getInfo(inventoryOpenEvent.getPlayer().getUniqueId());
            if (!lockedChest.canUse(lockUserInfo)) {
                inventoryOpenEvent.setCancelled(!lockUserInfo.isBypassing());
                inventoryOpenEvent.getPlayer().sendMessage(this.plugin.getLockConfig().getContainerIsLocked(lockedChest.getOwner().getName()));
            }
        }
    }

    private boolean hasNoBlockInHand(Player player) {
        ItemStack itemStack = player.getInventory().getItemInHand();
        if (this.plugin.getLockConfig().lockOnlyWithEmptyHand()) {
            return itemStack == null || itemStack.getType() == Material.AIR;
        }
        return itemStack == null || !itemStack.getType().isBlock() && !this.plugin.getLockConfig().isRightClickBlacklist(itemStack.getType()) || itemStack.getType() == Material.AIR;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        Player player = blockPlaceEvent.getPlayer();
        Block block = blockPlaceEvent.getBlock();
        Material material = block.getType();
        if (material == Material.CHEST || material == Material.TRAPPED_CHEST) {
            for (BlockPos blockPos : this.SURROUNDING) {
                LockedChest lockedChest;
                Block block2 = block.getRelative(blockPos.getX(), 0, blockPos.getZ());
                if (block2.getType() != material || (lockedChest = this.plugin.getLockManager().getLockedChest(block2)) == null || lockedChest.isOwner(player.getUniqueId())) continue;
                player.sendMessage(this.plugin.getLockConfig().getContainerIsLocked(lockedChest.getOwner().getName()));
                blockPlaceEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onFinalBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        Player player = blockPlaceEvent.getPlayer();
        Block block = blockPlaceEvent.getBlock();
        Material material = block.getType();
        if (material == Material.CHEST || material == Material.TRAPPED_CHEST) {
            for (BlockPos blockPos : this.SURROUNDING) {
                LockedChest lockedChest;
                Block block2 = block.getRelative(blockPos.getX(), 0, blockPos.getZ());
                if (block2.getType() != material || (lockedChest = this.plugin.getLockManager().getLockedChest(block2)) == null) continue;
                if (lockedChest.isOwner(player.getUniqueId())) {
                    lockedChest.addPosition(new BlockPos(block));
                    this.plugin.getLockManager().register(block.getWorld().getName(), lockedChest);
                    player.sendMessage(this.plugin.getLockConfig().getYouAddedContainer());
                    continue;
                }
                player.sendMessage(this.plugin.getLockConfig().getContainerIsLocked(lockedChest.getOwner().getName()));
                blockPlaceEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        LockedChest lockedChest;
        Block block = blockBreakEvent.getBlock();
        Material material = block.getType();
        Player player = blockBreakEvent.getPlayer();
        if (this.plugin.getLockConfig().isLockable(material) && (lockedChest = this.plugin.getLockManager().getLockedChest(block)) != null) {
            if (lockedChest.isOwner(player.getUniqueId())) {
                BlockPos blockPos = new BlockPos(block);
                this.plugin.getLockManager().unregister(lockedChest, blockPos);
                player.sendMessage(this.plugin.getLockConfig().getBrokeContainer());
            } else {
                blockBreakEvent.setCancelled(true);
                player.sendMessage(this.plugin.getLockConfig().getContainerIsLocked(lockedChest.getOwner().getName()));
            }
        }
    }

    private void requestLock(Player player, Block block) {
        new YesNoGui(this.plugin, this.plugin.getLockConfig().getLockRequestTitle(), yesNoGui -> {
            LockedChest lockedChest = this.plugin.getLockManager().getLockedChest(block);
            if (lockedChest == null && this.plugin.getLockConfig().isLockable(block.getType())) {
                this.plugin.getLockManager().requestLock(player, block);
            } else {
                player.sendMessage(this.plugin.getLockConfig().getContainerNotLockable());
            }
            yesNoGui.closeInventory((HumanEntity)player);
        }, yesNoGui -> yesNoGui.closeInventory((HumanEntity)player)).openFor(player);
    }
}

