/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.user;

import java.io.File;
import java.util.List;
import java.util.UUID;
import me.mylogo.chestlock.JsonSerialization;
import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.Module;
import me.mylogo.chestlock.user.LockUserInfo;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LockUserManager
extends Module {
    private List<LockUserInfo> infos;
    private JsonSerialization<LockUserInfo> lockUserInfoJsonSerialization = new JsonSerialization<LockUserInfo>(LockUserInfo::save, LockUserInfo::new, this::getFile);

    public LockUserManager(Lock lock) {
        super(lock);
        this.infos = this.lockUserInfoJsonSerialization.read();
        Bukkit.getOnlinePlayers().forEach(player -> this.getInfo((Player)player).setName(player.getName()));
    }

    @Override
    public void onDisable() {
        this.lockUserInfoJsonSerialization.save(this.infos);
    }

    public File getFile(boolean bl) {
        return this.getDataFile("chests." + (bl ? "tmp" : "json"));
    }

    public LockUserInfo getInfo(UUID uUID) {
        LockUserInfo lockUserInfo = this.getAbsoluteInfo(uUID);
        if (lockUserInfo == null) {
            lockUserInfo = new LockUserInfo(uUID);
            this.infos.add(lockUserInfo);
        }
        return lockUserInfo;
    }

    private LockUserInfo getAbsoluteInfo(UUID uUID) {
        return this.infos.stream().filter(lockUserInfo -> lockUserInfo.getUniqueId().equals(uUID)).findFirst().orElse(null);
    }

    public LockUserInfo getInfo(Player player) {
        return this.getInfo(player.getUniqueId());
    }

    public LockUserInfo getInfoByPlayerName(String string) {
        return this.infos.stream().filter(lockUserInfo -> string.equalsIgnoreCase(lockUserInfo.getName())).findFirst().orElse(null);
    }
}

