/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.chestprotect.hikari.hibernate;

import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import me.angeschossen.chestprotect.hikari.HikariConfig;
import me.angeschossen.chestprotect.hikari.HikariDataSource;
import me.angeschossen.chestprotect.hikari.hibernate.HikariConfigurationUtil;
import me.angeschossen.chestprotect.slf4j.Logger;
import me.angeschossen.chestprotect.slf4j.LoggerFactory;
import org.hibernate.HibernateException;
import org.hibernate.Version;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class HikariConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = -9131625057941275711L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariConnectionProvider.class);
    private HikariConfig hcfg = null;
    private HikariDataSource hds = null;

    public HikariConnectionProvider() {
        if (Version.getVersionString().substring(0, 5).compareTo("4.3.6") >= 1) {
            LOGGER.warn("me.angeschossen.chestprotect.hikari.hibernate.HikariConnectionProvider has been deprecated for versions of Hibernate 4.3.6 and newer.  Please switch to org.hibernate.hikaricp.internal.HikariCPConnectionProvider.");
        }
    }

    public void configure(Map map) {
        try {
            LOGGER.debug("Configuring HikariCP");
            this.hcfg = HikariConfigurationUtil.loadConfiguration(map);
            this.hds = new HikariDataSource(this.hcfg);
        }
        catch (Exception exception) {
            throw new HibernateException((Throwable)exception);
        }
        LOGGER.debug("HikariCP Configured");
    }

    public Connection getConnection() {
        Connection connection = null;
        if (this.hds != null) {
            connection = this.hds.getConnection();
        }
        return connection;
    }

    public void closeConnection(Connection connection) {
        connection.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class clazz) {
        return ConnectionProvider.class.equals((Object)clazz) || HikariConnectionProvider.class.isAssignableFrom(clazz);
    }

    public Object unwrap(Class clazz) {
        if (ConnectionProvider.class.equals((Object)clazz) || HikariConnectionProvider.class.isAssignableFrom(clazz)) {
            return this;
        }
        if (DataSource.class.isAssignableFrom(clazz)) {
            return this.hds;
        }
        throw new UnknownUnwrapTypeException(clazz);
    }

    public void stop() {
        this.hds.close();
    }
}

