/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.chestprotect.hikari.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import me.angeschossen.chestprotect.hikari.util.ClockSource;
import me.angeschossen.chestprotect.hikari.util.ConcurrentBag$IBagStateListener;
import me.angeschossen.chestprotect.hikari.util.ConcurrentBag$IConcurrentBagEntry;
import me.angeschossen.chestprotect.hikari.util.FastList;
import me.angeschossen.chestprotect.slf4j.Logger;
import me.angeschossen.chestprotect.slf4j.LoggerFactory;

public class ConcurrentBag
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentBag.class);
    private final CopyOnWriteArrayList sharedList;
    private final boolean weakThreadLocals;
    private final ThreadLocal threadList;
    private final ConcurrentBag$IBagStateListener listener;
    private final AtomicInteger waiters;
    private volatile boolean closed;
    private final SynchronousQueue handoffQueue;

    public ConcurrentBag(ConcurrentBag$IBagStateListener concurrentBag$IBagStateListener) {
        this.listener = concurrentBag$IBagStateListener;
        this.weakThreadLocals = this.useWeakThreadLocals();
        this.handoffQueue = new SynchronousQueue(true);
        this.waiters = new AtomicInteger();
        this.sharedList = new CopyOnWriteArrayList();
        this.threadList = this.weakThreadLocals ? ThreadLocal.withInitial(() -> new ArrayList(16)) : ThreadLocal.withInitial(() -> new FastList(ConcurrentBag$IConcurrentBagEntry.class, 16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentBag$IConcurrentBagEntry borrow(long l, TimeUnit timeUnit) {
        int n;
        List list = (List)this.threadList.get();
        for (n = list.size() - 1; n >= 0; --n) {
            ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry;
            Object e = list.remove(n);
            ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry2 = concurrentBag$IConcurrentBagEntry = this.weakThreadLocals ? (ConcurrentBag$IConcurrentBagEntry)((WeakReference)e).get() : (ConcurrentBag$IConcurrentBagEntry)e;
            if (concurrentBag$IConcurrentBagEntry == null || !concurrentBag$IConcurrentBagEntry.compareAndSet(0, 1)) continue;
            return concurrentBag$IConcurrentBagEntry;
        }
        n = this.waiters.incrementAndGet();
        try {
            long l2;
            for (ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry : this.sharedList) {
                if (!concurrentBag$IConcurrentBagEntry.compareAndSet(0, 1)) continue;
                if (n > 1) {
                    this.listener.addBagItem(n - 1);
                }
                ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry3 = concurrentBag$IConcurrentBagEntry;
                return concurrentBag$IConcurrentBagEntry3;
            }
            this.listener.addBagItem(n);
            l = timeUnit.toNanos(l);
            do {
                l2 = ClockSource.currentTime();
                ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry = (ConcurrentBag$IConcurrentBagEntry)this.handoffQueue.poll(l, TimeUnit.NANOSECONDS);
                if (concurrentBag$IConcurrentBagEntry != null && !concurrentBag$IConcurrentBagEntry.compareAndSet(0, 1)) continue;
                ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry4 = concurrentBag$IConcurrentBagEntry;
                return concurrentBag$IConcurrentBagEntry4;
            } while ((l -= ClockSource.elapsedNanos(l2)) > 10000L);
            ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry = null;
            return concurrentBag$IConcurrentBagEntry;
        }
        finally {
            this.waiters.decrementAndGet();
        }
    }

    public void requite(ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry) {
        concurrentBag$IConcurrentBagEntry.setState(0);
        int n = 0;
        while (this.waiters.get() > 0) {
            if (concurrentBag$IConcurrentBagEntry.getState() != 0 || this.handoffQueue.offer(concurrentBag$IConcurrentBagEntry)) {
                return;
            }
            if ((n & 0xFF) == 255) {
                LockSupport.parkNanos(TimeUnit.MICROSECONDS.toNanos(10L));
            } else {
                Thread.yield();
            }
            ++n;
        }
        List list = (List)this.threadList.get();
        if (list.size() < 50) {
            list.add(this.weakThreadLocals ? new WeakReference<ConcurrentBag$IConcurrentBagEntry>(concurrentBag$IConcurrentBagEntry) : concurrentBag$IConcurrentBagEntry);
        }
    }

    public void add(ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry) {
        if (this.closed) {
            LOGGER.info("ConcurrentBag has been closed, ignoring add()");
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.sharedList.add(concurrentBag$IConcurrentBagEntry);
        while (this.waiters.get() > 0 && concurrentBag$IConcurrentBagEntry.getState() == 0 && !this.handoffQueue.offer(concurrentBag$IConcurrentBagEntry)) {
            Thread.yield();
        }
    }

    public boolean remove(ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry) {
        if (!(concurrentBag$IConcurrentBagEntry.compareAndSet(1, -1) || concurrentBag$IConcurrentBagEntry.compareAndSet(-2, -1) || this.closed)) {
            LOGGER.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", (Object)concurrentBag$IConcurrentBagEntry);
            return false;
        }
        boolean bl = this.sharedList.remove(concurrentBag$IConcurrentBagEntry);
        if (!bl && !this.closed) {
            LOGGER.warn("Attempt to remove an object from the bag that does not exist: {}", (Object)concurrentBag$IConcurrentBagEntry);
        }
        ((List)this.threadList.get()).remove(concurrentBag$IConcurrentBagEntry);
        return bl;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public List values(int n) {
        List list = this.sharedList.stream().filter(concurrentBag$IConcurrentBagEntry -> concurrentBag$IConcurrentBagEntry.getState() == n).collect(Collectors.toList());
        Collections.reverse(list);
        return list;
    }

    public List values() {
        return (List)this.sharedList.clone();
    }

    public boolean reserve(ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry) {
        return concurrentBag$IConcurrentBagEntry.compareAndSet(0, -2);
    }

    public void unreserve(ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry) {
        if (concurrentBag$IConcurrentBagEntry.compareAndSet(-2, 0)) {
            while (this.waiters.get() > 0 && !this.handoffQueue.offer(concurrentBag$IConcurrentBagEntry)) {
                Thread.yield();
            }
        } else {
            LOGGER.warn("Attempt to relinquish an object to the bag that was not reserved: {}", (Object)concurrentBag$IConcurrentBagEntry);
        }
    }

    public int getWaitingThreadCount() {
        return this.waiters.get();
    }

    public int getCount(int n) {
        int n2 = 0;
        for (ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry : this.sharedList) {
            if (concurrentBag$IConcurrentBagEntry.getState() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int[] getStateCounts() {
        int[] nArray = new int[6];
        for (ConcurrentBag$IConcurrentBagEntry concurrentBag$IConcurrentBagEntry : this.sharedList) {
            int n = concurrentBag$IConcurrentBagEntry.getState();
            nArray[n] = nArray[n] + 1;
        }
        nArray[4] = this.sharedList.size();
        nArray[5] = this.waiters.get();
        return nArray;
    }

    public int size() {
        return this.sharedList.size();
    }

    public void dumpState() {
        this.sharedList.forEach(concurrentBag$IConcurrentBagEntry -> LOGGER.info(concurrentBag$IConcurrentBagEntry.toString()));
    }

    private boolean useWeakThreadLocals() {
        try {
            if (System.getProperty("me.angeschossen.chestprotect.hikari.useWeakReferences") != null) {
                return Boolean.getBoolean("me.angeschossen.chestprotect.hikari.useWeakReferences");
            }
            return this.getClass().getClassLoader() != ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            return true;
        }
    }
}

