/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.arenas;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.ArenaData;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.MessageData;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ArenaEditor {
    private static ArenaEditor instance;
    private HashMap<String, Clipboard> clipboards = new HashMap();
    private WorldEditPlugin worldEditPlugin;

    private ArenaEditor() {
    }

    public static ArenaEditor getInstance() {
        if (instance == null) {
            instance = new ArenaEditor();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    @Nullable
    public Vector getDimensions(String string) {
        if (!this.loadArena(string)) {
            return null;
        }
        BlockVector3 blockVector3 = this.clipboards.get(string).getDimensions();
        return new Vector(blockVector3.getX(), blockVector3.getY(), blockVector3.getZ());
    }

    public void saveArena(Player player, String string) {
        try {
            this.worldEditPlugin = (WorldEditPlugin)Bukkit.getServer().getPluginManager().getPlugin("WorldEdit");
            if (this.worldEditPlugin == null) {
                return;
            }
            File file = new File(Main.getInstance().getDataFolder().getPath(), "structure/" + string + ".STRUCTURE");
            Region region = this.worldEditPlugin.getSession(player).getSelection(this.worldEditPlugin.getSession(player).getSelectionWorld());
            BlockArrayClipboard blockArrayClipboard = new BlockArrayClipboard(region);
            EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(region.getWorld(), -1);
            Messages.sendMessage(player, MessageData.getMessage("arena.schematic.processing").replace("%VAR%", blockArrayClipboard.getDimensions().toString()));
            ForwardExtentCopy forwardExtentCopy = new ForwardExtentCopy((Extent)editSession, region, (Extent)blockArrayClipboard, region.getMinimumPoint());
            forwardExtentCopy.setCopyingEntities(true);
            Operations.complete((Operation)forwardExtentCopy);
            editSession.close();
            double d = player.getLocation().getX() - (double)region.getMinimumPoint().getX();
            double d2 = player.getLocation().getY() - (double)region.getMinimumPoint().getY();
            double d3 = player.getLocation().getZ() - (double)region.getMinimumPoint().getZ();
            ConfigData.getInstance().setArenaDelta(string, new Location(null, d, d2, d3, player.getLocation().getYaw(), player.getLocation().getPitch()));
            if (file.delete()) {
                Messages.sendMessage(player, "arena.schematic.removed");
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            try (ClipboardWriter clipboardWriter = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(file));){
                clipboardWriter.write((Clipboard)blockArrayClipboard);
                if (this.clipboards == null) {
                    this.clipboards = new HashMap();
                }
                this.clipboards.put(string, (Clipboard)blockArrayClipboard);
                Messages.sendMessage(player, "arena.schematic.saved");
            }
        }
        catch (WorldEditException | NullPointerException throwable) {
            Messages.sendMessage(player, "arena.schematic.selection");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    boolean pasteArena(ArenaData arenaData, String string) {
        if (!this.loadArena(string)) {
            return false;
        }
        BlockVector3 blockVector3 = BlockVector3.at((double)arenaData.getArenaLoc().getX(), (double)arenaData.getArenaLoc().getY(), (double)arenaData.getArenaLoc().getZ());
        try {
            EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession((World)new BukkitWorld(ArenaManager.getArenaWorld()), -1);
            Clipboard clipboard = this.clipboards.get(string);
            arenaData.setSchematicName(string);
            Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(blockVector3).ignoreAirBlocks(false).build();
            Operations.complete((Operation)operation);
            editSession.close();
            return true;
        }
        catch (WorldEditException | NullPointerException throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void pasteArenaAtLocation(Location location, String string) {
        if (!this.loadArena(string)) {
            return;
        }
        BlockVector3 blockVector3 = BukkitAdapter.asBlockVector((Location)location);
        try {
            EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession((World)new BukkitWorld(location.getWorld()), -1);
            Clipboard clipboard = this.clipboards.get(string);
            Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(blockVector3).ignoreAirBlocks(false).build();
            Operations.complete((Operation)operation);
            editSession.close();
        }
        catch (WorldEditException | NullPointerException throwable) {
            throwable.printStackTrace();
        }
    }

    void deleteArena(ArenaData arenaData) {
        if (!this.loadArena(arenaData.getSchematicName())) {
            return;
        }
        BlockVector3 blockVector3 = BlockVector3.at((double)arenaData.getArenaLoc().getX(), (double)arenaData.getArenaLoc().getY(), (double)arenaData.getArenaLoc().getZ());
        Clipboard clipboard = this.clipboards.get(arenaData.getSchematicName());
        try {
            EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession((World)new BukkitWorld(ArenaManager.getArenaWorld()), -1);
            CuboidRegion cuboidRegion = new CuboidRegion(blockVector3, blockVector3.add(clipboard.getDimensions()));
            for (Entity entity : ArenaManager.getArenaWorld().getEntities()) {
                if (entity.getType() == EntityType.PLAYER || !cuboidRegion.contains(BukkitAdapter.asBlockVector((Location)entity.getLocation()))) continue;
                entity.remove();
            }
            editSession.setBlocks((Region)cuboidRegion, (BlockStateHolder)BlockTypes.AIR.getDefaultState());
            editSession.close();
        }
        catch (WorldEditException | NullPointerException throwable) {
            throwable.printStackTrace();
        }
    }

    private boolean loadArena(String string) {
        File file = new File(Main.getInstance().getDataFolder().getPath(), "structure/" + string + ".STRUCTURE");
        this.worldEditPlugin = (WorldEditPlugin)Bukkit.getServer().getPluginManager().getPlugin("WorldEdit");
        if (this.worldEditPlugin == null) {
            Messages.sendConsoleWarning("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
            Messages.sendConsoleWarning("arena.schematic.no-worldedit");
            Messages.sendConsoleWarning("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
            return false;
        }
        if (!file.exists()) {
            Messages.sendConsoleWarning("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
            Messages.sendConsoleWarning("arena.schematic.no-file");
            Messages.sendConsoleWarning("File: " + string + ".STRUCTURE");
            Messages.sendConsoleWarning("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
            return false;
        }
        if (this.clipboards == null) {
            this.clipboards = new HashMap();
        }
        if (this.clipboards.get(string) == null) {
            ClipboardFormat clipboardFormat = ClipboardFormats.findByFile((File)file);
            if (clipboardFormat == null) {
                return false;
            }
            try (ClipboardReader clipboardReader = clipboardFormat.getReader((InputStream)new FileInputStream(file));){
                this.clipboards.put(string, clipboardReader.read());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

