/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.cmds;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.cmds.SubCommand;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.players.PlayerData;
import NL.martijnpu.ChunkDefence.players.PlayerDataManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

class ArenaInviteCancelCmd
extends SubCommand {
    ArenaInviteCancelCmd() {
    }

    @Override
    String getCommand() {
        return "arena";
    }

    @Override
    String getDescription() {
        return "Invoke the invite of a player to your arena";
    }

    @Override
    String[] getArgs() {
        return new String[]{"invite", "cancel"};
    }

    @Override
    boolean playerOnly() {
        return true;
    }

    @Override
    int getPlayerArguments() {
        return 1;
    }

    @Override
    String getUsage() {
        return super.getUsage() + " <player>";
    }

    @Override
    List<List<String>> getTabComplete() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        arrayList.add(Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toList()));
        return arrayList;
    }

    @Override
    void onCommand(Player player, String[] stringArray) {
        Player player2 = Bukkit.getPlayer((String)stringArray[0]);
        if (player2 == null) {
            Messages.sendMessage(player, "exception.offline");
            return;
        }
        if (player2 == player) {
            Messages.sendMessage(player, "exception.yourself");
            return;
        }
        PlayerData playerData = PlayerDataManager.getInstance().getUserData(player2.getUniqueId());
        Arena arena = ArenaManager.getInstance().getArena(player);
        if (arena == null) {
            Messages.sendMessage(player, "arena.invite.none-arena");
            return;
        }
        if (!ConfigData.getInstance().canInvitePlayers(arena.getArenaData().getGamemode())) {
            Messages.sendMessage(player, "arena.invite.gamemode");
            return;
        }
        if (playerData.removeInvite(arena)) {
            Messages.sendMessage(player, "arena.invite.not-invited");
        } else {
            Messages.sendMessage(player2, MessageData.getMessage("arena.invite.revoked").replace("%NAME%", player.getName()));
            Messages.sendMessage(player, "arena.invite.removed");
        }
    }
}

