/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.data;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.data.DefinedMobData;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class ConfigData {
    private static ConfigData instance;
    private final Map<String, Location> arena_deltas;
    private final Map<Integer, List<DefinedMobData>> waves;
    private final List<DefinedMobData> generatedMobs = new ArrayList<DefinedMobData>();
    private final String SHOP_RELATIVE_PLAYER_PATH = "is-shop-relative-to-player";
    private final String SHOP_COOLDOWN_PATH = "shop-cooldown";
    private final String PARTICLE_FREQUENCY_PATH = "particle_frequency";
    private final String VAULT_PATH = "vault";
    private final String ANTI_ARROW_PICKUP_PATH = "anti-arrow-pickup";
    private final String REMOVE_MILK_BUCKET_PATH = "remove-milk-bucket";
    private final String SCOREBOARD_UPDATE_PATH = "scoreboard-update";
    private final String SPAWN_BLOCK_PATH = "spawn-block";
    private final String GAMEMODE_PATH = "default-gamemode";
    private final String ARENA_BUY_COOLDOWN_PATH = "arena.cooldown";
    private final String ARENA_RESET_ON_LEAVE_PATH = "arena.reset-on-leave";
    private final String ARENA_SCHEMATIC_PATH = "arena.default-schematic";
    private final String ARENA_WORLD_PATH = "arena.world";
    private final String ARENA_BIOME_PATH = "arena.biome";
    private final String ARENA_SPACE_PATH = "arena.space-between";
    private final String ARENA_HEIGHT_PATH = "arena.height";
    private final String SERVER_TELEPORT_JOIN_PATH = "server.teleport-on-join";
    private final String SERVER_PROTECT_ALL_PATH = "server.protect-all-worlds";
    private final String GAMEMODES_PATH = "gamemodes";
    private final String GAMEMODES_DEFAULT_PATH = "gamemodes.default";
    private final String GM_NAME_PATH = "name";
    private final String GM_MATERIAL_PATH = "material";
    private final String GM_MAX_HEALTH_PATH = "max-health";
    private final String GM_ARENA_SAVE_BOUGHT_PATH = "arena.save-bought";
    private final String GM_ARENA_ALLOW_CHANGE_PATH = "arena.allow-change";
    private final String GM_ARENA_ALLOW_INVITE_PATH = "arena.allow-invite";
    private final String GM_DEATH_RESTART_WAVE_PATH = "player-death.restart-wave";
    private final String GM_DEATH_RESET_WAVES_PATH = "player-death.reset-waves";
    private final String GM_DEATH_RESET_INVENTORY_PATH = "player-death.reset-inventory";
    private final String GM_DEATH_RESET_ARENA_PATH = "player-death.reset-arena";
    private final String GM_DIFFICULTY_DEFAULT_PATH = "difficulty.default";
    private final String GM_DIFFICULTY_ON_WIN_PATH = "difficulty.on-win";
    private final String GM_DIFFICULTY_ON_LOSE_PATH = "difficulty.on-lose";
    private final String GM_DIFFICULTY_ADAPTIVE_PATH = "difficulty.adaptive";
    private final String GM_DIFFICULTY_MINIMUM_PATH = "difficulty.minimum";
    private final String GM_WAVE_TIME_BETWEEN_PATH = "wave.time-between";
    private final String GM_WAVE_COINS_SUCCEED_PATH = "wave.coins-succeed";
    private final String GM_WAVE_HEAL_ON_SUCCEED_PATH = "wave.heal-on-succeed";
    private final String SHOP_LOCATION_PATH = "shop-location";
    private final String SPAWN_LOCATION_PATH = "spawn-location";
    private final String DELTA_PATH = "delta-player-spawn";
    private final String WAVES_PATH = "defined-waves";
    private final String MOBS_PATH = "mobs";
    private Location spawn_location;
    private Location shop_location;

    private ConfigData() {
        this.waves = new HashMap<Integer, List<DefinedMobData>>();
        Main.getInstance().saveDefaultConfig();
        Main.getInstance().reloadConfig();
        boolean bl = FileHandler.setNotExists(Main.getInstance().getConfig(), "particle_frequency", 2);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "spawn-block", "OBSIDIAN");
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "arena.world", "arenaWorld");
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "arena.biome", "JUNGLE");
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "arena.default-schematic", "default");
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "arena.space-between", 500);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "arena.height", 60);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "arena.cooldown", 60);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "arena.reset-on-leave", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "vault", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "anti-arrow-pickup", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "remove-milk-bucket", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "shop-cooldown", 1);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "scoreboard-update", 30);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "default-gamemode", "SURVIVAL");
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "is-shop-relative-to-player", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "server.teleport-on-join", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "server.protect-all-worlds", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.name", "&6Default");
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.material", "GRASS_BLOCK");
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.wave.time-between", 60);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.wave.coins-succeed", 10);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.wave.heal-on-succeed", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.arena.save-bought", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.arena.allow-change", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.arena.allow-invite", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.player-death.restart-wave", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.player-death.reset-waves", false);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.player-death.reset-inventory", false);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.player-death.reset-arena", false);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.difficulty.default", 100);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.difficulty.on-win", 5);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.difficulty.on-lose", 9);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.difficulty.adaptive", true);
        bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.difficulty.minimum", 50);
        boolean bl2 = FileHandler.setNotExists(FileHandler.getInstance().getShopsConfig(), "shop-location", "null");
        bl2 |= FileHandler.setNotExists(FileHandler.getInstance().getShopsConfig(), "spawn-location", "world 0 90 0 0 0");
        boolean bl3 = FileHandler.setNotExists(FileHandler.getInstance().getMobsConfig(), "defined-waves", "[]");
        bl3 |= FileHandler.setNotExists(FileHandler.getInstance().getMobsConfig(), "mobs", "[]");
        if (bl |= FileHandler.setNotExists(Main.getInstance().getConfig(), "gamemodes.default.max-health", 20)) {
            Main.getInstance().saveConfig();
        }
        if (bl2) {
            FileHandler.getInstance().saveShopsConfig();
        }
        if (bl3) {
            FileHandler.getInstance().saveMobsConfig();
        }
        this.spawn_location = FileHandler.getLocationFromString(FileHandler.getInstance().getShopsConfig().getString("spawn-location", "world"));
        this.shop_location = FileHandler.getLocationFromString(FileHandler.getInstance().getShopsConfig().getString("shop-location", ""));
        this.arena_deltas = new HashMap<String, Location>();
        ConfigurationSection configurationSection = FileHandler.getInstance().getArenaConfig().getConfigurationSection("delta-player-spawn");
        if (configurationSection != null) {
            configurationSection.getKeys(false).forEach(string -> this.arena_deltas.put((String)string, FileHandler.getLocationFromString(configurationSection.getString(string, null))));
        }
        this.getAllMobs();
        this.getAllWaves();
    }

    public static ConfigData getInstance() {
        if (instance == null) {
            instance = new ConfigData();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public void printInitData() {
        if (this.generatedMobs.size() == 0) {
            Messages.sendConsoleWarning("Loading none mobs. This is an error or you have none mobs in the waves :(.");
        } else {
            Messages.sendConsole("Loading " + this.generatedMobs.size() + " mobs");
        }
        if (this.waves.size() == 0) {
            Messages.sendConsole("Loading none defined waves");
        } else {
            Messages.sendConsole("Loading " + this.waves.size() + " defined waves");
        }
    }

    private void getAllMobs() {
        this.generatedMobs.clear();
        ConfigurationSection configurationSection = FileHandler.getInstance().getMobsConfig().getConfigurationSection("mobs");
        if (configurationSection != null) {
            this.generatedMobs.addAll(this.getDefinedMobs(configurationSection));
        }
    }

    private void getAllWaves() {
        this.waves.clear();
        ConfigurationSection configurationSection = FileHandler.getInstance().getMobsConfig().getConfigurationSection("defined-waves");
        if (configurationSection == null) {
            return;
        }
        for (String string : configurationSection.getKeys(false)) {
            try {
                ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
                if (configurationSection2 == null) continue;
                this.waves.put(Integer.valueOf(string), this.getDefinedMobs(configurationSection2));
            }
            catch (NumberFormatException numberFormatException) {
                Messages.sendConsoleWarning(numberFormatException.toString());
            }
        }
    }

    private List<DefinedMobData> getDefinedMobs(@Nonnull ConfigurationSection configurationSection) {
        ArrayList<DefinedMobData> arrayList = new ArrayList<DefinedMobData>();
        for (String string : configurationSection.getKeys(false)) {
            try {
                arrayList.add(new DefinedMobData(configurationSection.getConfigurationSection(string)));
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                Messages.sendConsoleWarning("Unable to process a defined mob '" + configurationSection.getCurrentPath() + "." + string + "'. Skipping.");
            }
        }
        return arrayList;
    }

    public int getParticleFrequency() {
        return Main.getInstance().getConfig().getInt("particle_frequency", 2);
    }

    public GameMode getGamemode() {
        return GameMode.valueOf((String)Main.getInstance().getConfig().getString("default-gamemode".toUpperCase(), "SURVIVAL"));
    }

    public boolean getAntiArrowPickup() {
        return Main.getInstance().getConfig().getBoolean("anti-arrow-pickup", true);
    }

    public boolean getRemoveMilkBucket() {
        return Main.getInstance().getConfig().getBoolean("remove-milk-bucket", true);
    }

    public int getShopCooldown() {
        return Main.getInstance().getConfig().getInt("shop-cooldown", 1);
    }

    public int getScoreboardUpdate() {
        return Main.getInstance().getConfig().getInt("scoreboard-update", 30);
    }

    public Material getSpawnBlock() {
        return Material.getMaterial((String)Objects.requireNonNull(Main.getInstance().getConfig().getString("spawn-block", "OBSIDIAN")).toUpperCase());
    }

    public boolean isInvResetOnLeave() {
        return Main.getInstance().getConfig().getBoolean("arena.reset-on-leave", true);
    }

    public boolean using_vault() {
        return Main.getInstance().getConfig().getBoolean("vault", true);
    }

    public boolean isShopRelativePlayer() {
        return Main.getInstance().getConfig().getBoolean("is-shop-relative-to-player", true);
    }

    public boolean getTeleportOnJoin() {
        return Main.getInstance().getConfig().getBoolean("server.teleport-on-join", true);
    }

    public boolean getProtectAllWorlds() {
        return Main.getInstance().getConfig().getBoolean("server.protect-all-worlds", true);
    }

    public List<String> getGamemodes() {
        ConfigurationSection configurationSection = Main.getInstance().getConfig().getConfigurationSection("gamemodes");
        return configurationSection == null ? new ArrayList<String>() : new ArrayList(configurationSection.getKeys(false)).stream().sorted().collect(Collectors.toList());
    }

    public String getGamemodesName(String string) {
        return Main.getInstance().getConfig().getString("gamemodes." + string + "." + "name", Main.getInstance().getConfig().getString("gamemodes.default.name", "&Default"));
    }

    public Material getGamemodesMaterial(String string) {
        return Material.valueOf((String)Main.getInstance().getConfig().getString("gamemodes." + string + "." + "material", Main.getInstance().getConfig().getString("gamemodes.default.material", "GRASS_BLOCK")));
    }

    public int getWaveTimeBetween(String string) {
        return Main.getInstance().getConfig().getInt("gamemodes." + string + "." + "wave.time-between", Main.getInstance().getConfig().getInt("gamemodes.default.wave.time-between", 60));
    }

    public double getWaveCoinsSucceed(String string) {
        return Main.getInstance().getConfig().getDouble("gamemodes." + string + "." + "wave.coins-succeed", Main.getInstance().getConfig().getDouble("gamemodes.default.wave.coins-succeed", 10.0));
    }

    public boolean getWaveHealOnSucceed(String string) {
        return Main.getInstance().getConfig().getBoolean("gamemodes." + string + "." + "wave.heal-on-succeed", Main.getInstance().getConfig().getBoolean("gamemodes.default.wave.heal-on-succeed", true));
    }

    public boolean isPlayerDeathResetArena(String string) {
        return Main.getInstance().getConfig().getBoolean("gamemodes." + string + "." + "player-death.reset-arena", Main.getInstance().getConfig().getBoolean("gamemodes.default.player-death.reset-arena", false));
    }

    public boolean isPlayerDeathResetInventory(String string) {
        return Main.getInstance().getConfig().getBoolean("gamemodes." + string + "." + "player-death.reset-inventory", Main.getInstance().getConfig().getBoolean("gamemodes.default.player-death.reset-inventory", false));
    }

    public boolean isPlayerDeathResetWaves(String string) {
        return Main.getInstance().getConfig().getBoolean("gamemodes." + string + "." + "player-death.reset-waves", Main.getInstance().getConfig().getBoolean("gamemodes.default.player-death.reset-waves", false));
    }

    public boolean isPlayerDeathRestartWave(String string) {
        return Main.getInstance().getConfig().getBoolean("gamemodes." + string + "." + "player-death.restart-wave", Main.getInstance().getConfig().getBoolean("gamemodes.default.player-death.restart-wave", true));
    }

    public int getDefaultDifficulty(String string) {
        return Main.getInstance().getConfig().getInt("gamemodes." + string + "." + "difficulty.default", Main.getInstance().getConfig().getInt("gamemodes.default.difficulty.default", 100));
    }

    public int getWinDifficulty(String string) {
        return Main.getInstance().getConfig().getInt("gamemodes." + string + "." + "difficulty.on-win", Main.getInstance().getConfig().getInt("gamemodes.default.difficulty.on-win", 2));
    }

    public int getLoseDifficulty(String string) {
        return Main.getInstance().getConfig().getInt("gamemodes." + string + "." + "difficulty.on-lose", Main.getInstance().getConfig().getInt("gamemodes.default.difficulty.on-lose", 8));
    }

    public boolean isAdoptiveDifficulty(String string) {
        return Main.getInstance().getConfig().getBoolean("gamemodes." + string + "." + "difficulty.adaptive", Main.getInstance().getConfig().getBoolean("gamemodes.default.difficulty.adaptive", true));
    }

    public int getMinDifficulty(String string) {
        return Main.getInstance().getConfig().getInt("gamemodes." + string + "." + "difficulty.minimum", Main.getInstance().getConfig().getInt("gamemodes.default.difficulty.minimum", 50));
    }

    public boolean canChangeArena(String string) {
        return Main.getInstance().getConfig().getBoolean("gamemodes." + string + "." + "arena.allow-change", Main.getInstance().getConfig().getBoolean("gamemodes.default.arena.allow-change", true));
    }

    public boolean canInvitePlayers(String string) {
        return Main.getInstance().getConfig().getBoolean("gamemodes." + string + "." + "arena.allow-invite", Main.getInstance().getConfig().getBoolean("gamemodes.default.arena.allow-invite", true));
    }

    public int getMaxHealth(String string) {
        return Main.getInstance().getConfig().getInt("gamemodes." + string + "." + "max-health", Main.getInstance().getConfig().getInt("gamemodes.default.max-health", 20));
    }

    public boolean getArena_save_bought(String string) {
        return Main.getInstance().getConfig().getBoolean("gamemodes." + string + "." + "arena.save-bought", Main.getInstance().getConfig().getBoolean("gamemodes.default.arena.save-bought", true));
    }

    public Location getShop_location() {
        return this.shop_location == null ? null : this.shop_location.clone();
    }

    public void setShop_location(Location location) {
        this.shop_location = FileHandler.roundToHalf(location);
        FileHandler.getInstance().getShopsConfig().set("shop-location", (Object)FileHandler.getStringFromLocation(this.shop_location));
        FileHandler.getInstance().saveShopsConfig();
    }

    public Location getSpawn_location() {
        return this.spawn_location == null ? null : this.spawn_location.clone();
    }

    public void setSpawn_location(Location location) {
        this.spawn_location = FileHandler.roundToHalf(location);
        FileHandler.getInstance().getShopsConfig().set("spawn-location", (Object)FileHandler.getStringFromLocation(this.spawn_location));
        FileHandler.getInstance().saveShopsConfig();
    }

    public void setArenaDelta(String string, Location location) {
        Location location2 = FileHandler.roundToHalf(location.clone());
        location2.setWorld(null);
        this.arena_deltas.put(string, location2);
        FileHandler.getInstance().getArenaConfig().set("delta-player-spawn." + string, (Object)FileHandler.getStringFromLocationExcludeWorld(location2));
        FileHandler.getInstance().saveArenaConfig();
    }

    public String getArena_default_schematic() {
        return Main.getInstance().getConfig().getString("arena.default-schematic", "default");
    }

    public String getArena_world() {
        return Main.getInstance().getConfig().getString("arena.world", "arenaWorld");
    }

    public String getArena_biome() {
        return Main.getInstance().getConfig().getString("arena.biome", "JUNGLE");
    }

    public Location getArena_delta(String string) {
        return this.arena_deltas.get(string) == null ? null : this.arena_deltas.get(string).clone();
    }

    public int getArena_space() {
        return Main.getInstance().getConfig().getInt("arena.space-between", 500);
    }

    public int getArena_height() {
        return Main.getInstance().getConfig().getInt("arena.height", 60);
    }

    public int getArena_cooldown() {
        return Main.getInstance().getConfig().getInt("arena.cooldown", 60);
    }

    public boolean isWaveDefined(int n) {
        return this.waves.containsKey(n);
    }

    public Map<Integer, DefinedMobData> getWave(int n) {
        HashMap<Integer, DefinedMobData> hashMap = new HashMap<Integer, DefinedMobData>();
        if (!this.isWaveDefined(n)) {
            return hashMap;
        }
        this.waves.get(n).forEach(definedMobData -> hashMap.put(definedMobData.getAmount(), (DefinedMobData)definedMobData));
        return hashMap;
    }

    public List<DefinedMobData> getAllGeneratedMobs() {
        return this.generatedMobs;
    }
}

