/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.gui;

import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.gui.GuiSlot;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class GuiInventory {
    private final Inventory inventory;
    private Map<Integer, GuiSlot> itemSlots;
    private InventoryView inventoryView;

    public GuiInventory(@Nonnull Map<Integer, GuiSlot> map, @Nonnull InventoryType inventoryType, @Nonnull String string) {
        this.itemSlots = map;
        this.inventory = Bukkit.createInventory(null, (InventoryType)inventoryType, (String)MessageData.getMessage(string));
        this.changeItems(true, map);
    }

    public GuiInventory(@Nonnull Map<Integer, GuiSlot> map, int n, @Nonnull String string) {
        this.itemSlots = map;
        this.inventory = Bukkit.createInventory(null, (int)n, (String)MessageData.getMessage(string));
        this.changeItems(true, map);
    }

    protected void openInventory(Player player) {
        this.inventoryView = player.openInventory(this.inventory);
    }

    public void changeItem(int n, GuiSlot guiSlot) {
        this.itemSlots.put(n, guiSlot);
        this.inventory.setItem(n, guiSlot == null ? null : guiSlot.getItem());
    }

    public void changeItems(boolean bl, @Nonnull Map<Integer, GuiSlot> map) {
        if (bl) {
            this.itemSlots = map;
            this.inventory.clear();
        }
        for (Map.Entry<Integer, GuiSlot> entry : map.entrySet()) {
            this.changeItem(entry.getKey(), entry.getValue());
        }
    }

    public boolean canEdit(int n) {
        if (this.itemSlots.containsKey(n) && this.itemSlots.get(n) != null) {
            return this.itemSlots.get(n).canEdit();
        }
        return false;
    }

    @Nonnull
    public InventoryView getInventoryView() {
        return this.inventoryView;
    }

    public void onClick(int n, ClickType clickType) {
        if (this.itemSlots.containsKey(n)) {
            switch (clickType) {
                case LEFT: {
                    this.itemSlots.get(n).onLeftClick();
                    break;
                }
                case RIGHT: {
                    this.itemSlots.get(n).onRightClick();
                    break;
                }
                case SHIFT_LEFT: {
                    this.itemSlots.get(n).onLeftShiftClick();
                    break;
                }
                case SHIFT_RIGHT: {
                    this.itemSlots.get(n).onShiftRightClick();
                    break;
                }
                case MIDDLE: {
                    this.itemSlots.get(n).onMiddleClick();
                    break;
                }
            }
        }
    }

    public void inventoryTick() {
        this.itemSlots.forEach((n, guiSlot) -> {
            ItemStack itemStack;
            if (guiSlot != null && guiSlot.isAnimated() && (itemStack = this.inventoryView.getItem(n.intValue())) != null) {
                itemStack.setType(guiSlot.tickAnimation());
                this.inventory.setItem(n.intValue(), itemStack);
            }
        });
    }

    public GuiSlot getGuiSlot(int n) {
        return this.itemSlots.get(n);
    }

    void reload() {
        this.itemSlots.forEach((n, guiSlot) -> this.inventoryView.setItem(n.intValue(), guiSlot.getItem()));
    }
}

