/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.gui;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.gui.GuiInventory;
import NL.martijnpu.ChunkDefence.gui.GuiSign;
import NL.martijnpu.ChunkDefence.gui.GuiSlot;
import NL.martijnpu.ChunkDefence.gui.GuiType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;

public class GuiManager {
    private static GuiManager instance;
    private final Map<Player, GuiInventory> openInventories = new HashMap<Player, GuiInventory>();
    private final Map<Player, GuiSign> openSigns = new HashMap<Player, GuiSign>();
    private final List<Runnable> runnableQue = new ArrayList<Runnable>();

    private GuiManager() {
    }

    public static GuiManager getInstance() {
        if (instance == null) {
            instance = new GuiManager();
        }
        return instance;
    }

    public static void resetInstance() {
        if (instance != null) {
            instance.shutDown();
        }
        instance = null;
    }

    @Nullable
    public GuiInventory getGuiInventory(Player player) {
        return this.openInventories.get(player);
    }

    @Nullable
    public GuiSign getGuiSign(Player player) {
        return this.openSigns.get(player);
    }

    private void shutDown() {
        HashMap<Player, GuiInventory> hashMap = new HashMap<Player, GuiInventory>(this.openInventories);
        hashMap.forEach((player, guiInventory) -> guiInventory.getInventoryView().close());
    }

    public void closeInventory(Player player) {
        GuiInventory guiInventory = this.getGuiInventory(player);
        if (guiInventory == null) {
            return;
        }
        guiInventory.getInventoryView().close();
        this.openInventories.remove(player);
    }

    public void onCloseInventoryEvent(Player player) {
        this.openInventories.remove(player);
    }

    public void openInventory(Player player, GuiType guiType, @Nullable Map<Integer, GuiSlot> map) {
        GuiInventory guiInventory;
        try {
            guiInventory = new GuiInventory(guiType.getInventorySlots(player), InventoryType.valueOf((String)guiType.getInventoryType()), guiType.getInventoryName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                guiInventory = new GuiInventory(guiType.getInventorySlots(player), Integer.parseInt(guiType.getInventoryType()), guiType.getInventoryName());
            }
            catch (NumberFormatException numberFormatException) {
                Messages.sendConsole("Error, invalid inventoryType name: " + guiType.getInventoryType());
                return;
            }
        }
        if (map != null) {
            guiInventory.changeItems(false, map);
        }
        this.openInventories.put(player, guiInventory);
        guiInventory.openInventory(player);
    }

    public void openInventory(Player player, GuiInventory guiInventory) {
        this.openInventories.put(player, guiInventory);
        guiInventory.openInventory(player);
    }

    public void openSign(Player player, GuiSign guiSign) {
        guiSign.open(player);
        this.openSigns.put(player, guiSign);
    }

    public void inventoryTick() {
        this.openInventories.forEach((player, guiInventory) -> guiInventory.inventoryTick());
        this.runnableQue.removeIf(runnable -> {
            runnable.run();
            return true;
        });
    }

    public void addRunnableQue(Runnable runnable) {
        this.runnableQue.add(runnable);
    }

    public GuiSign returnAndCloseSign(Player player) {
        return this.openSigns.remove(player);
    }
}

