/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.gui;

import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.cmds.ArenaLeaveCmd;
import NL.martijnpu.ChunkDefence.cmds.ArenaStartGamemodeCmd;
import NL.martijnpu.ChunkDefence.cmds.ArenaWaveInfoCmd;
import NL.martijnpu.ChunkDefence.cmds.ShopTeleportCmd;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.gui.Books;
import NL.martijnpu.ChunkDefence.gui.GuiInventory;
import NL.martijnpu.ChunkDefence.gui.GuiManager;
import NL.martijnpu.ChunkDefence.gui.GuiMethods;
import NL.martijnpu.ChunkDefence.gui.GuiSlot;
import NL.martijnpu.ChunkDefence.shops.ShopArena;
import NL.martijnpu.ChunkDefence.shops.ShopItem;
import NL.martijnpu.ChunkDefence.shops.ShopManager;
import NL.martijnpu.ChunkDefence.shops.ShopTrap;
import NL.martijnpu.ChunkDefence.traps.TrapManager;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public enum GuiType {
    CONFIRM_ARENA_BUY,
    CONFIRM_ARENA_LEAVE,
    MAIN_MENU,
    TOP,
    SHOP_ADD,
    SHOP_EDIT_ARENA,
    SHOP_EDIT_TRAP,
    SHOP_EDIT_ITEM,
    GAMEMODES,
    TRAPS;


    public String getInventoryType() {
        switch (this) {
            case CONFIRM_ARENA_BUY: 
            case CONFIRM_ARENA_LEAVE: 
            case SHOP_ADD: {
                return "HOPPER";
            }
            case MAIN_MENU: 
            case GAMEMODES: {
                return "18";
            }
            case SHOP_EDIT_ARENA: 
            case SHOP_EDIT_TRAP: 
            case SHOP_EDIT_ITEM: 
            case TRAPS: {
                return "36";
            }
            case TOP: {
                return "54";
            }
        }
        return "DROPPER";
    }

    public String getInventoryName() {
        switch (this) {
            case CONFIRM_ARENA_BUY: {
                return "gui.buy-arena.name";
            }
            case CONFIRM_ARENA_LEAVE: {
                return "gui.leave-arena.name";
            }
            case MAIN_MENU: {
                return "gui.main-menu.name";
            }
            case TOP: {
                return "gui.scoreboard.name";
            }
            case SHOP_ADD: {
                return "gui.shop-add.name";
            }
            case SHOP_EDIT_ARENA: 
            case SHOP_EDIT_TRAP: 
            case SHOP_EDIT_ITEM: {
                return "gui.shop-add.edit";
            }
            case GAMEMODES: {
                return "gui.gamemodes.name";
            }
            case TRAPS: {
                return "Traps";
            }
        }
        return "Error";
    }

    public Map<Integer, GuiSlot> getInventorySlots(Player player) {
        HashMap<Integer, GuiSlot> hashMap = new HashMap<Integer, GuiSlot>();
        switch (this) {
            case CONFIRM_ARENA_BUY: {
                hashMap.put(0, new GuiSlot(Material.GRAY_STAINED_GLASS_PANE, "gui.buy-arena.question"));
                hashMap.put(2, new GuiSlot(Material.GRAY_STAINED_GLASS_PANE, "gui.buy-arena.question"));
                hashMap.put(4, new GuiSlot(Material.GRAY_STAINED_GLASS_PANE, "gui.buy-arena.question"));
                hashMap.put(3, new GuiSlot(Material.RED_CONCRETE_POWDER, "gui.buy-arena.question").setLore(Collections.singletonList("gui.buy-arena.cancel")).setLeftClick(() -> GuiManager.getInstance().closeInventory(player)));
                break;
            }
            case CONFIRM_ARENA_LEAVE: {
                hashMap.put(0, new GuiSlot(Material.GRAY_STAINED_GLASS_PANE, "gui.leave-arena.question"));
                hashMap.put(2, new GuiSlot(Material.GRAY_STAINED_GLASS_PANE, "gui.leave-arena.question"));
                hashMap.put(3, new GuiSlot(Material.RED_CONCRETE_POWDER, "gui.leave-arena.question").setLore(Collections.singletonList("gui.leave-arena.cancel")).setLeftClick(() -> GuiManager.getInstance().closeInventory(player)));
                hashMap.put(4, new GuiSlot(Material.GRAY_STAINED_GLASS_PANE, "gui.leave-arena.question"));
                break;
            }
            case MAIN_MENU: {
                Arena arena = ArenaManager.getInstance().getArena(player);
                hashMap.put(0, new GuiSlot(Material.PAINTING, "gui.main-menu.name"));
                hashMap.put(17, new GuiSlot(Material.BARRIER, "gui.main-menu.exit").setLeftClick(() -> GuiManager.getInstance().closeInventory(player)));
                hashMap.put(2, new GuiSlot(Material.SMOOTH_QUARTZ_STAIRS, "gui.main-menu.top").setLeftClick(() -> GuiMethods.openGuiTopBackMenu(player)));
                hashMap.put(9, new GuiSlot(Material.REDSTONE_TORCH, "gui.main-menu.help").setLeftClick(() -> {
                    GuiManager.getInstance().closeInventory(player);
                    Books.openBook(player, "welcome");
                }));
                if (arena == null) {
                    hashMap.put(4, new GuiSlot(Material.CRAFTING_TABLE, "gui.main-menu.create-arena").setLeftClick(() -> {
                        GuiManager.getInstance().closeInventory(player);
                        GuiManager.getInstance().openInventory(player, GAMEMODES, null);
                    }));
                    break;
                }
                hashMap.put(0, new GuiSlot(Material.PAINTING, "gui.main-menu.name").setLore((List<String>)ImmutableList.of((Object)MessageData.getMessage("wave.current").replace("%AMOUNT%", arena.getArenaData().getWave() + ""), (Object)MessageData.getMessage("wave.members").replace("%MEMBERS%", arena.getArenaMembers()))));
                hashMap.put(4, new GuiSlot(Material.OAK_SAPLING, "gui.main-menu.teleport-arena").setLeftClick(() -> arena.teleportHome(player, true)));
                hashMap.put(6, new GuiSlot(Material.FEATHER, "gui.main-menu.start-wave").setLeftClick(() -> arena.getWaveController().start()));
                hashMap.put(16, new GuiSlot(Material.DARK_OAK_DOOR, "gui.main-menu.leave").setLeftClick(() -> {
                    GuiManager.getInstance().closeInventory(player);
                    ArenaLeaveCmd.arenaLeaveCmd(player);
                }));
                hashMap.put(12, new GuiSlot(Material.SPECTRAL_ARROW, "gui.main-menu.teleport-shop").setLeftClick(() -> ShopTeleportCmd.teleport(player)));
                hashMap.put(14, new GuiSlot(Material.BOOK, "gui.main-menu.wave-info").setLeftClick(() -> {
                    GuiManager.getInstance().closeInventory(player);
                    ArenaWaveInfoCmd.onCommand(player);
                }));
                break;
            }
            case TOP: {
                List<Material> list = Arrays.asList(Material.EMERALD, Material.DIAMOND, Material.EMERALD, Material.DIAMOND, Material.GOLD_INGOT, Material.GOLD_INGOT, Material.GOLD_INGOT, Material.GOLD_INGOT, Material.GOLD_INGOT, Material.GOLD_INGOT, Material.GOLD_NUGGET, Material.GOLD_NUGGET, Material.GOLD_NUGGET, Material.IRON_INGOT, Material.QUARTZ, Material.NETHER_STAR, Material.HONEYCOMB, Material.POTATO);
                AtomicInteger atomicInteger = new AtomicInteger();
                Random random = new Random();
                for (int i = 0; i <= 35; ++i) {
                    if (i == 13 || i == 21 || i == 23 || i == 29 || i == 31 || i == 33 || random.nextInt(4) != 0) continue;
                    hashMap.put(i, new GuiSlot().setAnimated((double)random.nextInt(1) + random.nextDouble(), 0.0).addAnimation(list.get(random.nextInt(list.size())), random.nextInt(3) + 1).addAnimation(list.get(random.nextInt(list.size())), random.nextInt(3) + 1).addAnimation(list.get(random.nextInt(list.size())), random.nextInt(3) + 1));
                }
                hashMap.putAll(GuiMethods.getLine(36, 44));
                hashMap.put(46, new GuiSlot(Material.IRON_SWORD, "gui.scoreboard.kills-name").setLeftClick(() -> {
                    GuiMethods.changeTop(player, "KILLS");
                    GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
                    if (guiInventory != null) {
                        guiInventory.changeItem(40, new GuiSlot(Material.IRON_SWORD, "gui.scoreboard.kills-name"));
                    }
                }));
                hashMap.put(53, new GuiSlot(Material.BARRIER, "gui.main-menu.exit").setLeftClick(() -> GuiManager.getInstance().closeInventory(player)));
                hashMap.put(40, new GuiSlot(Material.IRON_SWORD, "gui.scoreboard.kills-name"));
                hashMap.put(49, new GuiSlot(Material.LECTERN).setLore(ConfigData.getInstance().getGamemodes()).setLeftClick(() -> GuiMethods.editTopIndex(player, atomicInteger, true)).setRightClick(() -> GuiMethods.editTopIndex(player, atomicInteger, false)));
                hashMap.put(4, GuiMethods.getTopItem(1, "KILLS"));
                hashMap.put(12, GuiMethods.getTopItem(2, "KILLS"));
                hashMap.put(14, GuiMethods.getTopItem(3, "KILLS"));
                hashMap.put(20, GuiMethods.getTopItem(4, "KILLS"));
                hashMap.put(22, GuiMethods.getTopItem(5, "KILLS"));
                hashMap.put(24, GuiMethods.getTopItem(6, "KILLS"));
                hashMap.put(28, GuiMethods.getTopItem(7, "KILLS"));
                hashMap.put(30, GuiMethods.getTopItem(8, "KILLS"));
                hashMap.put(32, GuiMethods.getTopItem(9, "KILLS"));
                hashMap.put(34, GuiMethods.getTopItem(10, "KILLS"));
                break;
            }
            case SHOP_ADD: {
                hashMap.put(0, new GuiSlot(Material.IRON_AXE, "&aItem shop").setLeftClick(() -> GuiMethods.openGuiItemShop(player)));
                hashMap.put(2, new GuiSlot(Material.BLAZE_POWDER, "&9Trap shop").setLeftClick(() -> GuiMethods.openGuiTrapShop(player)));
                hashMap.put(4, new GuiSlot(Material.GRASS_BLOCK, "&dArena shop").setLeftClick(() -> GuiMethods.openGuiArenaShop(player)));
                break;
            }
            case SHOP_EDIT_ARENA: {
                ShopArena shopArena = (ShopArena)ShopManager.getInstance().getShop(ShopManager.getInstance().lookingAt(player));
                boolean bl = shopArena == null;
                AtomicInteger atomicInteger = new AtomicInteger();
                hashMap.put(1, new GuiSlot(Material.IRON_AXE, "&6Selling arena").setLore(Collections.singletonList("Click the item below with to cycle trough the available arenas.")));
                hashMap.put(10, new GuiSlot(GuiMethods.getSchematicIndex(atomicInteger, bl ? ConfigData.getInstance().getArena_default_schematic() : shopArena.getSchematic())).setLeftClick(() -> GuiMethods.editSchematicIndex(player, atomicInteger, true)).setRightClick(() -> GuiMethods.editSchematicIndex(player, atomicInteger, false)));
                hashMap.put(3, new GuiSlot(Material.NAME_TAG, "&6Display name: &f" + (bl ? " " : shopArena.getName())).setLore(Collections.singletonList("Click below to edit the display name.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Display name", 12, bl ? " " : shopArena.getName(), "")));
                hashMap.put(12, new GuiSlot(Material.PAPER, bl ? " " : shopArena.getName()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit the display name.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Display name", 12, bl ? " " : shopArena.getName(), "")));
                hashMap.put(5, new GuiSlot(Material.SUNFLOWER, "&6Price: &f" + (bl ? "1.0" : shopArena.getCost() + "")).setLore(Collections.singletonList("Click below to edit the price of this shop.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Price", 14, bl ? "1.0" : shopArena.getCost() + "", "double")));
                hashMap.put(14, new GuiSlot(Material.PAPER, bl ? "1.0" : shopArena.getCost() + "").setLore(Arrays.asList("Price will be changed to:", " ", "Click to edit the price.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Price", 14, bl ? "1.0" : shopArena.getCost() + "", "double")));
                hashMap.put(7, new GuiSlot(Material.ARMOR_STAND, "&6Display item").setLore(Collections.singletonList("Replace the item below with the item you want to be displayed.")));
                hashMap.put(16, new GuiSlot(bl ? new ItemStack(Material.GLASS_PANE) : shopArena.getDisplayItem(null)).setLeftClick(() -> GuiMethods.swapItemsNull(player, 16, Material.GLASS_PANE)));
                hashMap.putAll(GuiMethods.getLine(18, 26));
                hashMap.put(27, new GuiSlot(Material.GREEN_CONCRETE, "&aSave changes").setLeftClick(() -> GuiMethods.saveShop(shopArena, player)));
                hashMap.put(31, new GuiSlot(Material.BARRIER, "&cRemove shop").setLeftClick(() -> GuiMethods.openGuiRemoveTrap(player, this, null)));
                hashMap.put(35, new GuiSlot(Material.RED_CONCRETE, "&cCancel").setLeftClick(() -> GuiMethods.closeGui(player)));
                break;
            }
            case SHOP_EDIT_TRAP: {
                ShopTrap shopTrap = (ShopTrap)ShopManager.getInstance().getShop(ShopManager.getInstance().lookingAt(player));
                boolean bl = shopTrap == null;
                AtomicInteger atomicInteger = new AtomicInteger();
                hashMap.put(1, new GuiSlot(Material.IRON_AXE, "&6Selling trap").setLore(Collections.singletonList("Scroll trough the list using your left and right mouse button.")));
                hashMap.put(10, new GuiSlot(TrapManager.getInstance().getTrapSelector(bl ? TrapManager.getInstance().getAllTrapBases().get(atomicInteger.get()).generateTrapItem(1) : GuiMethods.getTrapIndex(atomicInteger, shopTrap.getTrapBase()))).setLeftClick(() -> GuiMethods.editTrapIndex(player, atomicInteger, true)).setRightClick(() -> GuiMethods.editTrapIndex(player, atomicInteger, false)));
                hashMap.put(5, new GuiSlot(Material.SUNFLOWER, "&6Price: &f" + (bl ? "1.0" : shopTrap.getCost() + "")).setLore(Collections.singletonList("Click to edit the price of this shop.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Price", 14, bl ? "1.0" : shopTrap.getCost() + "", "double")));
                hashMap.put(14, new GuiSlot(Material.PAPER, bl ? "1.0" : shopTrap.getCost() + "").setLore(Arrays.asList("Price will be changed to:", " ", "Click to edit the price.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Price", 14, bl ? "1.0" : shopTrap.getCost() + "", "double")));
                hashMap.putAll(GuiMethods.getLine(18, 26));
                hashMap.put(27, new GuiSlot(Material.GREEN_CONCRETE, "&aSave changes").setLeftClick(() -> GuiMethods.saveShop(shopTrap, player)));
                hashMap.put(31, new GuiSlot(Material.BARRIER, "&cRemove shop").setLeftClick(() -> GuiMethods.openGuiRemoveTrap(player, this, null)));
                hashMap.put(35, new GuiSlot(Material.RED_CONCRETE, "&cCancel").setLeftClick(() -> GuiMethods.closeGui(player)));
                break;
            }
            case SHOP_EDIT_ITEM: {
                ShopItem shopItem = (ShopItem)ShopManager.getInstance().getShop(ShopManager.getInstance().lookingAt(player));
                boolean bl = shopItem == null;
                hashMap.put(1, new GuiSlot(Material.IRON_AXE, "&6Selling item").setLore(Collections.singletonList("Replace the item below with the item you want to sell.")));
                hashMap.put(10, new GuiSlot(bl ? new ItemStack(Material.GLASS_PANE) : shopItem.getItem()).setLeftClick(() -> GuiMethods.swapItemsNull(player, 10, Material.GLASS_PANE)));
                hashMap.put(3, new GuiSlot(Material.NAME_TAG, "&6Display name: &f" + (bl ? " " : shopItem.getName())).setLore(Collections.singletonList("Click to edit the display name.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Display name", 12, bl ? " " : shopItem.getName(), "")));
                hashMap.put(12, new GuiSlot(Material.PAPER, bl ? " " : shopItem.getName()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit the display name.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Display name", 12, bl ? " " : shopItem.getName(), "")));
                hashMap.put(5, new GuiSlot(Material.SUNFLOWER, "&6Price: &f" + (bl ? "1.0" : shopItem.getCost() + "")).setLore(Collections.singletonList("Click to edit the price of this shop.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Price", 14, bl ? "1.0" : shopItem.getCost() + "", "")));
                hashMap.put(14, new GuiSlot(Material.PAPER, bl ? "1.0" : shopItem.getCost() + "").setLore(Arrays.asList("Price will be changed to:", " ", "Click to edit the price.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Price", 14, bl ? "1.0" : shopItem.getCost() + "", "")));
                hashMap.put(7, new GuiSlot(Material.ARMOR_STAND, "&6Display item").setLore(Collections.singletonList("Replace the item below with the item you want to be displayed.")));
                hashMap.put(16, new GuiSlot(bl ? new ItemStack(Material.GLASS_PANE) : shopItem.getDisplayItem(null)).setLeftClick(() -> GuiMethods.swapItemsNull(player, 16, Material.GLASS_PANE)));
                hashMap.putAll(GuiMethods.getLine(18, 26));
                hashMap.put(27, new GuiSlot(Material.GREEN_CONCRETE, "&aSave changes").setLeftClick(() -> GuiMethods.saveShop(shopItem, player)));
                hashMap.put(31, new GuiSlot(Material.BARRIER, "&cRemove shop").setLeftClick(() -> GuiMethods.openGuiRemoveTrap(player, this, null)));
                hashMap.put(35, new GuiSlot(Material.RED_CONCRETE, "&cCancel").setLeftClick(() -> GuiMethods.closeGui(player)));
                break;
            }
            case GAMEMODES: {
                int n = 0;
                for (String string : ConfigData.getInstance().getGamemodes()) {
                    List<String> list = MessageData.getMessageList("gui.gamemodes.gamemode-lore");
                    for (int i = 0; i < list.size(); ++i) {
                        list.set(i, list.get(i).replace("%MAX_PLAYERS%", ConfigData.getInstance().canChangeArena(string) ? "Everyone" : "1").replace("%MAX_HEALTH%", (double)ConfigData.getInstance().getMaxHealth(string) * 0.5 + " hearts").replace("%NAME%", ConfigData.getInstance().getGamemodesName(string)).replace("%TIME_INBETWEEN%", ConfigData.getInstance().getWaveTimeBetween(string) + "").replace("%RESTART_ARENA_ON_DEATH%", ConfigData.getInstance().isPlayerDeathResetArena(string) + "").replace("%RESTART_WAVE_ON_DEATH%", ConfigData.getInstance().isPlayerDeathResetWaves(string) + "").replace("%DIFFICULTY%", ConfigData.getInstance().getDefaultDifficulty(string) + "").replace("%ADAPTIVE_DIFFICULTY%", ConfigData.getInstance().isAdoptiveDifficulty(string) + ""));
                    }
                    hashMap.put(n, new GuiSlot(ConfigData.getInstance().getGamemodesMaterial(string), ConfigData.getInstance().getGamemodesName(string)).setLore(list).setLeftClick(() -> {
                        ArenaStartGamemodeCmd.arenaStartGamemodeCmd(player, string);
                        GuiMethods.closeGui(player);
                    }));
                    ++n;
                }
                break;
            }
            case TRAPS: {
                hashMap.putAll(GuiMethods.getTrapPage(player, new AtomicInteger()));
                for (int i = 18; i <= 26; ++i) {
                    hashMap.put(i, new GuiSlot(Material.BLACK_STAINED_GLASS_PANE, " ").setLore(Collections.singletonList("Left click to get trap; Right click to edit.")).setAnimated(9.0, i).addAnimation(Material.BLACK_STAINED_GLASS_PANE, 20).addAnimation(Material.WHITE_STAINED_GLASS_PANE).addAnimation(Material.LIGHT_GRAY_STAINED_GLASS_PANE, 2).addAnimation(Material.GRAY_STAINED_GLASS_PANE, 3));
                }
                hashMap.put(31, new GuiSlot(Material.STRUCTURE_VOID, "&2Add new trap.").setLeftClick(() -> GuiMethods.openGuiTrapInfo(player, TrapManager.getInstance().createNewTrapBase())));
                hashMap.put(35, new GuiSlot(Material.RED_CONCRETE, "gui.main-menu.exit").setLeftClick(() -> GuiMethods.closeGui(player)));
                break;
            }
            default: {
                hashMap.put(0, new GuiSlot(Material.BARRIER, "&4Error while creating inventory " + this.name()));
                hashMap.put(2, new GuiSlot(Material.BARRIER, "&4Error while creating inventory " + this.name()));
                hashMap.put(4, new GuiSlot(Material.BARRIER, "&4Error while creating inventory " + this.name()));
                hashMap.put(6, new GuiSlot(Material.BARRIER, "&4Error while creating inventory " + this.name()));
                hashMap.put(8, new GuiSlot(Material.BARRIER, "&4Error while creating inventory " + this.name()));
            }
        }
        return hashMap;
    }
}

