/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.players;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.players.PlayerDataManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Economy {
    private static net.milkbowl.vault.economy.Economy economy;

    public static void setupEconomy() {
        if (!ConfigData.getInstance().using_vault()) {
            Messages.sendConsole("Vault economy disabled. Using own economy.");
            economy = null;
        }
        if (Main.getInstance().getServer().getPluginManager().getPlugin("Vault") == null) {
            Messages.sendConsole("No Vault dependency found. Using own economy!");
            return;
        }
        RegisteredServiceProvider registeredServiceProvider = Main.getInstance().getServer().getServicesManager().getRegistration(net.milkbowl.vault.economy.Economy.class);
        if (registeredServiceProvider == null) {
            Messages.sendConsole("No valid vault dependency found. Using own economy!");
            return;
        }
        economy = (net.milkbowl.vault.economy.Economy)registeredServiceProvider.getProvider();
        Messages.sendConsole("Successfully hooked into Vault");
    }

    public static boolean usingVault() {
        return economy != null && ConfigData.getInstance().using_vault();
    }

    public static void depositPlayer(Player player, double d) {
        if (d == 0.0) {
            return;
        }
        if (Economy.usingVault()) {
            economy.depositPlayer((OfflinePlayer)player, d);
        } else {
            PlayerDataManager.getInstance().getUserData(player.getUniqueId()).addBalance(d);
        }
    }

    public static void withdrawPlayer(Player player, double d) {
        if (d == 0.0) {
            return;
        }
        if (Economy.usingVault()) {
            economy.withdrawPlayer((OfflinePlayer)player, d);
        } else {
            PlayerDataManager.getInstance().getUserData(player.getUniqueId()).removeBalance(d);
        }
    }

    public static void setBalance(Player player, double d) {
        if (Economy.getBalance(player) == d) {
            return;
        }
        if (Economy.getBalance(player) > d) {
            Economy.withdrawPlayer(player, Economy.getBalance(player) - d);
        } else {
            Economy.depositPlayer(player, d - Economy.getBalance(player));
        }
    }

    public static double getBalance(Player player) {
        if (Economy.usingVault()) {
            return economy.getBalance((OfflinePlayer)player);
        }
        return PlayerDataManager.getInstance().getUserData(player.getUniqueId()).getBalance();
    }

    public static boolean exportToVault() {
        if (!Economy.usingVault()) {
            return false;
        }
        PlayerDataManager.getInstance().getAllUsers().forEach(uUID -> economy.depositPlayer(Bukkit.getOfflinePlayer((UUID)uUID), PlayerDataManager.getInstance().getUserData((UUID)uUID).getBalance()));
        return true;
    }

    public static boolean importFromVault() {
        if (!Economy.usingVault()) {
            return false;
        }
        PlayerDataManager.getInstance().getAllUsers().forEach(uUID -> PlayerDataManager.getInstance().getUserData((UUID)uUID).addBalance(economy.getBalance(Bukkit.getOfflinePlayer((UUID)uUID))));
        return true;
    }
}

