/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.shops;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.gui.GuiManager;
import NL.martijnpu.ChunkDefence.gui.GuiType;
import NL.martijnpu.ChunkDefence.shops.Shop;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ShopItem
extends Shop {
    private ItemStack item;
    private String name;

    public ShopItem(String string) {
        super(string);
        this.item = FileHandler.getInstance().getShopsConfig().getItemStack(string + ".item", new ItemStack(Material.STONE));
        if (this.item == null) {
            Messages.sendConsoleWarning("Unable to load shop " + string + ". Invalid Item");
            throw new IllegalArgumentException();
        }
        this.name = this.item.hasItemMeta() && this.item.getItemMeta().hasDisplayName() ? this.item.getItemMeta().getDisplayName() : "&6" + this.item.getType().name().replace("_", " ").toLowerCase();
        this.name = FileHandler.getInstance().getShopsConfig().getString(string + ".display.name", this.name);
        this.loadFloatingText();
        this.setItem(this.item);
        this.setDisplay(this.name);
        this.shopLocation.getRelative(BlockFace.UP).setType(Material.BARRIER);
    }

    public ShopItem(Block block, ItemStack itemStack, double d) {
        super(block, d, itemStack.getType().name());
        this.item = itemStack;
        this.name = itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : "&6" + itemStack.getType().name().replace("_", " ").toLowerCase();
        this.loadFloatingText();
        this.setItem(itemStack);
        this.setDisplay(this.name);
        this.save();
        this.shopLocation.getRelative(BlockFace.UP).setType(Material.BARRIER);
    }

    @Override
    public void buyItem(Player player) {
        if (!this.canBuy(player)) {
            return;
        }
        if (!this.handleMoney(player)) {
            return;
        }
        player.getInventory().addItem(new ItemStack[]{this.item.clone()});
    }

    @Override
    public boolean hasPermission(Player player) {
        return this.hasPermission(player, "item", this.item.getType().toString().toLowerCase());
    }

    @Override
    public void save() {
        FileHandler.getInstance().getShopsConfig().set(this.path + ".item", (Object)this.item);
        super.save();
    }

    @Override
    protected void loadFloatingText() {
        super.loadFloatingText();
        this.textList.forEach(floatingText -> {
            floatingText.text = floatingText.text.replace("%NAME%", this.name + "").replace("%AMOUNT%", this.item.getAmount() + "");
        });
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void changeItem(ItemStack itemStack) {
        this.item = itemStack;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!string.isEmpty()) {
            FileHandler.getInstance().getShopsConfig().set(this.path + ".display.name", (Object)string);
        }
    }

    @Override
    public void editShop(Player player) {
        GuiManager.getInstance().openInventory(player, GuiType.SHOP_EDIT_ITEM, null);
    }
}

