/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.shops;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.shops.DisplayText;
import NL.martijnpu.ChunkDefence.shops.Shop;
import NL.martijnpu.ChunkDefence.shops.ShopArena;
import NL.martijnpu.ChunkDefence.shops.ShopItem;
import NL.martijnpu.ChunkDefence.shops.ShopTrap;
import NL.martijnpu.ChunkDefence.traps.TrapBase;
import NL.martijnpu.ChunkDefence.traps.TrapManager;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class ShopManager {
    private static final String SHOPS_PATH = "shop";
    private static ShopManager instance;
    private static WrappedDataWatcher watcher;
    private static int randomEntityID;
    private final List<DisplayText> playerLooking = new ArrayList<DisplayText>();
    private final List<Shop> shops = new ArrayList<Shop>();

    private ShopManager() {
        this.setupMetaData();
        this.load();
    }

    public static ShopManager getInstance() {
        if (instance == null) {
            instance = new ShopManager();
        }
        return instance;
    }

    public static boolean instanceExists() {
        return instance != null;
    }

    public static void resetInstance() {
        if (instance != null) {
            instance.removePlayerLooks();
            instance.removeOldShopEntities();
        }
        randomEntityID = 0;
        instance = null;
    }

    public static WrappedDataWatcher getWatcher(String string) {
        WrappedDataWatcher wrappedDataWatcher = watcher.deepClone();
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true)), Optional.ofNullable(WrappedChatComponent.fromChatMessage((String)Messages.format(string))[0].getHandle()));
        return wrappedDataWatcher;
    }

    static int getRandomEntityID() {
        if (randomEntityID <= 0) {
            randomEntityID = new Random().nextInt(0x7FFFFFFE) + 1;
        }
        return randomEntityID;
    }

    public void printInitData() {
        if (this.shops.size() == 0) {
            Messages.sendConsoleWarning("Loading none shops. This could be an error or you don't have any shops");
        } else {
            Messages.sendConsole("Loading " + this.shops.size() + " shops");
        }
    }

    private void removePlayerLooks() {
        for (DisplayText displayText : this.playerLooking) {
            try {
                displayText.remove();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Messages.sendConsole("Couldn't unload interactions with shops. This could be harmless, report otherwise");
            }
        }
    }

    public void playerLook(Player player) {
        Shop shop;
        if (!Main.isProtocolLibAvailable()) {
            return;
        }
        Block block = this.lookingAt(player);
        DisplayText displayText = this.getPlayer(player);
        if (displayText != null) {
            if ((displayText.getShop().getShopLocation().equals(block) || displayText.getShop().getShopLocation().getRelative(BlockFace.UP).equals(block)) && player.getGameMode() != GameMode.SPECTATOR) {
                displayText.update();
                return;
            }
            displayText.remove();
            this.playerLooking.remove(displayText);
        }
        if ((shop = this.getShop(block)) != null && player.getGameMode() != GameMode.SPECTATOR) {
            this.playerLooking.add(new DisplayText(player, shop));
        }
    }

    public Shop addShop(Player player, TrapBase trapBase, double d) {
        Block block = this.lookingAt(player);
        if (block == null) {
            Messages.sendMessage(player, "shop.look");
            return null;
        }
        if (this.getShop(block) != null) {
            Messages.sendMessage(player, "shop.already-set");
            return null;
        }
        ShopTrap shopTrap = null;
        try {
            shopTrap = new ShopTrap(block, trapBase, d);
            this.shops.add(shopTrap);
            Messages.sendMessage(player, "shop.added");
        }
        catch (IllegalAccessException illegalAccessException) {
            Messages.sendMessage(player, illegalAccessException.getMessage());
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
        }
        return shopTrap;
    }

    @Nullable
    public Shop addShop(Player player, ItemStack itemStack, double d) {
        Block block = this.lookingAt(player);
        if (block == null) {
            Messages.sendMessage(player, "shop.look");
            return null;
        }
        if (this.getShop(block) != null) {
            Messages.sendMessage(player, "shop.already-set");
            return null;
        }
        ShopItem shopItem = new ShopItem(block, itemStack, d);
        this.shops.add(shopItem);
        Messages.sendMessage(player, "shop.added");
        return shopItem;
    }

    @Nullable
    public ShopArena addShop(Player player, String string, double d) {
        Block block = this.lookingAt(player);
        if (block == null) {
            Messages.sendMessage(player, "shop.look");
            return null;
        }
        if (this.getShop(block) != null) {
            Messages.sendMessage(player, "shop.already-set");
            return null;
        }
        ShopArena shopArena = new ShopArena(block, string, d);
        this.shops.add(shopArena);
        Messages.sendMessage(player, "shop.added");
        return shopArena;
    }

    public boolean removeShop(Player player) {
        Shop shop = this.getShop(this.lookingAt(player));
        if (shop == null) {
            return false;
        }
        shop.remove();
        this.removePlayerLooks();
        this.shops.remove(shop);
        return true;
    }

    public boolean moveShop(Player player, String string) {
        Block block = this.lookingAt(player);
        Shop shop = this.getShop(block);
        if (shop != null) {
            return false;
        }
        for (Shop shop2 : this.shops) {
            if (!shop2.path.equalsIgnoreCase("shop." + string)) continue;
            shop = shop2;
        }
        if (shop == null) {
            return false;
        }
        shop.move(block);
        this.load();
        return true;
    }

    public Shop getShop(Block block) {
        return block == null ? null : (Shop)this.shops.stream().filter(shop -> shop.getShopLocation().equals(block) || shop.getShopLocation().equals(block.getRelative(BlockFace.DOWN))).findFirst().orElse(null);
    }

    public Block lookingAt(Player player) {
        return player.getTargetBlockExact(6, FluidCollisionMode.SOURCE_ONLY);
    }

    @Nullable
    public Shop isPlayerAtShop(Player player) {
        for (DisplayText displayText : this.playerLooking) {
            if (!displayText.getPlayer().equals(player)) continue;
            return displayText.getShop();
        }
        return null;
    }

    public void editShop(Player player) {
        Shop shop = this.isPlayerAtShop(player);
        if (shop == null) {
            Messages.sendMessage(player, "shop.not-found");
            return;
        }
        shop.editShop(player);
    }

    private void setupMetaData() {
        ArmorStand armorStand = (ArmorStand)((World)Main.getInstance().getServer().getWorlds().get(0)).spawnEntity(new Location((World)Main.getInstance().getServer().getWorlds().get(0), 0.0, 0.0, 0.0), EntityType.ARMOR_STAND);
        armorStand.setCustomName(Messages.format("Temp Name"));
        armorStand.setCustomNameVisible(true);
        armorStand.setVisible(false);
        armorStand.setSmall(true);
        watcher = WrappedDataWatcher.getEntityWatcher((Entity)armorStand);
        armorStand.remove();
    }

    @Nullable
    private DisplayText getPlayer(@Nonnull Player player) {
        for (DisplayText displayText : this.playerLooking) {
            if (displayText.getPlayer() == null || !displayText.getPlayer().equals(player)) continue;
            return displayText;
        }
        return null;
    }

    private void load() {
        this.removeOldShopEntities();
        this.playerLooking.clear();
        this.shops.clear();
        FileHandler.setNotExists(FileHandler.getInstance().getShopsConfig(), SHOPS_PATH, "[]");
        ConfigurationSection configurationSection = FileHandler.getInstance().getShopsConfig().getConfigurationSection(SHOPS_PATH);
        if (configurationSection == null) {
            return;
        }
        for (String string : configurationSection.getKeys(false)) {
            try {
                if (configurationSection.contains(string + ".trap-index")) {
                    this.shops.add(new ShopTrap("shop." + string));
                    continue;
                }
                if (configurationSection.contains(string + ".item")) {
                    this.shops.add(new ShopItem("shop." + string));
                    continue;
                }
                if (configurationSection.contains(string + ".arena")) {
                    this.shops.add(new ShopArena("shop." + string));
                    continue;
                }
                Messages.sendConsoleWarning("Illegal shop: " + string + ". Not selling items, traps nor arenas! Skipping...");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                Messages.sendConsoleWarning(illegalAccessException.getMessage());
            }
        }
    }

    public void removeOldShopEntities() {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                int n;
                if (!entity.getPersistentDataContainer().has(Main.getKeyBase(), PersistentDataType.INTEGER) || (n = ((Integer)entity.getPersistentDataContainer().getOrDefault(Main.getKeyBase(), PersistentDataType.INTEGER, (Object)-1)).intValue()) == randomEntityID) continue;
                entity.remove();
            }
        }
        TrapManager.getInstance().replaceShopTraps();
    }
}

