/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.statistics;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.statistics.HighScore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.configuration.ConfigurationSection;

public class ScoreManager {
    private static ScoreManager instance;
    private final List<OfflinePlayer> topKills = new ArrayList<OfflinePlayer>();
    private final Map<String, List<HighScore>> topArenas = new HashMap<String, List<HighScore>>();

    private ScoreManager() {
        Collections.addAll(this.topKills, Bukkit.getOfflinePlayers());
        this.topKills.sort(Comparator.comparingInt(offlinePlayer -> -offlinePlayer.getStatistic(Statistic.MOB_KILLS)));
        this.loadFromFile();
    }

    public static ScoreManager getInstance() {
        if (instance == null) {
            instance = new ScoreManager();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public void printInitData() {
        Messages.sendConsole("Loading highscores from file");
        if (this.topArenas.isEmpty()) {
            Messages.sendConsole("> Loaded none highscores");
        } else {
            this.topArenas.forEach((string, list) -> Messages.sendConsole(" > Loaded " + list.size() + " scores for " + string));
        }
    }

    @Nullable
    public OfflinePlayer getTopKiller(int n) {
        if (this.topKills.size() < n) {
            return null;
        }
        return this.topKills.get(n - 1);
    }

    public void addMobKill(OfflinePlayer offlinePlayer) {
        int n;
        int n2;
        int n3;
        while ((n3 = this.topKills.indexOf(offlinePlayer)) != 0 && (n2 = offlinePlayer.getStatistic(Statistic.MOB_KILLS)) > (n = this.topKills.get(n3 - 1).getStatistic(Statistic.MOB_KILLS))) {
            Collections.swap(this.topKills, n3, n3 - 1);
        }
    }

    @Nullable
    public HighScore getTopGamemode(String string, int n) {
        List<HighScore> list = this.topArenas.get(string);
        if (list == null || list.size() < n) {
            return null;
        }
        return list.get(n - 1);
    }

    public boolean isValidGamemode(String string) {
        return this.topArenas.containsKey(string);
    }

    public void updateArenaScore(Arena arena) {
        if (arena.getArenaData().getMembers() == null || arena.getArenaData().getMembers().size() == 0) {
            return;
        }
        List list = this.topArenas.computeIfAbsent(arena.getArenaData().getGamemode(), string -> new ArrayList());
        if (list.stream().noneMatch(highScore -> highScore.updateScore(arena))) {
            list.add(new HighScore(arena));
        }
        this.updateHighScores();
    }

    public void removeArena(Arena arena) {
        if (arena.getArenaData().getMembers().size() == 0) {
            return;
        }
        List<HighScore> list = this.topArenas.get(arena.getArenaData().getGamemode());
        if (list != null) {
            list.forEach(highScore -> highScore.clearArena(arena));
        }
    }

    public void updateMembers(Arena arena, List<UUID> list) {
        List list2 = this.topArenas.computeIfAbsent(arena.getArenaData().getGamemode(), string -> new ArrayList());
        HighScore highScore = null;
        HighScore highScore2 = null;
        for (HighScore highScore3 : list2) {
            if (highScore3.getMemberList().size() == list.size() && highScore3.getMemberList().containsAll(list)) {
                highScore = highScore3;
            }
            if (highScore3.getMemberList().size() != arena.getArenaData().getMembers().size() || !highScore3.getMemberList().containsAll(arena.getArenaData().getMembers())) continue;
            highScore2 = highScore3;
        }
        if (highScore != null && highScore != highScore2) {
            highScore.remove();
            list2.remove(highScore);
        }
        if (arena.getArenaData().getMembers().size() != 0) {
            if (highScore2 != null) {
                highScore2.updateMembers(arena);
            } else {
                list2.add(new HighScore(arena));
            }
        }
    }

    public void updateHighScores() {
        this.topArenas.forEach((string, list) -> list.sort(Comparator.comparingInt(highScore -> -highScore.getWave())));
    }

    private void loadFromFile() {
        this.topArenas.clear();
        ConfigurationSection configurationSection = FileHandler.getInstance().getScoresConfig().getConfigurationSection("highscores");
        if (configurationSection == null || configurationSection.getKeys(false).size() == 0) {
            return;
        }
        for (String string : configurationSection.getKeys(false)) {
            ArrayList<HighScore> arrayList = new ArrayList<HighScore>();
            for (String string2 : configurationSection.getConfigurationSection(string).getKeys(false)) {
                try {
                    arrayList.add(new HighScore(string, string2));
                }
                catch (Exception exception) {
                    Messages.sendConsoleWarning("Unable to read highscore: " + string);
                    exception.printStackTrace();
                }
            }
            this.topArenas.put(string, arrayList);
        }
        this.updateHighScores();
    }
}

