/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.traps;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.traps.DamageType;
import NL.martijnpu.ChunkDefence.traps.ParticleOnAttack;
import NL.martijnpu.ChunkDefence.traps.ParticleType;
import NL.martijnpu.ChunkDefence.traps.TrapLocation;
import NL.martijnpu.ChunkDefence.traps.TrapManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.Vector;

public class TrapBase {
    private static final String _NAME_PATH = ".name";
    private static final String _NAME_VISIBLE_PATH = ".display-name";
    private static final String _DISPLAY_ITEM_PATH = ".display-item";
    private static final String _ITEM_GLOW_PATH = ".item-glow";
    private static final String _LORE_PATH = ".lore";
    private static final String _BLOCK_PATH = ".trap-block";
    private static final String _INTERVAL_PATH = ".interval";
    private static final String _DURABILITY_PATH = ".durability";
    private static final String _SETUP_TIME_PATH = ".setup-time";
    private static final String _FIRE_PATH = ".set-fire";
    private static final String _PARTICLE_TYPE_PATH = ".particle.type";
    private static final String _PARTICLE_SPEED_PATH = ".particle.particle-speed";
    private static final String _PARTICLE_SIZE_PATH = ".particle.size";
    private static final String _PARTICLE_AMOUNT_PATH = ".particle.amount";
    private static final String _PARTICLE_MODE_PATH = ".particle.mode";
    private static final String _PARTICLE_MODE_SPEED_PATH = ".particle.mode-speed";
    private static final String _PARTICLE_ATTACK_PATH = ".particle.particle_on_attack";
    private static final String _PARTICLE_ATTACK_SOUND_PATH = ".particle.sound_on_attack";
    private static final String _DAMAGE_AMOUNT_PATH = ".deal_damage.damage";
    private static final String _DAMAGE_TYPE_PATH = ".damage_type";
    private static final String _POTION_EFFECT_PATH = ".deal_effect.effect";
    private static final String _POTION_AMPLIFIER_PATH = ".deal_effect.amplify";
    private static final String _POTION_TIME_PATH = ".deal_effect.time";
    private static final String _TARGET_RANGE_PATH = ".target.range";
    private static final String _TARGET_AMOUNT_PATH = ".target.amount";
    private static final String _TARGET_ENTITY_PATH = ".target.entity";
    private String indexName;
    private String name;
    private double interval;
    private int damage;
    private PotionEffectType potionEffectType;
    private int potionAmplify;
    private int maxDurability;
    private double setupTime;
    private boolean setOnFire;
    private double targetRange;
    private int targetAmount;
    private List<EntityType> targetEntity;
    private Material displayItem;
    Boolean nameVisible;
    private Particle particle;
    private float particleSpeed;
    private float particleSize;
    private int particleAmount;
    private Material trapBlock;
    private ParticleOnAttack particleOnAttack;
    private ParticleType movementMode;
    private Sound soundOnAttack;
    private float potionTime;
    private Boolean itemGlow;
    private String lore;
    private float modeSpeed;
    private DamageType damageType;
    private float intervalPeriod = 0.0f;
    private int particlePeriod = 0;
    private List<Vector> particleDelta;

    TrapBase(String string) {
        this.indexName = string;
        string = "traps." + string;
        this.name = this.getConfig().getString(string + _NAME_PATH, "Unknown");
        this.nameVisible = this.getConfig().getBoolean(string + _NAME_VISIBLE_PATH, true);
        this.displayItem = Material.getMaterial((String)Objects.requireNonNull(this.getConfig().getString(string + _DISPLAY_ITEM_PATH, "DIRT")).toUpperCase().replace(' ', '_'));
        this.itemGlow = this.getConfig().getBoolean(string + _ITEM_GLOW_PATH, false);
        this.lore = this.getConfig().getString(string + _LORE_PATH, "");
        this.particle = Particle.valueOf((String)Objects.requireNonNull(this.getConfig().getString(string + _PARTICLE_TYPE_PATH, "BARRIER")).toUpperCase().replace(' ', '_'));
        this.particleSpeed = (float)this.getConfig().getDouble(string + _PARTICLE_SPEED_PATH, 1.0);
        this.particleSize = (float)this.getConfig().getDouble(string + _PARTICLE_SIZE_PATH, 0.0);
        this.particleAmount = this.getConfig().getInt(string + _PARTICLE_AMOUNT_PATH, 1);
        this.movementMode = ParticleType.valueOf(Objects.requireNonNull(this.getConfig().getString(string + _PARTICLE_MODE_PATH, "SPREAD")).toUpperCase().replace(' ', '_'));
        this.modeSpeed = (float)this.getConfig().getDouble(string + _PARTICLE_MODE_SPEED_PATH, 1.0);
        Material material = Material.getMaterial((String)Objects.requireNonNull(this.getConfig().getString(string + _BLOCK_PATH, "")).toUpperCase());
        this.trapBlock = material != null && !material.isAir() ? material : Material.DEAD_BUSH;
        this.particleOnAttack = ParticleOnAttack.valueOf(Objects.requireNonNull(this.getConfig().getString(string + _PARTICLE_ATTACK_PATH, "NONE")).toUpperCase().replace(' ', '_'));
        this.soundOnAttack = Sound.valueOf((String)Objects.requireNonNull(this.getConfig().getString(string + _PARTICLE_ATTACK_SOUND_PATH, "BLOCK_DISPENSER_LAUNCH")).toUpperCase().replace(' ', '_'));
        this.damage = this.getConfig().getInt(string + _DAMAGE_AMOUNT_PATH, -1);
        this.potionEffectType = PotionEffectType.getByName((String)Objects.requireNonNull(this.getConfig().getString(string + _POTION_EFFECT_PATH, "CONFUSION")).toUpperCase().replace(' ', '_'));
        this.potionAmplify = this.getConfig().getInt(string + _POTION_AMPLIFIER_PATH, 1);
        this.potionTime = (float)this.getConfig().getDouble(string + _POTION_TIME_PATH, 1.0);
        this.damageType = this.damage >= 0 ? DamageType.valueOf(Objects.requireNonNull(this.getConfig().getString(string + _DAMAGE_TYPE_PATH, "DAMAGE")).toUpperCase().replace(' ', '_')) : DamageType.valueOf(Objects.requireNonNull(this.getConfig().getString(string + _DAMAGE_TYPE_PATH, "POTION_EFFECT")).toUpperCase().replace(' ', '_'));
        this.interval = this.getConfig().getDouble(string + _INTERVAL_PATH, 1.0);
        this.maxDurability = this.getConfig().getInt(string + _DURABILITY_PATH, -1);
        this.setupTime = this.getConfig().getDouble(string + _SETUP_TIME_PATH, 0.0);
        this.setOnFire = this.getConfig().getBoolean(string + _FIRE_PATH, false);
        this.targetRange = this.getConfig().getDouble(string + _TARGET_RANGE_PATH, 1.0);
        this.targetAmount = this.getConfig().getInt(string + _TARGET_AMOUNT_PATH, -1);
        this.targetEntity = this.getEntities(string + _TARGET_ENTITY_PATH);
        this.particleDelta = new ArrayList<Vector>();
    }

    public TrapBase() {
        this.indexName = "Trap-" + TrapManager.getInstance().getAllTrapBasesName().size();
        this.name = (String)this.setAndGet(_NAME_PATH, "Unknown");
        this.nameVisible = (Boolean)this.setAndGet(_NAME_VISIBLE_PATH, true);
        this.displayItem = Material.getMaterial((String)((String)this.setAndGet(_DISPLAY_ITEM_PATH, "DIRT")));
        this.itemGlow = (Boolean)this.setAndGet(_ITEM_GLOW_PATH, false);
        this.lore = (String)this.setAndGet(_LORE_PATH, "");
        this.particle = Particle.valueOf((String)Objects.requireNonNull((String)this.setAndGet(_PARTICLE_TYPE_PATH, "barrier")).toUpperCase().replace(' ', '_'));
        this.particleSpeed = ((Float)this.setAndGet(_PARTICLE_SPEED_PATH, Float.valueOf(1.0f))).floatValue();
        this.particleSize = ((Float)this.setAndGet(_PARTICLE_SIZE_PATH, Float.valueOf(0.0f))).floatValue();
        this.particleAmount = (Integer)this.setAndGet(_PARTICLE_AMOUNT_PATH, 1);
        this.movementMode = ParticleType.valueOf(Objects.requireNonNull((String)this.setAndGet(_PARTICLE_MODE_PATH, "spread")).toUpperCase().replace(' ', '_'));
        this.modeSpeed = ((Float)this.setAndGet(_PARTICLE_MODE_SPEED_PATH, Float.valueOf(1.0f))).floatValue();
        Material material = Material.getMaterial((String)Objects.requireNonNull((String)this.setAndGet(_BLOCK_PATH, "")).toUpperCase());
        this.trapBlock = material != null && !material.isAir() ? material : Material.DEAD_BUSH;
        this.particleOnAttack = ParticleOnAttack.valueOf(Objects.requireNonNull((String)this.setAndGet(_PARTICLE_ATTACK_PATH, "NONE")).toUpperCase().replace(' ', '_'));
        this.soundOnAttack = Sound.valueOf((String)Objects.requireNonNull((String)this.setAndGet(_PARTICLE_ATTACK_SOUND_PATH, "BLOCK_DISPENSER_LAUNCH")).toUpperCase().replace(' ', '_'));
        this.damage = (Integer)this.setAndGet(_DAMAGE_AMOUNT_PATH, -1);
        this.potionEffectType = PotionEffectType.getByName((String)Objects.requireNonNull((String)this.setAndGet(_POTION_EFFECT_PATH, "CONFUSION")).toUpperCase());
        this.potionAmplify = (Integer)this.setAndGet(_POTION_AMPLIFIER_PATH, 1);
        this.potionTime = ((Float)this.setAndGet(_POTION_TIME_PATH, Float.valueOf(1.0f))).floatValue();
        this.damageType = DamageType.valueOf(Objects.requireNonNull((String)this.setAndGet(_DAMAGE_TYPE_PATH, "POTION_EFFECT")).toUpperCase().replace(' ', '_'));
        this.interval = (Double)this.setAndGet(_INTERVAL_PATH, 1.0);
        this.maxDurability = (Integer)this.setAndGet(_DURABILITY_PATH, -1);
        this.setupTime = (Double)this.setAndGet(_SETUP_TIME_PATH, 0.0);
        this.setOnFire = (Boolean)this.setAndGet(_FIRE_PATH, false);
        this.targetRange = (Double)this.setAndGet(_TARGET_RANGE_PATH, 1.0);
        this.targetAmount = (Integer)this.setAndGet(_TARGET_AMOUNT_PATH, -1);
        this.targetEntity = this.getEntities(_TARGET_ENTITY_PATH);
        this.particleDelta = new ArrayList<Vector>();
    }

    public ItemStack generateTrapItem(int n) {
        return this.generateTrapItem(n, -1);
    }

    public ItemStack generateTrapItem(int n, int n2) {
        ItemStack itemStack = new ItemStack(this.displayItem, n);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (n2 == -1) {
            n2 = this.maxDurability;
        }
        if (itemMeta != null) {
            itemMeta.setDisplayName(Messages.format(this.name));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Messages.format(this.lore));
        arrayList.add("");
        arrayList.add(Messages.format("trap.divider"));
        if (this.damageType == DamageType.POTION_EFFECT) {
            arrayList.add(Messages.format("trap.effect").replace("%EFFECT%", this.potionEffectType.getName().toLowerCase()));
            arrayList.add(Messages.format("trap.amplify").replace("%AMPLIFY%", this.potionAmplify + ""));
        } else if (this.damage >= 1) {
            arrayList.add(Messages.format("trap.damage").replace("%DAMAGE%", this.damage + "").replace("%AMOUNT%", this.interval + ""));
        } else if (!this.setOnFire) {
            arrayList.add(Messages.format("trap.damage-aesthetic"));
        }
        if (this.setOnFire) {
            arrayList.add(Messages.format("trap.fire"));
        }
        arrayList.add(Messages.format("trap.range").replace("%AMOUNT%", this.targetRange + ""));
        if (this.targetAmount > 0) {
            arrayList.add(Messages.format("trap.target").replace("%AMOUNT%", this.targetAmount + ""));
        }
        if (this.maxDurability == -1) {
            arrayList.add(Messages.format("trap.durability-infinity"));
        } else {
            arrayList.add(Messages.format("trap.durability").replace("%AMOUNT%", n2 + "").replace("%MAX_AMOUNT%", this.maxDurability + ""));
        }
        if (this.setupTime > 0.0) {
            arrayList.add(Messages.format("trap.build-time").replace("%AMOUNT%", this.setupTime + ""));
        }
        StringBuilder stringBuilder = new StringBuilder(Messages.format("trap.mobs"));
        if (this.targetEntity.size() == 0) {
            stringBuilder.append(Messages.format("trap.mobs-all"));
        } else {
            for (int i = 1; i < this.targetEntity.size() + 1; ++i) {
                stringBuilder.append(this.targetEntity.get(i - 1).name().toLowerCase()).append(" ");
                if (i % 4 != 0) continue;
                arrayList.add(Messages.format(stringBuilder.toString()));
                stringBuilder = new StringBuilder(Messages.format("trap.mobs-next-line"));
            }
        }
        if (stringBuilder.length() > 8) {
            arrayList.add(Messages.format(stringBuilder.toString()));
        }
        arrayList.add(Messages.format("trap.divider"));
        if (itemMeta == null) {
            return itemStack;
        }
        itemMeta.setLore(arrayList);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        if (this.itemGlow.booleanValue()) {
            itemMeta.addEnchant(Enchantment.LUCK, 1, false);
        }
        itemMeta.addAttributeModifier(Attribute.GENERIC_LUCK, new AttributeModifier(this.indexName, (double)n2, AttributeModifier.Operation.ADD_NUMBER));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    int getParticlePeriod() {
        return this.particlePeriod;
    }

    void handleDamageTick(TrapLocation trapLocation) {
        if (!trapLocation.canAttack()) {
            return;
        }
        boolean bl = trapLocation.display.getNearbyEntities(20.0, 20.0, 20.0).stream().anyMatch(entity -> entity instanceof Player);
        if (!bl) {
            return;
        }
        this.movementMode.spawnParticle((Entity)trapLocation.display, this, this.particleDelta);
        if (trapLocation.owner == null || this.intervalPeriod > 0.0f) {
            return;
        }
        this.damageType.attack(trapLocation);
    }

    void updateTime() {
        this.particlePeriod = (int)(((float)this.particlePeriod + this.modeSpeed) % 360.0f);
        this.intervalPeriod += (float)ConfigData.getInstance().getParticleFrequency() / 20.0f;
        if ((double)this.intervalPeriod >= this.interval) {
            this.intervalPeriod = 0.0f;
        }
        this.particleDelta = this.movementMode.calculateNextDelta(this);
    }

    PotionEffect getPotionEffect() {
        return new PotionEffect(this.potionEffectType, (int)(this.potionTime * 20.0f), this.potionAmplify);
    }

    private List<EntityType> getEntities(String string2) {
        ArrayList<EntityType> arrayList = new ArrayList<EntityType>();
        this.getConfig().getStringList("traps." + this.indexName + string2).forEach(string -> arrayList.add(EntityType.valueOf((String)string.toUpperCase().replace(' ', '_'))));
        return arrayList;
    }

    private FileConfiguration getConfig() {
        return FileHandler.getInstance().getTrapsConfig();
    }

    private Object setAndGet(String string, Object object) {
        this.getConfig().set("traps." + this.indexName + string, object);
        return object;
    }

    void removeTrap() {
        FileHandler.getInstance().getTrapsConfig().set("traps." + this.indexName, null);
        FileHandler.getInstance().saveTrapsConfig();
    }

    public void save() {
        String string = "traps." + this.indexName;
        this.getConfig().set(string + _NAME_PATH, (Object)this.name);
        this.getConfig().set(string + _NAME_VISIBLE_PATH, (Object)this.nameVisible);
        this.getConfig().set(string + _DISPLAY_ITEM_PATH, (Object)this.displayItem.name());
        this.getConfig().set(string + _ITEM_GLOW_PATH, (Object)this.itemGlow);
        this.getConfig().set(string + _LORE_PATH, (Object)this.lore);
        this.getConfig().set(string + _PARTICLE_TYPE_PATH, (Object)this.particle.name());
        this.getConfig().set(string + _PARTICLE_SPEED_PATH, (Object)Float.valueOf(this.particleSpeed));
        this.getConfig().set(string + _PARTICLE_SIZE_PATH, (Object)Float.valueOf(this.particleSize));
        this.getConfig().set(string + _PARTICLE_AMOUNT_PATH, (Object)this.particleAmount);
        this.getConfig().set(string + _PARTICLE_MODE_PATH, (Object)this.movementMode.name());
        this.getConfig().set(string + _PARTICLE_MODE_SPEED_PATH, (Object)Float.valueOf(this.modeSpeed));
        this.getConfig().set(string + _BLOCK_PATH, (Object)this.trapBlock.name());
        this.getConfig().set(string + _PARTICLE_ATTACK_PATH, (Object)this.particleOnAttack.name());
        this.getConfig().set(string + _PARTICLE_ATTACK_SOUND_PATH, (Object)this.soundOnAttack.name());
        this.getConfig().set(string + _DAMAGE_AMOUNT_PATH, (Object)this.damage);
        this.getConfig().set(string + _POTION_EFFECT_PATH, (Object)this.potionEffectType.getName());
        this.getConfig().set(string + _POTION_AMPLIFIER_PATH, (Object)this.potionAmplify);
        this.getConfig().set(string + _POTION_TIME_PATH, (Object)Float.valueOf(this.potionTime));
        this.getConfig().set(string + _DAMAGE_TYPE_PATH, (Object)this.damageType.name());
        this.getConfig().set(string + _INTERVAL_PATH, (Object)this.interval);
        this.getConfig().set(string + _DURABILITY_PATH, (Object)this.maxDurability);
        this.getConfig().set(string + _SETUP_TIME_PATH, (Object)this.setupTime);
        this.getConfig().set(string + _FIRE_PATH, (Object)this.setOnFire);
        this.getConfig().set(string + _TARGET_RANGE_PATH, (Object)this.targetRange);
        this.getConfig().set(string + _TARGET_AMOUNT_PATH, (Object)this.targetAmount);
        this.getConfig().set(string + _TARGET_ENTITY_PATH, this.targetEntity.stream().map(Enum::name).collect(Collectors.toList()));
        FileHandler.getInstance().saveTrapsConfig();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public double getInterval() {
        return this.interval;
    }

    public void setInterval(String string) {
        this.interval = Double.parseDouble(string);
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(String string) {
        this.damage = (int)Double.parseDouble(string);
    }

    public PotionEffectType getPotionEffectType() {
        return this.potionEffectType;
    }

    public void setPotionEffectType(String string) {
        this.potionEffectType = PotionType.valueOf((String)string).getEffectType();
    }

    public int getPotionAmplify() {
        return this.potionAmplify;
    }

    public void setPotionAmplify(String string) {
        this.potionAmplify = (int)Double.parseDouble(string);
    }

    public int getMaxDurability() {
        return this.maxDurability;
    }

    public void setMaxDurability(String string) {
        this.maxDurability = (int)Double.parseDouble(string);
    }

    public double getSetupTime() {
        return this.setupTime;
    }

    public void setSetupTime(String string) {
        this.setupTime = Double.parseDouble(string);
    }

    public boolean isSetOnFire() {
        return this.setOnFire;
    }

    public void setSetOnFire(boolean bl) {
        this.setOnFire = bl;
    }

    public double getTargetRange() {
        return this.targetRange;
    }

    public void setTargetRange(String string) {
        this.targetRange = Double.parseDouble(string);
    }

    public int getTargetAmount() {
        return this.targetAmount;
    }

    public void setTargetAmount(String string) {
        this.targetAmount = (int)Double.parseDouble(string);
    }

    public List<EntityType> getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(List<String> list) {
        if (list != null) {
            this.targetEntity = new ArrayList<EntityType>();
            list.forEach(string -> this.targetEntity.add(EntityType.valueOf((String)ChatColor.stripColor((String)string).toUpperCase().replace(' ', '_'))));
        }
    }

    public Material getDisplayItem() {
        return this.displayItem;
    }

    public void setDisplayItem(Material material) {
        this.displayItem = material;
    }

    public Boolean getNameVisible() {
        return this.nameVisible;
    }

    public void setNameVisible(Boolean bl) {
        this.nameVisible = bl;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(String string) {
        this.particle = Particle.valueOf((String)string.toUpperCase().replace(' ', '_'));
    }

    public float getParticleSpeed() {
        return this.particleSpeed;
    }

    public void setParticleSpeed(String string) {
        this.particleSpeed = Float.parseFloat(string);
    }

    public float getParticleSize() {
        return this.particleSize;
    }

    public void setParticleSize(String string) {
        this.particleSize = Float.parseFloat(string);
    }

    public int getParticleAmount() {
        return this.particleAmount;
    }

    public void setParticleAmount(String string) {
        this.particleAmount = (int)Double.parseDouble(string);
    }

    public Material getTrapBlock() {
        return this.trapBlock;
    }

    public void setTrapBlock(Material material) {
        this.trapBlock = material;
    }

    public ParticleOnAttack getParticleOnAttack() {
        return this.particleOnAttack;
    }

    public void setParticleOnAttack(String string) {
        this.particleOnAttack = ParticleOnAttack.valueOf(string.toUpperCase().replace(' ', '_'));
    }

    public ParticleType getMovementMode() {
        return this.movementMode;
    }

    public void setMovementMode(String string) {
        this.movementMode = ParticleType.valueOf(string.toUpperCase().replace(' ', '_'));
    }

    public Sound getSoundOnAttack() {
        return this.soundOnAttack;
    }

    public void setSoundOnAttack(String string) {
        this.soundOnAttack = Sound.valueOf((String)string.toUpperCase().replace(' ', '_'));
    }

    public float getPotionTime() {
        return this.potionTime;
    }

    public void setPotionTime(String string) {
        this.potionTime = Float.parseFloat(string);
    }

    public void setItemGlow(Boolean bl) {
        this.itemGlow = bl;
    }

    public String getLore() {
        return this.lore;
    }

    public void setLore(String string) {
        this.lore = string;
    }

    public float getModeSpeed() {
        return this.modeSpeed;
    }

    public void setModeSpeed(String string) {
        this.modeSpeed = Float.parseFloat(string);
    }

    public void setDamageType(String string) {
        this.damageType = DamageType.valueOf(string.toUpperCase().replace(' ', '_'));
    }

    public DamageType getDamageType() {
        return this.damageType;
    }
}

