/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.traps;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.traps.TrapBase;
import NL.martijnpu.ChunkDefence.traps.TrapManager;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class TrapLocation {
    public final TrapBase trapBase;
    public final Block block;
    final UUID owner;
    final AreaEffectCloud display;
    private AreaEffectCloud setupCloud;
    private AreaEffectCloud durabilityCloud;
    private double timeTillBuild;
    private int durability;

    TrapLocation(AreaEffectCloud areaEffectCloud, TrapManager trapManager) {
        this.block = areaEffectCloud.getLocation().getBlock();
        this.trapBase = trapManager.getTrapBase((String)areaEffectCloud.getPersistentDataContainer().get(Main.getKeyBase(), PersistentDataType.STRING));
        if (this.trapBase == null) {
            Messages.sendConsoleWarning("Couldn't load trap at location: " + FileHandler.getStringFromLocation(areaEffectCloud.getLocation()) + ". Illegal name: " + (String)areaEffectCloud.getPersistentDataContainer().get(Main.getKeyBase(), PersistentDataType.STRING));
            Messages.sendConsoleWarning("Removed unknown trap.");
            areaEffectCloud.remove();
            this.block.setType(Material.AIR);
            throw new IllegalArgumentException();
        }
        this.setupCloud = null;
        this.durabilityCloud = null;
        this.durability = this.trapBase.getMaxDurability();
        this.setBlock();
        this.display = areaEffectCloud;
        areaEffectCloud.setCustomName(this.trapBase.getName());
        this.owner = areaEffectCloud.getPersistentDataContainer().has(Main.getKeyOwner(), PersistentDataType.STRING) ? UUID.fromString(Objects.requireNonNull((String)areaEffectCloud.getPersistentDataContainer().get(Main.getKeyOwner(), PersistentDataType.STRING))) : null;
        if (areaEffectCloud.getPersistentDataContainer().has(Main.getKeyDurability(), PersistentDataType.INTEGER)) {
            this.durability = (Integer)areaEffectCloud.getPersistentDataContainer().get(Main.getKeyDurability(), PersistentDataType.INTEGER);
        } else {
            this.durability = this.trapBase.getMaxDurability();
            areaEffectCloud.getPersistentDataContainer().set(Main.getKeyDurability(), PersistentDataType.INTEGER, (Object)this.durability);
        }
    }

    TrapLocation(Block block, TrapBase trapBase, UUID uUID, int n) {
        this.trapBase = trapBase;
        this.owner = uUID;
        this.block = block;
        this.durabilityCloud = null;
        this.durability = n == -1 ? trapBase.getMaxDurability() : n;
        this.timeTillBuild = uUID == null ? -1.0 : trapBase.getSetupTime();
        this.setupCloud = this.timeTillBuild <= 0.0 ? null : this.generateCloud(new Vector(0.5, 0.4, 0.5), (int)(trapBase.getSetupTime() * (double)(40 / ConfigData.getInstance().getParticleFrequency())), "&e" + trapBase.getSetupTime());
        this.setBlock();
        this.display = this.generateCloud(new Vector(0.5, 0.2, 0.5), 999999, trapBase.getName());
        this.display.getPersistentDataContainer().set(Main.getKeyBase(), PersistentDataType.STRING, (Object)trapBase.getName());
        if (uUID != null) {
            this.display.getPersistentDataContainer().set(Main.getKeyOwner(), PersistentDataType.STRING, (Object)uUID.toString());
        }
        this.display.getPersistentDataContainer().set(Main.getKeyDurability(), PersistentDataType.INTEGER, (Object)n);
    }

    void delete() {
        this.display.getWorld().playSound(this.display.getLocation(), Sound.BLOCK_TRIPWIRE_DETACH, 1.0f, 1.0f);
        this.remove();
    }

    private void setBlock() {
        this.block.setType(this.trapBase.getTrapBlock());
        BlockData blockData = this.block.getType().createBlockData();
        if (blockData instanceof Waterlogged) {
            ((Waterlogged)blockData).setWaterlogged(false);
            this.block.setBlockData(blockData);
        }
    }

    private void remove() {
        this.display.remove();
        if (this.durabilityCloud != null) {
            this.durabilityCloud.remove();
        }
        if (this.setupCloud != null) {
            this.setupCloud.remove();
        }
        this.block.setType(Material.AIR);
    }

    void lowerDurability() {
        --this.durability;
        this.display.getPersistentDataContainer().set(Main.getKeyDurability(), PersistentDataType.INTEGER, (Object)this.durability);
    }

    int getDurability() {
        return this.durability;
    }

    void replaceIfShop() {
        if (this.owner == null) {
            this.setBlock();
        }
    }

    boolean removeTrap() {
        return !this.display.getLocation().getChunk().isLoaded() || this.durability <= 0;
    }

    void tickEngine() {
        if (!this.display.getLocation().getChunk().isLoaded()) {
            return;
        }
        this.checkDurabilityCloud();
        if (this.timeTillBuild > 0.0) {
            this.timeTillBuild -= 0.05 * (double)ConfigData.getInstance().getParticleFrequency();
            if (this.setupCloud == null) {
                this.setupCloud = this.generateCloud(new Vector(0.5, 0.4, 0.5), (int)(this.trapBase.getSetupTime() * (double)(40 / ConfigData.getInstance().getParticleFrequency())), Messages.format("&e" + this.round(this.timeTillBuild)));
            } else {
                this.setupCloud.setCustomName(Messages.format("&e" + this.round(this.timeTillBuild)));
            }
        } else {
            this.trapBase.handleDamageTick(this);
        }
        if (this.durability <= 0) {
            this.block.getWorld().spawnParticle(this.trapBase.getParticle(), this.block.getLocation(), this.trapBase.getParticleAmount() * 5, 0.5, 0.5, 0.5, (double)this.trapBase.getParticleSpeed());
            this.display.getWorld().playSound(this.display.getLocation(), Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, 1.0f, 1.0f);
            this.remove();
        }
    }

    private void checkDurabilityCloud() {
        if (this.durability <= 0 || this.owner == null || this.timeTillBuild > 0.0) {
            return;
        }
        if (this.durabilityCloud == null || !this.durabilityCloud.isValid()) {
            this.durabilityCloud = this.generateCloud(new Vector(0.5, 0.4, 0.5), 10, this.durability + "");
        }
        this.durabilityCloud.setDuration(ConfigData.getInstance().getParticleFrequency() * 5);
        double d = 1.0 * (double)this.durability / (double)this.trapBase.getMaxDurability();
        this.durabilityCloud.setCustomName(Messages.format(this.getColor(d) + this.durability));
    }

    boolean canAttack() {
        return this.timeTillBuild <= 0.0 && this.durability > 0 || this.owner == null;
    }

    private AreaEffectCloud generateCloud(Vector vector, int n, String string) {
        AreaEffectCloud areaEffectCloud = (AreaEffectCloud)this.block.getWorld().spawnEntity(this.block.getLocation().clone().add(vector), EntityType.AREA_EFFECT_CLOUD);
        areaEffectCloud.setParticle(Particle.BLOCK_CRACK, (Object)Material.AIR.createBlockData());
        areaEffectCloud.setWaitTime(0);
        areaEffectCloud.setSilent(true);
        areaEffectCloud.setInvulnerable(true);
        areaEffectCloud.setRadius(0.0f);
        areaEffectCloud.setDuration(n);
        areaEffectCloud.setCustomName(Messages.format(string));
        areaEffectCloud.setCustomNameVisible(true);
        return areaEffectCloud;
    }

    private double round(double d) {
        int n = (int)Math.pow(10.0, 1.0);
        return (double)Math.round(d * (double)n) / (double)n;
    }

    private String getColor(double d) {
        if (d > 1.0 || d < 0.0) {
            return "&x&C&C&0&0&C&C";
        }
        String string = String.format("x%02x%02x%02x", this.clamp(510.0 - 255.0 * (d * 2.0)), this.clamp(255.0 * (d * 2.0)), 0);
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            stringBuilder.append('&').append(c);
        }
        return stringBuilder.toString();
    }

    private int clamp(double d) {
        return (int)Math.max(0.0, Math.min(255.0, d));
    }
}

