/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.traps;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.traps.TrapBase;
import NL.martijnpu.ChunkDefence.traps.TrapLocation;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class TrapManager {
    public static final String METADATA_KEY_ATTACKED_BY = "lastAttack";
    private static TrapManager instance;
    private final List<TrapBase> trapBases = new ArrayList<TrapBase>();
    private final List<TrapLocation> trapLocations = new ArrayList<TrapLocation>();

    private TrapManager() {
        this.loadTrapsFile();
        this.loadEntityTraps();
    }

    public static TrapManager getInstance() {
        if (instance == null) {
            instance = new TrapManager();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public void printInitData() {
        if (this.trapBases.size() == 0) {
            Messages.sendConsoleWarning("Loading none defined traps. This could be an error or first startup.");
        } else {
            Messages.sendConsole("Loading " + this.trapBases.size() + " defined traps.");
        }
        Messages.sendConsole("Loading " + this.trapLocations.size() + " active traps.");
    }

    public List<String> getAllTrapBasesName() {
        return this.trapBases.stream().map(trapBase -> trapBase.getIndexName()).collect(Collectors.toList());
    }

    public List<TrapBase> getAllTrapBases() {
        return this.trapBases;
    }

    public TrapBase createNewTrapBase() {
        TrapBase trapBase = new TrapBase();
        this.trapBases.add(trapBase);
        return trapBase;
    }

    public void removeTrapBase(TrapBase trapBase) {
        if (trapBase == null) {
            return;
        }
        this.trapBases.remove(trapBase);
        trapBase.removeTrap();
    }

    public void loadEntityTraps() {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (entity.getType() != EntityType.AREA_EFFECT_CLOUD) continue;
                try {
                    if (!entity.getPersistentDataContainer().has(Main.getKeyBase(), PersistentDataType.STRING) || !this.trapLocations.stream().noneMatch(trapLocation -> trapLocation.display.equals(entity))) continue;
                    this.trapLocations.add(new TrapLocation((AreaEffectCloud)entity, this));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public void addEntity(Entity entity) {
        if (entity.getType() == EntityType.AREA_EFFECT_CLOUD && this.trapLocations.stream().noneMatch(trapLocation -> trapLocation.display.equals(entity))) {
            try {
                if (entity.getPersistentDataContainer().has(Main.getKeyBase(), PersistentDataType.STRING) && this.trapLocations.stream().noneMatch(trapLocation -> trapLocation.display.equals(entity))) {
                    this.trapLocations.add(new TrapLocation((AreaEffectCloud)entity, this));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public TrapBase getTrapBase(@Nullable Multimap<Attribute, AttributeModifier> multimap) {
        if (multimap == null) {
            return null;
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        for (TrapBase trapBase : this.trapBases) {
            multimap.forEach((attribute, attributeModifier) -> {
                if (attributeModifier.getName().equals(trapBase.getIndexName())) {
                    atomicInteger.set(1);
                }
            });
            if (atomicInteger.get() != 1) continue;
            return trapBase;
        }
        return null;
    }

    public int getDurability(Multimap<Attribute, AttributeModifier> multimap, TrapBase trapBase) {
        AtomicInteger atomicInteger = new AtomicInteger();
        atomicInteger.set(-1);
        multimap.forEach((attribute, attributeModifier) -> {
            if (attributeModifier.getName().equals(trapBase.getIndexName())) {
                atomicInteger.set((int)attributeModifier.getAmount());
            }
        });
        return atomicInteger.get();
    }

    @Nullable
    public TrapBase getTrapBase(String string) {
        string = Messages.format(string);
        for (TrapBase trapBase : this.trapBases) {
            if (!string.equalsIgnoreCase(trapBase.getIndexName()) && !string.equalsIgnoreCase(Messages.format(trapBase.getName()))) continue;
            return trapBase;
        }
        return null;
    }

    public void placeTrap(Block block, TrapBase trapBase, @Nullable Player player, int n) {
        Arena arena;
        if (!block.getRelative(BlockFace.DOWN).getType().isOccluding() || !block.getType().isAir() || block.getRelative(BlockFace.DOWN).getType() == Material.BARRIER) {
            if (player == null) {
                Messages.sendConsoleWarning("Unable to place trap at location " + FileHandler.getStringFromLocation(block.getLocation()));
            }
            throw new IllegalAccessException("trap.invalid-place");
        }
        if (this.getTrapBlock(block.getRelative(BlockFace.NORTH)) != null || this.getTrapBlock(block.getRelative(BlockFace.EAST)) != null || this.getTrapBlock(block.getRelative(BlockFace.SOUTH)) != null || this.getTrapBlock(block.getRelative(BlockFace.WEST)) != null) {
            if (player == null) {
                Messages.sendConsoleWarning("Unable to place trap at location " + FileHandler.getStringFromLocation(block.getLocation()) + ". You can't place traps next to each other.");
            }
            throw new IllegalAccessException("trap.invalid-place-nextToTrap");
        }
        if (!(player == null || player.hasPermission("chunkdefence.admin.trap_place") || (arena = ArenaManager.getInstance().getArena(player)) != null && arena.isInsideArena(block.getLocation()))) {
            Messages.sendMessage(player, "trap.outside-arena");
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
            return;
        }
        this.trapLocations.add(new TrapLocation(block, trapBase, player == null ? null : player.getUniqueId(), n));
        if (player != null && !player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            player.getInventory().getItemInMainHand().setAmount(player.getInventory().getItemInMainHand().getAmount() - 1);
        }
    }

    public void destroyTrap(Block block, @Nullable Player player) {
        TrapLocation trapLocation = this.getTrapBlock(block);
        if (trapLocation == null) {
            if (player != null) {
                Messages.sendConsoleWarning("No trap found to destroy at location " + FileHandler.getStringFromLocation(block.getLocation()));
            }
            return;
        }
        if (player != null && !player.hasPermission("chunkdefence.admin.destroy")) {
            if (trapLocation.owner == null) {
                Messages.sendMessage(player, MessageData.getMessage("trap.invalid-owner").replace("%NAME%", "ChunkDefence"));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                return;
            }
            if (!player.getUniqueId().equals(trapLocation.owner)) {
                String string = Bukkit.getOfflinePlayer((UUID)trapLocation.owner).getName();
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                Messages.sendMessage(player, MessageData.getMessage("trap.invalid-owner").replace("%NAME%", string == null ? "Unknown" : string));
                return;
            }
        }
        if (player != null && !player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            if (player.getInventory().firstEmpty() == -1) {
                Messages.sendMessage(player, "exception.full");
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                return;
            }
            player.getInventory().addItem(new ItemStack[]{trapLocation.trapBase.generateTrapItem(1, trapLocation.getDurability())});
        }
        this.destroyTrap(trapLocation);
    }

    void destroyTrap(TrapLocation trapLocation) {
        if (trapLocation == null) {
            return;
        }
        this.trapLocations.remove(trapLocation);
        trapLocation.delete();
    }

    public void replaceShopTraps() {
        this.trapLocations.forEach(TrapLocation::replaceIfShop);
    }

    public TrapLocation getTrapBlock(Block block) {
        return this.trapLocations.stream().filter(trapLocation -> trapLocation.block.equals(block)).findFirst().orElse(null);
    }

    public void handleEngineTick() {
        ArrayList<TrapLocation> arrayList = new ArrayList<TrapLocation>(this.trapLocations);
        this.trapBases.forEach(TrapBase::updateTime);
        for (TrapLocation trapLocation : arrayList) {
            trapLocation.tickEngine();
            if (!trapLocation.removeTrap()) continue;
            this.trapLocations.remove(trapLocation);
        }
    }

    public ItemStack getTrapSelector(ItemStack itemStack) {
        TrapBase trapBase = this.getTrapBase((Multimap<Attribute, AttributeModifier>)itemStack.getItemMeta().getAttributeModifiers());
        ItemMeta itemMeta = itemStack.getItemMeta();
        List list = itemMeta.getLore();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Messages.format("&f&m:::::::::::::::::::::::::::::::::::::::::::::::"));
        for (String string : this.getAllTrapBasesName()) {
            if (trapBase != null && string.equals(trapBase.getIndexName())) {
                arrayList.add(Messages.format("&5&l->  " + string));
                continue;
            }
            arrayList.add(Messages.format("&b" + string));
        }
        arrayList.add(Messages.format("&f&m:::::::::::::::::::::::::::::::::::::::::::::::"));
        if (list != null) {
            arrayList.add(" ");
            arrayList.addAll(list);
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private void loadTrapsFile() {
        String string = "traps";
        this.trapBases.clear();
        ConfigurationSection configurationSection = FileHandler.getInstance().getTrapsConfig().getConfigurationSection(string);
        if (configurationSection == null || configurationSection.getKeys(false).size() == 0) {
            return;
        }
        for (String string2 : configurationSection.getKeys(false)) {
            try {
                this.trapBases.add(new TrapBase(string2));
            }
            catch (Exception exception) {
                Messages.sendConsoleWarning("Unable to read defined trap: " + string2);
                exception.printStackTrace();
            }
        }
    }
}

