/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.waves;

import NL.martijnpu.ChunkDefence.waves.FireWorkTimer;
import NL.martijnpu.ChunkDefence.waves.SpawnWaves;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireWorks {
    static final List<FireWorkTimer> timerList = new ArrayList<FireWorkTimer>();
    private static final Random RANDOM = new Random();

    public static void updateTick() {
        timerList.forEach(FireWorkTimer::countdown);
        timerList.removeIf(fireWorkTimer -> fireWorkTimer.timer == 0);
    }

    public static void spawnFireWorksArena(Location location2) {
        SpawnWaves.availableSpawnLocation(location2).forEach(location -> new FireWorkTimer((Location)location, 1, RANDOM.nextInt(7)));
    }

    public static void spawnFireWork(Location location, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            new FireWorkTimer(location, n2, RANDOM.nextInt(7));
        }
    }

    static void spawn(Location location, int n) {
        Location location2 = location.clone();
        location2.add((double)RANDOM.nextInt(n) - 0.5 * (double)n, 2.0, (double)RANDOM.nextInt(n) - 0.5 * (double)n);
        Firework firework = (Firework)location2.getWorld().spawnEntity(location2, EntityType.FIREWORK);
        FireworkEffect fireworkEffect = FireworkEffect.builder().flicker(RANDOM.nextBoolean()).trail(RANDOM.nextBoolean()).with(FireWorks.getRandomType()).withColor(FireWorks.getRandomColor()).withFade(FireWorks.getRandomColor()).build();
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        fireworkMeta.addEffect(fireworkEffect);
        fireworkMeta.setPower(RANDOM.nextInt(2) + 1);
        firework.setFireworkMeta(fireworkMeta);
    }

    private static FireworkEffect.Type getRandomType() {
        switch (new Random().nextInt(4)) {
            case 0: {
                return FireworkEffect.Type.BALL;
            }
            case 1: {
                return FireworkEffect.Type.BALL_LARGE;
            }
            case 2: {
                return FireworkEffect.Type.BURST;
            }
            case 3: {
                return FireworkEffect.Type.CREEPER;
            }
        }
        return FireworkEffect.Type.STAR;
    }

    private static Color getRandomColor() {
        switch (new Random().nextInt(16)) {
            case 0: {
                return Color.AQUA;
            }
            case 1: {
                return Color.BLACK;
            }
            case 2: {
                return Color.YELLOW;
            }
            case 3: {
                return Color.BLUE;
            }
            case 4: {
                return Color.FUCHSIA;
            }
            case 5: {
                return Color.GRAY;
            }
            case 6: {
                return Color.GREEN;
            }
            case 7: {
                return Color.LIME;
            }
            case 8: {
                return Color.MAROON;
            }
            case 9: {
                return Color.NAVY;
            }
            case 10: {
                return Color.OLIVE;
            }
            case 11: {
                return Color.ORANGE;
            }
            case 12: {
                return Color.PURPLE;
            }
            case 13: {
                return Color.RED;
            }
            case 14: {
                return Color.SILVER;
            }
            case 15: {
                return Color.TEAL;
            }
        }
        return Color.WHITE;
    }
}

