/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.goals;

import java.util.List;
import java.util.stream.Collectors;
import net.citizensnpcs.api.ai.goals.MoveToGoal;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;

public class FollowPathGoal
extends BehaviorGoalAdapter {
    private int idx;
    private final NPC npc;
    private final List<MoveToGoal> path;

    public FollowPathGoal(NPC nPC, List<MoveToGoal> list) {
        this.npc = nPC;
        this.path = list;
    }

    @Override
    public void reset() {
        this.npc.getNavigator().cancelNavigation();
        this.idx = 0;
    }

    @Override
    public BehaviorStatus run() {
        BehaviorStatus behaviorStatus;
        if (this.idx >= this.path.size()) {
            return BehaviorStatus.SUCCESS;
        }
        if (!this.npc.getNavigator().isNavigating()) {
            this.setPath();
        }
        if ((behaviorStatus = this.path.get(this.idx).run()) == BehaviorStatus.SUCCESS) {
            ++this.idx;
            this.setPath();
            return BehaviorStatus.RUNNING;
        }
        return behaviorStatus;
    }

    private void setPath() {
        if (this.idx >= this.path.size()) {
            return;
        }
        this.path.get(this.idx).shouldExecute();
    }

    @Override
    public boolean shouldExecute() {
        return !this.npc.getNavigator().isNavigating() && this.path != null;
    }

    public static FollowPathGoal create(NPC nPC, List<MoveToGoal> list) {
        return new FollowPathGoal(nPC, list);
    }

    public static FollowPathGoal createFromLocations(NPC nPC, List<Location> list) {
        return new FollowPathGoal(nPC, list.stream().map(location -> new MoveToGoal(nPC, (Location)location)).collect(Collectors.toList()));
    }
}

