/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.speech;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.event.SpeechBystanderEvent;
import net.citizensnpcs.api.ai.speech.event.SpeechTargetedEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TalkableEntity
implements Talkable {
    private final Entity entity;

    public TalkableEntity(Entity entity) {
        this.entity = entity;
    }

    public TalkableEntity(NPC nPC) {
        this.entity = nPC.getEntity();
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof Entity)) {
            return -1;
        }
        if (CitizensAPI.getNPCRegistry().isNPC((Entity)object) && CitizensAPI.getNPCRegistry().isNPC(this.entity) && CitizensAPI.getNPCRegistry().getNPC((Entity)object).getUniqueId().equals(CitizensAPI.getNPCRegistry().getNPC(this.entity).getUniqueId()) || this.entity.equals(object)) {
            return 0;
        }
        return 1;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public String getName() {
        if (CitizensAPI.getNPCRegistry().isNPC(this.entity)) {
            return CitizensAPI.getNPCRegistry().getNPC(this.entity).getFullName();
        }
        if (this.entity instanceof Player) {
            return ((Player)this.entity).getName();
        }
        return this.entity.getType().name().replace("_", " ");
    }

    private void talk(NPC nPC, String string) {
        if (!CitizensAPI.getNPCRegistry().isNPC(this.entity)) {
            Messaging.sendWithNPCColorless((CommandSender)this.entity, string, nPC);
        }
    }

    @Override
    public void talkNear(SpeechContext speechContext, String string) {
        SpeechBystanderEvent speechBystanderEvent = new SpeechBystanderEvent(this, speechContext, string);
        Bukkit.getServer().getPluginManager().callEvent((Event)speechBystanderEvent);
        if (speechBystanderEvent.isCancelled()) {
            return;
        }
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(speechBystanderEvent.getContext().getTalker().getEntity());
        this.talk(nPC, speechBystanderEvent.getMessage());
    }

    @Override
    public void talkTo(SpeechContext speechContext, String string) {
        SpeechTargetedEvent speechTargetedEvent = new SpeechTargetedEvent(this, speechContext, string);
        Bukkit.getServer().getPluginManager().callEvent((Event)speechTargetedEvent);
        if (speechTargetedEvent.isCancelled()) {
            return;
        }
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(speechTargetedEvent.getContext().getTalker().getEntity());
        this.talk(nPC, speechTargetedEvent.getMessage());
    }
}

