/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.ParallelBehavior;

public abstract class Composite
extends BehaviorGoalAdapter {
    private final List<Behavior> behaviors;
    private final List<Behavior> parallel = Lists.newArrayListWithCapacity((int)0);
    private final Set<Behavior> parallelExecuting = Sets.newHashSetWithExpectedSize((int)0);

    public Composite(Behavior ... behaviorArray) {
        this(Arrays.asList(behaviorArray));
    }

    public Composite(Collection<Behavior> collection) {
        this.behaviors = Lists.newArrayList(collection);
        Iterator<Behavior> iterator = this.behaviors.iterator();
        while (iterator.hasNext()) {
            Behavior behavior = iterator.next();
            if (!(behavior instanceof ParallelBehavior)) continue;
            this.parallel.add(behavior);
            iterator.remove();
        }
    }

    public void addBehavior(Behavior behavior) {
        this.behaviors.add(behavior);
    }

    public List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void removeBehavior(Behavior behavior) {
        this.behaviors.remove(behavior);
    }

    @Override
    public void reset() {
        if (this.parallelExecuting.size() > 0) {
            for (Behavior behavior : this.parallelExecuting) {
                this.stopExecution(behavior);
            }
            this.parallelExecuting.clear();
        }
    }

    @Override
    public boolean shouldExecute() {
        return this.behaviors.size() > 0;
    }

    protected void stopExecution(Behavior behavior) {
        if (behavior == null) {
            return;
        }
        behavior.reset();
    }

    protected void tickParallel() {
        for (Behavior behavior : this.parallel) {
            this.tryAddParallel(behavior);
        }
        Iterator<Behavior> iterator = this.parallelExecuting.iterator();
        while (iterator.hasNext()) {
            Behavior behavior;
            behavior = iterator.next();
            BehaviorStatus behaviorStatus = behavior.run();
            switch (behaviorStatus) {
                case RESET_AND_REMOVE: {
                    this.behaviors.remove(behavior);
                }
                case FAILURE: 
                case SUCCESS: {
                    iterator.remove();
                    this.stopExecution(behavior);
                    break;
                }
            }
        }
    }

    private void tryAddParallel(Behavior behavior) {
        if (behavior.shouldExecute() && !this.parallelExecuting.contains(behavior)) {
            this.parallelExecuting.add(behavior);
        }
    }
}

