/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class Decorator
extends BehaviorGoalAdapter {
    private final Collection<Runnable> resetCallbacks;
    private final Collection<Runnable> runCallbacks;
    private final Collection<Predicate<Boolean>> shouldExecutePredicates;
    private final Collection<Function<BehaviorStatus, BehaviorStatus>> statusTransformers;
    private final Behavior wrapping;

    private Decorator(Behavior behavior, Collection<Runnable> collection, Collection<Function<BehaviorStatus, BehaviorStatus>> collection2, Collection<Predicate<Boolean>> collection3, Collection<Runnable> collection4) {
        this.wrapping = behavior;
        this.runCallbacks = collection;
        this.statusTransformers = collection2;
        this.shouldExecutePredicates = collection3;
        this.resetCallbacks = collection4;
    }

    @Override
    public void reset() {
        for (Runnable runnable : this.resetCallbacks) {
            runnable.run();
        }
        this.wrapping.reset();
    }

    @Override
    public BehaviorStatus run() {
        for (Runnable object : this.runCallbacks) {
            object.run();
        }
        Object object = this.wrapping.run();
        for (Function<BehaviorStatus, BehaviorStatus> function : this.statusTransformers) {
            object = function.apply((BehaviorStatus)((Object)object));
        }
        return object;
    }

    @Override
    public boolean shouldExecute() {
        boolean bl = this.wrapping.shouldExecute();
        for (Predicate<Boolean> predicate : this.shouldExecutePredicates) {
            bl = predicate.test(bl);
        }
        return bl;
    }

    public static Builder wrapping(Behavior behavior) {
        return new Builder(behavior);
    }

    public static class Builder {
        private Collection<Runnable> resetCallbacks = Collections.emptyList();
        private Collection<Runnable> runCallbacks = Collections.emptyList();
        private Collection<Predicate<Boolean>> shouldExecutePredicates = Collections.emptyList();
        private Collection<Function<BehaviorStatus, BehaviorStatus>> statusTransformers = Collections.emptyList();
        private final Behavior toWrap;

        private Builder(Behavior behavior) {
            this.toWrap = behavior;
        }

        public Decorator build() {
            return new Decorator(this.toWrap, this.runCallbacks, this.statusTransformers, this.shouldExecutePredicates, this.resetCallbacks);
        }

        public Builder withPreRunCallback(Runnable runnable) {
            if (this.runCallbacks == Collections.EMPTY_LIST) {
                this.runCallbacks = Lists.newArrayList();
            }
            this.runCallbacks.add(runnable);
            return this;
        }

        public Builder withResetCallback(Runnable runnable) {
            if (this.resetCallbacks == Collections.EMPTY_LIST) {
                this.resetCallbacks = Lists.newArrayList();
            }
            this.resetCallbacks.add(runnable);
            return this;
        }

        public Builder withShouldExecutePredicate(Predicate<Boolean> predicate) {
            if (this.shouldExecutePredicates == Collections.EMPTY_LIST) {
                this.shouldExecutePredicates = Lists.newArrayList();
            }
            this.shouldExecutePredicates.add(predicate);
            return this;
        }

        public Builder withStatusTransformer(Function<BehaviorStatus, BehaviorStatus> function) {
            if (this.statusTransformers == Collections.EMPTY_LIST) {
                this.statusTransformers = Lists.newArrayList();
            }
            this.statusTransformers.add(function);
            return this;
        }
    }
}

