/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Composite;

public class Selector
extends Composite {
    private Behavior executing;
    private boolean retryChildren = false;
    private final Function<List<Behavior>, Behavior> selectionFunction;
    private static final Random RANDOM = new Random();
    private static final Function<List<Behavior>, Behavior> RANDOM_SELECTION = list -> (Behavior)list.get(RANDOM.nextInt(list.size()));

    private Selector(Function<List<Behavior>, Behavior> function, boolean bl, Collection<Behavior> collection) {
        super(collection);
        this.selectionFunction = function;
        this.retryChildren = bl;
    }

    public Behavior getNextBehavior() {
        return this.selectionFunction.apply(this.getBehaviors());
    }

    public Function<List<Behavior>, Behavior> getSelectionFunction() {
        return this.selectionFunction;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.executing != null) {
            this.stopExecution(this.executing);
        }
        this.executing = null;
    }

    public boolean retryChildren() {
        return this.retryChildren;
    }

    @Override
    public BehaviorStatus run() {
        this.tickParallel();
        BehaviorStatus behaviorStatus = null;
        if (this.executing == null) {
            this.executing = this.getNextBehavior();
            if (this.executing == null) {
                return BehaviorStatus.FAILURE;
            }
            if (!this.executing.shouldExecute()) {
                behaviorStatus = BehaviorStatus.FAILURE;
            }
        }
        if (behaviorStatus == null) {
            behaviorStatus = this.executing.run();
        }
        if (behaviorStatus == BehaviorStatus.FAILURE) {
            if (this.retryChildren) {
                this.stopExecution(this.executing);
                this.executing = null;
                return BehaviorStatus.RUNNING;
            }
        } else if (behaviorStatus == BehaviorStatus.RESET_AND_REMOVE) {
            this.getBehaviors().remove(this.executing);
            this.stopExecution(this.executing);
            this.executing = null;
            return BehaviorStatus.SUCCESS;
        }
        return behaviorStatus;
    }

    public String toString() {
        return "Selector [executing=" + this.executing + ", retryChildren=" + this.retryChildren + ", selectionFunction=" + this.selectionFunction + ", getBehaviors()=" + this.getBehaviors() + "]";
    }

    public static Builder selecting(Behavior ... behaviorArray) {
        return Selector.selecting(Arrays.asList(behaviorArray));
    }

    public static Builder selecting(Collection<Behavior> collection) {
        return new Builder(collection);
    }

    static /* synthetic */ Function access$000() {
        return RANDOM_SELECTION;
    }

    public static class Builder {
        private final Collection<Behavior> behaviors;
        private boolean retryChildren;
        private Function<List<Behavior>, Behavior> selectionFunction = Selector.access$000();

        private Builder(Collection<Behavior> collection) {
            this.behaviors = collection;
        }

        public Selector build() {
            return new Selector(this.selectionFunction, this.retryChildren, this.behaviors);
        }

        public Builder retryChildren() {
            this.retryChildren = true;
            return this;
        }

        public Builder retryChildren(boolean bl) {
            this.retryChildren = bl;
            return this;
        }

        public Builder selectionFunction(Function<List<Behavior>, Behavior> function) {
            this.selectionFunction = function;
            return this;
        }
    }
}

