/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Composite;

public class Sequence
extends Composite {
    private final boolean continueRunning;
    private Behavior executing;
    private int executingIndex = -1;

    private Sequence(boolean bl, Behavior ... behaviorArray) {
        this(bl, Arrays.asList(behaviorArray));
    }

    private Sequence(boolean bl, Collection<Behavior> collection) {
        super(collection);
        this.continueRunning = bl;
    }

    private BehaviorStatus getContinuationStatus() {
        this.resetCurrent();
        if (this.continueRunning) {
            if (++this.executingIndex >= this.getBehaviors().size()) {
                return BehaviorStatus.FAILURE;
            }
            return BehaviorStatus.RUNNING;
        }
        return BehaviorStatus.FAILURE;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetCurrent();
        this.executingIndex = -1;
    }

    private void resetCurrent() {
        this.stopExecution(this.executing);
        this.executing = null;
    }

    public boolean retryChildren() {
        return this.continueRunning;
    }

    @Override
    public BehaviorStatus run() {
        BehaviorStatus behaviorStatus;
        this.tickParallel();
        List<Behavior> list = this.getBehaviors();
        if (this.executing == null && (behaviorStatus = this.selectNext(list)) != BehaviorStatus.RUNNING) {
            this.resetCurrent();
            return behaviorStatus;
        }
        behaviorStatus = this.executing.run();
        switch (behaviorStatus) {
            case RUNNING: {
                return BehaviorStatus.RUNNING;
            }
            case FAILURE: {
                return this.getContinuationStatus();
            }
            case RESET_AND_REMOVE: {
                list.remove(this.executingIndex--);
                return this.selectNext(list);
            }
            case SUCCESS: {
                this.resetCurrent();
                return this.selectNext(list);
            }
        }
        throw new IllegalStateException();
    }

    private BehaviorStatus selectNext(List<Behavior> list) {
        if (++this.executingIndex >= list.size()) {
            return BehaviorStatus.SUCCESS;
        }
        this.executing = list.get(this.executingIndex);
        if (!this.executing.shouldExecute()) {
            return this.getContinuationStatus();
        }
        return BehaviorStatus.RUNNING;
    }

    public String toString() {
        return "Sequence [executing=" + this.executing + ", executingIndex=" + this.executingIndex + ", retryChildren=" + this.continueRunning + ", getBehaviors()=" + this.getBehaviors() + "]";
    }

    public static Sequence createRetryingSequence(Behavior ... behaviorArray) {
        return Sequence.createRetryingSequence(Arrays.asList(behaviorArray));
    }

    public static Sequence createRetryingSequence(Collection<Behavior> collection) {
        return new Sequence(true, collection);
    }

    public static Sequence createSequence(Behavior ... behaviorArray) {
        return Sequence.createSequence(Arrays.asList(behaviorArray));
    }

    public static Sequence createSequence(Collection<Behavior> collection) {
        return new Sequence(false, collection);
    }
}

