/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import java.util.Objects;
import java.util.function.Supplier;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.AStarStorage;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.SimpleAStarStorage;

public class AStarMachine<N extends AStarNode, P extends Plan> {
    private Supplier<AStarStorage> storageSupplier;

    private AStarMachine(Supplier<AStarStorage> supplier) {
        this.storageSupplier = supplier;
    }

    private void f(AStarGoal<N> aStarGoal, N n, N n2) {
        float f = ((AStarNode)n).g + aStarGoal.g(n, n2);
        float f2 = aStarGoal.h(n2);
        ((AStarNode)n2).g = f;
        ((AStarNode)n2).h = f2;
    }

    private AStarStorage getInitialisedStorage(AStarGoal<N> aStarGoal, N n) {
        AStarStorage aStarStorage = this.storageSupplier.get();
        aStarStorage.open((AStarNode)n);
        ((AStarNode)n).g = aStarGoal.getInitialCost(n);
        ((AStarNode)n).h = 0.0f;
        return aStarStorage;
    }

    public AStarState getStateFor(AStarGoal<N> aStarGoal, N n) {
        return new AStarState(this, aStarGoal, (AStarNode)n, this.getInitialisedStorage(aStarGoal, n));
    }

    public P run(AStarState aStarState) {
        return this.run(aStarState, -1);
    }

    public P run(AStarState aStarState, int n) {
        return this.run(aStarState.storage, aStarState.goal, aStarState.start, n);
    }

    private P run(AStarStorage aStarStorage, AStarGoal<N> aStarGoal, N n, int n2) {
        Objects.requireNonNull(aStarGoal);
        Objects.requireNonNull(n);
        Objects.requireNonNull(aStarStorage);
        int n3 = 0;
        do {
            AStarNode aStarNode;
            if ((aStarNode = aStarStorage.removeBestNode()) == null) {
                return null;
            }
            if (aStarGoal.isFinished(aStarNode)) {
                return (P)aStarNode.buildPlan();
            }
            aStarStorage.close(aStarNode);
            for (AStarNode aStarNode2 : aStarNode.getNeighbours()) {
                this.f(aStarGoal, aStarNode, aStarNode2);
                if (!aStarStorage.shouldExamine(aStarNode2)) continue;
                aStarStorage.open(aStarNode2);
                aStarNode2.parent = aStarNode;
            }
        } while (n2 < 0 || n3++ < n2);
        return null;
    }

    public P runFully(AStarGoal<N> aStarGoal, N n) {
        return this.runFully(aStarGoal, n, -1);
    }

    public P runFully(AStarGoal<N> aStarGoal, N n, int n2) {
        return this.run(this.getInitialisedStorage(aStarGoal, n), aStarGoal, n, n2);
    }

    public void setStorageSupplier(Supplier<AStarStorage> supplier) {
        this.storageSupplier = supplier;
    }

    public static <N extends AStarNode, P extends Plan> AStarMachine<N, P> createWithDefaultStorage() {
        return AStarMachine.createWithStorage(SimpleAStarStorage.FACTORY);
    }

    public static <N extends AStarNode, P extends Plan> AStarMachine<N, P> createWithStorage(Supplier<AStarStorage> supplier) {
        return new AStarMachine<N, P>(supplier);
    }

    public static class AStarState {
        private final AStarGoal<N> goal;
        private final N start;
        private final AStarStorage storage;
        final /* synthetic */ AStarMachine this$0;

        private AStarState(AStarGoal<N> aStarGoal, N n, AStarStorage aStarStorage) {
            this.this$0 = var1_1;
            this.goal = aStarGoal;
            this.start = n;
            this.storage = aStarStorage;
        }

        public N getBestNode() {
            return this.storage.getBestNode();
        }

        public boolean isEmpty() {
            return this.storage.getBestNode() == null;
        }
    }
}

