/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Supplier;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.AStarStorage;

public class SimpleAStarStorage
implements AStarStorage {
    private final Map<AStarNode, Float> closed = Maps.newHashMapWithExpectedSize((int)512);
    private final Map<AStarNode, Float> open = Maps.newHashMapWithExpectedSize((int)128);
    private final Queue<AStarNode> queue = new PriorityQueue<AStarNode>(128);
    public static final Supplier<AStarStorage> FACTORY = SimpleAStarStorage::new;

    @Override
    public void close(AStarNode aStarNode) {
        this.open.remove(aStarNode);
        this.closed.put(aStarNode, Float.valueOf(aStarNode.g));
    }

    @Override
    public AStarNode getBestNode() {
        return this.queue.peek();
    }

    @Override
    public void open(AStarNode aStarNode) {
        this.queue.offer(aStarNode);
        this.open.put(aStarNode, Float.valueOf(aStarNode.g));
        this.closed.remove(aStarNode);
    }

    @Override
    public AStarNode removeBestNode() {
        return this.queue.poll();
    }

    @Override
    public boolean shouldExamine(AStarNode aStarNode) {
        Float f;
        Float f2 = this.open.get(aStarNode);
        if (f2 != null && f2.floatValue() > aStarNode.g) {
            this.open.remove(aStarNode);
            f2 = null;
        }
        if ((f = this.closed.get(aStarNode)) != null && f.floatValue() > aStarNode.g) {
            this.closed.remove(aStarNode);
            f = null;
        }
        return f == null && f2 == null;
    }

    public String toString() {
        return "SimpleAStarStorage [closed=" + this.closed + ", open=" + this.open + "]";
    }
}

