/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import java.util.concurrent.Callable;
import net.citizensnpcs.api.astar.pathfinder.CachingChunkBlockSource;
import net.citizensnpcs.api.util.BoundingBox;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public class AsyncChunkSnapshotBlockSource
extends CachingChunkBlockSource<ChunkSnapshot> {
    public AsyncChunkSnapshotBlockSource(Location location, float f) {
        super(location, f);
    }

    public AsyncChunkSnapshotBlockSource(World world, int n, int n2, float f) {
        super(world, n, n2, f);
    }

    @Override
    protected ChunkSnapshot getChunkObject(int n, int n2) {
        Callable<ChunkSnapshot> callable = () -> this.world.getChunkAt(n, n2).getChunkSnapshot(false, false, false);
        try {
            if (!Bukkit.isPrimaryThread()) {
                return (ChunkSnapshot)Bukkit.getScheduler().callSyncMethod(null, callable).get();
            }
            return callable.call();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    protected BoundingBox getCollisionBox(ChunkSnapshot chunkSnapshot, int n, int n2, int n3) {
        return null;
    }

    @Override
    protected int getLightLevel(ChunkSnapshot chunkSnapshot, int n, int n2, int n3) {
        return Math.min(15, chunkSnapshot.getBlockSkyLight(n, n2, n3) + chunkSnapshot.getBlockEmittedLight(n, n2, n3));
    }

    @Override
    protected Material getType(ChunkSnapshot chunkSnapshot, int n, int n2, int n3) {
        return chunkSnapshot.getBlockType(n, n2, n3);
    }
}

