/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public abstract class CachingChunkBlockSource<T>
extends BlockSource {
    private final Map<ChunkCoord, ChunkCache> chunkCache = Maps.newHashMap();
    private final Object[][] chunks;
    private final int chunkX;
    private final int chunkZ;
    protected final World world;
    private static boolean SUPPORT_BOUNDING_BOX = true;

    protected CachingChunkBlockSource(Location location, float f) {
        this(location.getWorld(), location.getBlockX(), location.getBlockZ(), f);
    }

    protected CachingChunkBlockSource(World world, int n, int n2, float f) {
        this(world, (int)((float)n - f), (int)((float)n2 - f), (int)((float)n + f), (int)((float)n2 + f));
    }

    protected CachingChunkBlockSource(World world, int n, int n2, int n3, int n4) {
        this.world = world;
        this.chunkX = n >> 4;
        this.chunkZ = n2 >> 4;
        int n5 = n3 >> 4;
        int n6 = n4 >> 4;
        this.chunks = new Object[n5 - this.chunkX + 1][n6 - this.chunkZ + 1];
        for (int i = this.chunkX; i < n5; ++i) {
            for (int j = this.chunkZ; j < n6; ++j) {
                this.chunks[i - this.chunkX][j - this.chunkZ] = this.getChunkObject(i, j);
            }
        }
    }

    protected abstract T getChunkObject(int var1, int var2);

    @Override
    public BoundingBox getCollisionBox(int n, int n2, int n3) {
        if (!SpigotUtil.checkYSafe(n2, this.world)) {
            return BoundingBox.EMPTY;
        }
        T t = this.getSpecific(n, n3);
        if (t != null) {
            return this.getCollisionBox(t, n & 0xF, n2, n3 & 0xF);
        }
        if (!SUPPORT_BOUNDING_BOX) {
            return null;
        }
        try {
            return BoundingBox.convert(this.world.getBlockAt(n, n2, n3).getBoundingBox());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            SUPPORT_BOUNDING_BOX = false;
            return null;
        }
    }

    protected abstract BoundingBox getCollisionBox(T var1, int var2, int var3, int var4);

    protected abstract int getLightLevel(T var1, int var2, int var3, int var4);

    @Override
    public Material getMaterialAt(int n, int n2, int n3) {
        if (!SpigotUtil.checkYSafe(n2, this.world)) {
            return Material.AIR;
        }
        T t = this.getSpecific(n, n3);
        if (t != null) {
            return this.getType(t, n & 0xF, n2, n3 & 0xF);
        }
        return this.world.getBlockAt(n, n2, n3).getType();
    }

    private T getSpecific(int n, int n2) {
        ChunkCache chunkCache;
        Object object;
        int n3 = (n >> 4) - this.chunkX;
        int n4 = (n2 >> 4) - this.chunkZ;
        if (n3 >= 0 && n3 < this.chunks.length) {
            object = this.chunks[n3];
            if (n4 >= 0 && n4 < ((Object[])object).length) {
                return (T)object[n4];
            }
        }
        if ((chunkCache = this.chunkCache.get(object = new ChunkCoord(n >> 4, n2 >> 4))) == null) {
            chunkCache = new ChunkCache();
            this.chunkCache.put((ChunkCoord)object, chunkCache);
        } else {
            if (chunkCache.obj != null) {
                return chunkCache.obj;
            }
            if (++chunkCache.hitCount >= 2) {
                chunkCache.obj = this.getChunkObject(n >> 4, n2 >> 4);
                return chunkCache.obj;
            }
        }
        return null;
    }

    protected abstract Material getType(T var1, int var2, int var3, int var4);

    @Override
    public World getWorld() {
        return this.world;
    }

    private static class ChunkCoord {
        int x;
        int z;

        public ChunkCoord(int n, int n2) {
            this.x = n;
            this.z = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            ChunkCoord chunkCoord = (ChunkCoord)object;
            return this.x == chunkCoord.x && this.z == chunkCoord.z;
        }

        public int hashCode() {
            int n = 31 * this.x;
            return 31 * n + this.z;
        }
    }

    private class ChunkCache {
        int hitCount;
        T obj;

        private ChunkCache() {
        }
    }
}

